/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.ActivityStreamUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"id", "createdDate", "lastUpdate", "version", "acl", "entityIdentifier", "emotion", "comment", "i18nKey", "attachmentId", "user"})
public class ActivityStream {
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private String id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    @Nullable
    private LocalDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    @Nullable
    private LocalDateTime lastUpdate;
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private Long version;
    public static final String JSON_PROPERTY_ACL = "acl";
    @Nonnull
    private AclEnum acl;
    public static final String JSON_PROPERTY_ENTITY_IDENTIFIER = "entityIdentifier";
    @Nonnull
    private UUID entityIdentifier;
    public static final String JSON_PROPERTY_EMOTION = "emotion";
    @Nullable
    private String emotion;
    public static final String JSON_PROPERTY_COMMENT = "comment";
    @Nullable
    private String comment;
    public static final String JSON_PROPERTY_I18N_KEY = "i18nKey";
    @Nonnull
    private String i18nKey;
    public static final String JSON_PROPERTY_ATTACHMENT_ID = "attachmentId";
    @Nullable
    private String attachmentId;
    public static final String JSON_PROPERTY_USER = "user";
    @Nullable
    private ActivityStreamUser user;

    public ActivityStream id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable String id) {
        this.id = id;
    }

    public ActivityStream createdDate(@Nullable LocalDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedDate(@Nullable LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public ActivityStream lastUpdate(@Nullable LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdate(@Nullable LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public ActivityStream version(@Nullable Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(@Nullable Long version) {
        this.version = version;
    }

    public ActivityStream acl(@Nonnull AclEnum acl) {
        this.acl = acl;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="acl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AclEnum getAcl() {
        return this.acl;
    }

    @JsonProperty(value="acl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAcl(@Nonnull AclEnum acl) {
        this.acl = acl;
    }

    public ActivityStream entityIdentifier(@Nonnull UUID entityIdentifier) {
        this.entityIdentifier = entityIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="entityIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getEntityIdentifier() {
        return this.entityIdentifier;
    }

    @JsonProperty(value="entityIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEntityIdentifier(@Nonnull UUID entityIdentifier) {
        this.entityIdentifier = entityIdentifier;
    }

    public ActivityStream emotion(@Nullable String emotion) {
        this.emotion = emotion;
        return this;
    }

    @Nullable
    @JsonProperty(value="emotion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmotion() {
        return this.emotion;
    }

    @JsonProperty(value="emotion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmotion(@Nullable String emotion) {
        this.emotion = emotion;
    }

    public ActivityStream comment(@Nullable String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getComment() {
        return this.comment;
    }

    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComment(@Nullable String comment) {
        this.comment = comment;
    }

    public ActivityStream i18nKey(@Nonnull String i18nKey) {
        this.i18nKey = i18nKey;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="i18nKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getI18nKey() {
        return this.i18nKey;
    }

    @JsonProperty(value="i18nKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setI18nKey(@Nonnull String i18nKey) {
        this.i18nKey = i18nKey;
    }

    public ActivityStream attachmentId(@Nullable String attachmentId) {
        this.attachmentId = attachmentId;
        return this;
    }

    @Nullable
    @JsonProperty(value="attachmentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAttachmentId() {
        return this.attachmentId;
    }

    @JsonProperty(value="attachmentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttachmentId(@Nullable String attachmentId) {
        this.attachmentId = attachmentId;
    }

    public ActivityStream user(@Nullable ActivityStreamUser user) {
        this.user = user;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ActivityStreamUser getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUser(@Nullable ActivityStreamUser user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityStream activityStream = (ActivityStream)o;
        return Objects.equals(this.id, activityStream.id) && Objects.equals(this.createdDate, activityStream.createdDate) && Objects.equals(this.lastUpdate, activityStream.lastUpdate) && Objects.equals(this.version, activityStream.version) && Objects.equals((Object)this.acl, (Object)activityStream.acl) && Objects.equals(this.entityIdentifier, activityStream.entityIdentifier) && Objects.equals(this.emotion, activityStream.emotion) && Objects.equals(this.comment, activityStream.comment) && Objects.equals(this.i18nKey, activityStream.i18nKey) && Objects.equals(this.attachmentId, activityStream.attachmentId) && Objects.equals(this.user, activityStream.user);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdDate, this.lastUpdate, this.version, this.acl, this.entityIdentifier, this.emotion, this.comment, this.i18nKey, this.attachmentId, this.user});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivityStream {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    acl: ").append(this.toIndentedString((Object)this.acl)).append("\n");
        sb.append("    entityIdentifier: ").append(this.toIndentedString(this.entityIdentifier)).append("\n");
        sb.append("    emotion: ").append(this.toIndentedString(this.emotion)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    i18nKey: ").append(this.toIndentedString(this.i18nKey)).append("\n");
        sb.append("    attachmentId: ").append(this.toIndentedString(this.attachmentId)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AclEnum {
        EVERYONE(String.valueOf("EVERYONE")),
        AUTHENTICATED(String.valueOf("AUTHENTICATED")),
        OWNER(String.valueOf("OWNER")),
        ADMIN(String.valueOf("ADMIN"));

        private String value;

        private AclEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AclEnum fromValue(String value) {
            for (AclEnum b : AclEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

