/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"userIdentifier", "name", "profilePictureUrl"})
public class ActivityStreamUser {
    public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
    @Nonnull
    private UUID userIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_PROFILE_PICTURE_URL = "profilePictureUrl";
    @Nullable
    private String profilePictureUrl;

    public ActivityStreamUser userIdentifier(@Nonnull UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getUserIdentifier() {
        return this.userIdentifier;
    }

    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserIdentifier(@Nonnull UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    public ActivityStreamUser name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public ActivityStreamUser profilePictureUrl(@Nullable String profilePictureUrl) {
        this.profilePictureUrl = profilePictureUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="profilePictureUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProfilePictureUrl() {
        return this.profilePictureUrl;
    }

    @JsonProperty(value="profilePictureUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfilePictureUrl(@Nullable String profilePictureUrl) {
        this.profilePictureUrl = profilePictureUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityStreamUser activityStreamUser = (ActivityStreamUser)o;
        return Objects.equals(this.userIdentifier, activityStreamUser.userIdentifier) && Objects.equals(this.name, activityStreamUser.name) && Objects.equals(this.profilePictureUrl, activityStreamUser.profilePictureUrl);
    }

    public int hashCode() {
        return Objects.hash(this.userIdentifier, this.name, this.profilePictureUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivityStreamUser {\n");
        sb.append("    userIdentifier: ").append(this.toIndentedString(this.userIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    profilePictureUrl: ").append(this.toIndentedString(this.profilePictureUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

