/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"acquirerIdentifier", "vendor", "transactionIdentifier", "customerIdentifier", "chargeIdentifier", "status", "agentInvoicedDate", "agentInvoiceIdentifier", "redirectUrl", "fees", "vendorSpecific"})
public class BookingContractPaymentDetails {
    public static final String JSON_PROPERTY_ACQUIRER_IDENTIFIER = "acquirerIdentifier";
    @Nonnull
    private String acquirerIdentifier;
    public static final String JSON_PROPERTY_VENDOR = "vendor";
    @Nonnull
    private VendorEnum vendor;
    public static final String JSON_PROPERTY_TRANSACTION_IDENTIFIER = "transactionIdentifier";
    @Nonnull
    private String transactionIdentifier;
    public static final String JSON_PROPERTY_CUSTOMER_IDENTIFIER = "customerIdentifier";
    @Nonnull
    private String customerIdentifier;
    public static final String JSON_PROPERTY_CHARGE_IDENTIFIER = "chargeIdentifier";
    @Nonnull
    private String chargeIdentifier;
    public static final String JSON_PROPERTY_STATUS = "status";
    @Nonnull
    private StatusEnum status;
    public static final String JSON_PROPERTY_AGENT_INVOICED_DATE = "agentInvoicedDate";
    @Nullable
    private LocalDateTime agentInvoicedDate;
    public static final String JSON_PROPERTY_AGENT_INVOICE_IDENTIFIER = "agentInvoiceIdentifier";
    @Nullable
    private String agentInvoiceIdentifier;
    public static final String JSON_PROPERTY_REDIRECT_URL = "redirectUrl";
    @Nullable
    private String redirectUrl;
    public static final String JSON_PROPERTY_FEES = "fees";
    @Nullable
    private List<Object> fees = new ArrayList<Object>();
    public static final String JSON_PROPERTY_VENDOR_SPECIFIC = "vendorSpecific";
    @Nonnull
    private Map<String, String> vendorSpecific = new HashMap<String, String>();

    public BookingContractPaymentDetails acquirerIdentifier(@Nonnull String acquirerIdentifier) {
        this.acquirerIdentifier = acquirerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="acquirerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getAcquirerIdentifier() {
        return this.acquirerIdentifier;
    }

    @JsonProperty(value="acquirerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAcquirerIdentifier(@Nonnull String acquirerIdentifier) {
        this.acquirerIdentifier = acquirerIdentifier;
    }

    public BookingContractPaymentDetails vendor(@Nonnull VendorEnum vendor) {
        this.vendor = vendor;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="vendor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public VendorEnum getVendor() {
        return this.vendor;
    }

    @JsonProperty(value="vendor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVendor(@Nonnull VendorEnum vendor) {
        this.vendor = vendor;
    }

    public BookingContractPaymentDetails transactionIdentifier(@Nonnull String transactionIdentifier) {
        this.transactionIdentifier = transactionIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="transactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getTransactionIdentifier() {
        return this.transactionIdentifier;
    }

    @JsonProperty(value="transactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTransactionIdentifier(@Nonnull String transactionIdentifier) {
        this.transactionIdentifier = transactionIdentifier;
    }

    public BookingContractPaymentDetails customerIdentifier(@Nonnull String customerIdentifier) {
        this.customerIdentifier = customerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="customerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getCustomerIdentifier() {
        return this.customerIdentifier;
    }

    @JsonProperty(value="customerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCustomerIdentifier(@Nonnull String customerIdentifier) {
        this.customerIdentifier = customerIdentifier;
    }

    public BookingContractPaymentDetails chargeIdentifier(@Nonnull String chargeIdentifier) {
        this.chargeIdentifier = chargeIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="chargeIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getChargeIdentifier() {
        return this.chargeIdentifier;
    }

    @JsonProperty(value="chargeIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChargeIdentifier(@Nonnull String chargeIdentifier) {
        this.chargeIdentifier = chargeIdentifier;
    }

    public BookingContractPaymentDetails status(@Nonnull StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(@Nonnull StatusEnum status) {
        this.status = status;
    }

    public BookingContractPaymentDetails agentInvoicedDate(@Nullable LocalDateTime agentInvoicedDate) {
        this.agentInvoicedDate = agentInvoicedDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="agentInvoicedDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getAgentInvoicedDate() {
        return this.agentInvoicedDate;
    }

    @JsonProperty(value="agentInvoicedDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAgentInvoicedDate(@Nullable LocalDateTime agentInvoicedDate) {
        this.agentInvoicedDate = agentInvoicedDate;
    }

    public BookingContractPaymentDetails agentInvoiceIdentifier(@Nullable String agentInvoiceIdentifier) {
        this.agentInvoiceIdentifier = agentInvoiceIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="agentInvoiceIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAgentInvoiceIdentifier() {
        return this.agentInvoiceIdentifier;
    }

    @JsonProperty(value="agentInvoiceIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAgentInvoiceIdentifier(@Nullable String agentInvoiceIdentifier) {
        this.agentInvoiceIdentifier = agentInvoiceIdentifier;
    }

    public BookingContractPaymentDetails redirectUrl(@Nullable String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="redirectUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @JsonProperty(value="redirectUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectUrl(@Nullable String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public BookingContractPaymentDetails fees(@Nullable List<Object> fees) {
        this.fees = fees;
        return this;
    }

    public BookingContractPaymentDetails addFeesItem(Object feesItem) {
        if (this.fees == null) {
            this.fees = new ArrayList<Object>();
        }
        this.fees.add(feesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="fees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getFees() {
        return this.fees;
    }

    @JsonProperty(value="fees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFees(@Nullable List<Object> fees) {
        this.fees = fees;
    }

    public BookingContractPaymentDetails vendorSpecific(@Nonnull Map<String, String> vendorSpecific) {
        this.vendorSpecific = vendorSpecific;
        return this;
    }

    public BookingContractPaymentDetails putVendorSpecificItem(String key, String vendorSpecificItem) {
        this.vendorSpecific.put(key, vendorSpecificItem);
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="vendorSpecific")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Map<String, String> getVendorSpecific() {
        return this.vendorSpecific;
    }

    @JsonProperty(value="vendorSpecific")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVendorSpecific(@Nonnull Map<String, String> vendorSpecific) {
        this.vendorSpecific = vendorSpecific;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingContractPaymentDetails bookingContractPaymentDetails = (BookingContractPaymentDetails)o;
        return Objects.equals(this.acquirerIdentifier, bookingContractPaymentDetails.acquirerIdentifier) && Objects.equals((Object)this.vendor, (Object)bookingContractPaymentDetails.vendor) && Objects.equals(this.transactionIdentifier, bookingContractPaymentDetails.transactionIdentifier) && Objects.equals(this.customerIdentifier, bookingContractPaymentDetails.customerIdentifier) && Objects.equals(this.chargeIdentifier, bookingContractPaymentDetails.chargeIdentifier) && Objects.equals((Object)this.status, (Object)bookingContractPaymentDetails.status) && Objects.equals(this.agentInvoicedDate, bookingContractPaymentDetails.agentInvoicedDate) && Objects.equals(this.agentInvoiceIdentifier, bookingContractPaymentDetails.agentInvoiceIdentifier) && Objects.equals(this.redirectUrl, bookingContractPaymentDetails.redirectUrl) && Objects.equals(this.fees, bookingContractPaymentDetails.fees) && Objects.equals(this.vendorSpecific, bookingContractPaymentDetails.vendorSpecific);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acquirerIdentifier, this.vendor, this.transactionIdentifier, this.customerIdentifier, this.chargeIdentifier, this.status, this.agentInvoicedDate, this.agentInvoiceIdentifier, this.redirectUrl, this.fees, this.vendorSpecific});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingContractPaymentDetails {\n");
        sb.append("    acquirerIdentifier: ").append(this.toIndentedString(this.acquirerIdentifier)).append("\n");
        sb.append("    vendor: ").append(this.toIndentedString((Object)this.vendor)).append("\n");
        sb.append("    transactionIdentifier: ").append(this.toIndentedString(this.transactionIdentifier)).append("\n");
        sb.append("    customerIdentifier: ").append(this.toIndentedString(this.customerIdentifier)).append("\n");
        sb.append("    chargeIdentifier: ").append(this.toIndentedString(this.chargeIdentifier)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    agentInvoicedDate: ").append(this.toIndentedString(this.agentInvoicedDate)).append("\n");
        sb.append("    agentInvoiceIdentifier: ").append(this.toIndentedString(this.agentInvoiceIdentifier)).append("\n");
        sb.append("    redirectUrl: ").append(this.toIndentedString(this.redirectUrl)).append("\n");
        sb.append("    fees: ").append(this.toIndentedString(this.fees)).append("\n");
        sb.append("    vendorSpecific: ").append(this.toIndentedString(this.vendorSpecific)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum VendorEnum {
        STRIPE(String.valueOf("STRIPE")),
        AGENT(String.valueOf("AGENT")),
        NMI(String.valueOf("NMI")),
        WISE(String.valueOf("WISE")),
        TEST(String.valueOf("TEST"));

        private String value;

        private VendorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VendorEnum fromValue(String value) {
            for (VendorEnum b : VendorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        INITIALIZED(String.valueOf("INITIALIZED")),
        PROCESSING(String.valueOf("PROCESSING")),
        SUCCEEDED(String.valueOf("SUCCEEDED")),
        FAILED(String.valueOf("FAILED"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

