/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.UpsertCityOnlyAddressRequest;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"externalIdentifier", "type", "ownerType", "name", "legalName", "userIdentifier", "accountEmail", "accountPhoneNumber", "description", "url", "currencyCode", "address", "acquirers", "bankAccounts", "ownerTypeIdentifier", "dob", "disbursementType"})
public class CreateAccountRequest {
    public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
    @Nullable
    private String externalIdentifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private TypeEnum type;
    public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
    @Nonnull
    private OwnerTypeEnum ownerType;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
    @Nullable
    private String legalName;
    public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
    @Nullable
    private String userIdentifier;
    public static final String JSON_PROPERTY_ACCOUNT_EMAIL = "accountEmail";
    @Nonnull
    private String accountEmail;
    public static final String JSON_PROPERTY_ACCOUNT_PHONE_NUMBER = "accountPhoneNumber";
    @Nullable
    private String accountPhoneNumber;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nonnull
    private String description;
    public static final String JSON_PROPERTY_URL = "url";
    @Nonnull
    private String url;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    @Nonnull
    private String currencyCode;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    @Nullable
    private UpsertCityOnlyAddressRequest address;
    public static final String JSON_PROPERTY_ACQUIRERS = "acquirers";
    @Nullable
    private List<Object> acquirers = new ArrayList<Object>();
    public static final String JSON_PROPERTY_BANK_ACCOUNTS = "bankAccounts";
    @Nullable
    private List<Object> bankAccounts = new ArrayList<Object>();
    public static final String JSON_PROPERTY_OWNER_TYPE_IDENTIFIER = "ownerTypeIdentifier";
    @Nullable
    private String ownerTypeIdentifier;
    public static final String JSON_PROPERTY_DOB = "dob";
    @Nullable
    private LocalDate dob;
    public static final String JSON_PROPERTY_DISBURSEMENT_TYPE = "disbursementType";
    @Nullable
    private DisbursementTypeEnum disbursementType;

    public CreateAccountRequest externalIdentifier(@Nullable String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalIdentifier(@Nullable String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public CreateAccountRequest type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    public CreateAccountRequest ownerType(@Nonnull OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OwnerTypeEnum getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerType(@Nonnull OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
    }

    public CreateAccountRequest name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CreateAccountRequest legalName(@Nullable String legalName) {
        this.legalName = legalName;
        return this;
    }

    @Nullable
    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalName() {
        return this.legalName;
    }

    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalName(@Nullable String legalName) {
        this.legalName = legalName;
    }

    public CreateAccountRequest userIdentifier(@Nullable String userIdentifier) {
        this.userIdentifier = userIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserIdentifier() {
        return this.userIdentifier;
    }

    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserIdentifier(@Nullable String userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    public CreateAccountRequest accountEmail(@Nonnull String accountEmail) {
        this.accountEmail = accountEmail;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="accountEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getAccountEmail() {
        return this.accountEmail;
    }

    @JsonProperty(value="accountEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountEmail(@Nonnull String accountEmail) {
        this.accountEmail = accountEmail;
    }

    public CreateAccountRequest accountPhoneNumber(@Nullable String accountPhoneNumber) {
        this.accountPhoneNumber = accountPhoneNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="accountPhoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountPhoneNumber() {
        return this.accountPhoneNumber;
    }

    @JsonProperty(value="accountPhoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountPhoneNumber(@Nullable String accountPhoneNumber) {
        this.accountPhoneNumber = accountPhoneNumber;
    }

    public CreateAccountRequest description(@Nonnull String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(@Nonnull String description) {
        this.description = description;
    }

    public CreateAccountRequest url(@Nonnull String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrl(@Nonnull String url) {
        this.url = url;
    }

    public CreateAccountRequest currencyCode(@Nonnull String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=3, max=3)
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=3, max=3) String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrencyCode(@Nonnull String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public CreateAccountRequest address(@Nullable UpsertCityOnlyAddressRequest address) {
        this.address = address;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UpsertCityOnlyAddressRequest getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(@Nullable UpsertCityOnlyAddressRequest address) {
        this.address = address;
    }

    public CreateAccountRequest acquirers(@Nullable List<Object> acquirers) {
        this.acquirers = acquirers;
        return this;
    }

    public CreateAccountRequest addAcquirersItem(Object acquirersItem) {
        if (this.acquirers == null) {
            this.acquirers = new ArrayList<Object>();
        }
        this.acquirers.add(acquirersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="acquirers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getAcquirers() {
        return this.acquirers;
    }

    @JsonProperty(value="acquirers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcquirers(@Nullable List<Object> acquirers) {
        this.acquirers = acquirers;
    }

    public CreateAccountRequest bankAccounts(@Nullable List<Object> bankAccounts) {
        this.bankAccounts = bankAccounts;
        return this;
    }

    public CreateAccountRequest addBankAccountsItem(Object bankAccountsItem) {
        if (this.bankAccounts == null) {
            this.bankAccounts = new ArrayList<Object>();
        }
        this.bankAccounts.add(bankAccountsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="bankAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getBankAccounts() {
        return this.bankAccounts;
    }

    @JsonProperty(value="bankAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccounts(@Nullable List<Object> bankAccounts) {
        this.bankAccounts = bankAccounts;
    }

    public CreateAccountRequest ownerTypeIdentifier(@Nullable String ownerTypeIdentifier) {
        this.ownerTypeIdentifier = ownerTypeIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="ownerTypeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwnerTypeIdentifier() {
        return this.ownerTypeIdentifier;
    }

    @JsonProperty(value="ownerTypeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerTypeIdentifier(@Nullable String ownerTypeIdentifier) {
        this.ownerTypeIdentifier = ownerTypeIdentifier;
    }

    public CreateAccountRequest dob(@Nullable LocalDate dob) {
        this.dob = dob;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="dob")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDob() {
        return this.dob;
    }

    @JsonProperty(value="dob")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDob(@Nullable LocalDate dob) {
        this.dob = dob;
    }

    public CreateAccountRequest disbursementType(@Nullable DisbursementTypeEnum disbursementType) {
        this.disbursementType = disbursementType;
        return this;
    }

    @Nullable
    @JsonProperty(value="disbursementType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DisbursementTypeEnum getDisbursementType() {
        return this.disbursementType;
    }

    @JsonProperty(value="disbursementType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisbursementType(@Nullable DisbursementTypeEnum disbursementType) {
        this.disbursementType = disbursementType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAccountRequest createAccountRequest = (CreateAccountRequest)o;
        return Objects.equals(this.externalIdentifier, createAccountRequest.externalIdentifier) && Objects.equals((Object)this.type, (Object)createAccountRequest.type) && Objects.equals((Object)this.ownerType, (Object)createAccountRequest.ownerType) && Objects.equals(this.name, createAccountRequest.name) && Objects.equals(this.legalName, createAccountRequest.legalName) && Objects.equals(this.userIdentifier, createAccountRequest.userIdentifier) && Objects.equals(this.accountEmail, createAccountRequest.accountEmail) && Objects.equals(this.accountPhoneNumber, createAccountRequest.accountPhoneNumber) && Objects.equals(this.description, createAccountRequest.description) && Objects.equals(this.url, createAccountRequest.url) && Objects.equals(this.currencyCode, createAccountRequest.currencyCode) && Objects.equals(this.address, createAccountRequest.address) && Objects.equals(this.acquirers, createAccountRequest.acquirers) && Objects.equals(this.bankAccounts, createAccountRequest.bankAccounts) && Objects.equals(this.ownerTypeIdentifier, createAccountRequest.ownerTypeIdentifier) && Objects.equals(this.dob, createAccountRequest.dob) && Objects.equals((Object)this.disbursementType, (Object)createAccountRequest.disbursementType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.externalIdentifier, this.type, this.ownerType, this.name, this.legalName, this.userIdentifier, this.accountEmail, this.accountPhoneNumber, this.description, this.url, this.currencyCode, this.address, this.acquirers, this.bankAccounts, this.ownerTypeIdentifier, this.dob, this.disbursementType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateAccountRequest {\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    ownerType: ").append(this.toIndentedString((Object)this.ownerType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    userIdentifier: ").append(this.toIndentedString(this.userIdentifier)).append("\n");
        sb.append("    accountEmail: ").append(this.toIndentedString(this.accountEmail)).append("\n");
        sb.append("    accountPhoneNumber: ").append(this.toIndentedString(this.accountPhoneNumber)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    acquirers: ").append(this.toIndentedString(this.acquirers)).append("\n");
        sb.append("    bankAccounts: ").append(this.toIndentedString(this.bankAccounts)).append("\n");
        sb.append("    ownerTypeIdentifier: ").append(this.toIndentedString(this.ownerTypeIdentifier)).append("\n");
        sb.append("    dob: ").append(this.toIndentedString(this.dob)).append("\n");
        sb.append("    disbursementType: ").append(this.toIndentedString((Object)this.disbursementType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        MERCHANT(String.valueOf("MERCHANT")),
        AFFILIATE(String.valueOf("AFFILIATE")),
        AGENT(String.valueOf("AGENT")),
        FACILITATOR(String.valueOf("FACILITATOR")),
        RATE_PROVIDER(String.valueOf("RATE_PROVIDER"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum OwnerTypeEnum {
        COMPANY(String.valueOf("COMPANY")),
        INDIVIDUAL(String.valueOf("INDIVIDUAL"));

        private String value;

        private OwnerTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OwnerTypeEnum fromValue(String value) {
            for (OwnerTypeEnum b : OwnerTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DisbursementTypeEnum {
        VIRTUAL_CREDIT_CARD(String.valueOf("VIRTUAL_CREDIT_CARD")),
        BANK_TRANSFER(String.valueOf("BANK_TRANSFER"));

        private String value;

        private DisbursementTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DisbursementTypeEnum fromValue(String value) {
            for (DisbursementTypeEnum b : DisbursementTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

