/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"localAccountIdentifier", "externalIdentifier", "accountIdentifier", "name"})
public class CreateMappingRequest {
    public static final String JSON_PROPERTY_LOCAL_ACCOUNT_IDENTIFIER = "localAccountIdentifier";
    @Nonnull
    private UUID localAccountIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
    @Nonnull
    private String externalIdentifier;
    public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
    @Nonnull
    private UUID accountIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;

    public CreateMappingRequest localAccountIdentifier(@Nonnull UUID localAccountIdentifier) {
        this.localAccountIdentifier = localAccountIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="localAccountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getLocalAccountIdentifier() {
        return this.localAccountIdentifier;
    }

    @JsonProperty(value="localAccountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocalAccountIdentifier(@Nonnull UUID localAccountIdentifier) {
        this.localAccountIdentifier = localAccountIdentifier;
    }

    public CreateMappingRequest externalIdentifier(@Nonnull String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExternalIdentifier(@Nonnull String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public CreateMappingRequest accountIdentifier(@Nonnull UUID accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getAccountIdentifier() {
        return this.accountIdentifier;
    }

    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountIdentifier(@Nonnull UUID accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
    }

    public CreateMappingRequest name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMappingRequest createMappingRequest = (CreateMappingRequest)o;
        return Objects.equals(this.localAccountIdentifier, createMappingRequest.localAccountIdentifier) && Objects.equals(this.externalIdentifier, createMappingRequest.externalIdentifier) && Objects.equals(this.accountIdentifier, createMappingRequest.accountIdentifier) && Objects.equals(this.name, createMappingRequest.name);
    }

    public int hashCode() {
        return Objects.hash(this.localAccountIdentifier, this.externalIdentifier, this.accountIdentifier, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateMappingRequest {\n");
        sb.append("    localAccountIdentifier: ").append(this.toIndentedString(this.localAccountIdentifier)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("    accountIdentifier: ").append(this.toIndentedString(this.accountIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

