/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.AcquirerCredentials;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"identifier", "name", "priority", "vendor", "type", "currencyCode", "credentials", "webhookSecret", "publicToken"})
public class Integrator {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    @Nonnull
    private String identifier;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    @Nonnull
    private Integer priority;
    public static final String JSON_PROPERTY_VENDOR = "vendor";
    @Nonnull
    private VendorEnum vendor;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private TypeEnum type;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    @Nonnull
    private String currencyCode;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    @Nonnull
    private List<@Valid AcquirerCredentials> credentials = new ArrayList<AcquirerCredentials>();
    public static final String JSON_PROPERTY_WEBHOOK_SECRET = "webhookSecret";
    @Nullable
    private String webhookSecret;
    public static final String JSON_PROPERTY_PUBLIC_TOKEN = "publicToken";
    @Nullable
    private String publicToken;

    public Integrator identifier(@Nonnull String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(@Nonnull String identifier) {
        this.identifier = identifier;
    }

    public Integrator name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public Integrator priority(@Nonnull Integer priority) {
        this.priority = priority;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPriority(@Nonnull Integer priority) {
        this.priority = priority;
    }

    public Integrator vendor(@Nonnull VendorEnum vendor) {
        this.vendor = vendor;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="vendor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public VendorEnum getVendor() {
        return this.vendor;
    }

    @JsonProperty(value="vendor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVendor(@Nonnull VendorEnum vendor) {
        this.vendor = vendor;
    }

    public Integrator type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    public Integrator currencyCode(@Nonnull String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrencyCode(@Nonnull String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Integrator credentials(@Nonnull List<@Valid AcquirerCredentials> credentials) {
        this.credentials = credentials;
        return this;
    }

    public Integrator addCredentialsItem(AcquirerCredentials credentialsItem) {
        if (this.credentials == null) {
            this.credentials = new ArrayList<AcquirerCredentials>();
        }
        this.credentials.add(credentialsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) List<@Valid AcquirerCredentials> getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCredentials(@Nonnull List<@Valid AcquirerCredentials> credentials) {
        this.credentials = credentials;
    }

    public Integrator webhookSecret(@Nullable String webhookSecret) {
        this.webhookSecret = webhookSecret;
        return this;
    }

    @Nullable
    @JsonProperty(value="webhookSecret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWebhookSecret() {
        return this.webhookSecret;
    }

    @JsonProperty(value="webhookSecret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebhookSecret(@Nullable String webhookSecret) {
        this.webhookSecret = webhookSecret;
    }

    public Integrator publicToken(@Nullable String publicToken) {
        this.publicToken = publicToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="publicToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicToken() {
        return this.publicToken;
    }

    @JsonProperty(value="publicToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPublicToken(@Nullable String publicToken) {
        this.publicToken = publicToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Integrator integrator = (Integrator)o;
        return Objects.equals(this.identifier, integrator.identifier) && Objects.equals(this.name, integrator.name) && Objects.equals(this.priority, integrator.priority) && Objects.equals((Object)this.vendor, (Object)integrator.vendor) && Objects.equals((Object)this.type, (Object)integrator.type) && Objects.equals(this.currencyCode, integrator.currencyCode) && Objects.equals(this.credentials, integrator.credentials) && Objects.equals(this.webhookSecret, integrator.webhookSecret) && Objects.equals(this.publicToken, integrator.publicToken);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.name, this.priority, this.vendor, this.type, this.currencyCode, this.credentials, this.webhookSecret, this.publicToken});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Integrator {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    vendor: ").append(this.toIndentedString((Object)this.vendor)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    webhookSecret: ").append(this.toIndentedString(this.webhookSecret)).append("\n");
        sb.append("    publicToken: ").append(this.toIndentedString(this.publicToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum VendorEnum {
        STRIPE(String.valueOf("STRIPE")),
        AGENT(String.valueOf("AGENT")),
        NMI(String.valueOf("NMI")),
        WISE(String.valueOf("WISE")),
        TEST(String.valueOf("TEST"));

        private String value;

        private VendorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VendorEnum fromValue(String value) {
            for (VendorEnum b : VendorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        CREDIT_CARD(String.valueOf("CREDIT_CARD")),
        BANK_TRANSFER(String.valueOf("BANK_TRANSFER")),
        PAY_PAL(String.valueOf("PAY_PAL")),
        CRYPTO(String.valueOf("CRYPTO")),
        AGENT(String.valueOf("AGENT")),
        CASH(String.valueOf("CASH"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

