/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.CustomMonetaryAmount;
import io.trippay.sdk.payment.model.GuestUser;
import io.trippay.sdk.payment.model.PayableContractSupplierItemBeneficiary;
import io.trippay.sdk.payment.model.SimpleDateTimeItinerary;
import io.trippay.sdk.payment.model.SupplierContractItemPolicy;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"user", "nameInEnglish", "descriptionInEnglish", "price", "itinerary", "pricingType", "type", "beneficiaryList", "payable", "policy", "externalIdentifier", "dailyRateList", "metadata"})
public class PayableContractSupplierItem {
    public static final String JSON_PROPERTY_USER = "user";
    @Nonnull
    private GuestUser user;
    public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
    @Nonnull
    private String nameInEnglish;
    public static final String JSON_PROPERTY_DESCRIPTION_IN_ENGLISH = "descriptionInEnglish";
    @Nonnull
    private String descriptionInEnglish;
    public static final String JSON_PROPERTY_PRICE = "price";
    @Nonnull
    private CustomMonetaryAmount price;
    public static final String JSON_PROPERTY_ITINERARY = "itinerary";
    @Nonnull
    private SimpleDateTimeItinerary itinerary;
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    @Nonnull
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private TypeEnum type;
    public static final String JSON_PROPERTY_BENEFICIARY_LIST = "beneficiaryList";
    @Nonnull
    private List<@Valid PayableContractSupplierItemBeneficiary> beneficiaryList = new ArrayList<PayableContractSupplierItemBeneficiary>();
    public static final String JSON_PROPERTY_PAYABLE = "payable";
    @Nonnull
    private PayableEnum payable;
    public static final String JSON_PROPERTY_POLICY = "policy";
    @Nullable
    private SupplierContractItemPolicy policy;
    public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
    @Nullable
    private String externalIdentifier;
    public static final String JSON_PROPERTY_DAILY_RATE_LIST = "dailyRateList";
    @Nullable
    private List<Object> dailyRateList = new ArrayList<Object>();
    public static final String JSON_PROPERTY_METADATA = "metadata";
    @Nullable
    private Map<String, String> metadata = new HashMap<String, String>();

    public PayableContractSupplierItem user(@Nonnull GuestUser user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GuestUser getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(@Nonnull GuestUser user) {
        this.user = user;
    }

    public PayableContractSupplierItem nameInEnglish(@Nonnull String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getNameInEnglish() {
        return this.nameInEnglish;
    }

    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNameInEnglish(@Nonnull String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
    }

    public PayableContractSupplierItem descriptionInEnglish(@Nonnull String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getDescriptionInEnglish() {
        return this.descriptionInEnglish;
    }

    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptionInEnglish(@Nonnull String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
    }

    public PayableContractSupplierItem price(@Nonnull CustomMonetaryAmount price) {
        this.price = price;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrice(@Nonnull CustomMonetaryAmount price) {
        this.price = price;
    }

    public PayableContractSupplierItem itinerary(@Nonnull SimpleDateTimeItinerary itinerary) {
        this.itinerary = itinerary;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SimpleDateTimeItinerary getItinerary() {
        return this.itinerary;
    }

    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItinerary(@Nonnull SimpleDateTimeItinerary itinerary) {
        this.itinerary = itinerary;
    }

    public PayableContractSupplierItem pricingType(@Nonnull PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricingType(@Nonnull PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public PayableContractSupplierItem type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    public PayableContractSupplierItem beneficiaryList(@Nonnull List<@Valid PayableContractSupplierItemBeneficiary> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
        return this;
    }

    public PayableContractSupplierItem addBeneficiaryListItem(PayableContractSupplierItemBeneficiary beneficiaryListItem) {
        if (this.beneficiaryList == null) {
            this.beneficiaryList = new ArrayList<PayableContractSupplierItemBeneficiary>();
        }
        this.beneficiaryList.add(beneficiaryListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<@Valid PayableContractSupplierItemBeneficiary> getBeneficiaryList() {
        return this.beneficiaryList;
    }

    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBeneficiaryList(@Nonnull List<@Valid PayableContractSupplierItemBeneficiary> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
    }

    public PayableContractSupplierItem payable(@Nonnull PayableEnum payable) {
        this.payable = payable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PayableEnum getPayable() {
        return this.payable;
    }

    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPayable(@Nonnull PayableEnum payable) {
        this.payable = payable;
    }

    public PayableContractSupplierItem policy(@Nullable SupplierContractItemPolicy policy) {
        this.policy = policy;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SupplierContractItemPolicy getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(@Nullable SupplierContractItemPolicy policy) {
        this.policy = policy;
    }

    public PayableContractSupplierItem externalIdentifier(@Nullable String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalIdentifier(@Nullable String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public PayableContractSupplierItem dailyRateList(@Nullable List<Object> dailyRateList) {
        this.dailyRateList = dailyRateList;
        return this;
    }

    public PayableContractSupplierItem addDailyRateListItem(Object dailyRateListItem) {
        if (this.dailyRateList == null) {
            this.dailyRateList = new ArrayList<Object>();
        }
        this.dailyRateList.add(dailyRateListItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getDailyRateList() {
        return this.dailyRateList;
    }

    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDailyRateList(@Nullable List<Object> dailyRateList) {
        this.dailyRateList = dailyRateList;
    }

    public PayableContractSupplierItem metadata(@Nullable Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public PayableContractSupplierItem putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(@Nullable Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayableContractSupplierItem payableContractSupplierItem = (PayableContractSupplierItem)o;
        return Objects.equals(this.user, payableContractSupplierItem.user) && Objects.equals(this.nameInEnglish, payableContractSupplierItem.nameInEnglish) && Objects.equals(this.descriptionInEnglish, payableContractSupplierItem.descriptionInEnglish) && Objects.equals(this.price, payableContractSupplierItem.price) && Objects.equals(this.itinerary, payableContractSupplierItem.itinerary) && Objects.equals((Object)this.pricingType, (Object)payableContractSupplierItem.pricingType) && Objects.equals((Object)this.type, (Object)payableContractSupplierItem.type) && Objects.equals(this.beneficiaryList, payableContractSupplierItem.beneficiaryList) && Objects.equals((Object)this.payable, (Object)payableContractSupplierItem.payable) && Objects.equals(this.policy, payableContractSupplierItem.policy) && Objects.equals(this.externalIdentifier, payableContractSupplierItem.externalIdentifier) && Objects.equals(this.dailyRateList, payableContractSupplierItem.dailyRateList) && Objects.equals(this.metadata, payableContractSupplierItem.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.user, this.nameInEnglish, this.descriptionInEnglish, this.price, this.itinerary, this.pricingType, this.type, this.beneficiaryList, this.payable, this.policy, this.externalIdentifier, this.dailyRateList, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayableContractSupplierItem {\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    nameInEnglish: ").append(this.toIndentedString(this.nameInEnglish)).append("\n");
        sb.append("    descriptionInEnglish: ").append(this.toIndentedString(this.descriptionInEnglish)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    itinerary: ").append(this.toIndentedString(this.itinerary)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    beneficiaryList: ").append(this.toIndentedString(this.beneficiaryList)).append("\n");
        sb.append("    payable: ").append(this.toIndentedString((Object)this.payable)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("    dailyRateList: ").append(this.toIndentedString(this.dailyRateList)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricingTypeEnum {
        PER_STAY(String.valueOf("PER_STAY")),
        PER_DAY(String.valueOf("PER_DAY")),
        PER_NIGHT(String.valueOf("PER_NIGHT")),
        PER_USE(String.valueOf("PER_USE")),
        PER_HOUR(String.valueOf("PER_HOUR")),
        PER_PERSON(String.valueOf("PER_PERSON")),
        PER_PERSON_PER_NIGHT(String.valueOf("PER_PERSON_PER_NIGHT")),
        PER_PERSON_PER_HOUR(String.valueOf("PER_PERSON_PER_HOUR")),
        PER_ADULT(String.valueOf("PER_ADULT")),
        PER_ADULT_PER_NIGHT(String.valueOf("PER_ADULT_PER_NIGHT")),
        PER_ADULT_PER_HOUR(String.valueOf("PER_ADULT_PER_HOUR")),
        PER_CHILD(String.valueOf("PER_CHILD")),
        PER_CHILD_PER_NIGHT(String.valueOf("PER_CHILD_PER_NIGHT")),
        PER_CHILD_PER_HOUR(String.valueOf("PER_CHILD_PER_HOUR"));

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        LODGING(String.valueOf("LODGING")),
        RAIL(String.valueOf("RAIL")),
        AIR(String.valueOf("AIR")),
        CAR(String.valueOf("CAR")),
        CRUISE(String.valueOf("CRUISE")),
        PACKAGE(String.valueOf("PACKAGE")),
        ADD_ON(String.valueOf("ADD_ON")),
        RENTAL(String.valueOf("RENTAL")),
        EXPERIENCE(String.valueOf("EXPERIENCE")),
        ANCILLARY_BOOKING(String.valueOf("ANCILLARY_BOOKING")),
        ANCILLARY_FEE(String.valueOf("ANCILLARY_FEE"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PayableEnum {
        IMMEDIATE(String.valueOf("IMMEDIATE")),
        ARRIVAL(String.valueOf("ARRIVAL")),
        DEPARTURE(String.valueOf("DEPARTURE")),
        AGENT(String.valueOf("AGENT"));

        private String value;

        private PayableEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayableEnum fromValue(String value) {
            for (PayableEnum b : PayableEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

