/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.UpsertAddressRequest;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;

@JsonPropertyOrder(value={"name", "legalName", "description", "url", "accountEmail", "accountPhoneNumber", "currencyCode", "address", "preferredDisbursementType"})
public class UpsertAccountRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
    @Nullable
    private String legalName;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nonnull
    private String description;
    public static final String JSON_PROPERTY_URL = "url";
    @Nonnull
    private String url;
    public static final String JSON_PROPERTY_ACCOUNT_EMAIL = "accountEmail";
    @Nonnull
    private String accountEmail;
    public static final String JSON_PROPERTY_ACCOUNT_PHONE_NUMBER = "accountPhoneNumber";
    @Nullable
    private String accountPhoneNumber;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    @Nonnull
    private String currencyCode;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    @Nonnull
    private UpsertAddressRequest address;
    public static final String JSON_PROPERTY_PREFERRED_DISBURSEMENT_TYPE = "preferredDisbursementType";
    @Nullable
    private PreferredDisbursementTypeEnum preferredDisbursementType = PreferredDisbursementTypeEnum.BANK_TRANSFER;

    public UpsertAccountRequest name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public UpsertAccountRequest legalName(@Nullable String legalName) {
        this.legalName = legalName;
        return this;
    }

    @Nullable
    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalName() {
        return this.legalName;
    }

    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalName(@Nullable String legalName) {
        this.legalName = legalName;
    }

    public UpsertAccountRequest description(@Nonnull String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(@Nonnull String description) {
        this.description = description;
    }

    public UpsertAccountRequest url(@Nonnull String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrl(@Nonnull String url) {
        this.url = url;
    }

    public UpsertAccountRequest accountEmail(@Nonnull String accountEmail) {
        this.accountEmail = accountEmail;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="accountEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getAccountEmail() {
        return this.accountEmail;
    }

    @JsonProperty(value="accountEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountEmail(@Nonnull String accountEmail) {
        this.accountEmail = accountEmail;
    }

    public UpsertAccountRequest accountPhoneNumber(@Nullable String accountPhoneNumber) {
        this.accountPhoneNumber = accountPhoneNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="accountPhoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountPhoneNumber() {
        return this.accountPhoneNumber;
    }

    @JsonProperty(value="accountPhoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountPhoneNumber(@Nullable String accountPhoneNumber) {
        this.accountPhoneNumber = accountPhoneNumber;
    }

    public UpsertAccountRequest currencyCode(@Nonnull String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=3, max=3)
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=3, max=3) String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrencyCode(@Nonnull String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public UpsertAccountRequest address(@Nonnull UpsertAddressRequest address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UpsertAddressRequest getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(@Nonnull UpsertAddressRequest address) {
        this.address = address;
    }

    public UpsertAccountRequest preferredDisbursementType(@Nullable PreferredDisbursementTypeEnum preferredDisbursementType) {
        this.preferredDisbursementType = preferredDisbursementType;
        return this;
    }

    @Nullable
    @JsonProperty(value="preferredDisbursementType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PreferredDisbursementTypeEnum getPreferredDisbursementType() {
        return this.preferredDisbursementType;
    }

    @JsonProperty(value="preferredDisbursementType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreferredDisbursementType(@Nullable PreferredDisbursementTypeEnum preferredDisbursementType) {
        this.preferredDisbursementType = preferredDisbursementType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertAccountRequest upsertAccountRequest = (UpsertAccountRequest)o;
        return Objects.equals(this.name, upsertAccountRequest.name) && Objects.equals(this.legalName, upsertAccountRequest.legalName) && Objects.equals(this.description, upsertAccountRequest.description) && Objects.equals(this.url, upsertAccountRequest.url) && Objects.equals(this.accountEmail, upsertAccountRequest.accountEmail) && Objects.equals(this.accountPhoneNumber, upsertAccountRequest.accountPhoneNumber) && Objects.equals(this.currencyCode, upsertAccountRequest.currencyCode) && Objects.equals(this.address, upsertAccountRequest.address) && Objects.equals((Object)this.preferredDisbursementType, (Object)upsertAccountRequest.preferredDisbursementType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.legalName, this.description, this.url, this.accountEmail, this.accountPhoneNumber, this.currencyCode, this.address, this.preferredDisbursementType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpsertAccountRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    accountEmail: ").append(this.toIndentedString(this.accountEmail)).append("\n");
        sb.append("    accountPhoneNumber: ").append(this.toIndentedString(this.accountPhoneNumber)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    preferredDisbursementType: ").append(this.toIndentedString((Object)this.preferredDisbursementType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PreferredDisbursementTypeEnum {
        VIRTUAL_CREDIT_CARD(String.valueOf("VIRTUAL_CREDIT_CARD")),
        BANK_TRANSFER(String.valueOf("BANK_TRANSFER"));

        private String value;

        private PreferredDisbursementTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PreferredDisbursementTypeEnum fromValue(String value) {
            for (PreferredDisbursementTypeEnum b : PreferredDisbursementTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

