/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"id", "createdDate", "lastUpdate", "version", "userIdentifier", "ownerIdentifier", "ownerName", "ownerType", "name", "enabled", "eventUrl", "eventList"})
public class Webhook {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private String id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    @Nullable
    private LocalDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    @Nullable
    private LocalDateTime lastUpdate;
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private Long version;
    public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
    @Nonnull
    private UUID userIdentifier;
    public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
    @Nonnull
    private UUID ownerIdentifier;
    public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
    @Nonnull
    private String ownerName;
    public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
    @Nonnull
    private OwnerTypeEnum ownerType;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    @Nonnull
    private Boolean enabled = true;
    public static final String JSON_PROPERTY_EVENT_URL = "eventUrl";
    @Nonnull
    private String eventUrl;
    public static final String JSON_PROPERTY_EVENT_LIST = "eventList";
    @Nonnull
    private List<Object> eventList = new ArrayList<Object>();

    public Webhook id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public Webhook createdDate(@Nullable LocalDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedDate(@Nullable LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public Webhook lastUpdate(@Nullable LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdate(@Nullable LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public Webhook version(@Nullable Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(@Nullable Long version) {
        this.version = version;
    }

    public Webhook userIdentifier(@Nonnull UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getUserIdentifier() {
        return this.userIdentifier;
    }

    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserIdentifier(@Nonnull UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    public Webhook ownerIdentifier(@Nonnull UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerIdentifier(@Nonnull UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
    }

    public Webhook ownerName(@Nonnull String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getOwnerName() {
        return this.ownerName;
    }

    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerName(@Nonnull String ownerName) {
        this.ownerName = ownerName;
    }

    public Webhook ownerType(@Nonnull OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OwnerTypeEnum getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerType(@Nonnull OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
    }

    public Webhook name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public Webhook enabled(@Nonnull Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnabled(@Nonnull Boolean enabled) {
        this.enabled = enabled;
    }

    public Webhook eventUrl(@Nonnull String eventUrl) {
        this.eventUrl = eventUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="eventUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getEventUrl() {
        return this.eventUrl;
    }

    @JsonProperty(value="eventUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventUrl(@Nonnull String eventUrl) {
        this.eventUrl = eventUrl;
    }

    public Webhook eventList(@Nonnull List<Object> eventList) {
        this.eventList = eventList;
        return this;
    }

    public Webhook addEventListItem(Object eventListItem) {
        if (this.eventList == null) {
            this.eventList = new ArrayList<Object>();
        }
        this.eventList.add(eventListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="eventList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Object> getEventList() {
        return this.eventList;
    }

    @JsonProperty(value="eventList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventList(@Nonnull List<Object> eventList) {
        this.eventList = eventList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook webhook = (Webhook)o;
        return Objects.equals(this.id, webhook.id) && Objects.equals(this.createdDate, webhook.createdDate) && Objects.equals(this.lastUpdate, webhook.lastUpdate) && Objects.equals(this.version, webhook.version) && Objects.equals(this.userIdentifier, webhook.userIdentifier) && Objects.equals(this.ownerIdentifier, webhook.ownerIdentifier) && Objects.equals(this.ownerName, webhook.ownerName) && Objects.equals((Object)this.ownerType, (Object)webhook.ownerType) && Objects.equals(this.name, webhook.name) && Objects.equals(this.enabled, webhook.enabled) && Objects.equals(this.eventUrl, webhook.eventUrl) && Objects.equals(this.eventList, webhook.eventList);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdDate, this.lastUpdate, this.version, this.userIdentifier, this.ownerIdentifier, this.ownerName, this.ownerType, this.name, this.enabled, this.eventUrl, this.eventList});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Webhook {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    userIdentifier: ").append(this.toIndentedString(this.userIdentifier)).append("\n");
        sb.append("    ownerIdentifier: ").append(this.toIndentedString(this.ownerIdentifier)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("    ownerType: ").append(this.toIndentedString((Object)this.ownerType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    eventUrl: ").append(this.toIndentedString(this.eventUrl)).append("\n");
        sb.append("    eventList: ").append(this.toIndentedString(this.eventList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OwnerTypeEnum {
        USER(String.valueOf("USER")),
        COMPANY(String.valueOf("COMPANY")),
        ACCOUNT(String.valueOf("ACCOUNT"));

        private String value;

        private OwnerTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OwnerTypeEnum fromValue(String value) {
            for (OwnerTypeEnum b : OwnerTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

