package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;

import io.trippay.sdk.payment.model.Account;
import io.trippay.sdk.payment.model.AccountStatusResponse;
import io.trippay.sdk.payment.model.CreateAccountRequest;
import io.trippay.sdk.payment.model.KeyValuePair;
import io.trippay.sdk.payment.model.PageAccount;
import io.trippay.sdk.payment.model.RemoveEntryResponse;
import io.trippay.sdk.payment.model.SetTaxIdentifierRequest;
import io.trippay.sdk.payment.model.State;
import io.trippay.sdk.payment.model.UniqueResult;
import io.trippay.sdk.payment.model.UpsertAccountRequest;
import io.trippay.sdk.payment.model.UpsertBankAccountRequest;
import io.trippay.sdk.payment.model.VerifyAccountRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Arrays;
import java.util.stream.Collectors;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:12:05.578754358+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class AccountApi {
    private ApiClient apiClient;

    public AccountApi() {
        this(new ApiClient());
    }

    @Autowired
    public AccountApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    
    /**
     * Check Account Status
     * Returns account status about whether this account has been verified and whether it is active.
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AccountStatusResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec checkAccountStatusRequestCreation(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling checkAccountStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AccountStatusResponse> localVarReturnType = new ParameterizedTypeReference<AccountStatusResponse>() {};
        return apiClient.invokeAPI("/api/account/{id}/status", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Check Account Status
     * Returns account status about whether this account has been verified and whether it is active.
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AccountStatusResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AccountStatusResponse> checkAccountStatus(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AccountStatusResponse> localVarReturnType = new ParameterizedTypeReference<AccountStatusResponse>() {};
        return checkAccountStatusRequestCreation(id, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Check Account Status
     * Returns account status about whether this account has been verified and whether it is active.
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;AccountStatusResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AccountStatusResponse>> checkAccountStatusWithHttpInfo(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AccountStatusResponse> localVarReturnType = new ParameterizedTypeReference<AccountStatusResponse>() {};
        return checkAccountStatusRequestCreation(id, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Check Account Status
     * Returns account status about whether this account has been verified and whether it is active.
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec checkAccountStatusWithResponseSpec(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return checkAccountStatusRequestCreation(id, winkVersion, accept);
    }

    /**
     * Check External Account Status
     * Returns account status about whether this account has been verified and whether it is active.
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AccountStatusResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec checkExternalAccountStatusRequestCreation(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling checkExternalAccountStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AccountStatusResponse> localVarReturnType = new ParameterizedTypeReference<AccountStatusResponse>() {};
        return apiClient.invokeAPI("/api/account/external/{id}/status", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Check External Account Status
     * Returns account status about whether this account has been verified and whether it is active.
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AccountStatusResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AccountStatusResponse> checkExternalAccountStatus(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AccountStatusResponse> localVarReturnType = new ParameterizedTypeReference<AccountStatusResponse>() {};
        return checkExternalAccountStatusRequestCreation(id, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Check External Account Status
     * Returns account status about whether this account has been verified and whether it is active.
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;AccountStatusResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AccountStatusResponse>> checkExternalAccountStatusWithHttpInfo(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AccountStatusResponse> localVarReturnType = new ParameterizedTypeReference<AccountStatusResponse>() {};
        return checkExternalAccountStatusRequestCreation(id, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Check External Account Status
     * Returns account status about whether this account has been verified and whether it is active.
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec checkExternalAccountStatusWithResponseSpec(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return checkExternalAccountStatusRequestCreation(id, winkVersion, accept);
    }

    /**
     * Create Account
     * Create a new account
     * <p><b>201</b> - Created
     * @param createAccountRequest The createAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAccountRequestCreation(@jakarta.annotation.Nonnull CreateAccountRequest createAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = createAccountRequest;
        // verify the required parameter 'createAccountRequest' is set
        if (createAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createAccountRequest' when calling createAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Account
     * Create a new account
     * <p><b>201</b> - Created
     * @param createAccountRequest The createAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> createAccount(@jakarta.annotation.Nonnull CreateAccountRequest createAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createAccountRequestCreation(createAccountRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Account
     * Create a new account
     * <p><b>201</b> - Created
     * @param createAccountRequest The createAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Account>> createAccountWithHttpInfo(@jakarta.annotation.Nonnull CreateAccountRequest createAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createAccountRequestCreation(createAccountRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Account
     * Create a new account
     * <p><b>201</b> - Created
     * @param createAccountRequest The createAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createAccountWithResponseSpec(@jakarta.annotation.Nonnull CreateAccountRequest createAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return createAccountRequestCreation(createAccountRequest, winkVersion);
    }

    /**
     * Add Bank Account
     * Add a bank account to an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertBankAccountRequest The upsertBankAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAccountBankAccountRequestCreation(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertBankAccountRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling createAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertBankAccountRequest' is set
        if (upsertBankAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertBankAccountRequest' when calling createAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/{id}/bank-account", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add Bank Account
     * Add a bank account to an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertBankAccountRequest The upsertBankAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> createAccountBankAccount(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createAccountBankAccountRequestCreation(id, upsertBankAccountRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Add Bank Account
     * Add a bank account to an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertBankAccountRequest The upsertBankAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Account>> createAccountBankAccountWithHttpInfo(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createAccountBankAccountRequestCreation(id, upsertBankAccountRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Add Bank Account
     * Add a bank account to an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertBankAccountRequest The upsertBankAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createAccountBankAccountWithResponseSpec(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return createAccountBankAccountRequestCreation(id, upsertBankAccountRequest, winkVersion);
    }

    /**
     * Add Bank Account to External
     * Add a bank account to an existing account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertBankAccountRequest The upsertBankAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createExternalAccountBankAccountRequestCreation(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertBankAccountRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling createExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertBankAccountRequest' is set
        if (upsertBankAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertBankAccountRequest' when calling createExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/external/{id}/bank-account", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add Bank Account to External
     * Add a bank account to an existing account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertBankAccountRequest The upsertBankAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> createExternalAccountBankAccount(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createExternalAccountBankAccountRequestCreation(id, upsertBankAccountRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Add Bank Account to External
     * Add a bank account to an existing account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertBankAccountRequest The upsertBankAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Account>> createExternalAccountBankAccountWithHttpInfo(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createExternalAccountBankAccountRequestCreation(id, upsertBankAccountRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Add Bank Account to External
     * Add a bank account to an existing account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertBankAccountRequest The upsertBankAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createExternalAccountBankAccountWithResponseSpec(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return createExternalAccountBankAccountRequestCreation(id, upsertBankAccountRequest, winkVersion);
    }

    /**
     * Delete Account
     * Show a specific account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec deleteAccountRequestCreation(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling deleteAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/account/{id}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Account
     * Show a specific account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> deleteAccount(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return deleteAccountRequestCreation(id, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Account
     * Show a specific account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponse>> deleteAccountWithHttpInfo(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return deleteAccountRequestCreation(id, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Account
     * Show a specific account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec deleteAccountWithResponseSpec(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return deleteAccountRequestCreation(id, winkVersion, accept);
    }

    /**
     * Verify Account Name
     * Check if account name is unique
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return UniqueResult
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isAccountNameUniqueRequestCreation(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable String identifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new WebClientResponseException("Missing the required parameter 'name' when calling isAccountNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("name", name);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "identifier", identifier));
        

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>() {};
        return apiClient.invokeAPI("/api/account/unique/{name}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify Account Name
     * Check if account name is unique
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return UniqueResult
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UniqueResult> isAccountNameUnique(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable String identifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>() {};
        return isAccountNameUniqueRequestCreation(name, identifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Verify Account Name
     * Check if account name is unique
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;UniqueResult&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UniqueResult>> isAccountNameUniqueWithHttpInfo(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable String identifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>() {};
        return isAccountNameUniqueRequestCreation(name, identifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Verify Account Name
     * Check if account name is unique
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec isAccountNameUniqueWithResponseSpec(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable String identifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return isAccountNameUniqueRequestCreation(name, identifier, winkVersion, accept);
    }

    /**
     * Show Account
     * Show a specific account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadAccountRequestCreation(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Account
     * Show a specific account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> loadAccount(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return loadAccountRequestCreation(id, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Account
     * Show a specific account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Account>> loadAccountWithHttpInfo(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return loadAccountRequestCreation(id, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Account
     * Show a specific account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec loadAccountWithResponseSpec(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return loadAccountRequestCreation(id, winkVersion, accept);
    }

    /**
     * Show Accounts by Name
     * Show accounts matching name
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadAccountByNameRequestCreation(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new WebClientResponseException("Missing the required parameter 'name' when calling loadAccountByName", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("name", name);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/name/{name}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Accounts by Name
     * Show accounts matching name
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Account> loadAccountByName(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return loadAccountByNameRequestCreation(name, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Accounts by Name
     * Show accounts matching name
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;Account&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<Account>>> loadAccountByNameWithHttpInfo(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return loadAccountByNameRequestCreation(name, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Accounts by Name
     * Show accounts matching name
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec loadAccountByNameWithResponseSpec(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return loadAccountByNameRequestCreation(name, winkVersion, accept);
    }

    /**
     * Show Accounts by Name like
     * Show accounts matching name that are like...
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param ignoreCase The ignoreCase parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadAccountByNameLikeRequestCreation(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable Boolean ignoreCase, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new WebClientResponseException("Missing the required parameter 'name' when calling loadAccountByNameLike", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "name", name));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "ignore-case", ignoreCase));
        

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/name", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Accounts by Name like
     * Show accounts matching name that are like...
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param ignoreCase The ignoreCase parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Account> loadAccountByNameLike(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable Boolean ignoreCase, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return loadAccountByNameLikeRequestCreation(name, ignoreCase, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Accounts by Name like
     * Show accounts matching name that are like...
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param ignoreCase The ignoreCase parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;Account&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<Account>>> loadAccountByNameLikeWithHttpInfo(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable Boolean ignoreCase, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return loadAccountByNameLikeRequestCreation(name, ignoreCase, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Accounts by Name like
     * Show accounts matching name that are like...
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param ignoreCase The ignoreCase parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec loadAccountByNameLikeWithResponseSpec(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable Boolean ignoreCase, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return loadAccountByNameLikeRequestCreation(name, ignoreCase, winkVersion, accept);
    }

    /**
     * Show Account Grid for User
     * Load account grid for authenticated user
     * <p><b>200</b> - OK
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return PageAccount
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadAccountGridForAuthenticatedUserRequestCreation(@jakarta.annotation.Nonnull State state, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = state;
        // verify the required parameter 'state' is set
        if (state == null) {
            throw new WebClientResponseException("Missing the required parameter 'state' when calling loadAccountGridForAuthenticatedUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageAccount> localVarReturnType = new ParameterizedTypeReference<PageAccount>() {};
        return apiClient.invokeAPI("/api/account/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Account Grid for User
     * Load account grid for authenticated user
     * <p><b>200</b> - OK
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return PageAccount
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageAccount> loadAccountGridForAuthenticatedUser(@jakarta.annotation.Nonnull State state, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageAccount> localVarReturnType = new ParameterizedTypeReference<PageAccount>() {};
        return loadAccountGridForAuthenticatedUserRequestCreation(state, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Account Grid for User
     * Load account grid for authenticated user
     * <p><b>200</b> - OK
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageAccount&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageAccount>> loadAccountGridForAuthenticatedUserWithHttpInfo(@jakarta.annotation.Nonnull State state, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageAccount> localVarReturnType = new ParameterizedTypeReference<PageAccount>() {};
        return loadAccountGridForAuthenticatedUserRequestCreation(state, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Account Grid for User
     * Load account grid for authenticated user
     * <p><b>200</b> - OK
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec loadAccountGridForAuthenticatedUserWithResponseSpec(@jakarta.annotation.Nonnull State state, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return loadAccountGridForAuthenticatedUserRequestCreation(state, winkVersion);
    }

    /**
     * Show Account for User
     * Load account details for authenticated user
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadAccountsForAuthenticatedUserRequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Account for User
     * Load account details for authenticated user
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Account> loadAccountsForAuthenticatedUser(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return loadAccountsForAuthenticatedUserRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Account for User
     * Load account details for authenticated user
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;Account&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<Account>>> loadAccountsForAuthenticatedUserWithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return loadAccountsForAuthenticatedUserRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Account for User
     * Load account details for authenticated user
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec loadAccountsForAuthenticatedUserWithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return loadAccountsForAuthenticatedUserRequestCreation(winkVersion, accept);
    }

    /**
     * Show Account for External
     * Show a specific account by passing your own external identifier
     * <p><b>200</b> - OK
     * @param externalAccountIdentifier The externalAccountIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadExternalAccountRequestCreation(@jakarta.annotation.Nonnull String externalAccountIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'externalAccountIdentifier' is set
        if (externalAccountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'externalAccountIdentifier' when calling loadExternalAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("externalAccountIdentifier", externalAccountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/external/{externalAccountIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Account for External
     * Show a specific account by passing your own external identifier
     * <p><b>200</b> - OK
     * @param externalAccountIdentifier The externalAccountIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> loadExternalAccount(@jakarta.annotation.Nonnull String externalAccountIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return loadExternalAccountRequestCreation(externalAccountIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Account for External
     * Show a specific account by passing your own external identifier
     * <p><b>200</b> - OK
     * @param externalAccountIdentifier The externalAccountIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Account>> loadExternalAccountWithHttpInfo(@jakarta.annotation.Nonnull String externalAccountIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return loadExternalAccountRequestCreation(externalAccountIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Account for External
     * Show a specific account by passing your own external identifier
     * <p><b>200</b> - OK
     * @param externalAccountIdentifier The externalAccountIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec loadExternalAccountWithResponseSpec(@jakarta.annotation.Nonnull String externalAccountIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return loadExternalAccountRequestCreation(externalAccountIdentifier, winkVersion, accept);
    }

    /**
     * Remove Bank Account
     * Remove an existing bank account for an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeAccountBankAccountRequestCreation(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String bankAccountId, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bankAccountId' is set
        if (bankAccountId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankAccountId' when calling removeAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);
        pathParams.put("bankAccountId", bankAccountId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/{id}/bank-account/{bankAccountId}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Bank Account
     * Remove an existing bank account for an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> removeAccountBankAccount(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String bankAccountId, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return removeAccountBankAccountRequestCreation(id, bankAccountId, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Remove Bank Account
     * Remove an existing bank account for an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Account>> removeAccountBankAccountWithHttpInfo(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String bankAccountId, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return removeAccountBankAccountRequestCreation(id, bankAccountId, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Remove Bank Account
     * Remove an existing bank account for an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeAccountBankAccountWithResponseSpec(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String bankAccountId, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return removeAccountBankAccountRequestCreation(id, bankAccountId, winkVersion, accept);
    }

    /**
     * Remove Bank Account for External
     * Remove an existing bank account for an account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeExternalAccountBankAccountRequestCreation(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String bankAccountId, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bankAccountId' is set
        if (bankAccountId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankAccountId' when calling removeExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);
        pathParams.put("bankAccountId", bankAccountId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/external/{id}/bank-account/{bankAccountId}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Bank Account for External
     * Remove an existing bank account for an account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> removeExternalAccountBankAccount(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String bankAccountId, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return removeExternalAccountBankAccountRequestCreation(id, bankAccountId, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Remove Bank Account for External
     * Remove an existing bank account for an account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Account>> removeExternalAccountBankAccountWithHttpInfo(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String bankAccountId, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return removeExternalAccountBankAccountRequestCreation(id, bankAccountId, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Remove Bank Account for External
     * Remove an existing bank account for an account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeExternalAccountBankAccountWithResponseSpec(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String bankAccountId, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return removeExternalAccountBankAccountRequestCreation(id, bankAccountId, winkVersion, accept);
    }

    /**
     * Search Accounts by Name
     * Show accounts matching name
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param ignorecase The ignorecase parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec searchAccountByNameRequestCreation(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable Boolean ignorecase, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new WebClientResponseException("Missing the required parameter 'name' when calling searchAccountByName", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "name", name));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "ignorecase", ignorecase));
        

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return apiClient.invokeAPI("/api/account/search", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Search Accounts by Name
     * Show accounts matching name
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param ignorecase The ignorecase parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePair> searchAccountByName(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable Boolean ignorecase, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return searchAccountByNameRequestCreation(name, ignorecase, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Search Accounts by Name
     * Show accounts matching name
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param ignorecase The ignorecase parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePair&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePair>>> searchAccountByNameWithHttpInfo(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable Boolean ignorecase, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return searchAccountByNameRequestCreation(name, ignorecase, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Search Accounts by Name
     * Show accounts matching name
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param ignorecase The ignorecase parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec searchAccountByNameWithResponseSpec(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable Boolean ignorecase, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return searchAccountByNameRequestCreation(name, ignorecase, winkVersion, accept);
    }

    /**
     * Show Accounts by Owner
     * List all accounts owned by creating entity
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAccountsByOwnerRequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/owner/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Accounts by Owner
     * List all accounts owned by creating entity
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Account> showAccountsByOwner(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return showAccountsByOwnerRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Accounts by Owner
     * List all accounts owned by creating entity
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;Account&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<Account>>> showAccountsByOwnerWithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return showAccountsByOwnerRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Accounts by Owner
     * List all accounts owned by creating entity
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAccountsByOwnerWithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showAccountsByOwnerRequestCreation(winkVersion, accept);
    }

    /**
     * Update Account
     * Update an existing account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertAccountRequest The upsertAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAccountRequestCreation(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertAccountRequest upsertAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertAccountRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAccountRequest' is set
        if (upsertAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountRequest' when calling updateAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/{id}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Account
     * Update an existing account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertAccountRequest The upsertAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> updateAccount(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertAccountRequest upsertAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateAccountRequestCreation(id, upsertAccountRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Account
     * Update an existing account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertAccountRequest The upsertAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Account>> updateAccountWithHttpInfo(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertAccountRequest upsertAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateAccountRequestCreation(id, upsertAccountRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Account
     * Update an existing account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertAccountRequest The upsertAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateAccountWithResponseSpec(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertAccountRequest upsertAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return updateAccountRequestCreation(id, upsertAccountRequest, winkVersion);
    }

    /**
     * Update External Account
     * Update an existing account using the externalIdentifier to find the account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertAccountRequest The upsertAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateExternalAccountRequestCreation(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertAccountRequest upsertAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertAccountRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateExternalAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAccountRequest' is set
        if (upsertAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountRequest' when calling updateExternalAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/external/{id}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update External Account
     * Update an existing account using the externalIdentifier to find the account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertAccountRequest The upsertAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> updateExternalAccount(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertAccountRequest upsertAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateExternalAccountRequestCreation(id, upsertAccountRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update External Account
     * Update an existing account using the externalIdentifier to find the account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertAccountRequest The upsertAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Account>> updateExternalAccountWithHttpInfo(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertAccountRequest upsertAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateExternalAccountRequestCreation(id, upsertAccountRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update External Account
     * Update an existing account using the externalIdentifier to find the account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertAccountRequest The upsertAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateExternalAccountWithResponseSpec(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertAccountRequest upsertAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return updateExternalAccountRequestCreation(id, upsertAccountRequest, winkVersion);
    }

    /**
     * Submit Tax ID
     * Accounts can respond to an invalid Tax ID error by completing this task
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param taskId The taskId parameter
     * @param setTaxIdentifierRequest The setTaxIdentifierRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateNationalIdentifierRequestCreation(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String taskId, @jakarta.annotation.Nonnull SetTaxIdentifierRequest setTaxIdentifierRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = setTaxIdentifierRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateNationalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'taskId' is set
        if (taskId == null) {
            throw new WebClientResponseException("Missing the required parameter 'taskId' when calling updateNationalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'setTaxIdentifierRequest' is set
        if (setTaxIdentifierRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'setTaxIdentifierRequest' when calling updateNationalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);
        pathParams.put("taskId", taskId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/{id}/task/{taskId}/tid", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Submit Tax ID
     * Accounts can respond to an invalid Tax ID error by completing this task
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param taskId The taskId parameter
     * @param setTaxIdentifierRequest The setTaxIdentifierRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> updateNationalIdentifier(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String taskId, @jakarta.annotation.Nonnull SetTaxIdentifierRequest setTaxIdentifierRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateNationalIdentifierRequestCreation(id, taskId, setTaxIdentifierRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Submit Tax ID
     * Accounts can respond to an invalid Tax ID error by completing this task
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param taskId The taskId parameter
     * @param setTaxIdentifierRequest The setTaxIdentifierRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Account>> updateNationalIdentifierWithHttpInfo(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String taskId, @jakarta.annotation.Nonnull SetTaxIdentifierRequest setTaxIdentifierRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateNationalIdentifierRequestCreation(id, taskId, setTaxIdentifierRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Submit Tax ID
     * Accounts can respond to an invalid Tax ID error by completing this task
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param taskId The taskId parameter
     * @param setTaxIdentifierRequest The setTaxIdentifierRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateNationalIdentifierWithResponseSpec(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String taskId, @jakarta.annotation.Nonnull SetTaxIdentifierRequest setTaxIdentifierRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return updateNationalIdentifierRequestCreation(id, taskId, setTaxIdentifierRequest, winkVersion);
    }

    /**
     * Update Bank Account
     * Update an existing bank account for an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param upsertBankAccountRequest The upsertBankAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec upsertAccountBankAccountRequestCreation(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String bankAccountId, @jakarta.annotation.Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertBankAccountRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling upsertAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bankAccountId' is set
        if (bankAccountId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankAccountId' when calling upsertAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertBankAccountRequest' is set
        if (upsertBankAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertBankAccountRequest' when calling upsertAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);
        pathParams.put("bankAccountId", bankAccountId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/{id}/bank-account/{bankAccountId}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Bank Account
     * Update an existing bank account for an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param upsertBankAccountRequest The upsertBankAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> upsertAccountBankAccount(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String bankAccountId, @jakarta.annotation.Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return upsertAccountBankAccountRequestCreation(id, bankAccountId, upsertBankAccountRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Bank Account
     * Update an existing bank account for an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param upsertBankAccountRequest The upsertBankAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Account>> upsertAccountBankAccountWithHttpInfo(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String bankAccountId, @jakarta.annotation.Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return upsertAccountBankAccountRequestCreation(id, bankAccountId, upsertBankAccountRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Bank Account
     * Update an existing bank account for an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param upsertBankAccountRequest The upsertBankAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec upsertAccountBankAccountWithResponseSpec(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String bankAccountId, @jakarta.annotation.Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return upsertAccountBankAccountRequestCreation(id, bankAccountId, upsertBankAccountRequest, winkVersion);
    }

    /**
     * Update Bank Account for External
     * Update an existing bank account for an account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param upsertBankAccountRequest The upsertBankAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec upsertExternalAccountBankAccountRequestCreation(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String bankAccountId, @jakarta.annotation.Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertBankAccountRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling upsertExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bankAccountId' is set
        if (bankAccountId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankAccountId' when calling upsertExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertBankAccountRequest' is set
        if (upsertBankAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertBankAccountRequest' when calling upsertExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);
        pathParams.put("bankAccountId", bankAccountId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/external/{id}/bank-account/{bankAccountId}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Bank Account for External
     * Update an existing bank account for an account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param upsertBankAccountRequest The upsertBankAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> upsertExternalAccountBankAccount(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String bankAccountId, @jakarta.annotation.Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return upsertExternalAccountBankAccountRequestCreation(id, bankAccountId, upsertBankAccountRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Bank Account for External
     * Update an existing bank account for an account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param upsertBankAccountRequest The upsertBankAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Account>> upsertExternalAccountBankAccountWithHttpInfo(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String bankAccountId, @jakarta.annotation.Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return upsertExternalAccountBankAccountRequestCreation(id, bankAccountId, upsertBankAccountRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Bank Account for External
     * Update an existing bank account for an account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param upsertBankAccountRequest The upsertBankAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec upsertExternalAccountBankAccountWithResponseSpec(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull String bankAccountId, @jakarta.annotation.Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return upsertExternalAccountBankAccountRequestCreation(id, bankAccountId, upsertBankAccountRequest, winkVersion);
    }

    /**
     * Verify Account
     * Enriches account with supplemental data that missing in the account creation phase.
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param verifyAccountRequest The verifyAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec verifyAccountRequestCreation(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull VerifyAccountRequest verifyAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = verifyAccountRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling verifyAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'verifyAccountRequest' is set
        if (verifyAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'verifyAccountRequest' when calling verifyAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/{id}/verify", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify Account
     * Enriches account with supplemental data that missing in the account creation phase.
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param verifyAccountRequest The verifyAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> verifyAccount(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull VerifyAccountRequest verifyAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return verifyAccountRequestCreation(id, verifyAccountRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Verify Account
     * Enriches account with supplemental data that missing in the account creation phase.
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param verifyAccountRequest The verifyAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Account>> verifyAccountWithHttpInfo(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull VerifyAccountRequest verifyAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return verifyAccountRequestCreation(id, verifyAccountRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Verify Account
     * Enriches account with supplemental data that missing in the account creation phase.
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param verifyAccountRequest The verifyAccountRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec verifyAccountWithResponseSpec(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull VerifyAccountRequest verifyAccountRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return verifyAccountRequestCreation(id, verifyAccountRequest, winkVersion);
    }
}
