package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;

import io.trippay.sdk.payment.model.Mapping;
import io.trippay.sdk.payment.model.PageMapping;
import io.trippay.sdk.payment.model.RemoveEntryResponse;
import io.trippay.sdk.payment.model.State;
import io.trippay.sdk.payment.model.UpsertAccountMappingRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Arrays;
import java.util.stream.Collectors;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:12:05.578754358+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class AccountMappingsApi {
    private ApiClient apiClient;

    public AccountMappingsApi() {
        this(new ApiClient());
    }

    @Autowired
    public AccountMappingsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    
    /**
     * Create Account Mapping
     * Create a mapping between a local account and a remote account.
     * <p><b>201</b> - Created
     * @param accountIdentifier The accountIdentifier parameter
     * @param upsertAccountMappingRequest The upsertAccountMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAccountMappingRequestCreation(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull UpsertAccountMappingRequest upsertAccountMappingRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertAccountMappingRequest;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling createAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAccountMappingRequest' is set
        if (upsertAccountMappingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountMappingRequest' when calling createAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/mapping", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Account Mapping
     * Create a mapping between a local account and a remote account.
     * <p><b>201</b> - Created
     * @param accountIdentifier The accountIdentifier parameter
     * @param upsertAccountMappingRequest The upsertAccountMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> createAccountMapping(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull UpsertAccountMappingRequest upsertAccountMappingRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return createAccountMappingRequestCreation(accountIdentifier, upsertAccountMappingRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Account Mapping
     * Create a mapping between a local account and a remote account.
     * <p><b>201</b> - Created
     * @param accountIdentifier The accountIdentifier parameter
     * @param upsertAccountMappingRequest The upsertAccountMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Mapping&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Mapping>> createAccountMappingWithHttpInfo(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull UpsertAccountMappingRequest upsertAccountMappingRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return createAccountMappingRequestCreation(accountIdentifier, upsertAccountMappingRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Account Mapping
     * Create a mapping between a local account and a remote account.
     * <p><b>201</b> - Created
     * @param accountIdentifier The accountIdentifier parameter
     * @param upsertAccountMappingRequest The upsertAccountMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createAccountMappingWithResponseSpec(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull UpsertAccountMappingRequest upsertAccountMappingRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return createAccountMappingRequestCreation(accountIdentifier, upsertAccountMappingRequest, winkVersion);
    }

    /**
     * Show Account Mapping
     * Show a specific mapping by account and mapping identifier
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadAccountMappingRequestCreation(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling loadAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);
        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/mapping/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Account Mapping
     * Show a specific mapping by account and mapping identifier
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> loadAccountMapping(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return loadAccountMappingRequestCreation(accountIdentifier, id, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Account Mapping
     * Show a specific mapping by account and mapping identifier
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;Mapping&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Mapping>> loadAccountMappingWithHttpInfo(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return loadAccountMappingRequestCreation(accountIdentifier, id, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Account Mapping
     * Show a specific mapping by account and mapping identifier
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec loadAccountMappingWithResponseSpec(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return loadAccountMappingRequestCreation(accountIdentifier, id, winkVersion, accept);
    }

    /**
     * Show Account Mappings
     * List all mappings belonging to a specific account.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return PageMapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadAccountMappingGridRequestCreation(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull State state, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = state;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling loadAccountMappingGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'state' is set
        if (state == null) {
            throw new WebClientResponseException("Missing the required parameter 'state' when calling loadAccountMappingGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageMapping> localVarReturnType = new ParameterizedTypeReference<PageMapping>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/mapping/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Account Mappings
     * List all mappings belonging to a specific account.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return PageMapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageMapping> loadAccountMappingGrid(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull State state, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageMapping> localVarReturnType = new ParameterizedTypeReference<PageMapping>() {};
        return loadAccountMappingGridRequestCreation(accountIdentifier, state, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Account Mappings
     * List all mappings belonging to a specific account.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageMapping&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageMapping>> loadAccountMappingGridWithHttpInfo(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull State state, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageMapping> localVarReturnType = new ParameterizedTypeReference<PageMapping>() {};
        return loadAccountMappingGridRequestCreation(accountIdentifier, state, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Account Mappings
     * List all mappings belonging to a specific account.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec loadAccountMappingGridWithResponseSpec(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull State state, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return loadAccountMappingGridRequestCreation(accountIdentifier, state, winkVersion);
    }

    /**
     * Delete Account Mapping
     * Delete a specific mapping owned by account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeAccountMappingRequestCreation(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling removeAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);
        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/mapping/{id}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Account Mapping
     * Delete a specific mapping owned by account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeAccountMapping(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeAccountMappingRequestCreation(accountIdentifier, id, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Account Mapping
     * Delete a specific mapping owned by account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponse>> removeAccountMappingWithHttpInfo(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeAccountMappingRequestCreation(accountIdentifier, id, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Account Mapping
     * Delete a specific mapping owned by account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeAccountMappingWithResponseSpec(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return removeAccountMappingRequestCreation(accountIdentifier, id, winkVersion, accept);
    }

    /**
     * Update Account Mapping
     * Update an existing mapping owned by account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param upsertAccountMappingRequest The upsertAccountMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAccountMappingRequestCreation(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertAccountMappingRequest upsertAccountMappingRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertAccountMappingRequest;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling updateAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAccountMappingRequest' is set
        if (upsertAccountMappingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountMappingRequest' when calling updateAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);
        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/mapping/{id}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Account Mapping
     * Update an existing mapping owned by account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param upsertAccountMappingRequest The upsertAccountMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> updateAccountMapping(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertAccountMappingRequest upsertAccountMappingRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return updateAccountMappingRequestCreation(accountIdentifier, id, upsertAccountMappingRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Account Mapping
     * Update an existing mapping owned by account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param upsertAccountMappingRequest The upsertAccountMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Mapping&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Mapping>> updateAccountMappingWithHttpInfo(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertAccountMappingRequest upsertAccountMappingRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return updateAccountMappingRequestCreation(accountIdentifier, id, upsertAccountMappingRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Account Mapping
     * Update an existing mapping owned by account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param upsertAccountMappingRequest The upsertAccountMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateAccountMappingWithResponseSpec(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertAccountMappingRequest upsertAccountMappingRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return updateAccountMappingRequestCreation(accountIdentifier, id, upsertAccountMappingRequest, winkVersion);
    }
}
