package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;

import io.trippay.sdk.payment.model.CountResponse;
import io.trippay.sdk.payment.model.Notification;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Arrays;
import java.util.stream.Collectors;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:12:05.578754358+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class NotificationApi {
    private ApiClient apiClient;

    public NotificationApi() {
        this(new ApiClient());
    }

    @Autowired
    public NotificationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    
    /**
     * Delete Notification
     * Remove announcement specified by its identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier Remove a message that belongs to this company identifier
     * @param messageIdentifier Message identifier to be removed
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Notification
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeNotificationRequestCreation(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String messageIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling removeNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'messageIdentifier' is set
        if (messageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'messageIdentifier' when calling removeNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);
        pathParams.put("messageIdentifier", messageIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Notification> localVarReturnType = new ParameterizedTypeReference<Notification>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/message/{messageIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Notification
     * Remove announcement specified by its identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier Remove a message that belongs to this company identifier
     * @param messageIdentifier Message identifier to be removed
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Notification
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Notification> removeNotification(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String messageIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Notification> localVarReturnType = new ParameterizedTypeReference<Notification>() {};
        return removeNotificationRequestCreation(accountIdentifier, messageIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Notification
     * Remove announcement specified by its identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier Remove a message that belongs to this company identifier
     * @param messageIdentifier Message identifier to be removed
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;Notification&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Notification>> removeNotificationWithHttpInfo(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String messageIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Notification> localVarReturnType = new ParameterizedTypeReference<Notification>() {};
        return removeNotificationRequestCreation(accountIdentifier, messageIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Notification
     * Remove announcement specified by its identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier Remove a message that belongs to this company identifier
     * @param messageIdentifier Message identifier to be removed
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeNotificationWithResponseSpec(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String messageIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return removeNotificationRequestCreation(accountIdentifier, messageIdentifier, winkVersion, accept);
    }

    /**
     * Show Notification
     * Retrieve messages for a specific company by ID
     * <p><b>200</b> - OK
     * @param accountIdentifier Retrieve a message for this company identifier
     * @param messageIdentifier Message identifier to be retrieved
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Notification
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showNotificationRequestCreation(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String messageIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'messageIdentifier' is set
        if (messageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'messageIdentifier' when calling showNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);
        pathParams.put("messageIdentifier", messageIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Notification> localVarReturnType = new ParameterizedTypeReference<Notification>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/message/{messageIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Notification
     * Retrieve messages for a specific company by ID
     * <p><b>200</b> - OK
     * @param accountIdentifier Retrieve a message for this company identifier
     * @param messageIdentifier Message identifier to be retrieved
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Notification
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Notification> showNotification(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String messageIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Notification> localVarReturnType = new ParameterizedTypeReference<Notification>() {};
        return showNotificationRequestCreation(accountIdentifier, messageIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Notification
     * Retrieve messages for a specific company by ID
     * <p><b>200</b> - OK
     * @param accountIdentifier Retrieve a message for this company identifier
     * @param messageIdentifier Message identifier to be retrieved
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;Notification&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Notification>> showNotificationWithHttpInfo(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String messageIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Notification> localVarReturnType = new ParameterizedTypeReference<Notification>() {};
        return showNotificationRequestCreation(accountIdentifier, messageIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Notification
     * Retrieve messages for a specific company by ID
     * <p><b>200</b> - OK
     * @param accountIdentifier Retrieve a message for this company identifier
     * @param messageIdentifier Message identifier to be retrieved
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showNotificationWithResponseSpec(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nonnull String messageIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showNotificationRequestCreation(accountIdentifier, messageIdentifier, winkVersion, accept);
    }

    /**
     * Show Notifications
     * Retrieve all the messages for this account.
     * <p><b>200</b> - OK
     * @param accountIdentifier ID of entity to retrieve stream for
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;Notification&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showNotificationsRequestCreation(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showNotifications", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Notification> localVarReturnType = new ParameterizedTypeReference<Notification>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/message/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Notifications
     * Retrieve all the messages for this account.
     * <p><b>200</b> - OK
     * @param accountIdentifier ID of entity to retrieve stream for
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;Notification&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Notification> showNotifications(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Notification> localVarReturnType = new ParameterizedTypeReference<Notification>() {};
        return showNotificationsRequestCreation(accountIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Notifications
     * Retrieve all the messages for this account.
     * <p><b>200</b> - OK
     * @param accountIdentifier ID of entity to retrieve stream for
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;Notification&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<Notification>>> showNotificationsWithHttpInfo(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Notification> localVarReturnType = new ParameterizedTypeReference<Notification>() {};
        return showNotificationsRequestCreation(accountIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Notifications
     * Retrieve all the messages for this account.
     * <p><b>200</b> - OK
     * @param accountIdentifier ID of entity to retrieve stream for
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showNotificationsWithResponseSpec(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showNotificationsRequestCreation(accountIdentifier, winkVersion, accept);
    }

    /**
     * Show Unread Count
     * Retrieve count of unread messages
     * <p><b>200</b> - OK
     * @param accountIdentifier Show unread message count for this company identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return CountResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showUnreadMessageCountRequestCreation(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showUnreadMessageCount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CountResponse> localVarReturnType = new ParameterizedTypeReference<CountResponse>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/message/count", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Unread Count
     * Retrieve count of unread messages
     * <p><b>200</b> - OK
     * @param accountIdentifier Show unread message count for this company identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return CountResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CountResponse> showUnreadMessageCount(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponse> localVarReturnType = new ParameterizedTypeReference<CountResponse>() {};
        return showUnreadMessageCountRequestCreation(accountIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Unread Count
     * Retrieve count of unread messages
     * <p><b>200</b> - OK
     * @param accountIdentifier Show unread message count for this company identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;CountResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CountResponse>> showUnreadMessageCountWithHttpInfo(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponse> localVarReturnType = new ParameterizedTypeReference<CountResponse>() {};
        return showUnreadMessageCountRequestCreation(accountIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Unread Count
     * Retrieve count of unread messages
     * <p><b>200</b> - OK
     * @param accountIdentifier Show unread message count for this company identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showUnreadMessageCountWithResponseSpec(@jakarta.annotation.Nonnull String accountIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showUnreadMessageCountRequestCreation(accountIdentifier, winkVersion, accept);
    }
}
