/*
 * Wink Payment API
 * A programmatic way to create bookings, receive reactive and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Accounts use bank accounts to get paid.
 */
@JsonPropertyOrder({
  BankAccount.JSON_PROPERTY_IDENTIFIER,
  BankAccount.JSON_PROPERTY_COUNTRY_CODE,
  BankAccount.JSON_PROPERTY_CURRENCY_CODE,
  BankAccount.JSON_PROPERTY_ACCOUNT_HOLDER_NAME,
  BankAccount.JSON_PROPERTY_SWIFT_CODE,
  BankAccount.JSON_PROPERTY_ROUTING_NUMBER,
  BankAccount.JSON_PROPERTY_ACCOUNT_NUMBER,
  BankAccount.JSON_PROPERTY_PRIMARY
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:12:05.578754358+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class BankAccount {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  @jakarta.annotation.Nonnull
  private UUID identifier;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  @jakarta.annotation.Nonnull
  private String countryCode;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  @jakarta.annotation.Nonnull
  private String currencyCode;

  public static final String JSON_PROPERTY_ACCOUNT_HOLDER_NAME = "accountHolderName";
  @jakarta.annotation.Nonnull
  private String accountHolderName;

  public static final String JSON_PROPERTY_SWIFT_CODE = "swiftCode";
  @jakarta.annotation.Nullable
  private String swiftCode;

  public static final String JSON_PROPERTY_ROUTING_NUMBER = "routingNumber";
  @jakarta.annotation.Nullable
  private String routingNumber;

  public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
  @jakarta.annotation.Nonnull
  private String accountNumber;

  public static final String JSON_PROPERTY_PRIMARY = "primary";
  @jakarta.annotation.Nonnull
  private Boolean primary;

  public BankAccount() {
  }

  public BankAccount identifier(@jakarta.annotation.Nonnull UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

  /**
   * Unique bank account identifier
   * @return identifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(@jakarta.annotation.Nonnull UUID identifier) {
    this.identifier = identifier;
  }

  public BankAccount countryCode(@jakarta.annotation.Nonnull String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

  /**
   * Country of bank account
   * @return countryCode
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCountryCode() {
    return countryCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCountryCode(@jakarta.annotation.Nonnull String countryCode) {
    this.countryCode = countryCode;
  }

  public BankAccount currencyCode(@jakarta.annotation.Nonnull String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Currency of bank account
   * @return currencyCode
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrencyCode(@jakarta.annotation.Nonnull String currencyCode) {
    this.currencyCode = currencyCode;
  }

  public BankAccount accountHolderName(@jakarta.annotation.Nonnull String accountHolderName) {
    
    this.accountHolderName = accountHolderName;
    return this;
  }

  /**
   * Bank account holder name
   * @return accountHolderName
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountHolderName() {
    return accountHolderName;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountHolderName(@jakarta.annotation.Nonnull String accountHolderName) {
    this.accountHolderName = accountHolderName;
  }

  public BankAccount swiftCode(@jakarta.annotation.Nullable String swiftCode) {
    
    this.swiftCode = swiftCode;
    return this;
  }

  /**
   * Bank SWIFT code. Unique code identifier the bank and branch of the bank account.
   * @return swiftCode
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SWIFT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSwiftCode() {
    return swiftCode;
  }


  @JsonProperty(JSON_PROPERTY_SWIFT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSwiftCode(@jakarta.annotation.Nullable String swiftCode) {
    this.swiftCode = swiftCode;
  }

  public BankAccount routingNumber(@jakarta.annotation.Nullable String routingNumber) {
    
    this.routingNumber = routingNumber;
    return this;
  }

  /**
   * Bank account routing number. This is sort code in HK and Zengin code in JP.
   * @return routingNumber
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROUTING_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoutingNumber() {
    return routingNumber;
  }


  @JsonProperty(JSON_PROPERTY_ROUTING_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoutingNumber(@jakarta.annotation.Nullable String routingNumber) {
    this.routingNumber = routingNumber;
  }

  public BankAccount accountNumber(@jakarta.annotation.Nonnull String accountNumber) {
    
    this.accountNumber = accountNumber;
    return this;
  }

  /**
   * Bank account number. In all EU countries, this would be the IBAN. In other countries, the routing number will apply as well.
   * @return accountNumber
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_ACCOUNT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountNumber() {
    return accountNumber;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountNumber(@jakarta.annotation.Nonnull String accountNumber) {
    this.accountNumber = accountNumber;
  }

  public BankAccount primary(@jakarta.annotation.Nonnull Boolean primary) {
    
    this.primary = primary;
    return this;
  }

  /**
   * One bank account always needs to be primary.
   * @return primary
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRIMARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getPrimary() {
    return primary;
  }


  @JsonProperty(JSON_PROPERTY_PRIMARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrimary(@jakarta.annotation.Nonnull Boolean primary) {
    this.primary = primary;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BankAccount bankAccount = (BankAccount) o;
    return Objects.equals(this.identifier, bankAccount.identifier) &&
        Objects.equals(this.countryCode, bankAccount.countryCode) &&
        Objects.equals(this.currencyCode, bankAccount.currencyCode) &&
        Objects.equals(this.accountHolderName, bankAccount.accountHolderName) &&
        Objects.equals(this.swiftCode, bankAccount.swiftCode) &&
        Objects.equals(this.routingNumber, bankAccount.routingNumber) &&
        Objects.equals(this.accountNumber, bankAccount.accountNumber) &&
        Objects.equals(this.primary, bankAccount.primary);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, countryCode, currencyCode, accountHolderName, swiftCode, routingNumber, accountNumber, primary);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BankAccount {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    accountHolderName: ").append(toIndentedString(accountHolderName)).append("\n");
    sb.append("    swiftCode: ").append(toIndentedString(swiftCode)).append("\n");
    sb.append("    routingNumber: ").append(toIndentedString(routingNumber)).append("\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    primary: ").append(toIndentedString(primary)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

