/*
 * Wink Payment API
 * A programmatic way to create bookings, receive reactive and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.Beneficiary;
import io.trippay.sdk.payment.model.GuestUser;
import io.trippay.sdk.payment.model.SimpleDateTimeItinerary;
import io.trippay.sdk.payment.model.SupplierContractItemPolicy;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * BookingContractItem
 */
@JsonPropertyOrder({
  BookingContractItem.JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE,
  BookingContractItem.JSON_PROPERTY_USER,
  BookingContractItem.JSON_PROPERTY_NAME_IN_ENGLISH,
  BookingContractItem.JSON_PROPERTY_DESCRIPTION_IN_ENGLISH,
  BookingContractItem.JSON_PROPERTY_ITINERARY,
  BookingContractItem.JSON_PROPERTY_PRICING_TYPE,
  BookingContractItem.JSON_PROPERTY_TYPE,
  BookingContractItem.JSON_PROPERTY_BENEFICIARY_LIST,
  BookingContractItem.JSON_PROPERTY_PAYABLE,
  BookingContractItem.JSON_PROPERTY_POLICY,
  BookingContractItem.JSON_PROPERTY_EXTERNAL_IDENTIFIER,
  BookingContractItem.JSON_PROPERTY_TOKENS_EARNED,
  BookingContractItem.JSON_PROPERTY_DAILY_RATE_LIST,
  BookingContractItem.JSON_PROPERTY_CANCELLED,
  BookingContractItem.JSON_PROPERTY_SOURCE_CURRENCY,
  BookingContractItem.JSON_PROPERTY_DISPLAY_CURRENCY,
  BookingContractItem.JSON_PROPERTY_SUPPLIER_CURRENCY,
  BookingContractItem.JSON_PROPERTY_INTERNAL_CURRENCY,
  BookingContractItem.JSON_PROPERTY_CAPTURE_CURRENCY,
  BookingContractItem.JSON_PROPERTY_SOURCE_AMOUNT,
  BookingContractItem.JSON_PROPERTY_DISPLAY_AMOUNT,
  BookingContractItem.JSON_PROPERTY_SUPPLIER_AMOUNT,
  BookingContractItem.JSON_PROPERTY_INTERNAL_AMOUNT,
  BookingContractItem.JSON_PROPERTY_CAPTURE_AMOUNT,
  BookingContractItem.JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER,
  BookingContractItem.JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER,
  BookingContractItem.JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER,
  BookingContractItem.JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER,
  BookingContractItem.JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER,
  BookingContractItem.JSON_PROPERTY_NET_SOURCE_AMOUNT,
  BookingContractItem.JSON_PROPERTY_NET_DISPLAY_AMOUNT,
  BookingContractItem.JSON_PROPERTY_NET_SUPPLIER_AMOUNT,
  BookingContractItem.JSON_PROPERTY_NET_INTERNAL_AMOUNT,
  BookingContractItem.JSON_PROPERTY_NET_CAPTURE_AMOUNT,
  BookingContractItem.JSON_PROPERTY_METADATA,
  BookingContractItem.JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES,
  BookingContractItem.JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES,
  BookingContractItem.JSON_PROPERTY_CANCELLABLE_BY_TRAVELER,
  BookingContractItem.JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER_OR_AGENT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:12:05.578754358+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class BookingContractItem {
  public static final String JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE = "supplierItemBookingCode";
  @jakarta.annotation.Nonnull
  private String supplierItemBookingCode;

  public static final String JSON_PROPERTY_USER = "user";
  @jakarta.annotation.Nonnull
  private GuestUser user;

  public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
  @jakarta.annotation.Nonnull
  private String nameInEnglish;

  public static final String JSON_PROPERTY_DESCRIPTION_IN_ENGLISH = "descriptionInEnglish";
  @jakarta.annotation.Nonnull
  private String descriptionInEnglish;

  public static final String JSON_PROPERTY_ITINERARY = "itinerary";
  @jakarta.annotation.Nonnull
  private SimpleDateTimeItinerary itinerary;

  /**
   * How to calculate the total amount.
   */
  public enum PricingTypeEnum {
    PER_STAY(String.valueOf("PER_STAY")),
    
    PER_DAY(String.valueOf("PER_DAY")),
    
    PER_NIGHT(String.valueOf("PER_NIGHT")),
    
    PER_USE(String.valueOf("PER_USE")),
    
    PER_HOUR(String.valueOf("PER_HOUR")),
    
    PER_PERSON(String.valueOf("PER_PERSON")),
    
    PER_PERSON_PER_NIGHT(String.valueOf("PER_PERSON_PER_NIGHT")),
    
    PER_PERSON_PER_HOUR(String.valueOf("PER_PERSON_PER_HOUR")),
    
    PER_ADULT(String.valueOf("PER_ADULT")),
    
    PER_ADULT_PER_NIGHT(String.valueOf("PER_ADULT_PER_NIGHT")),
    
    PER_ADULT_PER_HOUR(String.valueOf("PER_ADULT_PER_HOUR")),
    
    PER_CHILD(String.valueOf("PER_CHILD")),
    
    PER_CHILD_PER_NIGHT(String.valueOf("PER_CHILD_PER_NIGHT")),
    
    PER_CHILD_PER_HOUR(String.valueOf("PER_CHILD_PER_HOUR"));

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  @jakarta.annotation.Nonnull
  private PricingTypeEnum pricingType;

  /**
   * Type of item this is.
   */
  public enum TypeEnum {
    LODGING(String.valueOf("LODGING")),
    
    RAIL(String.valueOf("RAIL")),
    
    AIR(String.valueOf("AIR")),
    
    CAR(String.valueOf("CAR")),
    
    CRUISE(String.valueOf("CRUISE")),
    
    PACKAGE(String.valueOf("PACKAGE")),
    
    ADD_ON(String.valueOf("ADD_ON")),
    
    RENTAL(String.valueOf("RENTAL")),
    
    EXPERIENCE(String.valueOf("EXPERIENCE")),
    
    ANCILLARY_BOOKING(String.valueOf("ANCILLARY_BOOKING")),
    
    ANCILLARY_FEE(String.valueOf("ANCILLARY_FEE"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  @jakarta.annotation.Nonnull
  private TypeEnum type;

  public static final String JSON_PROPERTY_BENEFICIARY_LIST = "beneficiaryList";
  @jakarta.annotation.Nonnull
  private List<@Valid Beneficiary> beneficiaryList = new ArrayList<>();

  /**
   * When to charge for this item.
   */
  public enum PayableEnum {
    IMMEDIATE(String.valueOf("IMMEDIATE")),
    
    ARRIVAL(String.valueOf("ARRIVAL")),
    
    DEPARTURE(String.valueOf("DEPARTURE")),
    
    AGENT(String.valueOf("AGENT"));

    private String value;

    PayableEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PayableEnum fromValue(String value) {
      for (PayableEnum b : PayableEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYABLE = "payable";
  @jakarta.annotation.Nonnull
  private PayableEnum payable;

  public static final String JSON_PROPERTY_POLICY = "policy";
  @jakarta.annotation.Nullable
  private SupplierContractItemPolicy policy;

  public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
  @jakarta.annotation.Nullable
  private String externalIdentifier;

  public static final String JSON_PROPERTY_TOKENS_EARNED = "tokensEarned";
  @jakarta.annotation.Nullable
  private Long tokensEarned;

  public static final String JSON_PROPERTY_DAILY_RATE_LIST = "dailyRateList";
  @jakarta.annotation.Nullable
  private List<Object> dailyRateList = new ArrayList<>();

  public static final String JSON_PROPERTY_CANCELLED = "cancelled";
  @jakarta.annotation.Nullable
  private Boolean cancelled;

  public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
  @jakarta.annotation.Nonnull
  private String sourceCurrency;

  public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
  @jakarta.annotation.Nonnull
  private String displayCurrency;

  public static final String JSON_PROPERTY_SUPPLIER_CURRENCY = "supplierCurrency";
  @jakarta.annotation.Nonnull
  private String supplierCurrency;

  public static final String JSON_PROPERTY_INTERNAL_CURRENCY = "internalCurrency";
  @jakarta.annotation.Nonnull
  private String internalCurrency;

  public static final String JSON_PROPERTY_CAPTURE_CURRENCY = "captureCurrency";
  @jakarta.annotation.Nonnull
  private String captureCurrency;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal sourceAmount;

  public static final String JSON_PROPERTY_DISPLAY_AMOUNT = "displayAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal displayAmount;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT = "supplierAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal supplierAmount;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT = "internalAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal internalAmount;

  public static final String JSON_PROPERTY_CAPTURE_AMOUNT = "captureAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal captureAmount;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER = "sourceAmountRefundModifier";
  @jakarta.annotation.Nullable
  private BigDecimal sourceAmountRefundModifier;

  public static final String JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER = "displayAmountRefundModifier";
  @jakarta.annotation.Nullable
  private BigDecimal displayAmountRefundModifier;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER = "supplierAmountRefundModifier";
  @jakarta.annotation.Nullable
  private BigDecimal supplierAmountRefundModifier;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER = "internalAmountRefundModifier";
  @jakarta.annotation.Nullable
  private BigDecimal internalAmountRefundModifier;

  public static final String JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER = "captureAmountRefundModifier";
  @jakarta.annotation.Nullable
  private BigDecimal captureAmountRefundModifier;

  public static final String JSON_PROPERTY_NET_SOURCE_AMOUNT = "netSourceAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal netSourceAmount;

  public static final String JSON_PROPERTY_NET_DISPLAY_AMOUNT = "netDisplayAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal netDisplayAmount;

  public static final String JSON_PROPERTY_NET_SUPPLIER_AMOUNT = "netSupplierAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal netSupplierAmount;

  public static final String JSON_PROPERTY_NET_INTERNAL_AMOUNT = "netInternalAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal netInternalAmount;

  public static final String JSON_PROPERTY_NET_CAPTURE_AMOUNT = "netCaptureAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal netCaptureAmount;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  @jakarta.annotation.Nullable
  private Map<String, String> metadata = new HashMap<>();

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
  @jakarta.annotation.Nullable
  private Boolean cancellableWithNoCharges;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES = "cancellableWithPotentialCharges";
  @jakarta.annotation.Nullable
  private Boolean cancellableWithPotentialCharges;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
  @jakarta.annotation.Nullable
  private Boolean cancellableByTraveler;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER_OR_AGENT = "cancellableBySupplierOrAgent";
  @jakarta.annotation.Nullable
  private Boolean cancellableBySupplierOrAgent;

  public BookingContractItem() {
  }

  public BookingContractItem supplierItemBookingCode(@jakarta.annotation.Nonnull String supplierItemBookingCode) {
    
    this.supplierItemBookingCode = supplierItemBookingCode;
    return this;
  }

  /**
   * Booking code identifying the supplier line item.
   * @return supplierItemBookingCode
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierItemBookingCode() {
    return supplierItemBookingCode;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierItemBookingCode(@jakarta.annotation.Nonnull String supplierItemBookingCode) {
    this.supplierItemBookingCode = supplierItemBookingCode;
  }

  public BookingContractItem user(@jakarta.annotation.Nonnull GuestUser user) {
    
    this.user = user;
    return this;
  }

  /**
   * Get user
   * @return user
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GuestUser getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(@jakarta.annotation.Nonnull GuestUser user) {
    this.user = user;
  }

  public BookingContractItem nameInEnglish(@jakarta.annotation.Nonnull String nameInEnglish) {
    
    this.nameInEnglish = nameInEnglish;
    return this;
  }

  /**
   * Name of item in English included in booking.
   * @return nameInEnglish
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getNameInEnglish() {
    return nameInEnglish;
  }


  @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNameInEnglish(@jakarta.annotation.Nonnull String nameInEnglish) {
    this.nameInEnglish = nameInEnglish;
  }

  public BookingContractItem descriptionInEnglish(@jakarta.annotation.Nonnull String descriptionInEnglish) {
    
    this.descriptionInEnglish = descriptionInEnglish;
    return this;
  }

  /**
   * Short description in English of item included in booking.
   * @return descriptionInEnglish
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_DESCRIPTION_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescriptionInEnglish() {
    return descriptionInEnglish;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptionInEnglish(@jakarta.annotation.Nonnull String descriptionInEnglish) {
    this.descriptionInEnglish = descriptionInEnglish;
  }

  public BookingContractItem itinerary(@jakarta.annotation.Nonnull SimpleDateTimeItinerary itinerary) {
    
    this.itinerary = itinerary;
    return this;
  }

  /**
   * Get itinerary
   * @return itinerary
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SimpleDateTimeItinerary getItinerary() {
    return itinerary;
  }


  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItinerary(@jakarta.annotation.Nonnull SimpleDateTimeItinerary itinerary) {
    this.itinerary = itinerary;
  }

  public BookingContractItem pricingType(@jakarta.annotation.Nonnull PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

  /**
   * How to calculate the total amount.
   * @return pricingType
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricingType(@jakarta.annotation.Nonnull PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }

  public BookingContractItem type(@jakarta.annotation.Nonnull TypeEnum type) {
    
    this.type = type;
    return this;
  }

  /**
   * Type of item this is.
   * @return type
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(@jakarta.annotation.Nonnull TypeEnum type) {
    this.type = type;
  }

  public BookingContractItem beneficiaryList(@jakarta.annotation.Nonnull List<@Valid Beneficiary> beneficiaryList) {
    
    this.beneficiaryList = beneficiaryList;
    return this;
  }

  public BookingContractItem addBeneficiaryListItem(Beneficiary beneficiaryListItem) {
    if (this.beneficiaryList == null) {
      this.beneficiaryList = new ArrayList<>();
    }
    this.beneficiaryList.add(beneficiaryListItem);
    return this;
  }

  /**
   * Get beneficiaryList
   * @return beneficiaryList
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_BENEFICIARY_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<@Valid Beneficiary> getBeneficiaryList() {
    return beneficiaryList;
  }


  @JsonProperty(JSON_PROPERTY_BENEFICIARY_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBeneficiaryList(@jakarta.annotation.Nonnull List<@Valid Beneficiary> beneficiaryList) {
    this.beneficiaryList = beneficiaryList;
  }

  public BookingContractItem payable(@jakarta.annotation.Nonnull PayableEnum payable) {
    
    this.payable = payable;
    return this;
  }

  /**
   * When to charge for this item.
   * @return payable
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PAYABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PayableEnum getPayable() {
    return payable;
  }


  @JsonProperty(JSON_PROPERTY_PAYABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPayable(@jakarta.annotation.Nonnull PayableEnum payable) {
    this.payable = payable;
  }

  public BookingContractItem policy(@jakarta.annotation.Nullable SupplierContractItemPolicy policy) {
    
    this.policy = policy;
    return this;
  }

  /**
   * Get policy
   * @return policy
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SupplierContractItemPolicy getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(@jakarta.annotation.Nullable SupplierContractItemPolicy policy) {
    this.policy = policy;
  }

  public BookingContractItem externalIdentifier(@jakarta.annotation.Nullable String externalIdentifier) {
    
    this.externalIdentifier = externalIdentifier;
    return this;
  }

  /**
   * Optional externalIdentifier to remote inventory.
   * @return externalIdentifier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalIdentifier() {
    return externalIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalIdentifier(@jakarta.annotation.Nullable String externalIdentifier) {
    this.externalIdentifier = externalIdentifier;
  }

  public BookingContractItem tokensEarned(@jakarta.annotation.Nullable Long tokensEarned) {
    
    this.tokensEarned = tokensEarned;
    return this;
  }

  /**
   * Tokens minted for this item
   * @return tokensEarned
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTokensEarned() {
    return tokensEarned;
  }


  @JsonProperty(JSON_PROPERTY_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokensEarned(@jakarta.annotation.Nullable Long tokensEarned) {
    this.tokensEarned = tokensEarned;
  }

  public BookingContractItem dailyRateList(@jakarta.annotation.Nullable List<Object> dailyRateList) {
    
    this.dailyRateList = dailyRateList;
    return this;
  }

  public BookingContractItem addDailyRateListItem(Object dailyRateListItem) {
    if (this.dailyRateList == null) {
      this.dailyRateList = new ArrayList<>();
    }
    this.dailyRateList.add(dailyRateListItem);
    return this;
  }

  /**
   * Get dailyRateList
   * @return dailyRateList
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getDailyRateList() {
    return dailyRateList;
  }


  @JsonProperty(JSON_PROPERTY_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDailyRateList(@jakarta.annotation.Nullable List<Object> dailyRateList) {
    this.dailyRateList = dailyRateList;
  }

  public BookingContractItem cancelled(@jakarta.annotation.Nullable Boolean cancelled) {
    
    this.cancelled = cancelled;
    return this;
  }

  /**
   * Optional geoname externalIdentifier to remote inventory.
   * @return cancelled
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancelled() {
    return cancelled;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelled(@jakarta.annotation.Nullable Boolean cancelled) {
    this.cancelled = cancelled;
  }

  public BookingContractItem sourceCurrency(@jakarta.annotation.Nonnull String sourceCurrency) {
    
    this.sourceCurrency = sourceCurrency;
    return this;
  }

  /**
   * The source currency
   * @return sourceCurrency
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceCurrency() {
    return sourceCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceCurrency(@jakarta.annotation.Nonnull String sourceCurrency) {
    this.sourceCurrency = sourceCurrency;
  }

  public BookingContractItem displayCurrency(@jakarta.annotation.Nonnull String displayCurrency) {
    
    this.displayCurrency = displayCurrency;
    return this;
  }

  /**
   * The display currency
   * @return displayCurrency
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDisplayCurrency() {
    return displayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayCurrency(@jakarta.annotation.Nonnull String displayCurrency) {
    this.displayCurrency = displayCurrency;
  }

  public BookingContractItem supplierCurrency(@jakarta.annotation.Nonnull String supplierCurrency) {
    
    this.supplierCurrency = supplierCurrency;
    return this;
  }

  /**
   * The supplier currency
   * @return supplierCurrency
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierCurrency() {
    return supplierCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierCurrency(@jakarta.annotation.Nonnull String supplierCurrency) {
    this.supplierCurrency = supplierCurrency;
  }

  public BookingContractItem internalCurrency(@jakarta.annotation.Nonnull String internalCurrency) {
    
    this.internalCurrency = internalCurrency;
    return this;
  }

  /**
   * The internal currency
   * @return internalCurrency
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInternalCurrency() {
    return internalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalCurrency(@jakarta.annotation.Nonnull String internalCurrency) {
    this.internalCurrency = internalCurrency;
  }

  public BookingContractItem captureCurrency(@jakarta.annotation.Nonnull String captureCurrency) {
    
    this.captureCurrency = captureCurrency;
    return this;
  }

  /**
   * The capture currency
   * @return captureCurrency
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCaptureCurrency() {
    return captureCurrency;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCaptureCurrency(@jakarta.annotation.Nonnull String captureCurrency) {
    this.captureCurrency = captureCurrency;
  }

  public BookingContractItem sourceAmount(@jakarta.annotation.Nonnull BigDecimal sourceAmount) {
    
    this.sourceAmount = sourceAmount;
    return this;
  }

  /**
   * The total initial price as quoted in the original TripPay contract.
   * minimum: 0
   * @return sourceAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getSourceAmount() {
    return sourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceAmount(@jakarta.annotation.Nonnull BigDecimal sourceAmount) {
    this.sourceAmount = sourceAmount;
  }

  public BookingContractItem displayAmount(@jakarta.annotation.Nonnull BigDecimal displayAmount) {
    
    this.displayAmount = displayAmount;
    return this;
  }

  /**
   * The total display price.
   * minimum: 0
   * @return displayAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getDisplayAmount() {
    return displayAmount;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayAmount(@jakarta.annotation.Nonnull BigDecimal displayAmount) {
    this.displayAmount = displayAmount;
  }

  public BookingContractItem supplierAmount(@jakarta.annotation.Nonnull BigDecimal supplierAmount) {
    
    this.supplierAmount = supplierAmount;
    return this;
  }

  /**
   * The total supplier price.
   * minimum: 0
   * @return supplierAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getSupplierAmount() {
    return supplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierAmount(@jakarta.annotation.Nonnull BigDecimal supplierAmount) {
    this.supplierAmount = supplierAmount;
  }

  public BookingContractItem internalAmount(@jakarta.annotation.Nonnull BigDecimal internalAmount) {
    
    this.internalAmount = internalAmount;
    return this;
  }

  /**
   * The total internal price.
   * minimum: 0
   * @return internalAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getInternalAmount() {
    return internalAmount;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalAmount(@jakarta.annotation.Nonnull BigDecimal internalAmount) {
    this.internalAmount = internalAmount;
  }

  public BookingContractItem captureAmount(@jakarta.annotation.Nonnull BigDecimal captureAmount) {
    
    this.captureAmount = captureAmount;
    return this;
  }

  /**
   * The total capture price.
   * minimum: 0
   * @return captureAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getCaptureAmount() {
    return captureAmount;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCaptureAmount(@jakarta.annotation.Nonnull BigDecimal captureAmount) {
    this.captureAmount = captureAmount;
  }

  public BookingContractItem sourceAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal sourceAmountRefundModifier) {
    
    this.sourceAmountRefundModifier = sourceAmountRefundModifier;
    return this;
  }

  /**
   * The source amount still due after a partial refund occurs.
   * minimum: 0
   * @return sourceAmountRefundModifier
   */
  @jakarta.annotation.Nullable
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceAmountRefundModifier() {
    return sourceAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal sourceAmountRefundModifier) {
    this.sourceAmountRefundModifier = sourceAmountRefundModifier;
  }

  public BookingContractItem displayAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal displayAmountRefundModifier) {
    
    this.displayAmountRefundModifier = displayAmountRefundModifier;
    return this;
  }

  /**
   * The display amount still due after a partial refund occurs.
   * minimum: 0
   * @return displayAmountRefundModifier
   */
  @jakarta.annotation.Nullable
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getDisplayAmountRefundModifier() {
    return displayAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal displayAmountRefundModifier) {
    this.displayAmountRefundModifier = displayAmountRefundModifier;
  }

  public BookingContractItem supplierAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal supplierAmountRefundModifier) {
    
    this.supplierAmountRefundModifier = supplierAmountRefundModifier;
    return this;
  }

  /**
   * The supplier amount still due after a partial refund occurs.
   * minimum: 0
   * @return supplierAmountRefundModifier
   */
  @jakarta.annotation.Nullable
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSupplierAmountRefundModifier() {
    return supplierAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal supplierAmountRefundModifier) {
    this.supplierAmountRefundModifier = supplierAmountRefundModifier;
  }

  public BookingContractItem internalAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal internalAmountRefundModifier) {
    
    this.internalAmountRefundModifier = internalAmountRefundModifier;
    return this;
  }

  /**
   * The internal amount still due after a partial refund occurs.
   * minimum: 0
   * @return internalAmountRefundModifier
   */
  @jakarta.annotation.Nullable
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalAmountRefundModifier() {
    return internalAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal internalAmountRefundModifier) {
    this.internalAmountRefundModifier = internalAmountRefundModifier;
  }

  public BookingContractItem captureAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal captureAmountRefundModifier) {
    
    this.captureAmountRefundModifier = captureAmountRefundModifier;
    return this;
  }

  /**
   * The capture amount still due after a partial refund occurs.
   * minimum: 0
   * @return captureAmountRefundModifier
   */
  @jakarta.annotation.Nullable
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getCaptureAmountRefundModifier() {
    return captureAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal captureAmountRefundModifier) {
    this.captureAmountRefundModifier = captureAmountRefundModifier;
  }

  public BookingContractItem netSourceAmount(@jakarta.annotation.Nonnull BigDecimal netSourceAmount) {
    
    this.netSourceAmount = netSourceAmount;
    return this;
  }

  /**
   * Source amount minus source modifier.
   * minimum: 0
   * @return netSourceAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getNetSourceAmount() {
    return netSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetSourceAmount(@jakarta.annotation.Nonnull BigDecimal netSourceAmount) {
    this.netSourceAmount = netSourceAmount;
  }

  public BookingContractItem netDisplayAmount(@jakarta.annotation.Nonnull BigDecimal netDisplayAmount) {
    
    this.netDisplayAmount = netDisplayAmount;
    return this;
  }

  /**
   * Display amount minus display modifier.
   * minimum: 0
   * @return netDisplayAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getNetDisplayAmount() {
    return netDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetDisplayAmount(@jakarta.annotation.Nonnull BigDecimal netDisplayAmount) {
    this.netDisplayAmount = netDisplayAmount;
  }

  public BookingContractItem netSupplierAmount(@jakarta.annotation.Nonnull BigDecimal netSupplierAmount) {
    
    this.netSupplierAmount = netSupplierAmount;
    return this;
  }

  /**
   * Supplier amount minus supplier modifier.
   * minimum: 0
   * @return netSupplierAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getNetSupplierAmount() {
    return netSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetSupplierAmount(@jakarta.annotation.Nonnull BigDecimal netSupplierAmount) {
    this.netSupplierAmount = netSupplierAmount;
  }

  public BookingContractItem netInternalAmount(@jakarta.annotation.Nonnull BigDecimal netInternalAmount) {
    
    this.netInternalAmount = netInternalAmount;
    return this;
  }

  /**
   * Internal amount minus internal modifier.
   * minimum: 0
   * @return netInternalAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getNetInternalAmount() {
    return netInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetInternalAmount(@jakarta.annotation.Nonnull BigDecimal netInternalAmount) {
    this.netInternalAmount = netInternalAmount;
  }

  public BookingContractItem netCaptureAmount(@jakarta.annotation.Nonnull BigDecimal netCaptureAmount) {
    
    this.netCaptureAmount = netCaptureAmount;
    return this;
  }

  /**
   * Capture amount minus capture modifier.
   * minimum: 0
   * @return netCaptureAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getNetCaptureAmount() {
    return netCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetCaptureAmount(@jakarta.annotation.Nonnull BigDecimal netCaptureAmount) {
    this.netCaptureAmount = netCaptureAmount;
  }

  public BookingContractItem metadata(@jakarta.annotation.Nullable Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public BookingContractItem putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

  /**
   * Place to add more data related to the booking contract item.
   * @return metadata
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(@jakarta.annotation.Nullable Map<String, String> metadata) {
    this.metadata = metadata;
  }

  public BookingContractItem cancellableWithNoCharges(@jakarta.annotation.Nullable Boolean cancellableWithNoCharges) {
    
    this.cancellableWithNoCharges = cancellableWithNoCharges;
    return this;
  }

  /**
   * Whether the booking can still be cancelled and whether cancellation charges might still occur.
   * @return cancellableWithNoCharges
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithNoCharges() {
    return cancellableWithNoCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithNoCharges(@jakarta.annotation.Nullable Boolean cancellableWithNoCharges) {
    this.cancellableWithNoCharges = cancellableWithNoCharges;
  }

  public BookingContractItem cancellableWithPotentialCharges(@jakarta.annotation.Nullable Boolean cancellableWithPotentialCharges) {
    
    this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
    return this;
  }

  /**
   * Whether the booking can still be cancelled and whether cancellation charges might still occur.
   * @return cancellableWithPotentialCharges
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithPotentialCharges() {
    return cancellableWithPotentialCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithPotentialCharges(@jakarta.annotation.Nullable Boolean cancellableWithPotentialCharges) {
    this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
  }

  public BookingContractItem cancellableByTraveler(@jakarta.annotation.Nullable Boolean cancellableByTraveler) {
    
    this.cancellableByTraveler = cancellableByTraveler;
    return this;
  }

  /**
   * Whether the booking can still be cancelled by the traveller.
   * @return cancellableByTraveler
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByTraveler() {
    return cancellableByTraveler;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByTraveler(@jakarta.annotation.Nullable Boolean cancellableByTraveler) {
    this.cancellableByTraveler = cancellableByTraveler;
  }

  public BookingContractItem cancellableBySupplierOrAgent(@jakarta.annotation.Nullable Boolean cancellableBySupplierOrAgent) {
    
    this.cancellableBySupplierOrAgent = cancellableBySupplierOrAgent;
    return this;
  }

  /**
   * Whether the booking can still be cancelled by the supplier. A supplier cancellation overrides the refundable
   * @return cancellableBySupplierOrAgent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER_OR_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableBySupplierOrAgent() {
    return cancellableBySupplierOrAgent;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER_OR_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableBySupplierOrAgent(@jakarta.annotation.Nullable Boolean cancellableBySupplierOrAgent) {
    this.cancellableBySupplierOrAgent = cancellableBySupplierOrAgent;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContractItem bookingContractItem = (BookingContractItem) o;
    return Objects.equals(this.supplierItemBookingCode, bookingContractItem.supplierItemBookingCode) &&
        Objects.equals(this.user, bookingContractItem.user) &&
        Objects.equals(this.nameInEnglish, bookingContractItem.nameInEnglish) &&
        Objects.equals(this.descriptionInEnglish, bookingContractItem.descriptionInEnglish) &&
        Objects.equals(this.itinerary, bookingContractItem.itinerary) &&
        Objects.equals(this.pricingType, bookingContractItem.pricingType) &&
        Objects.equals(this.type, bookingContractItem.type) &&
        Objects.equals(this.beneficiaryList, bookingContractItem.beneficiaryList) &&
        Objects.equals(this.payable, bookingContractItem.payable) &&
        Objects.equals(this.policy, bookingContractItem.policy) &&
        Objects.equals(this.externalIdentifier, bookingContractItem.externalIdentifier) &&
        Objects.equals(this.tokensEarned, bookingContractItem.tokensEarned) &&
        Objects.equals(this.dailyRateList, bookingContractItem.dailyRateList) &&
        Objects.equals(this.cancelled, bookingContractItem.cancelled) &&
        Objects.equals(this.sourceCurrency, bookingContractItem.sourceCurrency) &&
        Objects.equals(this.displayCurrency, bookingContractItem.displayCurrency) &&
        Objects.equals(this.supplierCurrency, bookingContractItem.supplierCurrency) &&
        Objects.equals(this.internalCurrency, bookingContractItem.internalCurrency) &&
        Objects.equals(this.captureCurrency, bookingContractItem.captureCurrency) &&
        Objects.equals(this.sourceAmount, bookingContractItem.sourceAmount) &&
        Objects.equals(this.displayAmount, bookingContractItem.displayAmount) &&
        Objects.equals(this.supplierAmount, bookingContractItem.supplierAmount) &&
        Objects.equals(this.internalAmount, bookingContractItem.internalAmount) &&
        Objects.equals(this.captureAmount, bookingContractItem.captureAmount) &&
        Objects.equals(this.sourceAmountRefundModifier, bookingContractItem.sourceAmountRefundModifier) &&
        Objects.equals(this.displayAmountRefundModifier, bookingContractItem.displayAmountRefundModifier) &&
        Objects.equals(this.supplierAmountRefundModifier, bookingContractItem.supplierAmountRefundModifier) &&
        Objects.equals(this.internalAmountRefundModifier, bookingContractItem.internalAmountRefundModifier) &&
        Objects.equals(this.captureAmountRefundModifier, bookingContractItem.captureAmountRefundModifier) &&
        Objects.equals(this.netSourceAmount, bookingContractItem.netSourceAmount) &&
        Objects.equals(this.netDisplayAmount, bookingContractItem.netDisplayAmount) &&
        Objects.equals(this.netSupplierAmount, bookingContractItem.netSupplierAmount) &&
        Objects.equals(this.netInternalAmount, bookingContractItem.netInternalAmount) &&
        Objects.equals(this.netCaptureAmount, bookingContractItem.netCaptureAmount) &&
        Objects.equals(this.metadata, bookingContractItem.metadata) &&
        Objects.equals(this.cancellableWithNoCharges, bookingContractItem.cancellableWithNoCharges) &&
        Objects.equals(this.cancellableWithPotentialCharges, bookingContractItem.cancellableWithPotentialCharges) &&
        Objects.equals(this.cancellableByTraveler, bookingContractItem.cancellableByTraveler) &&
        Objects.equals(this.cancellableBySupplierOrAgent, bookingContractItem.cancellableBySupplierOrAgent);
  }

  @Override
  public int hashCode() {
    return Objects.hash(supplierItemBookingCode, user, nameInEnglish, descriptionInEnglish, itinerary, pricingType, type, beneficiaryList, payable, policy, externalIdentifier, tokensEarned, dailyRateList, cancelled, sourceCurrency, displayCurrency, supplierCurrency, internalCurrency, captureCurrency, sourceAmount, displayAmount, supplierAmount, internalAmount, captureAmount, sourceAmountRefundModifier, displayAmountRefundModifier, supplierAmountRefundModifier, internalAmountRefundModifier, captureAmountRefundModifier, netSourceAmount, netDisplayAmount, netSupplierAmount, netInternalAmount, netCaptureAmount, metadata, cancellableWithNoCharges, cancellableWithPotentialCharges, cancellableByTraveler, cancellableBySupplierOrAgent);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContractItem {\n");
    sb.append("    supplierItemBookingCode: ").append(toIndentedString(supplierItemBookingCode)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    nameInEnglish: ").append(toIndentedString(nameInEnglish)).append("\n");
    sb.append("    descriptionInEnglish: ").append(toIndentedString(descriptionInEnglish)).append("\n");
    sb.append("    itinerary: ").append(toIndentedString(itinerary)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    beneficiaryList: ").append(toIndentedString(beneficiaryList)).append("\n");
    sb.append("    payable: ").append(toIndentedString(payable)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    externalIdentifier: ").append(toIndentedString(externalIdentifier)).append("\n");
    sb.append("    tokensEarned: ").append(toIndentedString(tokensEarned)).append("\n");
    sb.append("    dailyRateList: ").append(toIndentedString(dailyRateList)).append("\n");
    sb.append("    cancelled: ").append(toIndentedString(cancelled)).append("\n");
    sb.append("    sourceCurrency: ").append(toIndentedString(sourceCurrency)).append("\n");
    sb.append("    displayCurrency: ").append(toIndentedString(displayCurrency)).append("\n");
    sb.append("    supplierCurrency: ").append(toIndentedString(supplierCurrency)).append("\n");
    sb.append("    internalCurrency: ").append(toIndentedString(internalCurrency)).append("\n");
    sb.append("    captureCurrency: ").append(toIndentedString(captureCurrency)).append("\n");
    sb.append("    sourceAmount: ").append(toIndentedString(sourceAmount)).append("\n");
    sb.append("    displayAmount: ").append(toIndentedString(displayAmount)).append("\n");
    sb.append("    supplierAmount: ").append(toIndentedString(supplierAmount)).append("\n");
    sb.append("    internalAmount: ").append(toIndentedString(internalAmount)).append("\n");
    sb.append("    captureAmount: ").append(toIndentedString(captureAmount)).append("\n");
    sb.append("    sourceAmountRefundModifier: ").append(toIndentedString(sourceAmountRefundModifier)).append("\n");
    sb.append("    displayAmountRefundModifier: ").append(toIndentedString(displayAmountRefundModifier)).append("\n");
    sb.append("    supplierAmountRefundModifier: ").append(toIndentedString(supplierAmountRefundModifier)).append("\n");
    sb.append("    internalAmountRefundModifier: ").append(toIndentedString(internalAmountRefundModifier)).append("\n");
    sb.append("    captureAmountRefundModifier: ").append(toIndentedString(captureAmountRefundModifier)).append("\n");
    sb.append("    netSourceAmount: ").append(toIndentedString(netSourceAmount)).append("\n");
    sb.append("    netDisplayAmount: ").append(toIndentedString(netDisplayAmount)).append("\n");
    sb.append("    netSupplierAmount: ").append(toIndentedString(netSupplierAmount)).append("\n");
    sb.append("    netInternalAmount: ").append(toIndentedString(netInternalAmount)).append("\n");
    sb.append("    netCaptureAmount: ").append(toIndentedString(netCaptureAmount)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    cancellableWithNoCharges: ").append(toIndentedString(cancellableWithNoCharges)).append("\n");
    sb.append("    cancellableWithPotentialCharges: ").append(toIndentedString(cancellableWithPotentialCharges)).append("\n");
    sb.append("    cancellableByTraveler: ").append(toIndentedString(cancellableByTraveler)).append("\n");
    sb.append("    cancellableBySupplierOrAgent: ").append(toIndentedString(cancellableBySupplierOrAgent)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

