/*
 * Wink Payment API
 * A programmatic way to create bookings, receive reactive and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Mapping record is responsible for mapping a local account identifier with a remote system. When a booking comes in from the remote system, we will know how to properly assign funds to the correct accounts.
 */
@JsonPropertyOrder({
  Mapping.JSON_PROPERTY_ID,
  Mapping.JSON_PROPERTY_CREATED_DATE,
  Mapping.JSON_PROPERTY_LAST_UPDATE,
  Mapping.JSON_PROPERTY_VERSION,
  Mapping.JSON_PROPERTY_ACCOUNT_OWNER_IDENTIFIER,
  Mapping.JSON_PROPERTY_LOCAL_ACCOUNT_IDENTIFIER,
  Mapping.JSON_PROPERTY_EXTERNAL_IDENTIFIER,
  Mapping.JSON_PROPERTY_ACCOUNT_IDENTIFIER,
  Mapping.JSON_PROPERTY_NAME
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:12:05.578754358+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class Mapping {
  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nullable
  private String id;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  @jakarta.annotation.Nullable
  private java.time.LocalDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  @jakarta.annotation.Nullable
  private java.time.LocalDateTime lastUpdate;

  public static final String JSON_PROPERTY_VERSION = "version";
  @jakarta.annotation.Nullable
  private Long version;

  public static final String JSON_PROPERTY_ACCOUNT_OWNER_IDENTIFIER = "accountOwnerIdentifier";
  @jakarta.annotation.Nonnull
  private String accountOwnerIdentifier;

  public static final String JSON_PROPERTY_LOCAL_ACCOUNT_IDENTIFIER = "localAccountIdentifier";
  @jakarta.annotation.Nonnull
  private String localAccountIdentifier;

  public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
  @jakarta.annotation.Nonnull
  private String externalIdentifier;

  public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
  @jakarta.annotation.Nonnull
  private String accountIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public Mapping() {
  }

  public Mapping id(@jakarta.annotation.Nullable String id) {
    
    this.id = id;
    return this;
  }

  /**
   * Document UUID
   * @return id
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(@jakarta.annotation.Nullable String id) {
    this.id = id;
  }

  public Mapping createdDate(@jakarta.annotation.Nullable java.time.LocalDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

  /**
   * Datetime this record was first created
   * @return createdDate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(@jakarta.annotation.Nullable java.time.LocalDateTime createdDate) {
    this.createdDate = createdDate;
  }

  public Mapping lastUpdate(@jakarta.annotation.Nullable java.time.LocalDateTime lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

  /**
   * Datetime this record was last updated
   * @return lastUpdate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(@jakarta.annotation.Nullable java.time.LocalDateTime lastUpdate) {
    this.lastUpdate = lastUpdate;
  }

  public Mapping version(@jakarta.annotation.Nullable Long version) {
    
    this.version = version;
    return this;
  }

  /**
   * Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.
   * @return version
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(@jakarta.annotation.Nullable Long version) {
    this.version = version;
  }

  public Mapping accountOwnerIdentifier(@jakarta.annotation.Nonnull String accountOwnerIdentifier) {
    
    this.accountOwnerIdentifier = accountOwnerIdentifier;
    return this;
  }

  /**
   * The entity that owns this account.
   * @return accountOwnerIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_ACCOUNT_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountOwnerIdentifier() {
    return accountOwnerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountOwnerIdentifier(@jakarta.annotation.Nonnull String accountOwnerIdentifier) {
    this.accountOwnerIdentifier = accountOwnerIdentifier;
  }

  public Mapping localAccountIdentifier(@jakarta.annotation.Nonnull String localAccountIdentifier) {
    
    this.localAccountIdentifier = localAccountIdentifier;
    return this;
  }

  /**
   * Local account identifier is the account identifier of the remote entity within TripPay
   * @return localAccountIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_LOCAL_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLocalAccountIdentifier() {
    return localAccountIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_LOCAL_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocalAccountIdentifier(@jakarta.annotation.Nonnull String localAccountIdentifier) {
    this.localAccountIdentifier = localAccountIdentifier;
  }

  public Mapping externalIdentifier(@jakarta.annotation.Nonnull String externalIdentifier) {
    
    this.externalIdentifier = externalIdentifier;
    return this;
  }

  /**
   * External identifier is the identifier of this entity in a remote system
   * @return externalIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getExternalIdentifier() {
    return externalIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExternalIdentifier(@jakarta.annotation.Nonnull String externalIdentifier) {
    this.externalIdentifier = externalIdentifier;
  }

  public Mapping accountIdentifier(@jakarta.annotation.Nonnull String accountIdentifier) {
    
    this.accountIdentifier = accountIdentifier;
    return this;
  }

  /**
   * Account identifier is the account doing the mapping
   * @return accountIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountIdentifier() {
    return accountIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountIdentifier(@jakarta.annotation.Nonnull String accountIdentifier) {
    this.accountIdentifier = accountIdentifier;
  }

  public Mapping name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Name of the entity being mapped
   * @return name
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Mapping mapping = (Mapping) o;
    return Objects.equals(this.id, mapping.id) &&
        Objects.equals(this.createdDate, mapping.createdDate) &&
        Objects.equals(this.lastUpdate, mapping.lastUpdate) &&
        Objects.equals(this.version, mapping.version) &&
        Objects.equals(this.accountOwnerIdentifier, mapping.accountOwnerIdentifier) &&
        Objects.equals(this.localAccountIdentifier, mapping.localAccountIdentifier) &&
        Objects.equals(this.externalIdentifier, mapping.externalIdentifier) &&
        Objects.equals(this.accountIdentifier, mapping.accountIdentifier) &&
        Objects.equals(this.name, mapping.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdDate, lastUpdate, version, accountOwnerIdentifier, localAccountIdentifier, externalIdentifier, accountIdentifier, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Mapping {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    accountOwnerIdentifier: ").append(toIndentedString(accountOwnerIdentifier)).append("\n");
    sb.append("    localAccountIdentifier: ").append(toIndentedString(localAccountIdentifier)).append("\n");
    sb.append("    externalIdentifier: ").append(toIndentedString(externalIdentifier)).append("\n");
    sb.append("    accountIdentifier: ").append(toIndentedString(accountIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

