/*
 * Wink Payment API
 * A programmatic way to create bookings, receive reactive and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Notification
 */
@JsonPropertyOrder({
  Notification.JSON_PROPERTY_ID,
  Notification.JSON_PROPERTY_CREATED_DATE,
  Notification.JSON_PROPERTY_LAST_UPDATE,
  Notification.JSON_PROPERTY_VERSION,
  Notification.JSON_PROPERTY_OWNER_IDENTIFIER,
  Notification.JSON_PROPERTY_PRIORITY,
  Notification.JSON_PROPERTY_TYPE,
  Notification.JSON_PROPERTY_RECIPIENT_TYPE,
  Notification.JSON_PROPERTY_APPLICATION,
  Notification.JSON_PROPERTY_MESSAGE_TEMPLATE_ID,
  Notification.JSON_PROPERTY_SUBJECT,
  Notification.JSON_PROPERTY_BODY,
  Notification.JSON_PROPERTY_CTA_URL,
  Notification.JSON_PROPERTY_READ,
  Notification.JSON_PROPERTY_MARKED_AS_REMOVED,
  Notification.JSON_PROPERTY_NOTIFY_VIA_EMAIL
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:12:05.578754358+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class Notification {
  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nullable
  private String id;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  @jakarta.annotation.Nullable
  private java.time.LocalDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  @jakarta.annotation.Nullable
  private java.time.LocalDateTime lastUpdate;

  public static final String JSON_PROPERTY_VERSION = "version";
  @jakarta.annotation.Nullable
  private Long version;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  @jakarta.annotation.Nonnull
  private UUID ownerIdentifier;

  /**
   * Importance of message
   */
  public enum PriorityEnum {
    HIGH(String.valueOf("HIGH")),
    
    MEDIUM(String.valueOf("MEDIUM")),
    
    LOW(String.valueOf("LOW"));

    private String value;

    PriorityEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PriorityEnum fromValue(String value) {
      for (PriorityEnum b : PriorityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRIORITY = "priority";
  @jakarta.annotation.Nonnull
  private PriorityEnum priority;

  /**
   * Message type
   */
  public enum TypeEnum {
    ALERT(String.valueOf("ALERT")),
    
    MESSAGE(String.valueOf("MESSAGE")),
    
    FEATURE(String.valueOf("FEATURE"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  @jakarta.annotation.Nonnull
  private TypeEnum type;

  /**
   * Recipient type
   */
  public enum RecipientTypeEnum {
    USER(String.valueOf("USER")),
    
    ACCOUNT(String.valueOf("ACCOUNT"));

    private String value;

    RecipientTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RecipientTypeEnum fromValue(String value) {
      for (RecipientTypeEnum b : RecipientTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RECIPIENT_TYPE = "recipientType";
  @jakarta.annotation.Nonnull
  private RecipientTypeEnum recipientType;

  /**
   * Application domain
   */
  public enum ApplicationEnum {
    EXTRANET(String.valueOf("EXTRANET")),
    
    CORPORATE(String.valueOf("CORPORATE")),
    
    TRAVEL_AGENT(String.valueOf("TRAVEL_AGENT")),
    
    STUDIO(String.valueOf("STUDIO")),
    
    PAYMENT(String.valueOf("PAYMENT"));

    private String value;

    ApplicationEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ApplicationEnum fromValue(String value) {
      for (ApplicationEnum b : ApplicationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_APPLICATION = "application";
  @jakarta.annotation.Nonnull
  private ApplicationEnum application;

  public static final String JSON_PROPERTY_MESSAGE_TEMPLATE_ID = "messageTemplateId";
  @jakarta.annotation.Nonnull
  private String messageTemplateId;

  public static final String JSON_PROPERTY_SUBJECT = "subject";
  @jakarta.annotation.Nonnull
  private String subject;

  public static final String JSON_PROPERTY_BODY = "body";
  @jakarta.annotation.Nonnull
  private String body;

  public static final String JSON_PROPERTY_CTA_URL = "ctaUrl";
  @jakarta.annotation.Nonnull
  private String ctaUrl;

  public static final String JSON_PROPERTY_READ = "read";
  @jakarta.annotation.Nullable
  private Boolean read;

  public static final String JSON_PROPERTY_MARKED_AS_REMOVED = "markedAsRemoved";
  @jakarta.annotation.Nullable
  private Boolean markedAsRemoved;

  public static final String JSON_PROPERTY_NOTIFY_VIA_EMAIL = "notifyViaEmail";
  @jakarta.annotation.Nullable
  private Boolean notifyViaEmail;

  public Notification() {
  }

  public Notification id(@jakarta.annotation.Nullable String id) {
    
    this.id = id;
    return this;
  }

  /**
   * Document UUID
   * @return id
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(@jakarta.annotation.Nullable String id) {
    this.id = id;
  }

  public Notification createdDate(@jakarta.annotation.Nullable java.time.LocalDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

  /**
   * Datetime this record was first created
   * @return createdDate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(@jakarta.annotation.Nullable java.time.LocalDateTime createdDate) {
    this.createdDate = createdDate;
  }

  public Notification lastUpdate(@jakarta.annotation.Nullable java.time.LocalDateTime lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

  /**
   * Datetime this record was last updated
   * @return lastUpdate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(@jakarta.annotation.Nullable java.time.LocalDateTime lastUpdate) {
    this.lastUpdate = lastUpdate;
  }

  public Notification version(@jakarta.annotation.Nullable Long version) {
    
    this.version = version;
    return this;
  }

  /**
   * Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.
   * @return version
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(@jakarta.annotation.Nullable Long version) {
    this.version = version;
  }

  public Notification ownerIdentifier(@jakarta.annotation.Nonnull UUID ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

  /**
   * Owner identifier
   * @return ownerIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerIdentifier(@jakarta.annotation.Nonnull UUID ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }

  public Notification priority(@jakarta.annotation.Nonnull PriorityEnum priority) {
    
    this.priority = priority;
    return this;
  }

  /**
   * Importance of message
   * @return priority
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PriorityEnum getPriority() {
    return priority;
  }


  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPriority(@jakarta.annotation.Nonnull PriorityEnum priority) {
    this.priority = priority;
  }

  public Notification type(@jakarta.annotation.Nonnull TypeEnum type) {
    
    this.type = type;
    return this;
  }

  /**
   * Message type
   * @return type
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(@jakarta.annotation.Nonnull TypeEnum type) {
    this.type = type;
  }

  public Notification recipientType(@jakarta.annotation.Nonnull RecipientTypeEnum recipientType) {
    
    this.recipientType = recipientType;
    return this;
  }

  /**
   * Recipient type
   * @return recipientType
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_RECIPIENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RecipientTypeEnum getRecipientType() {
    return recipientType;
  }


  @JsonProperty(JSON_PROPERTY_RECIPIENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRecipientType(@jakarta.annotation.Nonnull RecipientTypeEnum recipientType) {
    this.recipientType = recipientType;
  }

  public Notification application(@jakarta.annotation.Nonnull ApplicationEnum application) {
    
    this.application = application;
    return this;
  }

  /**
   * Application domain
   * @return application
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_APPLICATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ApplicationEnum getApplication() {
    return application;
  }


  @JsonProperty(JSON_PROPERTY_APPLICATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setApplication(@jakarta.annotation.Nonnull ApplicationEnum application) {
    this.application = application;
  }

  public Notification messageTemplateId(@jakarta.annotation.Nonnull String messageTemplateId) {
    
    this.messageTemplateId = messageTemplateId;
    return this;
  }

  /**
   * Message template
   * @return messageTemplateId
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_MESSAGE_TEMPLATE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMessageTemplateId() {
    return messageTemplateId;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE_TEMPLATE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMessageTemplateId(@jakarta.annotation.Nonnull String messageTemplateId) {
    this.messageTemplateId = messageTemplateId;
  }

  public Notification subject(@jakarta.annotation.Nonnull String subject) {
    
    this.subject = subject;
    return this;
  }

  /**
   * Subject of message
   * @return subject
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSubject() {
    return subject;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSubject(@jakarta.annotation.Nonnull String subject) {
    this.subject = subject;
  }

  public Notification body(@jakarta.annotation.Nonnull String body) {
    
    this.body = body;
    return this;
  }

  /**
   * Subject of message
   * @return body
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBody() {
    return body;
  }


  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBody(@jakarta.annotation.Nonnull String body) {
    this.body = body;
  }

  public Notification ctaUrl(@jakarta.annotation.Nonnull String ctaUrl) {
    
    this.ctaUrl = ctaUrl;
    return this;
  }

  /**
   * Path to feature
   * @return ctaUrl
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_CTA_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCtaUrl() {
    return ctaUrl;
  }


  @JsonProperty(JSON_PROPERTY_CTA_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCtaUrl(@jakarta.annotation.Nonnull String ctaUrl) {
    this.ctaUrl = ctaUrl;
  }

  public Notification read(@jakarta.annotation.Nullable Boolean read) {
    
    this.read = read;
    return this;
  }

  /**
   * AffiliateAccountLightweight read announcement
   * @return read
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_READ)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRead() {
    return read;
  }


  @JsonProperty(JSON_PROPERTY_READ)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRead(@jakarta.annotation.Nullable Boolean read) {
    this.read = read;
  }

  public Notification markedAsRemoved(@jakarta.annotation.Nullable Boolean markedAsRemoved) {
    
    this.markedAsRemoved = markedAsRemoved;
    return this;
  }

  /**
   * Message marked as removed
   * @return markedAsRemoved
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MARKED_AS_REMOVED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMarkedAsRemoved() {
    return markedAsRemoved;
  }


  @JsonProperty(JSON_PROPERTY_MARKED_AS_REMOVED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMarkedAsRemoved(@jakarta.annotation.Nullable Boolean markedAsRemoved) {
    this.markedAsRemoved = markedAsRemoved;
  }

  public Notification notifyViaEmail(@jakarta.annotation.Nullable Boolean notifyViaEmail) {
    
    this.notifyViaEmail = notifyViaEmail;
    return this;
  }

  /**
   * Also send email announcement
   * @return notifyViaEmail
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NOTIFY_VIA_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getNotifyViaEmail() {
    return notifyViaEmail;
  }


  @JsonProperty(JSON_PROPERTY_NOTIFY_VIA_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNotifyViaEmail(@jakarta.annotation.Nullable Boolean notifyViaEmail) {
    this.notifyViaEmail = notifyViaEmail;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Notification notification = (Notification) o;
    return Objects.equals(this.id, notification.id) &&
        Objects.equals(this.createdDate, notification.createdDate) &&
        Objects.equals(this.lastUpdate, notification.lastUpdate) &&
        Objects.equals(this.version, notification.version) &&
        Objects.equals(this.ownerIdentifier, notification.ownerIdentifier) &&
        Objects.equals(this.priority, notification.priority) &&
        Objects.equals(this.type, notification.type) &&
        Objects.equals(this.recipientType, notification.recipientType) &&
        Objects.equals(this.application, notification.application) &&
        Objects.equals(this.messageTemplateId, notification.messageTemplateId) &&
        Objects.equals(this.subject, notification.subject) &&
        Objects.equals(this.body, notification.body) &&
        Objects.equals(this.ctaUrl, notification.ctaUrl) &&
        Objects.equals(this.read, notification.read) &&
        Objects.equals(this.markedAsRemoved, notification.markedAsRemoved) &&
        Objects.equals(this.notifyViaEmail, notification.notifyViaEmail);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdDate, lastUpdate, version, ownerIdentifier, priority, type, recipientType, application, messageTemplateId, subject, body, ctaUrl, read, markedAsRemoved, notifyViaEmail);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Notification {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    recipientType: ").append(toIndentedString(recipientType)).append("\n");
    sb.append("    application: ").append(toIndentedString(application)).append("\n");
    sb.append("    messageTemplateId: ").append(toIndentedString(messageTemplateId)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    ctaUrl: ").append(toIndentedString(ctaUrl)).append("\n");
    sb.append("    read: ").append(toIndentedString(read)).append("\n");
    sb.append("    markedAsRemoved: ").append(toIndentedString(markedAsRemoved)).append("\n");
    sb.append("    notifyViaEmail: ").append(toIndentedString(notifyViaEmail)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

