/*
 * Wink Payment API
 * A programmatic way to create bookings, receive reactive and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.CustomMonetaryAmount;
import io.trippay.sdk.payment.model.GuestUser;
import io.trippay.sdk.payment.model.PayableContractSupplierItemBeneficiary;
import io.trippay.sdk.payment.model.SimpleDateTimeItinerary;
import io.trippay.sdk.payment.model.SupplierContractItemPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Holds one booking line item for a specific supplier.
 */
@JsonPropertyOrder({
  PayableContractSupplierItem.JSON_PROPERTY_USER,
  PayableContractSupplierItem.JSON_PROPERTY_NAME_IN_ENGLISH,
  PayableContractSupplierItem.JSON_PROPERTY_DESCRIPTION_IN_ENGLISH,
  PayableContractSupplierItem.JSON_PROPERTY_PRICE,
  PayableContractSupplierItem.JSON_PROPERTY_ITINERARY,
  PayableContractSupplierItem.JSON_PROPERTY_PRICING_TYPE,
  PayableContractSupplierItem.JSON_PROPERTY_TYPE,
  PayableContractSupplierItem.JSON_PROPERTY_BENEFICIARY_LIST,
  PayableContractSupplierItem.JSON_PROPERTY_PAYABLE,
  PayableContractSupplierItem.JSON_PROPERTY_POLICY,
  PayableContractSupplierItem.JSON_PROPERTY_EXTERNAL_IDENTIFIER,
  PayableContractSupplierItem.JSON_PROPERTY_DAILY_RATE_LIST,
  PayableContractSupplierItem.JSON_PROPERTY_METADATA
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:12:05.578754358+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class PayableContractSupplierItem {
  public static final String JSON_PROPERTY_USER = "user";
  @jakarta.annotation.Nonnull
  private GuestUser user;

  public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
  @jakarta.annotation.Nonnull
  private String nameInEnglish;

  public static final String JSON_PROPERTY_DESCRIPTION_IN_ENGLISH = "descriptionInEnglish";
  @jakarta.annotation.Nonnull
  private String descriptionInEnglish;

  public static final String JSON_PROPERTY_PRICE = "price";
  @jakarta.annotation.Nonnull
  private CustomMonetaryAmount price;

  public static final String JSON_PROPERTY_ITINERARY = "itinerary";
  @jakarta.annotation.Nonnull
  private SimpleDateTimeItinerary itinerary;

  /**
   * Indicates the way this item should be priced.
   */
  public enum PricingTypeEnum {
    PER_STAY(String.valueOf("PER_STAY")),
    
    PER_DAY(String.valueOf("PER_DAY")),
    
    PER_NIGHT(String.valueOf("PER_NIGHT")),
    
    PER_USE(String.valueOf("PER_USE")),
    
    PER_HOUR(String.valueOf("PER_HOUR")),
    
    PER_PERSON(String.valueOf("PER_PERSON")),
    
    PER_PERSON_PER_NIGHT(String.valueOf("PER_PERSON_PER_NIGHT")),
    
    PER_PERSON_PER_HOUR(String.valueOf("PER_PERSON_PER_HOUR")),
    
    PER_ADULT(String.valueOf("PER_ADULT")),
    
    PER_ADULT_PER_NIGHT(String.valueOf("PER_ADULT_PER_NIGHT")),
    
    PER_ADULT_PER_HOUR(String.valueOf("PER_ADULT_PER_HOUR")),
    
    PER_CHILD(String.valueOf("PER_CHILD")),
    
    PER_CHILD_PER_NIGHT(String.valueOf("PER_CHILD_PER_NIGHT")),
    
    PER_CHILD_PER_HOUR(String.valueOf("PER_CHILD_PER_HOUR"));

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  @jakarta.annotation.Nonnull
  private PricingTypeEnum pricingType;

  /**
   * Type of item this is.
   */
  public enum TypeEnum {
    LODGING(String.valueOf("LODGING")),
    
    RAIL(String.valueOf("RAIL")),
    
    AIR(String.valueOf("AIR")),
    
    CAR(String.valueOf("CAR")),
    
    CRUISE(String.valueOf("CRUISE")),
    
    PACKAGE(String.valueOf("PACKAGE")),
    
    ADD_ON(String.valueOf("ADD_ON")),
    
    RENTAL(String.valueOf("RENTAL")),
    
    EXPERIENCE(String.valueOf("EXPERIENCE")),
    
    ANCILLARY_BOOKING(String.valueOf("ANCILLARY_BOOKING")),
    
    ANCILLARY_FEE(String.valueOf("ANCILLARY_FEE"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  @jakarta.annotation.Nonnull
  private TypeEnum type;

  public static final String JSON_PROPERTY_BENEFICIARY_LIST = "beneficiaryList";
  @jakarta.annotation.Nonnull
  private List<@Valid PayableContractSupplierItemBeneficiary> beneficiaryList = new ArrayList<>();

  /**
   * When to charge for this item.
   */
  public enum PayableEnum {
    IMMEDIATE(String.valueOf("IMMEDIATE")),
    
    ARRIVAL(String.valueOf("ARRIVAL")),
    
    DEPARTURE(String.valueOf("DEPARTURE")),
    
    AGENT(String.valueOf("AGENT"));

    private String value;

    PayableEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PayableEnum fromValue(String value) {
      for (PayableEnum b : PayableEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYABLE = "payable";
  @jakarta.annotation.Nonnull
  private PayableEnum payable;

  public static final String JSON_PROPERTY_POLICY = "policy";
  @jakarta.annotation.Nullable
  private SupplierContractItemPolicy policy;

  public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
  @jakarta.annotation.Nullable
  private String externalIdentifier;

  public static final String JSON_PROPERTY_DAILY_RATE_LIST = "dailyRateList";
  @jakarta.annotation.Nullable
  private List<Object> dailyRateList = new ArrayList<>();

  public static final String JSON_PROPERTY_METADATA = "metadata";
  @jakarta.annotation.Nullable
  private Map<String, String> metadata = new HashMap<>();

  public PayableContractSupplierItem() {
  }

  public PayableContractSupplierItem user(@jakarta.annotation.Nonnull GuestUser user) {
    
    this.user = user;
    return this;
  }

  /**
   * Person doing the booking.
   * @return user
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GuestUser getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(@jakarta.annotation.Nonnull GuestUser user) {
    this.user = user;
  }

  public PayableContractSupplierItem nameInEnglish(@jakarta.annotation.Nonnull String nameInEnglish) {
    
    this.nameInEnglish = nameInEnglish;
    return this;
  }

  /**
   * Name of item in English included in booking.
   * @return nameInEnglish
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getNameInEnglish() {
    return nameInEnglish;
  }


  @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNameInEnglish(@jakarta.annotation.Nonnull String nameInEnglish) {
    this.nameInEnglish = nameInEnglish;
  }

  public PayableContractSupplierItem descriptionInEnglish(@jakarta.annotation.Nonnull String descriptionInEnglish) {
    
    this.descriptionInEnglish = descriptionInEnglish;
    return this;
  }

  /**
   * Short description in English of item included in booking.
   * @return descriptionInEnglish
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_DESCRIPTION_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescriptionInEnglish() {
    return descriptionInEnglish;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptionInEnglish(@jakarta.annotation.Nonnull String descriptionInEnglish) {
    this.descriptionInEnglish = descriptionInEnglish;
  }

  public PayableContractSupplierItem price(@jakarta.annotation.Nonnull CustomMonetaryAmount price) {
    
    this.price = price;
    return this;
  }

  /**
   * Raw incoming price.
   * @return price
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrice(@jakarta.annotation.Nonnull CustomMonetaryAmount price) {
    this.price = price;
  }

  public PayableContractSupplierItem itinerary(@jakarta.annotation.Nonnull SimpleDateTimeItinerary itinerary) {
    
    this.itinerary = itinerary;
    return this;
  }

  /**
   * Get itinerary
   * @return itinerary
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SimpleDateTimeItinerary getItinerary() {
    return itinerary;
  }


  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItinerary(@jakarta.annotation.Nonnull SimpleDateTimeItinerary itinerary) {
    this.itinerary = itinerary;
  }

  public PayableContractSupplierItem pricingType(@jakarta.annotation.Nonnull PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

  /**
   * Indicates the way this item should be priced.
   * @return pricingType
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricingType(@jakarta.annotation.Nonnull PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }

  public PayableContractSupplierItem type(@jakarta.annotation.Nonnull TypeEnum type) {
    
    this.type = type;
    return this;
  }

  /**
   * Type of item this is.
   * @return type
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(@jakarta.annotation.Nonnull TypeEnum type) {
    this.type = type;
  }

  public PayableContractSupplierItem beneficiaryList(@jakarta.annotation.Nonnull List<@Valid PayableContractSupplierItemBeneficiary> beneficiaryList) {
    
    this.beneficiaryList = beneficiaryList;
    return this;
  }

  public PayableContractSupplierItem addBeneficiaryListItem(PayableContractSupplierItemBeneficiary beneficiaryListItem) {
    if (this.beneficiaryList == null) {
      this.beneficiaryList = new ArrayList<>();
    }
    this.beneficiaryList.add(beneficiaryListItem);
    return this;
  }

  /**
   * Get beneficiaryList
   * @return beneficiaryList
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_BENEFICIARY_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<@Valid PayableContractSupplierItemBeneficiary> getBeneficiaryList() {
    return beneficiaryList;
  }


  @JsonProperty(JSON_PROPERTY_BENEFICIARY_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBeneficiaryList(@jakarta.annotation.Nonnull List<@Valid PayableContractSupplierItemBeneficiary> beneficiaryList) {
    this.beneficiaryList = beneficiaryList;
  }

  public PayableContractSupplierItem payable(@jakarta.annotation.Nonnull PayableEnum payable) {
    
    this.payable = payable;
    return this;
  }

  /**
   * When to charge for this item.
   * @return payable
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PAYABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PayableEnum getPayable() {
    return payable;
  }


  @JsonProperty(JSON_PROPERTY_PAYABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPayable(@jakarta.annotation.Nonnull PayableEnum payable) {
    this.payable = payable;
  }

  public PayableContractSupplierItem policy(@jakarta.annotation.Nullable SupplierContractItemPolicy policy) {
    
    this.policy = policy;
    return this;
  }

  /**
   * Get policy
   * @return policy
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SupplierContractItemPolicy getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(@jakarta.annotation.Nullable SupplierContractItemPolicy policy) {
    this.policy = policy;
  }

  public PayableContractSupplierItem externalIdentifier(@jakarta.annotation.Nullable String externalIdentifier) {
    
    this.externalIdentifier = externalIdentifier;
    return this;
  }

  /**
   * Optional geoname externalIdentifier to remote blocking.
   * @return externalIdentifier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalIdentifier() {
    return externalIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalIdentifier(@jakarta.annotation.Nullable String externalIdentifier) {
    this.externalIdentifier = externalIdentifier;
  }

  public PayableContractSupplierItem dailyRateList(@jakarta.annotation.Nullable List<Object> dailyRateList) {
    
    this.dailyRateList = dailyRateList;
    return this;
  }

  public PayableContractSupplierItem addDailyRateListItem(Object dailyRateListItem) {
    if (this.dailyRateList == null) {
      this.dailyRateList = new ArrayList<>();
    }
    this.dailyRateList.add(dailyRateListItem);
    return this;
  }

  /**
   * Get dailyRateList
   * @return dailyRateList
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getDailyRateList() {
    return dailyRateList;
  }


  @JsonProperty(JSON_PROPERTY_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDailyRateList(@jakarta.annotation.Nullable List<Object> dailyRateList) {
    this.dailyRateList = dailyRateList;
  }

  public PayableContractSupplierItem metadata(@jakarta.annotation.Nullable Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public PayableContractSupplierItem putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

  /**
   * Place to add more data related to the booking contract item.
   * @return metadata
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(@jakarta.annotation.Nullable Map<String, String> metadata) {
    this.metadata = metadata;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayableContractSupplierItem payableContractSupplierItem = (PayableContractSupplierItem) o;
    return Objects.equals(this.user, payableContractSupplierItem.user) &&
        Objects.equals(this.nameInEnglish, payableContractSupplierItem.nameInEnglish) &&
        Objects.equals(this.descriptionInEnglish, payableContractSupplierItem.descriptionInEnglish) &&
        Objects.equals(this.price, payableContractSupplierItem.price) &&
        Objects.equals(this.itinerary, payableContractSupplierItem.itinerary) &&
        Objects.equals(this.pricingType, payableContractSupplierItem.pricingType) &&
        Objects.equals(this.type, payableContractSupplierItem.type) &&
        Objects.equals(this.beneficiaryList, payableContractSupplierItem.beneficiaryList) &&
        Objects.equals(this.payable, payableContractSupplierItem.payable) &&
        Objects.equals(this.policy, payableContractSupplierItem.policy) &&
        Objects.equals(this.externalIdentifier, payableContractSupplierItem.externalIdentifier) &&
        Objects.equals(this.dailyRateList, payableContractSupplierItem.dailyRateList) &&
        Objects.equals(this.metadata, payableContractSupplierItem.metadata);
  }

  @Override
  public int hashCode() {
    return Objects.hash(user, nameInEnglish, descriptionInEnglish, price, itinerary, pricingType, type, beneficiaryList, payable, policy, externalIdentifier, dailyRateList, metadata);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayableContractSupplierItem {\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    nameInEnglish: ").append(toIndentedString(nameInEnglish)).append("\n");
    sb.append("    descriptionInEnglish: ").append(toIndentedString(descriptionInEnglish)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    itinerary: ").append(toIndentedString(itinerary)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    beneficiaryList: ").append(toIndentedString(beneficiaryList)).append("\n");
    sb.append("    payable: ").append(toIndentedString(payable)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    externalIdentifier: ").append(toIndentedString(externalIdentifier)).append("\n");
    sb.append("    dailyRateList: ").append(toIndentedString(dailyRateList)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

