/*
 * Wink Payment API
 * A programmatic way to create bookings, receive reactive and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.CustomMonetaryAmount;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * RefundRequest
 */
@JsonPropertyOrder({
  RefundRequest.JSON_PROPERTY_REFUND,
  RefundRequest.JSON_PROPERTY_DESCRIPTION,
  RefundRequest.JSON_PROPERTY_REASON_TYPE,
  RefundRequest.JSON_PROPERTY_CANCEL_ON_REFUND
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:12:05.578754358+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class RefundRequest {
  public static final String JSON_PROPERTY_REFUND = "refund";
  @jakarta.annotation.Nonnull
  private CustomMonetaryAmount refund;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  @jakarta.annotation.Nonnull
  private String description;

  /**
   * A description of the refund that can be displayed to booker
   */
  public enum ReasonTypeEnum {
    DUPLICATE(String.valueOf("DUPLICATE")),
    
    FRAUDULENT(String.valueOf("FRAUDULENT")),
    
    REQUESTED_BY_CUSTOMER(String.valueOf("REQUESTED_BY_CUSTOMER")),
    
    GUEST_COMPLAINT(String.valueOf("GUEST_COMPLAINT")),
    
    GUEST_BOOKED_INCORRECT_DATE(String.valueOf("GUEST_BOOKED_INCORRECT_DATE")),
    
    GUEST_SICK(String.valueOf("GUEST_SICK")),
    
    OVERBOOKING(String.valueOf("OVERBOOKING")),
    
    EMERGENCY(String.valueOf("EMERGENCY")),
    
    FLIGHT_CANCELLED(String.valueOf("FLIGHT_CANCELLED")),
    
    DEATH_IN_FAMILY(String.valueOf("DEATH_IN_FAMILY")),
    
    OTHER(String.valueOf("OTHER")),
    
    EXPIRED_UNCAPTURED_CHARGE(String.valueOf("EXPIRED_UNCAPTURED_CHARGE"));

    private String value;

    ReasonTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ReasonTypeEnum fromValue(String value) {
      for (ReasonTypeEnum b : ReasonTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REASON_TYPE = "reasonType";
  @jakarta.annotation.Nonnull
  private ReasonTypeEnum reasonType;

  /**
   * Whether to cancel the booking alongside requesting a refund.
   */
  public enum CancelOnRefundEnum {
    NONE(String.valueOf("NONE")),
    
    CANCEL_ON_SUCCESSFUL_REFUND(String.valueOf("CANCEL_ON_SUCCESSFUL_REFUND")),
    
    CANCEL_REGARDLESS(String.valueOf("CANCEL_REGARDLESS"));

    private String value;

    CancelOnRefundEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancelOnRefundEnum fromValue(String value) {
      for (CancelOnRefundEnum b : CancelOnRefundEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCEL_ON_REFUND = "cancelOnRefund";
  @jakarta.annotation.Nonnull
  private CancelOnRefundEnum cancelOnRefund;

  public RefundRequest() {
  }

  public RefundRequest refund(@jakarta.annotation.Nonnull CustomMonetaryAmount refund) {
    
    this.refund = refund;
    return this;
  }

  /**
   * The amount refunded
   * @return refund
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_REFUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getRefund() {
    return refund;
  }


  @JsonProperty(JSON_PROPERTY_REFUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRefund(@jakarta.annotation.Nonnull CustomMonetaryAmount refund) {
    this.refund = refund;
  }

  public RefundRequest description(@jakarta.annotation.Nonnull String description) {
    
    this.description = description;
    return this;
  }

  /**
   * A description of the refund that can be displayed to booker
   * @return description
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescription(@jakarta.annotation.Nonnull String description) {
    this.description = description;
  }

  public RefundRequest reasonType(@jakarta.annotation.Nonnull ReasonTypeEnum reasonType) {
    
    this.reasonType = reasonType;
    return this;
  }

  /**
   * A description of the refund that can be displayed to booker
   * @return reasonType
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_REASON_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ReasonTypeEnum getReasonType() {
    return reasonType;
  }


  @JsonProperty(JSON_PROPERTY_REASON_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setReasonType(@jakarta.annotation.Nonnull ReasonTypeEnum reasonType) {
    this.reasonType = reasonType;
  }

  public RefundRequest cancelOnRefund(@jakarta.annotation.Nonnull CancelOnRefundEnum cancelOnRefund) {
    
    this.cancelOnRefund = cancelOnRefund;
    return this;
  }

  /**
   * Whether to cancel the booking alongside requesting a refund.
   * @return cancelOnRefund
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CANCEL_ON_REFUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CancelOnRefundEnum getCancelOnRefund() {
    return cancelOnRefund;
  }


  @JsonProperty(JSON_PROPERTY_CANCEL_ON_REFUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCancelOnRefund(@jakarta.annotation.Nonnull CancelOnRefundEnum cancelOnRefund) {
    this.cancelOnRefund = cancelOnRefund;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RefundRequest refundRequest = (RefundRequest) o;
    return Objects.equals(this.refund, refundRequest.refund) &&
        Objects.equals(this.description, refundRequest.description) &&
        Objects.equals(this.reasonType, refundRequest.reasonType) &&
        Objects.equals(this.cancelOnRefund, refundRequest.cancelOnRefund);
  }

  @Override
  public int hashCode() {
    return Objects.hash(refund, description, reasonType, cancelOnRefund);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RefundRequest {\n");
    sb.append("    refund: ").append(toIndentedString(refund)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    reasonType: ").append(toIndentedString(reasonType)).append("\n");
    sb.append("    cancelOnRefund: ").append(toIndentedString(cancelOnRefund)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

