/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;
import io.trippay.sdk.payment.model.Notification;
import io.trippay.sdk.payment.model.SendNotification;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SendNotificationControllerApi {
    private ApiClient apiClient;

    public SendNotificationControllerApi() {
        this(new ApiClient());
    }

    @Autowired
    public SendNotificationControllerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createNotificationRequestCreation(@Nonnull SendNotification sendNotification, @Nullable String winkVersion) throws WebClientResponseException {
        SendNotification postBody = sendNotification;
        if (sendNotification == null) {
            throw new WebClientResponseException("Missing the required parameter 'sendNotification' when calling createNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Notification> localVarReturnType = new ParameterizedTypeReference<Notification>(this){};
        return this.apiClient.invokeAPI("/api/administration/notification", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Notification> createNotification(@Nonnull SendNotification sendNotification, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Notification> localVarReturnType = new ParameterizedTypeReference<Notification>(this){};
        return this.createNotificationRequestCreation(sendNotification, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Notification>>> createNotificationWithHttpInfo(@Nonnull SendNotification sendNotification, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Notification> localVarReturnType = new ParameterizedTypeReference<Notification>(this){};
        return this.createNotificationRequestCreation(sendNotification, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createNotificationWithResponseSpec(@Nonnull SendNotification sendNotification, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createNotificationRequestCreation(sendNotification, winkVersion);
    }
}

