/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"id", "createdDate", "lastUpdate", "version", "ownerIdentifier", "priority", "type", "recipientType", "application", "messageTemplateId", "subject", "body", "ctaUrl", "read", "markedAsRemoved", "notifyViaEmail"})
public class Notification {
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private String id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    @Nullable
    private LocalDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    @Nullable
    private LocalDateTime lastUpdate;
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private Long version;
    public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
    @Nonnull
    private UUID ownerIdentifier;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    @Nonnull
    private PriorityEnum priority;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private TypeEnum type;
    public static final String JSON_PROPERTY_RECIPIENT_TYPE = "recipientType";
    @Nonnull
    private RecipientTypeEnum recipientType;
    public static final String JSON_PROPERTY_APPLICATION = "application";
    @Nonnull
    private ApplicationEnum application;
    public static final String JSON_PROPERTY_MESSAGE_TEMPLATE_ID = "messageTemplateId";
    @Nonnull
    private String messageTemplateId;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    @Nonnull
    private String subject;
    public static final String JSON_PROPERTY_BODY = "body";
    @Nonnull
    private String body;
    public static final String JSON_PROPERTY_CTA_URL = "ctaUrl";
    @Nonnull
    private String ctaUrl;
    public static final String JSON_PROPERTY_READ = "read";
    @Nullable
    private Boolean read;
    public static final String JSON_PROPERTY_MARKED_AS_REMOVED = "markedAsRemoved";
    @Nullable
    private Boolean markedAsRemoved;
    public static final String JSON_PROPERTY_NOTIFY_VIA_EMAIL = "notifyViaEmail";
    @Nullable
    private Boolean notifyViaEmail;

    public Notification id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable String id) {
        this.id = id;
    }

    public Notification createdDate(@Nullable LocalDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedDate(@Nullable LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public Notification lastUpdate(@Nullable LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdate(@Nullable LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public Notification version(@Nullable Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(@Nullable Long version) {
        this.version = version;
    }

    public Notification ownerIdentifier(@Nonnull UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerIdentifier(@Nonnull UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
    }

    public Notification priority(@Nonnull PriorityEnum priority) {
        this.priority = priority;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PriorityEnum getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPriority(@Nonnull PriorityEnum priority) {
        this.priority = priority;
    }

    public Notification type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    public Notification recipientType(@Nonnull RecipientTypeEnum recipientType) {
        this.recipientType = recipientType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="recipientType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RecipientTypeEnum getRecipientType() {
        return this.recipientType;
    }

    @JsonProperty(value="recipientType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRecipientType(@Nonnull RecipientTypeEnum recipientType) {
        this.recipientType = recipientType;
    }

    public Notification application(@Nonnull ApplicationEnum application) {
        this.application = application;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="application")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ApplicationEnum getApplication() {
        return this.application;
    }

    @JsonProperty(value="application")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setApplication(@Nonnull ApplicationEnum application) {
        this.application = application;
    }

    public Notification messageTemplateId(@Nonnull String messageTemplateId) {
        this.messageTemplateId = messageTemplateId;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="messageTemplateId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getMessageTemplateId() {
        return this.messageTemplateId;
    }

    @JsonProperty(value="messageTemplateId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMessageTemplateId(@Nonnull String messageTemplateId) {
        this.messageTemplateId = messageTemplateId;
    }

    public Notification subject(@Nonnull String subject) {
        this.subject = subject;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubject(@Nonnull String subject) {
        this.subject = subject;
    }

    public Notification body(@Nonnull String body) {
        this.body = body;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="body")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getBody() {
        return this.body;
    }

    @JsonProperty(value="body")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBody(@Nonnull String body) {
        this.body = body;
    }

    public Notification ctaUrl(@Nonnull String ctaUrl) {
        this.ctaUrl = ctaUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="ctaUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getCtaUrl() {
        return this.ctaUrl;
    }

    @JsonProperty(value="ctaUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCtaUrl(@Nonnull String ctaUrl) {
        this.ctaUrl = ctaUrl;
    }

    public Notification read(@Nullable Boolean read) {
        this.read = read;
        return this;
    }

    @Nullable
    @JsonProperty(value="read")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRead() {
        return this.read;
    }

    @JsonProperty(value="read")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRead(@Nullable Boolean read) {
        this.read = read;
    }

    public Notification markedAsRemoved(@Nullable Boolean markedAsRemoved) {
        this.markedAsRemoved = markedAsRemoved;
        return this;
    }

    @Nullable
    @JsonProperty(value="markedAsRemoved")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMarkedAsRemoved() {
        return this.markedAsRemoved;
    }

    @JsonProperty(value="markedAsRemoved")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMarkedAsRemoved(@Nullable Boolean markedAsRemoved) {
        this.markedAsRemoved = markedAsRemoved;
    }

    public Notification notifyViaEmail(@Nullable Boolean notifyViaEmail) {
        this.notifyViaEmail = notifyViaEmail;
        return this;
    }

    @Nullable
    @JsonProperty(value="notifyViaEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNotifyViaEmail() {
        return this.notifyViaEmail;
    }

    @JsonProperty(value="notifyViaEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotifyViaEmail(@Nullable Boolean notifyViaEmail) {
        this.notifyViaEmail = notifyViaEmail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification notification = (Notification)o;
        return Objects.equals(this.id, notification.id) && Objects.equals(this.createdDate, notification.createdDate) && Objects.equals(this.lastUpdate, notification.lastUpdate) && Objects.equals(this.version, notification.version) && Objects.equals(this.ownerIdentifier, notification.ownerIdentifier) && Objects.equals((Object)this.priority, (Object)notification.priority) && Objects.equals((Object)this.type, (Object)notification.type) && Objects.equals((Object)this.recipientType, (Object)notification.recipientType) && Objects.equals((Object)this.application, (Object)notification.application) && Objects.equals(this.messageTemplateId, notification.messageTemplateId) && Objects.equals(this.subject, notification.subject) && Objects.equals(this.body, notification.body) && Objects.equals(this.ctaUrl, notification.ctaUrl) && Objects.equals(this.read, notification.read) && Objects.equals(this.markedAsRemoved, notification.markedAsRemoved) && Objects.equals(this.notifyViaEmail, notification.notifyViaEmail);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdDate, this.lastUpdate, this.version, this.ownerIdentifier, this.priority, this.type, this.recipientType, this.application, this.messageTemplateId, this.subject, this.body, this.ctaUrl, this.read, this.markedAsRemoved, this.notifyViaEmail});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Notification {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    ownerIdentifier: ").append(this.toIndentedString(this.ownerIdentifier)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    recipientType: ").append(this.toIndentedString((Object)this.recipientType)).append("\n");
        sb.append("    application: ").append(this.toIndentedString((Object)this.application)).append("\n");
        sb.append("    messageTemplateId: ").append(this.toIndentedString(this.messageTemplateId)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    ctaUrl: ").append(this.toIndentedString(this.ctaUrl)).append("\n");
        sb.append("    read: ").append(this.toIndentedString(this.read)).append("\n");
        sb.append("    markedAsRemoved: ").append(this.toIndentedString(this.markedAsRemoved)).append("\n");
        sb.append("    notifyViaEmail: ").append(this.toIndentedString(this.notifyViaEmail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PriorityEnum {
        HIGH(String.valueOf("HIGH")),
        MEDIUM(String.valueOf("MEDIUM")),
        LOW(String.valueOf("LOW"));

        private String value;

        private PriorityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PriorityEnum fromValue(String value) {
            for (PriorityEnum b : PriorityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        ALERT(String.valueOf("ALERT")),
        MESSAGE(String.valueOf("MESSAGE")),
        FEATURE(String.valueOf("FEATURE"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RecipientTypeEnum {
        USER(String.valueOf("USER")),
        ACCOUNT(String.valueOf("ACCOUNT"));

        private String value;

        private RecipientTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RecipientTypeEnum fromValue(String value) {
            for (RecipientTypeEnum b : RecipientTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ApplicationEnum {
        EXTRANET(String.valueOf("EXTRANET")),
        CORPORATE(String.valueOf("CORPORATE")),
        TRAVEL_AGENT(String.valueOf("TRAVEL_AGENT")),
        STUDIO(String.valueOf("STUDIO")),
        PAYMENT(String.valueOf("PAYMENT"));

        private String value;

        private ApplicationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ApplicationEnum fromValue(String value) {
            for (ApplicationEnum b : ApplicationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

