/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.trippay.sdk.payment.model.AffiliateInformation;
import io.trippay.sdk.payment.model.PricedSupplierContractWithAcquirer;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"id", "createdDate", "lastUpdate", "version", "affiliate", "displayCurrency", "redirectUrl", "contract", "acquirerList", "metadata", "instant"})
public class PayableContract {
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private String id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    @Nullable
    private LocalDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    @Nullable
    private LocalDateTime lastUpdate;
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private Long version;
    public static final String JSON_PROPERTY_AFFILIATE = "affiliate";
    @Nonnull
    private AffiliateInformation affiliate;
    public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
    @Nonnull
    private String displayCurrency = "USD";
    public static final String JSON_PROPERTY_REDIRECT_URL = "redirectUrl";
    @Nonnull
    private String redirectUrl;
    public static final String JSON_PROPERTY_CONTRACT = "contract";
    @Nonnull
    private PricedSupplierContractWithAcquirer contract;
    public static final String JSON_PROPERTY_ACQUIRER_LIST = "acquirerList";
    @Nonnull
    private List<Object> acquirerList = new ArrayList<Object>();
    public static final String JSON_PROPERTY_METADATA = "metadata";
    @Nullable
    private Map<String, String> metadata = new HashMap<String, String>();
    public static final String JSON_PROPERTY_INSTANT = "instant";
    @Nonnull
    private LocalDateTime instant;

    public PayableContract id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable String id) {
        this.id = id;
    }

    public PayableContract createdDate(@Nullable LocalDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedDate(@Nullable LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public PayableContract lastUpdate(@Nullable LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdate(@Nullable LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public PayableContract version(@Nullable Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(@Nullable Long version) {
        this.version = version;
    }

    public PayableContract affiliate(@Nonnull AffiliateInformation affiliate) {
        this.affiliate = affiliate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="affiliate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AffiliateInformation getAffiliate() {
        return this.affiliate;
    }

    @JsonProperty(value="affiliate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAffiliate(@Nonnull AffiliateInformation affiliate) {
        this.affiliate = affiliate;
    }

    public PayableContract displayCurrency(@Nonnull String displayCurrency) {
        this.displayCurrency = displayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getDisplayCurrency() {
        return this.displayCurrency;
    }

    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayCurrency(@Nonnull String displayCurrency) {
        this.displayCurrency = displayCurrency;
    }

    public PayableContract redirectUrl(@Nonnull String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="redirectUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getRedirectUrl() {
        return this.redirectUrl;
    }

    @JsonProperty(value="redirectUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRedirectUrl(@Nonnull String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public PayableContract contract(@Nonnull PricedSupplierContractWithAcquirer contract) {
        this.contract = contract;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="contract")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricedSupplierContractWithAcquirer getContract() {
        return this.contract;
    }

    @JsonProperty(value="contract")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContract(@Nonnull PricedSupplierContractWithAcquirer contract) {
        this.contract = contract;
    }

    public PayableContract acquirerList(@Nonnull List<Object> acquirerList) {
        this.acquirerList = acquirerList;
        return this;
    }

    public PayableContract addAcquirerListItem(Object acquirerListItem) {
        if (this.acquirerList == null) {
            this.acquirerList = new ArrayList<Object>();
        }
        this.acquirerList.add(acquirerListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="acquirerList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=0x7FFFFFFF) List<Object> getAcquirerList() {
        return this.acquirerList;
    }

    @JsonProperty(value="acquirerList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAcquirerList(@Nonnull List<Object> acquirerList) {
        this.acquirerList = acquirerList;
    }

    public PayableContract metadata(@Nullable Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public PayableContract putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(@Nullable Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public PayableContract instant(@Nonnull LocalDateTime instant) {
        this.instant = instant;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="instant")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDateTime getInstant() {
        return this.instant;
    }

    @JsonProperty(value="instant")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInstant(@Nonnull LocalDateTime instant) {
        this.instant = instant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayableContract payableContract = (PayableContract)o;
        return Objects.equals(this.id, payableContract.id) && Objects.equals(this.createdDate, payableContract.createdDate) && Objects.equals(this.lastUpdate, payableContract.lastUpdate) && Objects.equals(this.version, payableContract.version) && Objects.equals(this.affiliate, payableContract.affiliate) && Objects.equals(this.displayCurrency, payableContract.displayCurrency) && Objects.equals(this.redirectUrl, payableContract.redirectUrl) && Objects.equals(this.contract, payableContract.contract) && Objects.equals(this.acquirerList, payableContract.acquirerList) && Objects.equals(this.metadata, payableContract.metadata) && Objects.equals(this.instant, payableContract.instant);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdDate, this.lastUpdate, this.version, this.affiliate, this.displayCurrency, this.redirectUrl, this.contract, this.acquirerList, this.metadata, this.instant);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayableContract {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    affiliate: ").append(this.toIndentedString(this.affiliate)).append("\n");
        sb.append("    displayCurrency: ").append(this.toIndentedString(this.displayCurrency)).append("\n");
        sb.append("    redirectUrl: ").append(this.toIndentedString(this.redirectUrl)).append("\n");
        sb.append("    contract: ").append(this.toIndentedString(this.contract)).append("\n");
        sb.append("    acquirerList: ").append(this.toIndentedString(this.acquirerList)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    instant: ").append(this.toIndentedString(this.instant)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

