/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.AuthenticatedUser;
import io.trippay.sdk.payment.model.PayableContractSupplier;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"user", "affiliateAccountIdentifier", "affiliateAccountIdentifierType", "displayCurrency", "contractList", "traceId", "redirectUrl", "sourceUrl", "metadata"})
public class PayableContractRequest {
    public static final String JSON_PROPERTY_USER = "user";
    @Nonnull
    private AuthenticatedUser user;
    public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER = "affiliateAccountIdentifier";
    @Nonnull
    private String affiliateAccountIdentifier;
    public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE = "affiliateAccountIdentifierType";
    @Nonnull
    private AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType;
    public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
    @Nonnull
    private String displayCurrency = "USD";
    public static final String JSON_PROPERTY_CONTRACT_LIST = "contractList";
    @Nonnull
    private List<@Valid PayableContractSupplier> contractList = new ArrayList<PayableContractSupplier>();
    public static final String JSON_PROPERTY_TRACE_ID = "traceId";
    @Nullable
    private String traceId;
    public static final String JSON_PROPERTY_REDIRECT_URL = "redirectUrl";
    @Nonnull
    private String redirectUrl;
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    @Nonnull
    private String sourceUrl;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    @Nullable
    private Map<String, String> metadata = new HashMap<String, String>();

    public PayableContractRequest user(@Nonnull AuthenticatedUser user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AuthenticatedUser getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(@Nonnull AuthenticatedUser user) {
        this.user = user;
    }

    public PayableContractRequest affiliateAccountIdentifier(@Nonnull String affiliateAccountIdentifier) {
        this.affiliateAccountIdentifier = affiliateAccountIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="affiliateAccountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getAffiliateAccountIdentifier() {
        return this.affiliateAccountIdentifier;
    }

    @JsonProperty(value="affiliateAccountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAffiliateAccountIdentifier(@Nonnull String affiliateAccountIdentifier) {
        this.affiliateAccountIdentifier = affiliateAccountIdentifier;
    }

    public PayableContractRequest affiliateAccountIdentifierType(@Nonnull AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
        this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="affiliateAccountIdentifierType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AffiliateAccountIdentifierTypeEnum getAffiliateAccountIdentifierType() {
        return this.affiliateAccountIdentifierType;
    }

    @JsonProperty(value="affiliateAccountIdentifierType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAffiliateAccountIdentifierType(@Nonnull AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
        this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
    }

    public PayableContractRequest displayCurrency(@Nonnull String displayCurrency) {
        this.displayCurrency = displayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getDisplayCurrency() {
        return this.displayCurrency;
    }

    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayCurrency(@Nonnull String displayCurrency) {
        this.displayCurrency = displayCurrency;
    }

    public PayableContractRequest contractList(@Nonnull List<@Valid PayableContractSupplier> contractList) {
        this.contractList = contractList;
        return this;
    }

    public PayableContractRequest addContractListItem(PayableContractSupplier contractListItem) {
        if (this.contractList == null) {
            this.contractList = new ArrayList<PayableContractSupplier>();
        }
        this.contractList.add(contractListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="contractList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<@Valid PayableContractSupplier> getContractList() {
        return this.contractList;
    }

    @JsonProperty(value="contractList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContractList(@Nonnull List<@Valid PayableContractSupplier> contractList) {
        this.contractList = contractList;
    }

    public PayableContractRequest traceId(@Nullable String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Nullable
    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTraceId(@Nullable String traceId) {
        this.traceId = traceId;
    }

    public PayableContractRequest redirectUrl(@Nonnull String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="redirectUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getRedirectUrl() {
        return this.redirectUrl;
    }

    @JsonProperty(value="redirectUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRedirectUrl(@Nonnull String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public PayableContractRequest sourceUrl(@Nonnull String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceUrl(@Nonnull String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public PayableContractRequest metadata(@Nullable Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public PayableContractRequest putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(@Nullable Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayableContractRequest payableContractRequest = (PayableContractRequest)o;
        return Objects.equals(this.user, payableContractRequest.user) && Objects.equals(this.affiliateAccountIdentifier, payableContractRequest.affiliateAccountIdentifier) && Objects.equals((Object)this.affiliateAccountIdentifierType, (Object)payableContractRequest.affiliateAccountIdentifierType) && Objects.equals(this.displayCurrency, payableContractRequest.displayCurrency) && Objects.equals(this.contractList, payableContractRequest.contractList) && Objects.equals(this.traceId, payableContractRequest.traceId) && Objects.equals(this.redirectUrl, payableContractRequest.redirectUrl) && Objects.equals(this.sourceUrl, payableContractRequest.sourceUrl) && Objects.equals(this.metadata, payableContractRequest.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.user, this.affiliateAccountIdentifier, this.affiliateAccountIdentifierType, this.displayCurrency, this.contractList, this.traceId, this.redirectUrl, this.sourceUrl, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayableContractRequest {\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    affiliateAccountIdentifier: ").append(this.toIndentedString(this.affiliateAccountIdentifier)).append("\n");
        sb.append("    affiliateAccountIdentifierType: ").append(this.toIndentedString((Object)this.affiliateAccountIdentifierType)).append("\n");
        sb.append("    displayCurrency: ").append(this.toIndentedString(this.displayCurrency)).append("\n");
        sb.append("    contractList: ").append(this.toIndentedString(this.contractList)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    redirectUrl: ").append(this.toIndentedString(this.redirectUrl)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AffiliateAccountIdentifierTypeEnum {
        INTERNAL(String.valueOf("INTERNAL")),
        EXTERNAL(String.valueOf("EXTERNAL"));

        private String value;

        private AffiliateAccountIdentifierTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AffiliateAccountIdentifierTypeEnum fromValue(String value) {
            for (AffiliateAccountIdentifierTypeEnum b : AffiliateAccountIdentifierTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

