/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.BeneficiaryCharge;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"identifier", "identifierType", "amountDue", "type", "metadata"})
public class PayableContractSupplierItemBeneficiary {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    @Nonnull
    private String identifier;
    public static final String JSON_PROPERTY_IDENTIFIER_TYPE = "identifierType";
    @Nonnull
    private IdentifierTypeEnum identifierType;
    public static final String JSON_PROPERTY_AMOUNT_DUE = "amountDue";
    @Nonnull
    private BeneficiaryCharge amountDue;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private TypeEnum type;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    @Nullable
    private Map<String, String> metadata = new HashMap<String, String>();

    public PayableContractSupplierItemBeneficiary identifier(@Nonnull String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(@Nonnull String identifier) {
        this.identifier = identifier;
    }

    public PayableContractSupplierItemBeneficiary identifierType(@Nonnull IdentifierTypeEnum identifierType) {
        this.identifierType = identifierType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="identifierType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IdentifierTypeEnum getIdentifierType() {
        return this.identifierType;
    }

    @JsonProperty(value="identifierType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifierType(@Nonnull IdentifierTypeEnum identifierType) {
        this.identifierType = identifierType;
    }

    public PayableContractSupplierItemBeneficiary amountDue(@Nonnull BeneficiaryCharge amountDue) {
        this.amountDue = amountDue;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="amountDue")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BeneficiaryCharge getAmountDue() {
        return this.amountDue;
    }

    @JsonProperty(value="amountDue")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDue(@Nonnull BeneficiaryCharge amountDue) {
        this.amountDue = amountDue;
    }

    public PayableContractSupplierItemBeneficiary type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    public PayableContractSupplierItemBeneficiary metadata(@Nullable Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public PayableContractSupplierItemBeneficiary putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(@Nullable Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayableContractSupplierItemBeneficiary payableContractSupplierItemBeneficiary = (PayableContractSupplierItemBeneficiary)o;
        return Objects.equals(this.identifier, payableContractSupplierItemBeneficiary.identifier) && Objects.equals((Object)this.identifierType, (Object)payableContractSupplierItemBeneficiary.identifierType) && Objects.equals(this.amountDue, payableContractSupplierItemBeneficiary.amountDue) && Objects.equals((Object)this.type, (Object)payableContractSupplierItemBeneficiary.type) && Objects.equals(this.metadata, payableContractSupplierItemBeneficiary.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.identifierType, this.amountDue, this.type, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayableContractSupplierItemBeneficiary {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    identifierType: ").append(this.toIndentedString((Object)this.identifierType)).append("\n");
        sb.append("    amountDue: ").append(this.toIndentedString(this.amountDue)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum IdentifierTypeEnum {
        INTERNAL(String.valueOf("INTERNAL")),
        EXTERNAL(String.valueOf("EXTERNAL"));

        private String value;

        private IdentifierTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IdentifierTypeEnum fromValue(String value) {
            for (IdentifierTypeEnum b : IdentifierTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        TRIP_PAY(String.valueOf("TRIP_PAY")),
        PLATFORM_FEE(String.valueOf("PLATFORM_FEE")),
        COMMISSION(String.valueOf("COMMISSION")),
        AFFILIATE_AGENCY_FEE(String.valueOf("AFFILIATE_AGENCY_FEE")),
        SUPPLIER_AGENCY_FEE(String.valueOf("SUPPLIER_AGENCY_FEE")),
        SALE(String.valueOf("SALE"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

