/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.CustomMonetaryAmount;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;

@JsonPropertyOrder(value={"refund", "description", "reasonType", "cancelOnRefund"})
public class RefundRequest {
    public static final String JSON_PROPERTY_REFUND = "refund";
    @Nonnull
    private CustomMonetaryAmount refund;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nonnull
    private String description;
    public static final String JSON_PROPERTY_REASON_TYPE = "reasonType";
    @Nonnull
    private ReasonTypeEnum reasonType;
    public static final String JSON_PROPERTY_CANCEL_ON_REFUND = "cancelOnRefund";
    @Nonnull
    private CancelOnRefundEnum cancelOnRefund;

    public RefundRequest refund(@Nonnull CustomMonetaryAmount refund) {
        this.refund = refund;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="refund")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getRefund() {
        return this.refund;
    }

    @JsonProperty(value="refund")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRefund(@Nonnull CustomMonetaryAmount refund) {
        this.refund = refund;
    }

    public RefundRequest description(@Nonnull String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(@Nonnull String description) {
        this.description = description;
    }

    public RefundRequest reasonType(@Nonnull ReasonTypeEnum reasonType) {
        this.reasonType = reasonType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="reasonType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ReasonTypeEnum getReasonType() {
        return this.reasonType;
    }

    @JsonProperty(value="reasonType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setReasonType(@Nonnull ReasonTypeEnum reasonType) {
        this.reasonType = reasonType;
    }

    public RefundRequest cancelOnRefund(@Nonnull CancelOnRefundEnum cancelOnRefund) {
        this.cancelOnRefund = cancelOnRefund;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="cancelOnRefund")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CancelOnRefundEnum getCancelOnRefund() {
        return this.cancelOnRefund;
    }

    @JsonProperty(value="cancelOnRefund")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCancelOnRefund(@Nonnull CancelOnRefundEnum cancelOnRefund) {
        this.cancelOnRefund = cancelOnRefund;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefundRequest refundRequest = (RefundRequest)o;
        return Objects.equals(this.refund, refundRequest.refund) && Objects.equals(this.description, refundRequest.description) && Objects.equals((Object)this.reasonType, (Object)refundRequest.reasonType) && Objects.equals((Object)this.cancelOnRefund, (Object)refundRequest.cancelOnRefund);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.refund, this.description, this.reasonType, this.cancelOnRefund});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RefundRequest {\n");
        sb.append("    refund: ").append(this.toIndentedString(this.refund)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    reasonType: ").append(this.toIndentedString((Object)this.reasonType)).append("\n");
        sb.append("    cancelOnRefund: ").append(this.toIndentedString((Object)this.cancelOnRefund)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ReasonTypeEnum {
        DUPLICATE(String.valueOf("DUPLICATE")),
        FRAUDULENT(String.valueOf("FRAUDULENT")),
        REQUESTED_BY_CUSTOMER(String.valueOf("REQUESTED_BY_CUSTOMER")),
        GUEST_COMPLAINT(String.valueOf("GUEST_COMPLAINT")),
        GUEST_BOOKED_INCORRECT_DATE(String.valueOf("GUEST_BOOKED_INCORRECT_DATE")),
        GUEST_SICK(String.valueOf("GUEST_SICK")),
        OVERBOOKING(String.valueOf("OVERBOOKING")),
        EMERGENCY(String.valueOf("EMERGENCY")),
        FLIGHT_CANCELLED(String.valueOf("FLIGHT_CANCELLED")),
        DEATH_IN_FAMILY(String.valueOf("DEATH_IN_FAMILY")),
        OTHER(String.valueOf("OTHER")),
        EXPIRED_UNCAPTURED_CHARGE(String.valueOf("EXPIRED_UNCAPTURED_CHARGE"));

        private String value;

        private ReasonTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReasonTypeEnum fromValue(String value) {
            for (ReasonTypeEnum b : ReasonTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CancelOnRefundEnum {
        NONE(String.valueOf("NONE")),
        CANCEL_ON_SUCCESSFUL_REFUND(String.valueOf("CANCEL_ON_SUCCESSFUL_REFUND")),
        CANCEL_REGARDLESS(String.valueOf("CANCEL_REGARDLESS"));

        private String value;

        private CancelOnRefundEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CancelOnRefundEnum fromValue(String value) {
            for (CancelOnRefundEnum b : CancelOnRefundEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

