/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"localAccountIdentifier", "externalIdentifier"})
public class UpsertAccountMappingRequest {
    public static final String JSON_PROPERTY_LOCAL_ACCOUNT_IDENTIFIER = "localAccountIdentifier";
    @Nonnull
    private UUID localAccountIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
    @Nonnull
    private String externalIdentifier;

    public UpsertAccountMappingRequest localAccountIdentifier(@Nonnull UUID localAccountIdentifier) {
        this.localAccountIdentifier = localAccountIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="localAccountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getLocalAccountIdentifier() {
        return this.localAccountIdentifier;
    }

    @JsonProperty(value="localAccountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocalAccountIdentifier(@Nonnull UUID localAccountIdentifier) {
        this.localAccountIdentifier = localAccountIdentifier;
    }

    public UpsertAccountMappingRequest externalIdentifier(@Nonnull String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExternalIdentifier(@Nonnull String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertAccountMappingRequest upsertAccountMappingRequest = (UpsertAccountMappingRequest)o;
        return Objects.equals(this.localAccountIdentifier, upsertAccountMappingRequest.localAccountIdentifier) && Objects.equals(this.externalIdentifier, upsertAccountMappingRequest.externalIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.localAccountIdentifier, this.externalIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpsertAccountMappingRequest {\n");
        sb.append("    localAccountIdentifier: ").append(this.toIndentedString(this.localAccountIdentifier)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

