/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.ActivityStreamUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"acl", "entityIdentifier", "eventDate", "emotion", "comment", "i18nKey", "attachmentId", "user"})
public class UpsertActivityStreamRequest {
    public static final String JSON_PROPERTY_ACL = "acl";
    @Nonnull
    private AclEnum acl;
    public static final String JSON_PROPERTY_ENTITY_IDENTIFIER = "entityIdentifier";
    @Nonnull
    private UUID entityIdentifier;
    public static final String JSON_PROPERTY_EVENT_DATE = "eventDate";
    @Nullable
    private LocalDateTime eventDate;
    public static final String JSON_PROPERTY_EMOTION = "emotion";
    @Nullable
    private String emotion;
    public static final String JSON_PROPERTY_COMMENT = "comment";
    @Nullable
    private String comment;
    public static final String JSON_PROPERTY_I18N_KEY = "i18nKey";
    @Nonnull
    private String i18nKey;
    public static final String JSON_PROPERTY_ATTACHMENT_ID = "attachmentId";
    @Nullable
    private String attachmentId;
    public static final String JSON_PROPERTY_USER = "user";
    @Nullable
    private ActivityStreamUser user;

    public UpsertActivityStreamRequest acl(@Nonnull AclEnum acl) {
        this.acl = acl;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="acl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AclEnum getAcl() {
        return this.acl;
    }

    @JsonProperty(value="acl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAcl(@Nonnull AclEnum acl) {
        this.acl = acl;
    }

    public UpsertActivityStreamRequest entityIdentifier(@Nonnull UUID entityIdentifier) {
        this.entityIdentifier = entityIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="entityIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getEntityIdentifier() {
        return this.entityIdentifier;
    }

    @JsonProperty(value="entityIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEntityIdentifier(@Nonnull UUID entityIdentifier) {
        this.entityIdentifier = entityIdentifier;
    }

    public UpsertActivityStreamRequest eventDate(@Nullable LocalDateTime eventDate) {
        this.eventDate = eventDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="eventDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getEventDate() {
        return this.eventDate;
    }

    @JsonProperty(value="eventDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventDate(@Nullable LocalDateTime eventDate) {
        this.eventDate = eventDate;
    }

    public UpsertActivityStreamRequest emotion(@Nullable String emotion) {
        this.emotion = emotion;
        return this;
    }

    @Nullable
    @JsonProperty(value="emotion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmotion() {
        return this.emotion;
    }

    @JsonProperty(value="emotion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmotion(@Nullable String emotion) {
        this.emotion = emotion;
    }

    public UpsertActivityStreamRequest comment(@Nullable String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getComment() {
        return this.comment;
    }

    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComment(@Nullable String comment) {
        this.comment = comment;
    }

    public UpsertActivityStreamRequest i18nKey(@Nonnull String i18nKey) {
        this.i18nKey = i18nKey;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="i18nKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getI18nKey() {
        return this.i18nKey;
    }

    @JsonProperty(value="i18nKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setI18nKey(@Nonnull String i18nKey) {
        this.i18nKey = i18nKey;
    }

    public UpsertActivityStreamRequest attachmentId(@Nullable String attachmentId) {
        this.attachmentId = attachmentId;
        return this;
    }

    @Nullable
    @JsonProperty(value="attachmentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAttachmentId() {
        return this.attachmentId;
    }

    @JsonProperty(value="attachmentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttachmentId(@Nullable String attachmentId) {
        this.attachmentId = attachmentId;
    }

    public UpsertActivityStreamRequest user(@Nullable ActivityStreamUser user) {
        this.user = user;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ActivityStreamUser getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUser(@Nullable ActivityStreamUser user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertActivityStreamRequest upsertActivityStreamRequest = (UpsertActivityStreamRequest)o;
        return Objects.equals((Object)this.acl, (Object)upsertActivityStreamRequest.acl) && Objects.equals(this.entityIdentifier, upsertActivityStreamRequest.entityIdentifier) && Objects.equals(this.eventDate, upsertActivityStreamRequest.eventDate) && Objects.equals(this.emotion, upsertActivityStreamRequest.emotion) && Objects.equals(this.comment, upsertActivityStreamRequest.comment) && Objects.equals(this.i18nKey, upsertActivityStreamRequest.i18nKey) && Objects.equals(this.attachmentId, upsertActivityStreamRequest.attachmentId) && Objects.equals(this.user, upsertActivityStreamRequest.user);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acl, this.entityIdentifier, this.eventDate, this.emotion, this.comment, this.i18nKey, this.attachmentId, this.user});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpsertActivityStreamRequest {\n");
        sb.append("    acl: ").append(this.toIndentedString((Object)this.acl)).append("\n");
        sb.append("    entityIdentifier: ").append(this.toIndentedString(this.entityIdentifier)).append("\n");
        sb.append("    eventDate: ").append(this.toIndentedString(this.eventDate)).append("\n");
        sb.append("    emotion: ").append(this.toIndentedString(this.emotion)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    i18nKey: ").append(this.toIndentedString(this.i18nKey)).append("\n");
        sb.append("    attachmentId: ").append(this.toIndentedString(this.attachmentId)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AclEnum {
        EVERYONE(String.valueOf("EVERYONE")),
        AUTHENTICATED(String.valueOf("AUTHENTICATED")),
        OWNER(String.valueOf("OWNER")),
        ADMIN(String.valueOf("ADMIN"));

        private String value;

        private AclEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AclEnum fromValue(String value) {
            for (AclEnum b : AclEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

