/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.trippay.sdk.payment.model.ManagingEntity;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"name", "entity", "enabled", "eventUrl", "eventList"})
public class UpsertWebhookRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_ENTITY = "entity";
    @Nonnull
    private ManagingEntity entity;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    @Nonnull
    private Boolean enabled = true;
    public static final String JSON_PROPERTY_EVENT_URL = "eventUrl";
    @Nonnull
    private String eventUrl;
    public static final String JSON_PROPERTY_EVENT_LIST = "eventList";
    @Nonnull
    private List<Object> eventList = new ArrayList<Object>();

    public UpsertWebhookRequest name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public UpsertWebhookRequest entity(@Nonnull ManagingEntity entity) {
        this.entity = entity;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ManagingEntity getEntity() {
        return this.entity;
    }

    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEntity(@Nonnull ManagingEntity entity) {
        this.entity = entity;
    }

    public UpsertWebhookRequest enabled(@Nonnull Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnabled(@Nonnull Boolean enabled) {
        this.enabled = enabled;
    }

    public UpsertWebhookRequest eventUrl(@Nonnull String eventUrl) {
        this.eventUrl = eventUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="eventUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getEventUrl() {
        return this.eventUrl;
    }

    @JsonProperty(value="eventUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventUrl(@Nonnull String eventUrl) {
        this.eventUrl = eventUrl;
    }

    public UpsertWebhookRequest eventList(@Nonnull List<Object> eventList) {
        this.eventList = eventList;
        return this;
    }

    public UpsertWebhookRequest addEventListItem(Object eventListItem) {
        if (this.eventList == null) {
            this.eventList = new ArrayList<Object>();
        }
        this.eventList.add(eventListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="eventList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Object> getEventList() {
        return this.eventList;
    }

    @JsonProperty(value="eventList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventList(@Nonnull List<Object> eventList) {
        this.eventList = eventList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertWebhookRequest upsertWebhookRequest = (UpsertWebhookRequest)o;
        return Objects.equals(this.name, upsertWebhookRequest.name) && Objects.equals(this.entity, upsertWebhookRequest.entity) && Objects.equals(this.enabled, upsertWebhookRequest.enabled) && Objects.equals(this.eventUrl, upsertWebhookRequest.eventUrl) && Objects.equals(this.eventList, upsertWebhookRequest.eventList);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.entity, this.enabled, this.eventUrl, this.eventList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpsertWebhookRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    eventUrl: ").append(this.toIndentedString(this.eventUrl)).append("\n");
        sb.append("    eventList: ").append(this.toIndentedString(this.eventList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

