/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.reference.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.reference.invoker.ApiClient;
import travel.wink.sdk.reference.model.GeoName;
import travel.wink.sdk.reference.model.GeoNameCountry;
import travel.wink.sdk.reference.model.KeyValuePair;

public class GeoNameApi {
    private ApiClient apiClient;

    public GeoNameApi() {
        this(new ApiClient());
    }

    @Autowired
    public GeoNameApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec searchForCitiesRequestCreation(String term, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (term == null) {
            throw new WebClientResponseException("Missing the required parameter 'term' when calling searchForCities", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("term", term);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GeoName> localVarReturnType = new ParameterizedTypeReference<GeoName>(){};
        return this.apiClient.invokeAPI("/api/geo/city/search/{term}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<GeoName> searchForCities(String term, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoName> localVarReturnType = new ParameterizedTypeReference<GeoName>(){};
        return this.searchForCitiesRequestCreation(term, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<GeoName>>> searchForCitiesWithHttpInfo(String term, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoName> localVarReturnType = new ParameterizedTypeReference<GeoName>(){};
        return this.searchForCitiesRequestCreation(term, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec searchForCityRequestCreation(String searchTerm, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (searchTerm == null) {
            throw new WebClientResponseException("Missing the required parameter 'searchTerm' when calling searchForCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("searchTerm", searchTerm);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GeoName> localVarReturnType = new ParameterizedTypeReference<GeoName>(){};
        return this.apiClient.invokeAPI("/api/geoip/city/{searchTerm}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<GeoName> searchForCity(String searchTerm, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoName> localVarReturnType = new ParameterizedTypeReference<GeoName>(){};
        return this.searchForCityRequestCreation(searchTerm, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<GeoName>>> searchForCityWithHttpInfo(String searchTerm, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoName> localVarReturnType = new ParameterizedTypeReference<GeoName>(){};
        return this.searchForCityRequestCreation(searchTerm, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showContinentsRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.apiClient.invokeAPI("/api/geoip/continent/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePair> showContinents(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showContinentsRequestCreation(winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showContinentsWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showContinentsRequestCreation(winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showCountries1RequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GeoNameCountry> localVarReturnType = new ParameterizedTypeReference<GeoNameCountry>(){};
        return this.apiClient.invokeAPI("/api/geoip/country/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<GeoNameCountry> showCountries1(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameCountry> localVarReturnType = new ParameterizedTypeReference<GeoNameCountry>(){};
        return this.showCountries1RequestCreation(winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<GeoNameCountry>>> showCountries1WithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameCountry> localVarReturnType = new ParameterizedTypeReference<GeoNameCountry>(){};
        return this.showCountries1RequestCreation(winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showGeoNameByIdRequestCreation(String geoNameId, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (geoNameId == null) {
            throw new WebClientResponseException("Missing the required parameter 'geoNameId' when calling showGeoNameById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("geoNameId", geoNameId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GeoName> localVarReturnType = new ParameterizedTypeReference<GeoName>(){};
        return this.apiClient.invokeAPI("/api/geo/{geoNameId}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GeoName> showGeoNameById(String geoNameId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoName> localVarReturnType = new ParameterizedTypeReference<GeoName>(){};
        return this.showGeoNameByIdRequestCreation(geoNameId, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GeoName>> showGeoNameByIdWithHttpInfo(String geoNameId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoName> localVarReturnType = new ParameterizedTypeReference<GeoName>(){};
        return this.showGeoNameByIdRequestCreation(geoNameId, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showTimezonesRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(){};
        return this.apiClient.invokeAPI("/api/geoip/timezone/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<String> showTimezones(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(){};
        return this.showTimezonesRequestCreation(winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<String>>> showTimezonesWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(){};
        return this.showTimezonesRequestCreation(winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }
}

