package travel.wink.sdk.reference.api;

import travel.wink.sdk.reference.invoker.ApiClient;

import travel.wink.sdk.reference.model.GenericErrorMessage;
import travel.wink.sdk.reference.model.GeoNameConsumer;
import travel.wink.sdk.reference.model.GeoNameCountryConsumer;
import travel.wink.sdk.reference.model.KeyValuePairConsumer;
import travel.wink.sdk.reference.model.ShowSocialNetworks400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-16T10:19:40.122348377+07:00[Asia/Bangkok]")
public class GeoNameApi {
    private ApiClient apiClient;

    public GeoNameApi() {
        this(new ApiClient());
    }

    @Autowired
    public GeoNameApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Find geo-name by term
     * Finds a list of geo-name entities for a term that &#x60;sounds like&#x60;.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param term Geo-name term to be searched
     * @param winkVersion The winkVersion parameter
     * @return List&lt;GeoNameConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec searchForCitiesRequestCreation(String term, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'term' is set
        if (term == null) {
            throw new WebClientResponseException("Missing the required parameter 'term' when calling searchForCities", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("term", term);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GeoNameConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameConsumer>() {};
        return apiClient.invokeAPI("/api/geo/city/search/{term}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Find geo-name by term
     * Finds a list of geo-name entities for a term that &#x60;sounds like&#x60;.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param term Geo-name term to be searched
     * @param winkVersion The winkVersion parameter
     * @return List&lt;GeoNameConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<GeoNameConsumer> searchForCities(String term, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameConsumer>() {};
        return searchForCitiesRequestCreation(term, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Find geo-name by term
     * Finds a list of geo-name entities for a term that &#x60;sounds like&#x60;.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param term Geo-name term to be searched
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;GeoNameConsumer&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<GeoNameConsumer>>> searchForCitiesWithHttpInfo(String term, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameConsumer>() {};
        return searchForCitiesRequestCreation(term, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Find geo-name by term
     * Finds a list of geo-name entities for a term that &#x60;sounds like&#x60;.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param term Geo-name term to be searched
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec searchForCitiesWithResponseSpec(String term, String winkVersion) throws WebClientResponseException {
        return searchForCitiesRequestCreation(term, winkVersion);
    }
    /**
     * Search for city
     * Searches for city matching search term.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param searchTerm Search for city by search term
     * @param winkVersion The winkVersion parameter
     * @return List&lt;GeoNameConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec searchForCityRequestCreation(String searchTerm, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'searchTerm' is set
        if (searchTerm == null) {
            throw new WebClientResponseException("Missing the required parameter 'searchTerm' when calling searchForCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("searchTerm", searchTerm);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GeoNameConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameConsumer>() {};
        return apiClient.invokeAPI("/api/geoip/city/{searchTerm}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Search for city
     * Searches for city matching search term.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param searchTerm Search for city by search term
     * @param winkVersion The winkVersion parameter
     * @return List&lt;GeoNameConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<GeoNameConsumer> searchForCity(String searchTerm, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameConsumer>() {};
        return searchForCityRequestCreation(searchTerm, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Search for city
     * Searches for city matching search term.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param searchTerm Search for city by search term
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;GeoNameConsumer&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<GeoNameConsumer>>> searchForCityWithHttpInfo(String searchTerm, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameConsumer>() {};
        return searchForCityRequestCreation(searchTerm, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Search for city
     * Searches for city matching search term.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param searchTerm Search for city by search term
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec searchForCityWithResponseSpec(String searchTerm, String winkVersion) throws WebClientResponseException {
        return searchForCityRequestCreation(searchTerm, winkVersion);
    }
    /**
     * Show all continents
     * List all continents.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContinentsRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>() {};
        return apiClient.invokeAPI("/api/geoip/continent/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show all continents
     * List all continents.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairConsumer> showContinents(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>() {};
        return showContinentsRequestCreation(winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show all continents
     * List all continents.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairConsumer&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairConsumer>>> showContinentsWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>() {};
        return showContinentsRequestCreation(winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show all continents
     * List all continents.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showContinentsWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return showContinentsRequestCreation(winkVersion);
    }
    /**
     * Show all countries
     * List all countries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;GeoNameCountryConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCountries1RequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GeoNameCountryConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameCountryConsumer>() {};
        return apiClient.invokeAPI("/api/geoip/country/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show all countries
     * List all countries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;GeoNameCountryConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<GeoNameCountryConsumer> showCountries1(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameCountryConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameCountryConsumer>() {};
        return showCountries1RequestCreation(winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show all countries
     * List all countries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;GeoNameCountryConsumer&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<GeoNameCountryConsumer>>> showCountries1WithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameCountryConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameCountryConsumer>() {};
        return showCountries1RequestCreation(winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show all countries
     * List all countries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCountries1WithResponseSpec(String winkVersion) throws WebClientResponseException {
        return showCountries1RequestCreation(winkVersion);
    }
    /**
     * Find geo-name by identifier
     * Finds geo-name by given identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param geoNameId Geo-name identifier
     * @param winkVersion The winkVersion parameter
     * @return GeoNameConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showGeoNameByIdRequestCreation(String geoNameId, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'geoNameId' is set
        if (geoNameId == null) {
            throw new WebClientResponseException("Missing the required parameter 'geoNameId' when calling showGeoNameById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("geoNameId", geoNameId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GeoNameConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameConsumer>() {};
        return apiClient.invokeAPI("/api/geo/{geoNameId}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Find geo-name by identifier
     * Finds geo-name by given identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param geoNameId Geo-name identifier
     * @param winkVersion The winkVersion parameter
     * @return GeoNameConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GeoNameConsumer> showGeoNameById(String geoNameId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameConsumer>() {};
        return showGeoNameByIdRequestCreation(geoNameId, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Find geo-name by identifier
     * Finds geo-name by given identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param geoNameId Geo-name identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;GeoNameConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<GeoNameConsumer>> showGeoNameByIdWithHttpInfo(String geoNameId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameConsumer>() {};
        return showGeoNameByIdRequestCreation(geoNameId, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Find geo-name by identifier
     * Finds geo-name by given identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param geoNameId Geo-name identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showGeoNameByIdWithResponseSpec(String geoNameId, String winkVersion) throws WebClientResponseException {
        return showGeoNameByIdRequestCreation(geoNameId, winkVersion);
    }
    /**
     * Show all time zones
     * List all time zones.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;String&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showTimezonesRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<List<String>> localVarReturnType = new ParameterizedTypeReference<List<String>>() {};
        return apiClient.invokeAPI("/api/geoip/timezone/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show all time zones
     * List all time zones.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;String&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<List<String>> showTimezones(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<List<String>> localVarReturnType = new ParameterizedTypeReference<List<String>>() {};
        return showTimezonesRequestCreation(winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show all time zones
     * List all time zones.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;String&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<String>>> showTimezonesWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<List<String>> localVarReturnType = new ParameterizedTypeReference<List<String>>() {};
        return showTimezonesRequestCreation(winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show all time zones
     * List all time zones.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showTimezonesWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return showTimezonesRequestCreation(winkVersion);
    }
}
