/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Reference API Welcome to the Reference API - A programmer-friendly way to find platform supported taxonomies of reference data.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.12.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.reference.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * GeoNameCountryConsumer
 */
@JsonPropertyOrder({
  GeoNameCountryConsumer.JSON_PROPERTY_GEO_NAME_ID,
  GeoNameCountryConsumer.JSON_PROPERTY_CONTINENT_CODE,
  GeoNameCountryConsumer.JSON_PROPERTY_CONTINENT_NAME,
  GeoNameCountryConsumer.JSON_PROPERTY_COUNTRY_ISO_CODE,
  GeoNameCountryConsumer.JSON_PROPERTY_COUNTRY_NAME
})
@JsonTypeName("GeoNameCountry_Consumer")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-16T10:19:40.122348377+07:00[Asia/Bangkok]")
public class GeoNameCountryConsumer {
  public static final String JSON_PROPERTY_GEO_NAME_ID = "geoNameId";
  private String geoNameId;

  public static final String JSON_PROPERTY_CONTINENT_CODE = "continentCode";
  private String continentCode;

  public static final String JSON_PROPERTY_CONTINENT_NAME = "continentName";
  private String continentName;

  public static final String JSON_PROPERTY_COUNTRY_ISO_CODE = "countryIsoCode";
  private String countryIsoCode;

  public static final String JSON_PROPERTY_COUNTRY_NAME = "countryName";
  private String countryName;

  public GeoNameCountryConsumer() {
  }

  public GeoNameCountryConsumer geoNameId(String geoNameId) {
    
    this.geoNameId = geoNameId;
    return this;
  }

   /**
   * Get geoNameId
   * @return geoNameId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGeoNameId() {
    return geoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeoNameId(String geoNameId) {
    this.geoNameId = geoNameId;
  }


  public GeoNameCountryConsumer continentCode(String continentCode) {
    
    this.continentCode = continentCode;
    return this;
  }

   /**
   * Get continentCode
   * @return continentCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinentCode() {
    return continentCode;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinentCode(String continentCode) {
    this.continentCode = continentCode;
  }


  public GeoNameCountryConsumer continentName(String continentName) {
    
    this.continentName = continentName;
    return this;
  }

   /**
   * Get continentName
   * @return continentName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CONTINENT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinentName() {
    return continentName;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinentName(String continentName) {
    this.continentName = continentName;
  }


  public GeoNameCountryConsumer countryIsoCode(String countryIsoCode) {
    
    this.countryIsoCode = countryIsoCode;
    return this;
  }

   /**
   * Get countryIsoCode
   * @return countryIsoCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_ISO_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryIsoCode() {
    return countryIsoCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_ISO_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryIsoCode(String countryIsoCode) {
    this.countryIsoCode = countryIsoCode;
  }


  public GeoNameCountryConsumer countryName(String countryName) {
    
    this.countryName = countryName;
    return this;
  }

   /**
   * Get countryName
   * @return countryName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryName() {
    return countryName;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryName(String countryName) {
    this.countryName = countryName;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeoNameCountryConsumer geoNameCountryConsumer = (GeoNameCountryConsumer) o;
    return Objects.equals(this.geoNameId, geoNameCountryConsumer.geoNameId) &&
        Objects.equals(this.continentCode, geoNameCountryConsumer.continentCode) &&
        Objects.equals(this.continentName, geoNameCountryConsumer.continentName) &&
        Objects.equals(this.countryIsoCode, geoNameCountryConsumer.countryIsoCode) &&
        Objects.equals(this.countryName, geoNameCountryConsumer.countryName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(geoNameId, continentCode, continentName, countryIsoCode, countryName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeoNameCountryConsumer {\n");
    sb.append("    geoNameId: ").append(toIndentedString(geoNameId)).append("\n");
    sb.append("    continentCode: ").append(toIndentedString(continentCode)).append("\n");
    sb.append("    continentName: ").append(toIndentedString(continentName)).append("\n");
    sb.append("    countryIsoCode: ").append(toIndentedString(countryIsoCode)).append("\n");
    sb.append("    countryName: ").append(toIndentedString(countryName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

