/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.reference.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.reference.invoker.ApiClient;
import travel.wink.sdk.reference.model.CountResponseConsumer;
import travel.wink.sdk.reference.model.CountryConsumer;
import travel.wink.sdk.reference.model.KeyValuePairConsumer;
import travel.wink.sdk.reference.model.LanguageConsumer;
import travel.wink.sdk.reference.model.PageExchangeRateViewConsumer;
import travel.wink.sdk.reference.model.QuoteConsumer;

public class ReferenceApi {
    private ApiClient apiClient;

    public ReferenceApi() {
        this(new ApiClient());
    }

    @Autowired
    public ReferenceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec showAllExchangeRatesRequestCreation(Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (page == null) {
            throw new WebClientResponseException("Missing the required parameter 'page' when calling showAllExchangeRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (size == null) {
            throw new WebClientResponseException("Missing the required parameter 'size' when calling showAllExchangeRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageExchangeRateViewConsumer> localVarReturnType = new ParameterizedTypeReference<PageExchangeRateViewConsumer>(this){};
        return this.apiClient.invokeAPI("/reference-data/fx", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageExchangeRateViewConsumer> showAllExchangeRates(Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageExchangeRateViewConsumer> localVarReturnType = new ParameterizedTypeReference<PageExchangeRateViewConsumer>(this){};
        return this.showAllExchangeRatesRequestCreation(page, size, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageExchangeRateViewConsumer>> showAllExchangeRatesWithHttpInfo(Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageExchangeRateViewConsumer> localVarReturnType = new ParameterizedTypeReference<PageExchangeRateViewConsumer>(this){};
        return this.showAllExchangeRatesRequestCreation(page, size, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAllExchangeRatesWithResponseSpec(Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        return this.showAllExchangeRatesRequestCreation(page, size, winkVersion);
    }

    private WebClient.ResponseSpec showAvailableCodesForCategoryRequestCreation(String category, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (category == null) {
            throw new WebClientResponseException("Missing the required parameter 'category' when calling showAvailableCodesForCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("category", category);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(this){};
        return this.apiClient.invokeAPI("/reference-data/ota/{category}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairConsumer> showAvailableCodesForCategory(String category, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(this){};
        return this.showAvailableCodesForCategoryRequestCreation(category, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairConsumer>>> showAvailableCodesForCategoryWithHttpInfo(String category, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(this){};
        return this.showAvailableCodesForCategoryRequestCreation(category, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAvailableCodesForCategoryWithResponseSpec(String category, String winkVersion) throws WebClientResponseException {
        return this.showAvailableCodesForCategoryRequestCreation(category, winkVersion);
    }

    private WebClient.ResponseSpec showAvailableOtaCategoriesRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(this){};
        return this.apiClient.invokeAPI("/reference-data/ota/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairConsumer> showAvailableOtaCategories(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(this){};
        return this.showAvailableOtaCategoriesRequestCreation(winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairConsumer>>> showAvailableOtaCategoriesWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(this){};
        return this.showAvailableOtaCategoriesRequestCreation(winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAvailableOtaCategoriesWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return this.showAvailableOtaCategoriesRequestCreation(winkVersion);
    }

    private WebClient.ResponseSpec showCountriesRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CountryConsumer> localVarReturnType = new ParameterizedTypeReference<CountryConsumer>(this){};
        return this.apiClient.invokeAPI("/reference-data/country/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<CountryConsumer> showCountries(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountryConsumer> localVarReturnType = new ParameterizedTypeReference<CountryConsumer>(this){};
        return this.showCountriesRequestCreation(winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<CountryConsumer>>> showCountriesWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountryConsumer> localVarReturnType = new ParameterizedTypeReference<CountryConsumer>(this){};
        return this.showCountriesRequestCreation(winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCountriesWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return this.showCountriesRequestCreation(winkVersion);
    }

    private WebClient.ResponseSpec showCurrenciesRequestCreation() throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<List<String>> localVarReturnType = new ParameterizedTypeReference<List<String>>(this){};
        return this.apiClient.invokeAPI("/reference-data/currency/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<List<String>> showCurrencies() throws WebClientResponseException {
        ParameterizedTypeReference<List<String>> localVarReturnType = new ParameterizedTypeReference<List<String>>(this){};
        return this.showCurrenciesRequestCreation().bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<String>>> showCurrenciesWithHttpInfo() throws WebClientResponseException {
        ParameterizedTypeReference<List<String>> localVarReturnType = new ParameterizedTypeReference<List<String>>(this){};
        return this.showCurrenciesRequestCreation().toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCurrenciesWithResponseSpec() throws WebClientResponseException {
        return this.showCurrenciesRequestCreation();
    }

    private WebClient.ResponseSpec showExchangeRateRequestCreation(String sourceCurrency, String targetCurrency, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (sourceCurrency == null) {
            throw new WebClientResponseException("Missing the required parameter 'sourceCurrency' when calling showExchangeRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (targetCurrency == null) {
            throw new WebClientResponseException("Missing the required parameter 'targetCurrency' when calling showExchangeRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("sourceCurrency", sourceCurrency);
        pathParams.put("targetCurrency", targetCurrency);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<QuoteConsumer> localVarReturnType = new ParameterizedTypeReference<QuoteConsumer>(this){};
        return this.apiClient.invokeAPI("/reference-data/fx/{sourceCurrency}/{targetCurrency}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<QuoteConsumer> showExchangeRate(String sourceCurrency, String targetCurrency, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<QuoteConsumer> localVarReturnType = new ParameterizedTypeReference<QuoteConsumer>(this){};
        return this.showExchangeRateRequestCreation(sourceCurrency, targetCurrency, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<QuoteConsumer>> showExchangeRateWithHttpInfo(String sourceCurrency, String targetCurrency, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<QuoteConsumer> localVarReturnType = new ParameterizedTypeReference<QuoteConsumer>(this){};
        return this.showExchangeRateRequestCreation(sourceCurrency, targetCurrency, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showExchangeRateWithResponseSpec(String sourceCurrency, String targetCurrency, String winkVersion) throws WebClientResponseException {
        return this.showExchangeRateRequestCreation(sourceCurrency, targetCurrency, winkVersion);
    }

    private WebClient.ResponseSpec showExchangeRateCountRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CountResponseConsumer> localVarReturnType = new ParameterizedTypeReference<CountResponseConsumer>(this){};
        return this.apiClient.invokeAPI("/reference-data/fx/count", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CountResponseConsumer> showExchangeRateCount(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponseConsumer> localVarReturnType = new ParameterizedTypeReference<CountResponseConsumer>(this){};
        return this.showExchangeRateCountRequestCreation(winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CountResponseConsumer>> showExchangeRateCountWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponseConsumer> localVarReturnType = new ParameterizedTypeReference<CountResponseConsumer>(this){};
        return this.showExchangeRateCountRequestCreation(winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showExchangeRateCountWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return this.showExchangeRateCountRequestCreation(winkVersion);
    }

    private WebClient.ResponseSpec showExchangeRateForTargetCurrencyRequestCreation(String currency, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (currency == null) {
            throw new WebClientResponseException("Missing the required parameter 'currency' when calling showExchangeRateForTargetCurrency", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("currency", currency);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<QuoteConsumer> localVarReturnType = new ParameterizedTypeReference<QuoteConsumer>(this){};
        return this.apiClient.invokeAPI("/reference-data/fx/{currency}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<QuoteConsumer> showExchangeRateForTargetCurrency(String currency, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<QuoteConsumer> localVarReturnType = new ParameterizedTypeReference<QuoteConsumer>(this){};
        return this.showExchangeRateForTargetCurrencyRequestCreation(currency, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<QuoteConsumer>>> showExchangeRateForTargetCurrencyWithHttpInfo(String currency, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<QuoteConsumer> localVarReturnType = new ParameterizedTypeReference<QuoteConsumer>(this){};
        return this.showExchangeRateForTargetCurrencyRequestCreation(currency, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showExchangeRateForTargetCurrencyWithResponseSpec(String currency, String winkVersion) throws WebClientResponseException {
        return this.showExchangeRateForTargetCurrencyRequestCreation(currency, winkVersion);
    }

    private WebClient.ResponseSpec showHotelNamesRequestCreation(String name, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (name == null) {
            throw new WebClientResponseException("Missing the required parameter 'name' when calling showHotelNames", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("name", name);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(this){};
        return this.apiClient.invokeAPI("/reference-data/lookup/hotel/{name}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairConsumer> showHotelNames(String name, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(this){};
        return this.showHotelNamesRequestCreation(name, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairConsumer>>> showHotelNamesWithHttpInfo(String name, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(this){};
        return this.showHotelNamesRequestCreation(name, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showHotelNamesWithResponseSpec(String name, String winkVersion) throws WebClientResponseException {
        return this.showHotelNamesRequestCreation(name, winkVersion);
    }

    private WebClient.ResponseSpec showLanguagesRequestCreation() throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<LanguageConsumer> localVarReturnType = new ParameterizedTypeReference<LanguageConsumer>(this){};
        return this.apiClient.invokeAPI("/reference-data/language/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<LanguageConsumer> showLanguages() throws WebClientResponseException {
        ParameterizedTypeReference<LanguageConsumer> localVarReturnType = new ParameterizedTypeReference<LanguageConsumer>(this){};
        return this.showLanguagesRequestCreation().bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<LanguageConsumer>>> showLanguagesWithHttpInfo() throws WebClientResponseException {
        ParameterizedTypeReference<LanguageConsumer> localVarReturnType = new ParameterizedTypeReference<LanguageConsumer>(this){};
        return this.showLanguagesRequestCreation().toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showLanguagesWithResponseSpec() throws WebClientResponseException {
        return this.showLanguagesRequestCreation();
    }

    private WebClient.ResponseSpec showLifestylesRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(this){};
        return this.apiClient.invokeAPI("/reference-data/lifestyle/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairConsumer> showLifestyles(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(this){};
        return this.showLifestylesRequestCreation(winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairConsumer>>> showLifestylesWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(this){};
        return this.showLifestylesRequestCreation(winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showLifestylesWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return this.showLifestylesRequestCreation(winkVersion);
    }

    private WebClient.ResponseSpec showPerksRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(this){};
        return this.apiClient.invokeAPI("/reference-data/perk/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairConsumer> showPerks(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(this){};
        return this.showPerksRequestCreation(winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairConsumer>>> showPerksWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(this){};
        return this.showPerksRequestCreation(winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showPerksWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return this.showPerksRequestCreation(winkVersion);
    }

    private WebClient.ResponseSpec showSocialNetworksRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(this){};
        return this.apiClient.invokeAPI("/reference-data/social/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairConsumer> showSocialNetworks(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(this){};
        return this.showSocialNetworksRequestCreation(winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairConsumer>>> showSocialNetworksWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(this){};
        return this.showSocialNetworksRequestCreation(winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSocialNetworksWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return this.showSocialNetworksRequestCreation(winkVersion);
    }
}

