/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Reference API Welcome to the Reference API - A programmer-friendly way to find platform supported taxonomies of reference data.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.30.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.reference.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * GeoNameNonAuthenticatedEntity
 */
@JsonPropertyOrder({
  GeoNameNonAuthenticatedEntity.JSON_PROPERTY_GEO_NAME_ID,
  GeoNameNonAuthenticatedEntity.JSON_PROPERTY_LOCALE_CODE,
  GeoNameNonAuthenticatedEntity.JSON_PROPERTY_CONTINENT_CODE,
  GeoNameNonAuthenticatedEntity.JSON_PROPERTY_CONTINENT_NAME,
  GeoNameNonAuthenticatedEntity.JSON_PROPERTY_COUNTRY_ISO_CODE,
  GeoNameNonAuthenticatedEntity.JSON_PROPERTY_COUNTRY_NAME,
  GeoNameNonAuthenticatedEntity.JSON_PROPERTY_CITY_NAME,
  GeoNameNonAuthenticatedEntity.JSON_PROPERTY_TIMEZONE,
  GeoNameNonAuthenticatedEntity.JSON_PROPERTY_SUB_DIVISION1_CODE,
  GeoNameNonAuthenticatedEntity.JSON_PROPERTY_SUB_DIVISION1_NAME,
  GeoNameNonAuthenticatedEntity.JSON_PROPERTY_SUB_DIVISION2_CODE,
  GeoNameNonAuthenticatedEntity.JSON_PROPERTY_SUB_DIVISION2_NAME
})
@JsonTypeName("GeoName_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-12-27T18:02:52.299594363+07:00[Asia/Bangkok]")
public class GeoNameNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_GEO_NAME_ID = "geoNameId";
  private String geoNameId;

  public static final String JSON_PROPERTY_LOCALE_CODE = "localeCode";
  private String localeCode;

  public static final String JSON_PROPERTY_CONTINENT_CODE = "continentCode";
  private String continentCode;

  public static final String JSON_PROPERTY_CONTINENT_NAME = "continentName";
  private String continentName;

  public static final String JSON_PROPERTY_COUNTRY_ISO_CODE = "countryIsoCode";
  private String countryIsoCode;

  public static final String JSON_PROPERTY_COUNTRY_NAME = "countryName";
  private String countryName;

  public static final String JSON_PROPERTY_CITY_NAME = "cityName";
  private String cityName;

  public static final String JSON_PROPERTY_TIMEZONE = "timezone";
  private String timezone;

  public static final String JSON_PROPERTY_SUB_DIVISION1_CODE = "subDivision1Code";
  private String subDivision1Code;

  public static final String JSON_PROPERTY_SUB_DIVISION1_NAME = "subDivision1Name";
  private String subDivision1Name;

  public static final String JSON_PROPERTY_SUB_DIVISION2_CODE = "subDivision2Code";
  private String subDivision2Code;

  public static final String JSON_PROPERTY_SUB_DIVISION2_NAME = "subDivision2Name";
  private String subDivision2Name;

  public GeoNameNonAuthenticatedEntity() {
  }

  public GeoNameNonAuthenticatedEntity geoNameId(String geoNameId) {
    
    this.geoNameId = geoNameId;
    return this;
  }

   /**
   * GeoName identifiers taken from [https://geonames.org](https://geonames.org).
   * @return geoNameId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGeoNameId() {
    return geoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeoNameId(String geoNameId) {
    this.geoNameId = geoNameId;
  }


  public GeoNameNonAuthenticatedEntity localeCode(String localeCode) {
    
    this.localeCode = localeCode;
    return this;
  }

   /**
   * Locale code
   * @return localeCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOCALE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocaleCode() {
    return localeCode;
  }


  @JsonProperty(JSON_PROPERTY_LOCALE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocaleCode(String localeCode) {
    this.localeCode = localeCode;
  }


  public GeoNameNonAuthenticatedEntity continentCode(String continentCode) {
    
    this.continentCode = continentCode;
    return this;
  }

   /**
   * Continent code
   * @return continentCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinentCode() {
    return continentCode;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinentCode(String continentCode) {
    this.continentCode = continentCode;
  }


  public GeoNameNonAuthenticatedEntity continentName(String continentName) {
    
    this.continentName = continentName;
    return this;
  }

   /**
   * Continent name
   * @return continentName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CONTINENT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinentName() {
    return continentName;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinentName(String continentName) {
    this.continentName = continentName;
  }


  public GeoNameNonAuthenticatedEntity countryIsoCode(String countryIsoCode) {
    
    this.countryIsoCode = countryIsoCode;
    return this;
  }

   /**
   * Country ISO code
   * @return countryIsoCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_ISO_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryIsoCode() {
    return countryIsoCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_ISO_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryIsoCode(String countryIsoCode) {
    this.countryIsoCode = countryIsoCode;
  }


  public GeoNameNonAuthenticatedEntity countryName(String countryName) {
    
    this.countryName = countryName;
    return this;
  }

   /**
   * Country name
   * @return countryName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryName() {
    return countryName;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryName(String countryName) {
    this.countryName = countryName;
  }


  public GeoNameNonAuthenticatedEntity cityName(String cityName) {
    
    this.cityName = cityName;
    return this;
  }

   /**
   * City name
   * @return cityName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCityName() {
    return cityName;
  }


  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityName(String cityName) {
    this.cityName = cityName;
  }


  public GeoNameNonAuthenticatedEntity timezone(String timezone) {
    
    this.timezone = timezone;
    return this;
  }

   /**
   * Timezone
   * @return timezone
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimezone() {
    return timezone;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }


  public GeoNameNonAuthenticatedEntity subDivision1Code(String subDivision1Code) {
    
    this.subDivision1Code = subDivision1Code;
    return this;
  }

   /**
   * Sub-division 1 code
   * @return subDivision1Code
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUB_DIVISION1_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubDivision1Code() {
    return subDivision1Code;
  }


  @JsonProperty(JSON_PROPERTY_SUB_DIVISION1_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubDivision1Code(String subDivision1Code) {
    this.subDivision1Code = subDivision1Code;
  }


  public GeoNameNonAuthenticatedEntity subDivision1Name(String subDivision1Name) {
    
    this.subDivision1Name = subDivision1Name;
    return this;
  }

   /**
   * Sub-division 1 name
   * @return subDivision1Name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUB_DIVISION1_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubDivision1Name() {
    return subDivision1Name;
  }


  @JsonProperty(JSON_PROPERTY_SUB_DIVISION1_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubDivision1Name(String subDivision1Name) {
    this.subDivision1Name = subDivision1Name;
  }


  public GeoNameNonAuthenticatedEntity subDivision2Code(String subDivision2Code) {
    
    this.subDivision2Code = subDivision2Code;
    return this;
  }

   /**
   * Sub-division 2 code
   * @return subDivision2Code
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUB_DIVISION2_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubDivision2Code() {
    return subDivision2Code;
  }


  @JsonProperty(JSON_PROPERTY_SUB_DIVISION2_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubDivision2Code(String subDivision2Code) {
    this.subDivision2Code = subDivision2Code;
  }


  public GeoNameNonAuthenticatedEntity subDivision2Name(String subDivision2Name) {
    
    this.subDivision2Name = subDivision2Name;
    return this;
  }

   /**
   * Sub-division 2 name
   * @return subDivision2Name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUB_DIVISION2_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubDivision2Name() {
    return subDivision2Name;
  }


  @JsonProperty(JSON_PROPERTY_SUB_DIVISION2_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubDivision2Name(String subDivision2Name) {
    this.subDivision2Name = subDivision2Name;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeoNameNonAuthenticatedEntity geoNameNonAuthenticatedEntity = (GeoNameNonAuthenticatedEntity) o;
    return Objects.equals(this.geoNameId, geoNameNonAuthenticatedEntity.geoNameId) &&
        Objects.equals(this.localeCode, geoNameNonAuthenticatedEntity.localeCode) &&
        Objects.equals(this.continentCode, geoNameNonAuthenticatedEntity.continentCode) &&
        Objects.equals(this.continentName, geoNameNonAuthenticatedEntity.continentName) &&
        Objects.equals(this.countryIsoCode, geoNameNonAuthenticatedEntity.countryIsoCode) &&
        Objects.equals(this.countryName, geoNameNonAuthenticatedEntity.countryName) &&
        Objects.equals(this.cityName, geoNameNonAuthenticatedEntity.cityName) &&
        Objects.equals(this.timezone, geoNameNonAuthenticatedEntity.timezone) &&
        Objects.equals(this.subDivision1Code, geoNameNonAuthenticatedEntity.subDivision1Code) &&
        Objects.equals(this.subDivision1Name, geoNameNonAuthenticatedEntity.subDivision1Name) &&
        Objects.equals(this.subDivision2Code, geoNameNonAuthenticatedEntity.subDivision2Code) &&
        Objects.equals(this.subDivision2Name, geoNameNonAuthenticatedEntity.subDivision2Name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(geoNameId, localeCode, continentCode, continentName, countryIsoCode, countryName, cityName, timezone, subDivision1Code, subDivision1Name, subDivision2Code, subDivision2Name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeoNameNonAuthenticatedEntity {\n");
    sb.append("    geoNameId: ").append(toIndentedString(geoNameId)).append("\n");
    sb.append("    localeCode: ").append(toIndentedString(localeCode)).append("\n");
    sb.append("    continentCode: ").append(toIndentedString(continentCode)).append("\n");
    sb.append("    continentName: ").append(toIndentedString(continentName)).append("\n");
    sb.append("    countryIsoCode: ").append(toIndentedString(countryIsoCode)).append("\n");
    sb.append("    countryName: ").append(toIndentedString(countryName)).append("\n");
    sb.append("    cityName: ").append(toIndentedString(cityName)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    subDivision1Code: ").append(toIndentedString(subDivision1Code)).append("\n");
    sb.append("    subDivision1Name: ").append(toIndentedString(subDivision1Name)).append("\n");
    sb.append("    subDivision2Code: ").append(toIndentedString(subDivision2Code)).append("\n");
    sb.append("    subDivision2Name: ").append(toIndentedString(subDivision2Name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

