package travel.wink.sdk.reference.api;

import travel.wink.sdk.reference.invoker.ApiClient;

import travel.wink.sdk.reference.model.CountResponseNonAuthenticatedEntity;
import travel.wink.sdk.reference.model.CountryNonAuthenticatedEntity;
import travel.wink.sdk.reference.model.GenericErrorMessage;
import travel.wink.sdk.reference.model.KeyValuePairNonAuthenticatedEntity;
import travel.wink.sdk.reference.model.LanguageNonAuthenticatedEntity;
import travel.wink.sdk.reference.model.PageExchangeRateViewNonAuthenticatedEntity;
import travel.wink.sdk.reference.model.QuoteNonAuthenticatedEntity;
import travel.wink.sdk.reference.model.ShowSocialNetworks400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T22:30:28.019507486+07:00[Asia/Bangkok]")
public class ReferenceApi {
    private ApiClient apiClient;

    public ReferenceApi() {
        this(new ApiClient());
    }

    @Autowired
    public ReferenceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show all exchange rates
     * Show exchange rates for target currency and all payment-supported currencies.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param page The page parameter
     * @param size The size parameter
     * @param winkVersion The winkVersion parameter
     * @return PageExchangeRateViewNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAllExchangeRatesRequestCreation(Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'page' is set
        if (page == null) {
            throw new WebClientResponseException("Missing the required parameter 'page' when calling showAllExchangeRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'size' is set
        if (size == null) {
            throw new WebClientResponseException("Missing the required parameter 'size' when calling showAllExchangeRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageExchangeRateViewNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageExchangeRateViewNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/fx", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show all exchange rates
     * Show exchange rates for target currency and all payment-supported currencies.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param page The page parameter
     * @param size The size parameter
     * @param winkVersion The winkVersion parameter
     * @return PageExchangeRateViewNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageExchangeRateViewNonAuthenticatedEntity> showAllExchangeRates(Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageExchangeRateViewNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageExchangeRateViewNonAuthenticatedEntity>() {};
        return showAllExchangeRatesRequestCreation(page, size, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show all exchange rates
     * Show exchange rates for target currency and all payment-supported currencies.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param page The page parameter
     * @param size The size parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageExchangeRateViewNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageExchangeRateViewNonAuthenticatedEntity>> showAllExchangeRatesWithHttpInfo(Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageExchangeRateViewNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageExchangeRateViewNonAuthenticatedEntity>() {};
        return showAllExchangeRatesRequestCreation(page, size, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show all exchange rates
     * Show exchange rates for target currency and all payment-supported currencies.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param page The page parameter
     * @param size The size parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAllExchangeRatesWithResponseSpec(Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        return showAllExchangeRatesRequestCreation(page, size, winkVersion);
    }
    /**
     * Show OTA codes
     * Shows payment-supported OTA codes based on given category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param category Requested OTA code
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAvailableCodesForCategoryRequestCreation(String category, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'category' is set
        if (category == null) {
            throw new WebClientResponseException("Missing the required parameter 'category' when calling showAvailableCodesForCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("category", category);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/ota/{category}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show OTA codes
     * Shows payment-supported OTA codes based on given category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param category Requested OTA code
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairNonAuthenticatedEntity> showAvailableCodesForCategory(String category, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return showAvailableCodesForCategoryRequestCreation(category, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show OTA codes
     * Shows payment-supported OTA codes based on given category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param category Requested OTA code
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairNonAuthenticatedEntity>>> showAvailableCodesForCategoryWithHttpInfo(String category, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return showAvailableCodesForCategoryRequestCreation(category, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show OTA codes
     * Shows payment-supported OTA codes based on given category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param category Requested OTA code
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAvailableCodesForCategoryWithResponseSpec(String category, String winkVersion) throws WebClientResponseException {
        return showAvailableCodesForCategoryRequestCreation(category, winkVersion);
    }
    /**
     * Show OTA category codes
     * Shows payment-supported OTA categories.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAvailableOtaCategoriesRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/ota/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show OTA category codes
     * Shows payment-supported OTA categories.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairNonAuthenticatedEntity> showAvailableOtaCategories(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return showAvailableOtaCategoriesRequestCreation(winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show OTA category codes
     * Shows payment-supported OTA categories.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairNonAuthenticatedEntity>>> showAvailableOtaCategoriesWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return showAvailableOtaCategoriesRequestCreation(winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show OTA category codes
     * Shows payment-supported OTA categories.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAvailableOtaCategoriesWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return showAvailableOtaCategoriesRequestCreation(winkVersion);
    }
    /**
     * Show countries
     * Show list of payment-supported countries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;CountryNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCountriesRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CountryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<CountryNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/country/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show countries
     * Show list of payment-supported countries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;CountryNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<CountryNonAuthenticatedEntity> showCountries(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<CountryNonAuthenticatedEntity>() {};
        return showCountriesRequestCreation(winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show countries
     * Show list of payment-supported countries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;CountryNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<CountryNonAuthenticatedEntity>>> showCountriesWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<CountryNonAuthenticatedEntity>() {};
        return showCountriesRequestCreation(winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show countries
     * Show list of payment-supported countries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCountriesWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return showCountriesRequestCreation(winkVersion);
    }
    /**
     * Show currencies
     * List of payment-supported currencies.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @return List&lt;String&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCurrenciesRequestCreation() throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<List<String>> localVarReturnType = new ParameterizedTypeReference<List<String>>() {};
        return apiClient.invokeAPI("/reference-data/currency/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show currencies
     * List of payment-supported currencies.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @return List&lt;String&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<List<String>> showCurrencies() throws WebClientResponseException {
        ParameterizedTypeReference<List<String>> localVarReturnType = new ParameterizedTypeReference<List<String>>() {};
        return showCurrenciesRequestCreation().bodyToMono(localVarReturnType);
    }

    /**
     * Show currencies
     * List of payment-supported currencies.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @return ResponseEntity&lt;List&lt;String&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<String>>> showCurrenciesWithHttpInfo() throws WebClientResponseException {
        ParameterizedTypeReference<List<String>> localVarReturnType = new ParameterizedTypeReference<List<String>>() {};
        return showCurrenciesRequestCreation().toEntity(localVarReturnType);
    }

    /**
     * Show currencies
     * List of payment-supported currencies.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCurrenciesWithResponseSpec() throws WebClientResponseException {
        return showCurrenciesRequestCreation();
    }
    /**
     * Show exchange rate
     * Show exchange rate between target and source currency
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param sourceCurrency The sourceCurrency parameter
     * @param targetCurrency The targetCurrency parameter
     * @param winkVersion The winkVersion parameter
     * @return QuoteNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showExchangeRateRequestCreation(String sourceCurrency, String targetCurrency, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'sourceCurrency' is set
        if (sourceCurrency == null) {
            throw new WebClientResponseException("Missing the required parameter 'sourceCurrency' when calling showExchangeRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'targetCurrency' is set
        if (targetCurrency == null) {
            throw new WebClientResponseException("Missing the required parameter 'targetCurrency' when calling showExchangeRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("sourceCurrency", sourceCurrency);
        pathParams.put("targetCurrency", targetCurrency);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<QuoteNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<QuoteNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/fx/{sourceCurrency}/{targetCurrency}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show exchange rate
     * Show exchange rate between target and source currency
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param sourceCurrency The sourceCurrency parameter
     * @param targetCurrency The targetCurrency parameter
     * @param winkVersion The winkVersion parameter
     * @return QuoteNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<QuoteNonAuthenticatedEntity> showExchangeRate(String sourceCurrency, String targetCurrency, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<QuoteNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<QuoteNonAuthenticatedEntity>() {};
        return showExchangeRateRequestCreation(sourceCurrency, targetCurrency, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show exchange rate
     * Show exchange rate between target and source currency
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param sourceCurrency The sourceCurrency parameter
     * @param targetCurrency The targetCurrency parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;QuoteNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<QuoteNonAuthenticatedEntity>> showExchangeRateWithHttpInfo(String sourceCurrency, String targetCurrency, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<QuoteNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<QuoteNonAuthenticatedEntity>() {};
        return showExchangeRateRequestCreation(sourceCurrency, targetCurrency, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show exchange rate
     * Show exchange rate between target and source currency
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param sourceCurrency The sourceCurrency parameter
     * @param targetCurrency The targetCurrency parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showExchangeRateWithResponseSpec(String sourceCurrency, String targetCurrency, String winkVersion) throws WebClientResponseException {
        return showExchangeRateRequestCreation(sourceCurrency, targetCurrency, winkVersion);
    }
    /**
     * Show exchange rates count
     * Returns a count of number of quotes available.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return CountResponseNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showExchangeRateCountRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CountResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<CountResponseNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/fx/count", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show exchange rates count
     * Returns a count of number of quotes available.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return CountResponseNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CountResponseNonAuthenticatedEntity> showExchangeRateCount(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<CountResponseNonAuthenticatedEntity>() {};
        return showExchangeRateCountRequestCreation(winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show exchange rates count
     * Returns a count of number of quotes available.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CountResponseNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CountResponseNonAuthenticatedEntity>> showExchangeRateCountWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<CountResponseNonAuthenticatedEntity>() {};
        return showExchangeRateCountRequestCreation(winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show exchange rates count
     * Returns a count of number of quotes available.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showExchangeRateCountWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return showExchangeRateCountRequestCreation(winkVersion);
    }
    /**
     * Show exchange rates
     * Show exchange rates for target currency and all payment-supported currencies.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param currency The currency parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;QuoteNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showExchangeRateForTargetCurrencyRequestCreation(String currency, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'currency' is set
        if (currency == null) {
            throw new WebClientResponseException("Missing the required parameter 'currency' when calling showExchangeRateForTargetCurrency", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("currency", currency);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<QuoteNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<QuoteNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/fx/{currency}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show exchange rates
     * Show exchange rates for target currency and all payment-supported currencies.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param currency The currency parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;QuoteNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<QuoteNonAuthenticatedEntity> showExchangeRateForTargetCurrency(String currency, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<QuoteNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<QuoteNonAuthenticatedEntity>() {};
        return showExchangeRateForTargetCurrencyRequestCreation(currency, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show exchange rates
     * Show exchange rates for target currency and all payment-supported currencies.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param currency The currency parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;QuoteNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<QuoteNonAuthenticatedEntity>>> showExchangeRateForTargetCurrencyWithHttpInfo(String currency, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<QuoteNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<QuoteNonAuthenticatedEntity>() {};
        return showExchangeRateForTargetCurrencyRequestCreation(currency, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show exchange rates
     * Show exchange rates for target currency and all payment-supported currencies.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param currency The currency parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showExchangeRateForTargetCurrencyWithResponseSpec(String currency, String winkVersion) throws WebClientResponseException {
        return showExchangeRateForTargetCurrencyRequestCreation(currency, winkVersion);
    }
    /**
     * Hotel Name Search
     * Search for property by name.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showHotelNamesRequestCreation(String name, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new WebClientResponseException("Missing the required parameter 'name' when calling showHotelNames", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("name", name);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/lookup/hotel/{name}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Hotel Name Search
     * Search for property by name.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairNonAuthenticatedEntity> showHotelNames(String name, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return showHotelNamesRequestCreation(name, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Hotel Name Search
     * Search for property by name.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairNonAuthenticatedEntity>>> showHotelNamesWithHttpInfo(String name, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return showHotelNamesRequestCreation(name, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Hotel Name Search
     * Search for property by name.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showHotelNamesWithResponseSpec(String name, String winkVersion) throws WebClientResponseException {
        return showHotelNamesRequestCreation(name, winkVersion);
    }
    /**
     * Show Languages
     * Retrieve list of system languages
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @return List&lt;LanguageNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showLanguagesRequestCreation() throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<LanguageNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LanguageNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/language/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Languages
     * Retrieve list of system languages
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @return List&lt;LanguageNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<LanguageNonAuthenticatedEntity> showLanguages() throws WebClientResponseException {
        ParameterizedTypeReference<LanguageNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LanguageNonAuthenticatedEntity>() {};
        return showLanguagesRequestCreation().bodyToFlux(localVarReturnType);
    }

    /**
     * Show Languages
     * Retrieve list of system languages
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @return ResponseEntity&lt;List&lt;LanguageNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<LanguageNonAuthenticatedEntity>>> showLanguagesWithHttpInfo() throws WebClientResponseException {
        ParameterizedTypeReference<LanguageNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LanguageNonAuthenticatedEntity>() {};
        return showLanguagesRequestCreation().toEntityList(localVarReturnType);
    }

    /**
     * Show Languages
     * Retrieve list of system languages
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showLanguagesWithResponseSpec() throws WebClientResponseException {
        return showLanguagesRequestCreation();
    }
    /**
     * Show Lifestyles
     * Retrieve list of all supported lifestyles indicated by an array of key / value pairs.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showLifestylesRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/lifestyle/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Lifestyles
     * Retrieve list of all supported lifestyles indicated by an array of key / value pairs.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairNonAuthenticatedEntity> showLifestyles(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return showLifestylesRequestCreation(winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Lifestyles
     * Retrieve list of all supported lifestyles indicated by an array of key / value pairs.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairNonAuthenticatedEntity>>> showLifestylesWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return showLifestylesRequestCreation(winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Lifestyles
     * Retrieve list of all supported lifestyles indicated by an array of key / value pairs.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showLifestylesWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return showLifestylesRequestCreation(winkVersion);
    }
    /**
     * Show Perks
     * Retrieve list of perks
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPerksRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/perk/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Perks
     * Retrieve list of perks
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairNonAuthenticatedEntity> showPerks(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return showPerksRequestCreation(winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Perks
     * Retrieve list of perks
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairNonAuthenticatedEntity>>> showPerksWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return showPerksRequestCreation(winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Perks
     * Retrieve list of perks
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPerksWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return showPerksRequestCreation(winkVersion);
    }
    /**
     * Show Social Networks
     * Retrieve list of all supported social networks
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSocialNetworksRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/social/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Social Networks
     * Retrieve list of all supported social networks
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairNonAuthenticatedEntity> showSocialNetworks(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return showSocialNetworksRequestCreation(winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Social Networks
     * Retrieve list of all supported social networks
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairNonAuthenticatedEntity>>> showSocialNetworksWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return showSocialNetworksRequestCreation(winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Social Networks
     * Retrieve list of all supported social networks
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSocialNetworksWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return showSocialNetworksRequestCreation(winkVersion);
    }
}
