/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.reference.invoker;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.annotation.Nullable;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MimeType;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;
import travel.wink.sdk.reference.invoker.JavaTimeFormatter;
import travel.wink.sdk.reference.invoker.RFC3339DateFormat;
import travel.wink.sdk.reference.invoker.auth.ApiKeyAuth;
import travel.wink.sdk.reference.invoker.auth.Authentication;
import travel.wink.sdk.reference.invoker.auth.HttpBasicAuth;
import travel.wink.sdk.reference.invoker.auth.HttpBearerAuth;
import travel.wink.sdk.reference.invoker.auth.OAuth;

public class ApiClient
extends JavaTimeFormatter {
    private static final String URI_TEMPLATE_ATTRIBUTE = WebClient.class.getName() + ".uriTemplate";
    private HttpHeaders defaultHeaders = new HttpHeaders();
    private MultiValueMap<String, String> defaultCookies = new LinkedMultiValueMap();
    private String basePath = "https://api.wink.travel";
    private final WebClient webClient;
    private final DateFormat dateFormat;
    private final ObjectMapper objectMapper;
    private Map<String, Authentication> authentications;

    public ApiClient() {
        this.dateFormat = ApiClient.createDefaultDateFormat();
        this.objectMapper = ApiClient.createDefaultObjectMapper(this.dateFormat);
        this.webClient = ApiClient.buildWebClient(this.objectMapper);
        this.init();
    }

    public ApiClient(WebClient webClient) {
        this(Optional.ofNullable(webClient).orElseGet(() -> ApiClient.buildWebClient()), ApiClient.createDefaultDateFormat());
    }

    public ApiClient(ObjectMapper mapper, DateFormat format) {
        this(ApiClient.buildWebClient(mapper.copy()), format);
    }

    public ApiClient(WebClient webClient, ObjectMapper mapper, DateFormat format) {
        this(Optional.ofNullable(webClient).orElseGet(() -> ApiClient.buildWebClient(mapper.copy())), format);
    }

    private ApiClient(WebClient webClient, DateFormat format) {
        this.webClient = webClient;
        this.dateFormat = format;
        this.objectMapper = ApiClient.createDefaultObjectMapper(format);
        this.init();
    }

    public static DateFormat createDefaultDateFormat() {
        RFC3339DateFormat dateFormat = new RFC3339DateFormat();
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat;
    }

    public static ObjectMapper createDefaultObjectMapper(@Nullable DateFormat dateFormat) {
        if (null == dateFormat) {
            dateFormat = ApiClient.createDefaultDateFormat();
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDateFormat(dateFormat);
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNullableModule jnm = new JsonNullableModule();
        mapper.registerModule((Module)jnm);
        return mapper;
    }

    protected void init() {
        this.authentications = new HashMap<String, Authentication>();
        this.authentications.put("oauth2ClientCredentials", new OAuth());
        this.authentications = Collections.unmodifiableMap(this.authentications);
    }

    public static WebClient.Builder buildWebClientBuilder(ObjectMapper mapper) {
        ExchangeStrategies strategies = ExchangeStrategies.builder().codecs(clientDefaultCodecsConfigurer -> {
            clientDefaultCodecsConfigurer.defaultCodecs().jackson2JsonEncoder((Encoder)new Jackson2JsonEncoder(mapper, new MimeType[]{MediaType.APPLICATION_JSON}));
            clientDefaultCodecsConfigurer.defaultCodecs().jackson2JsonDecoder((Decoder)new Jackson2JsonDecoder(mapper, new MimeType[]{MediaType.APPLICATION_JSON}));
        }).build();
        WebClient.Builder webClientBuilder = WebClient.builder().exchangeStrategies(strategies);
        return webClientBuilder;
    }

    public static WebClient.Builder buildWebClientBuilder() {
        return ApiClient.buildWebClientBuilder(ApiClient.createDefaultObjectMapper(null));
    }

    public static WebClient buildWebClient(ObjectMapper mapper) {
        return ApiClient.buildWebClientBuilder(mapper).build();
    }

    public static WebClient buildWebClient() {
        return ApiClient.buildWebClientBuilder(ApiClient.createDefaultObjectMapper(null)).build();
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public void setBearerToken(String bearerToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBearerAuth)) continue;
            ((HttpBearerAuth)auth).setBearerToken(bearerToken);
            return;
        }
        throw new RuntimeException("No Bearer authentication configured!");
    }

    public void setUsername(String username) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setUsername(username);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setPassword(String password) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setPassword(password);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setApiKey(String apiKey) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKey(apiKey);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setApiKeyPrefix(String apiKeyPrefix) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKeyPrefix(apiKeyPrefix);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setAccessToken(String accessToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setAccessToken(accessToken);
            return;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClient addDefaultHeader(String name, String value) {
        if (this.defaultHeaders.containsKey((Object)name)) {
            this.defaultHeaders.remove((Object)name);
        }
        this.defaultHeaders.add(name, value);
        return this;
    }

    public ApiClient addDefaultCookie(String name, String value) {
        if (this.defaultCookies.containsKey((Object)name)) {
            this.defaultCookies.remove((Object)name);
        }
        this.defaultCookies.add((Object)name, (Object)value);
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public Date parseDate(String str) {
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public WebClient getWebClient() {
        return this.webClient;
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDate((Date)param);
        }
        if (param instanceof OffsetDateTime) {
            return this.formatOffsetDateTime((OffsetDateTime)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public MultiValueMap<String, String> parameterToMultiValueMap(CollectionFormat collectionFormat, String name, Object value) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        if (collectionFormat == null) {
            collectionFormat = CollectionFormat.CSV;
        }
        if (value instanceof Map) {
            Map valuesMap = (Map)value;
            for (Map.Entry entry : valuesMap.entrySet()) {
                params.add((Object)((String)entry.getKey()), (Object)this.parameterToString(entry.getValue()));
            }
            return params;
        }
        Collection valueCollection = null;
        if (!(value instanceof Collection)) {
            params.add((Object)name, (Object)this.parameterToString(value));
            return params;
        }
        valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        if (collectionFormat.equals((Object)CollectionFormat.MULTI)) {
            for (Object item : valueCollection) {
                params.add((Object)name, (Object)this.parameterToString(item));
            }
            return params;
        }
        ArrayList<String> values = new ArrayList<String>();
        for (Object o : valueCollection) {
            values.add(this.parameterToString(o));
        }
        params.add((Object)name, (Object)collectionFormat.collectionToString(values));
        return params;
    }

    public boolean isJsonMime(String mediaType) {
        if ("*/*".equals(mediaType)) {
            return true;
        }
        try {
            return this.isJsonMime(MediaType.parseMediaType((String)mediaType));
        }
        catch (InvalidMediaTypeException invalidMediaTypeException) {
            return false;
        }
    }

    public boolean isJsonMime(MediaType mediaType) {
        return mediaType != null && (MediaType.APPLICATION_JSON.isCompatibleWith(mediaType) || mediaType.getSubtype().matches("^.*(\\+json|ndjson)[;]?\\s*$"));
    }

    public boolean isProblemJsonMime(String mediaType) {
        return "application/problem+json".equalsIgnoreCase(mediaType);
    }

    public List<MediaType> selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            MediaType mediaType = MediaType.parseMediaType((String)accept);
            if (!this.isJsonMime(mediaType) || this.isProblemJsonMime(accept)) continue;
            return Collections.singletonList(mediaType);
        }
        return MediaType.parseMediaTypes((String)StringUtils.arrayToCommaDelimitedString((Object[])accepts));
    }

    public MediaType selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return null;
        }
        for (String contentType : contentTypes) {
            MediaType mediaType = MediaType.parseMediaType((String)contentType);
            if (!this.isJsonMime(mediaType)) continue;
            return mediaType;
        }
        return MediaType.parseMediaType((String)contentTypes[0]);
    }

    protected BodyInserter<?, ? super ClientHttpRequest> selectBody(Object obj, MultiValueMap<String, Object> formParams, MediaType contentType) {
        if (MediaType.APPLICATION_FORM_URLENCODED.equals((Object)contentType)) {
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            formParams.toSingleValueMap().entrySet().forEach(arg_0 -> ApiClient.lambda$selectBody$3((MultiValueMap)map, arg_0));
            return BodyInserters.fromFormData((MultiValueMap)map);
        }
        if (MediaType.MULTIPART_FORM_DATA.equals((Object)contentType)) {
            return BodyInserters.fromMultipartData(formParams);
        }
        return obj != null ? BodyInserters.fromValue((Object)obj) : null;
    }

    public <T> WebClient.ResponseSpec invokeAPI(String path, HttpMethod method, Map<String, Object> pathParams, MultiValueMap<String, String> queryParams, Object body, HttpHeaders headerParams, MultiValueMap<String, String> cookieParams, MultiValueMap<String, Object> formParams, List<MediaType> accept, MediaType contentType, String[] authNames, ParameterizedTypeReference<T> returnType) throws RestClientException {
        WebClient.RequestBodySpec requestBuilder = this.prepareRequest(path, method, pathParams, queryParams, body, headerParams, cookieParams, formParams, accept, contentType, authNames);
        return requestBuilder.retrieve();
    }

    private String generateQueryUri(MultiValueMap<String, String> queryParams, Map<String, Object> uriParams) {
        StringBuilder queryBuilder = new StringBuilder();
        queryParams.forEach((name, values) -> {
            if (CollectionUtils.isEmpty((Collection)values)) {
                if (queryBuilder.length() != 0) {
                    queryBuilder.append('&');
                }
                queryBuilder.append((String)name);
            } else {
                int valueItemCounter = 0;
                for (Object value : values) {
                    if (queryBuilder.length() != 0) {
                        queryBuilder.append('&');
                    }
                    queryBuilder.append((String)name);
                    if (value == null) continue;
                    String templatizedKey = name + valueItemCounter++;
                    uriParams.put(templatizedKey, value.toString());
                    queryBuilder.append('=').append("{").append(templatizedKey).append("}");
                }
            }
        });
        return queryBuilder.toString();
    }

    private WebClient.RequestBodySpec prepareRequest(String path, HttpMethod method, Map<String, Object> pathParams, MultiValueMap<String, String> queryParams, Object body, HttpHeaders headerParams, MultiValueMap<String, String> cookieParams, MultiValueMap<String, Object> formParams, List<MediaType> accept, MediaType contentType, String[] authNames) {
        this.updateParamsForAuth(authNames, queryParams, headerParams, cookieParams);
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.basePath).path(path);
        Object finalUri = builder.build(false).toUriString();
        HashMap<String, Object> uriParams = new HashMap<String, Object>();
        uriParams.putAll(pathParams);
        if (queryParams != null && !queryParams.isEmpty()) {
            String queryUri = this.generateQueryUri(queryParams, uriParams);
            finalUri = (String)finalUri + "?" + queryUri;
        }
        WebClient.RequestBodySpec requestBuilder = (WebClient.RequestBodySpec)this.webClient.method(method).uri((String)finalUri, uriParams);
        if (accept != null) {
            requestBuilder.accept(accept.toArray(new MediaType[accept.size()]));
        }
        if (contentType != null) {
            requestBuilder.contentType(contentType);
        }
        this.addHeadersToRequest(headerParams, requestBuilder);
        this.addHeadersToRequest(this.defaultHeaders, requestBuilder);
        this.addCookiesToRequest(cookieParams, requestBuilder);
        this.addCookiesToRequest(this.defaultCookies, requestBuilder);
        requestBuilder.attribute(URI_TEMPLATE_ATTRIBUTE, (Object)path);
        requestBuilder.body(this.selectBody(body, formParams, contentType));
        return requestBuilder;
    }

    protected void addHeadersToRequest(HttpHeaders headers, WebClient.RequestBodySpec requestBuilder) {
        for (Map.Entry entry : headers.entrySet()) {
            List values = (List)entry.getValue();
            for (String value : values) {
                if (value == null) continue;
                requestBuilder.header((String)entry.getKey(), new String[]{value});
            }
        }
    }

    protected void addCookiesToRequest(MultiValueMap<String, String> cookies, WebClient.RequestBodySpec requestBuilder) {
        for (Map.Entry entry : cookies.entrySet()) {
            List values = (List)entry.getValue();
            for (String value : values) {
                if (value == null) continue;
                requestBuilder.cookie((String)entry.getKey(), value);
            }
        }
    }

    protected void updateParamsForAuth(String[] authNames, MultiValueMap<String, String> queryParams, HttpHeaders headerParams, MultiValueMap<String, String> cookieParams) {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                throw new RestClientException("Authentication undefined: " + authName);
            }
            auth.applyToParams(queryParams, headerParams, cookieParams);
        }
    }

    public String collectionPathParameterToString(CollectionFormat collectionFormat, Collection<?> values) {
        if (CollectionFormat.MULTI.equals((Object)collectionFormat)) {
            return this.parameterToString(values);
        }
        if (collectionFormat == null) {
            collectionFormat = CollectionFormat.CSV;
        }
        return collectionFormat.collectionToString(values);
    }

    private static /* synthetic */ void lambda$selectBody$3(MultiValueMap map, Map.Entry es) {
        map.add((Object)((String)es.getKey()), (Object)String.valueOf(es.getValue()));
    }

    public static enum CollectionFormat {
        CSV(","),
        TSV("\t"),
        SSV(" "),
        PIPES("|"),
        MULTI(null);

        private final String separator;

        private CollectionFormat(String separator) {
            this.separator = separator;
        }

        private String collectionToString(Collection<?> collection) {
            return StringUtils.collectionToDelimitedString(collection, (String)this.separator);
        }
    }
}

