/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Reference API Welcome to the Reference API - A programmer-friendly way to find platform supported taxonomies of reference data.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.65.4
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.reference.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * LanguageNonAuthenticatedEntity
 */
@JsonPropertyOrder({
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_COUNTRY,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_DISPLAY_COUNTRY,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_DISPLAY_LANGUAGE,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_DISPLAY_NAME,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_DISPLAY_SCRIPT,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_DISPLAY_VARIANT,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_ISO3_COUNTRY,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_ISO3_LANGUAGE,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_LANGUAGE,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_SCRIPT,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_VARIANT
})
@JsonTypeName("Language_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-23T16:39:58.635331566+07:00[Asia/Bangkok]")
public class LanguageNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_COUNTRY = "country";
  private String country;

  public static final String JSON_PROPERTY_DISPLAY_COUNTRY = "displayCountry";
  private String displayCountry;

  public static final String JSON_PROPERTY_DISPLAY_LANGUAGE = "displayLanguage";
  private String displayLanguage;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_DISPLAY_SCRIPT = "displayScript";
  private String displayScript;

  public static final String JSON_PROPERTY_DISPLAY_VARIANT = "displayVariant";
  private String displayVariant;

  public static final String JSON_PROPERTY_ISO3_COUNTRY = "iso3Country";
  private String iso3Country;

  public static final String JSON_PROPERTY_ISO3_LANGUAGE = "iso3Language";
  private String iso3Language;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private String language;

  public static final String JSON_PROPERTY_SCRIPT = "script";
  private String script;

  public static final String JSON_PROPERTY_VARIANT = "variant";
  private String variant;

  public LanguageNonAuthenticatedEntity() {
  }

  public LanguageNonAuthenticatedEntity country(String country) {
    
    this.country = country;
    return this;
  }

   /**
   * Get country
   * @return country
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(String country) {
    this.country = country;
  }


  public LanguageNonAuthenticatedEntity displayCountry(String displayCountry) {
    
    this.displayCountry = displayCountry;
    return this;
  }

   /**
   * Get displayCountry
   * @return displayCountry
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISPLAY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayCountry() {
    return displayCountry;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayCountry(String displayCountry) {
    this.displayCountry = displayCountry;
  }


  public LanguageNonAuthenticatedEntity displayLanguage(String displayLanguage) {
    
    this.displayLanguage = displayLanguage;
    return this;
  }

   /**
   * Get displayLanguage
   * @return displayLanguage
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISPLAY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayLanguage() {
    return displayLanguage;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayLanguage(String displayLanguage) {
    this.displayLanguage = displayLanguage;
  }


  public LanguageNonAuthenticatedEntity displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public LanguageNonAuthenticatedEntity displayScript(String displayScript) {
    
    this.displayScript = displayScript;
    return this;
  }

   /**
   * Get displayScript
   * @return displayScript
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISPLAY_SCRIPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayScript() {
    return displayScript;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_SCRIPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayScript(String displayScript) {
    this.displayScript = displayScript;
  }


  public LanguageNonAuthenticatedEntity displayVariant(String displayVariant) {
    
    this.displayVariant = displayVariant;
    return this;
  }

   /**
   * Get displayVariant
   * @return displayVariant
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISPLAY_VARIANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayVariant() {
    return displayVariant;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_VARIANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayVariant(String displayVariant) {
    this.displayVariant = displayVariant;
  }


  public LanguageNonAuthenticatedEntity iso3Country(String iso3Country) {
    
    this.iso3Country = iso3Country;
    return this;
  }

   /**
   * Get iso3Country
   * @return iso3Country
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ISO3_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIso3Country() {
    return iso3Country;
  }


  @JsonProperty(JSON_PROPERTY_ISO3_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIso3Country(String iso3Country) {
    this.iso3Country = iso3Country;
  }


  public LanguageNonAuthenticatedEntity iso3Language(String iso3Language) {
    
    this.iso3Language = iso3Language;
    return this;
  }

   /**
   * Get iso3Language
   * @return iso3Language
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ISO3_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIso3Language() {
    return iso3Language;
  }


  @JsonProperty(JSON_PROPERTY_ISO3_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIso3Language(String iso3Language) {
    this.iso3Language = iso3Language;
  }


  public LanguageNonAuthenticatedEntity language(String language) {
    
    this.language = language;
    return this;
  }

   /**
   * Get language
   * @return language
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(String language) {
    this.language = language;
  }


  public LanguageNonAuthenticatedEntity script(String script) {
    
    this.script = script;
    return this;
  }

   /**
   * Get script
   * @return script
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SCRIPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getScript() {
    return script;
  }


  @JsonProperty(JSON_PROPERTY_SCRIPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScript(String script) {
    this.script = script;
  }


  public LanguageNonAuthenticatedEntity variant(String variant) {
    
    this.variant = variant;
    return this;
  }

   /**
   * Get variant
   * @return variant
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VARIANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVariant() {
    return variant;
  }


  @JsonProperty(JSON_PROPERTY_VARIANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariant(String variant) {
    this.variant = variant;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LanguageNonAuthenticatedEntity languageNonAuthenticatedEntity = (LanguageNonAuthenticatedEntity) o;
    return Objects.equals(this.country, languageNonAuthenticatedEntity.country) &&
        Objects.equals(this.displayCountry, languageNonAuthenticatedEntity.displayCountry) &&
        Objects.equals(this.displayLanguage, languageNonAuthenticatedEntity.displayLanguage) &&
        Objects.equals(this.displayName, languageNonAuthenticatedEntity.displayName) &&
        Objects.equals(this.displayScript, languageNonAuthenticatedEntity.displayScript) &&
        Objects.equals(this.displayVariant, languageNonAuthenticatedEntity.displayVariant) &&
        Objects.equals(this.iso3Country, languageNonAuthenticatedEntity.iso3Country) &&
        Objects.equals(this.iso3Language, languageNonAuthenticatedEntity.iso3Language) &&
        Objects.equals(this.language, languageNonAuthenticatedEntity.language) &&
        Objects.equals(this.script, languageNonAuthenticatedEntity.script) &&
        Objects.equals(this.variant, languageNonAuthenticatedEntity.variant);
  }

  @Override
  public int hashCode() {
    return Objects.hash(country, displayCountry, displayLanguage, displayName, displayScript, displayVariant, iso3Country, iso3Language, language, script, variant);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LanguageNonAuthenticatedEntity {\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    displayCountry: ").append(toIndentedString(displayCountry)).append("\n");
    sb.append("    displayLanguage: ").append(toIndentedString(displayLanguage)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    displayScript: ").append(toIndentedString(displayScript)).append("\n");
    sb.append("    displayVariant: ").append(toIndentedString(displayVariant)).append("\n");
    sb.append("    iso3Country: ").append(toIndentedString(iso3Country)).append("\n");
    sb.append("    iso3Language: ").append(toIndentedString(iso3Language)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    script: ").append(toIndentedString(script)).append("\n");
    sb.append("    variant: ").append(toIndentedString(variant)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

