/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.reference.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.reference.invoker.ApiClient;
import travel.wink.sdk.reference.model.GeoNameConsumer;
import travel.wink.sdk.reference.model.GeoNameCountryConsumer;
import travel.wink.sdk.reference.model.KeyValuePairConsumer;

public class GeoNameApi {
    private ApiClient apiClient;

    public GeoNameApi() {
        this(new ApiClient());
    }

    @Autowired
    public GeoNameApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec searchForCitiesRequestCreation(String term, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (term == null) {
            throw new WebClientResponseException("Missing the required parameter 'term' when calling searchForCities", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("term", term);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GeoNameConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameConsumer>(){};
        return this.apiClient.invokeAPI("/api/geo/city/search/{term}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<GeoNameConsumer> searchForCities(String term, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameConsumer>(){};
        return this.searchForCitiesRequestCreation(term, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<GeoNameConsumer>>> searchForCitiesWithHttpInfo(String term, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameConsumer>(){};
        return this.searchForCitiesRequestCreation(term, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec searchForCitiesWithResponseSpec(String term, String winkVersion) throws WebClientResponseException {
        return this.searchForCitiesRequestCreation(term, winkVersion);
    }

    private WebClient.ResponseSpec searchForCityRequestCreation(String searchTerm, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (searchTerm == null) {
            throw new WebClientResponseException("Missing the required parameter 'searchTerm' when calling searchForCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("searchTerm", searchTerm);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GeoNameConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameConsumer>(){};
        return this.apiClient.invokeAPI("/api/geoip/city/{searchTerm}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<GeoNameConsumer> searchForCity(String searchTerm, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameConsumer>(){};
        return this.searchForCityRequestCreation(searchTerm, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<GeoNameConsumer>>> searchForCityWithHttpInfo(String searchTerm, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameConsumer>(){};
        return this.searchForCityRequestCreation(searchTerm, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec searchForCityWithResponseSpec(String searchTerm, String winkVersion) throws WebClientResponseException {
        return this.searchForCityRequestCreation(searchTerm, winkVersion);
    }

    private WebClient.ResponseSpec showContinentsRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(){};
        return this.apiClient.invokeAPI("/api/geoip/continent/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairConsumer> showContinents(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(){};
        return this.showContinentsRequestCreation(winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairConsumer>>> showContinentsWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairConsumer> localVarReturnType = new ParameterizedTypeReference<KeyValuePairConsumer>(){};
        return this.showContinentsRequestCreation(winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showContinentsWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return this.showContinentsRequestCreation(winkVersion);
    }

    private WebClient.ResponseSpec showCountries1RequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GeoNameCountryConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameCountryConsumer>(){};
        return this.apiClient.invokeAPI("/api/geoip/country/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<GeoNameCountryConsumer> showCountries1(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameCountryConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameCountryConsumer>(){};
        return this.showCountries1RequestCreation(winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<GeoNameCountryConsumer>>> showCountries1WithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameCountryConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameCountryConsumer>(){};
        return this.showCountries1RequestCreation(winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCountries1WithResponseSpec(String winkVersion) throws WebClientResponseException {
        return this.showCountries1RequestCreation(winkVersion);
    }

    private WebClient.ResponseSpec showGeoNameByIdRequestCreation(String geoNameId, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (geoNameId == null) {
            throw new WebClientResponseException("Missing the required parameter 'geoNameId' when calling showGeoNameById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("geoNameId", geoNameId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GeoNameConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameConsumer>(){};
        return this.apiClient.invokeAPI("/api/geo/{geoNameId}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GeoNameConsumer> showGeoNameById(String geoNameId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameConsumer>(){};
        return this.showGeoNameByIdRequestCreation(geoNameId, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GeoNameConsumer>> showGeoNameByIdWithHttpInfo(String geoNameId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameConsumer> localVarReturnType = new ParameterizedTypeReference<GeoNameConsumer>(){};
        return this.showGeoNameByIdRequestCreation(geoNameId, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showGeoNameByIdWithResponseSpec(String geoNameId, String winkVersion) throws WebClientResponseException {
        return this.showGeoNameByIdRequestCreation(geoNameId, winkVersion);
    }

    private WebClient.ResponseSpec showTimezonesRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(){};
        return this.apiClient.invokeAPI("/api/geoip/timezone/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<String> showTimezones(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(){};
        return this.showTimezonesRequestCreation(winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<String>>> showTimezonesWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(){};
        return this.showTimezonesRequestCreation(winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showTimezonesWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return this.showTimezonesRequestCreation(winkVersion);
    }
}

