package travel.wink.sdk.reference.api;

import travel.wink.sdk.reference.invoker.ApiClient;

import travel.wink.sdk.reference.model.GenericErrorMessage;
import travel.wink.sdk.reference.model.GeoIPNonAuthenticatedEntity;
import travel.wink.sdk.reference.model.GeoNameCountryNonAuthenticatedEntity;
import travel.wink.sdk.reference.model.GeoNameNonAuthenticatedEntity;
import travel.wink.sdk.reference.model.KeyValuePairNonAuthenticatedEntity;
import travel.wink.sdk.reference.model.ShowSocialNetworks400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-24T16:12:09.505448761+07:00[Asia/Bangkok]")
public class GeoDataApi {
    private ApiClient apiClient;

    public GeoDataApi() {
        this(new ApiClient());
    }

    @Autowired
    public GeoDataApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Find Geo Name by Term
     * Finds a list of geo-name entities for a term that &#x60;sounds like&#x60;.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param term Geo-name term to be searched
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;GeoNameNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec searchForCitiesRequestCreation(String term, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'term' is set
        if (term == null) {
            throw new WebClientResponseException("Missing the required parameter 'term' when calling searchForCities", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("term", term);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GeoNameNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/geo/city/search/{term}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Find Geo Name by Term
     * Finds a list of geo-name entities for a term that &#x60;sounds like&#x60;.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param term Geo-name term to be searched
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;GeoNameNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<GeoNameNonAuthenticatedEntity> searchForCities(String term, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameNonAuthenticatedEntity>() {};
        return searchForCitiesRequestCreation(term, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Find Geo Name by Term
     * Finds a list of geo-name entities for a term that &#x60;sounds like&#x60;.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param term Geo-name term to be searched
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;GeoNameNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<GeoNameNonAuthenticatedEntity>>> searchForCitiesWithHttpInfo(String term, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameNonAuthenticatedEntity>() {};
        return searchForCitiesRequestCreation(term, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Find Geo Name by Term
     * Finds a list of geo-name entities for a term that &#x60;sounds like&#x60;.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param term Geo-name term to be searched
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec searchForCitiesWithResponseSpec(String term, String winkVersion, String accept) throws WebClientResponseException {
        return searchForCitiesRequestCreation(term, winkVersion, accept);
    }
    /**
     * City Search
     * Searches for city matching search term.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param searchTerm Search for city by search term
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;GeoIPNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec searchForCityRequestCreation(String searchTerm, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'searchTerm' is set
        if (searchTerm == null) {
            throw new WebClientResponseException("Missing the required parameter 'searchTerm' when calling searchForCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("searchTerm", searchTerm);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GeoIPNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoIPNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/geo-ip/city/{searchTerm}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * City Search
     * Searches for city matching search term.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param searchTerm Search for city by search term
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;GeoIPNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<GeoIPNonAuthenticatedEntity> searchForCity(String searchTerm, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoIPNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoIPNonAuthenticatedEntity>() {};
        return searchForCityRequestCreation(searchTerm, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * City Search
     * Searches for city matching search term.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param searchTerm Search for city by search term
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;GeoIPNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<GeoIPNonAuthenticatedEntity>>> searchForCityWithHttpInfo(String searchTerm, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoIPNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoIPNonAuthenticatedEntity>() {};
        return searchForCityRequestCreation(searchTerm, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * City Search
     * Searches for city matching search term.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param searchTerm Search for city by search term
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec searchForCityWithResponseSpec(String searchTerm, String winkVersion, String accept) throws WebClientResponseException {
        return searchForCityRequestCreation(searchTerm, winkVersion, accept);
    }
    /**
     * Show All Continents
     * List all continents.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContinentsRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/geo-ip/continent/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show All Continents
     * List all continents.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairNonAuthenticatedEntity> showContinents(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return showContinentsRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show All Continents
     * List all continents.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairNonAuthenticatedEntity>>> showContinentsWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return showContinentsRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show All Continents
     * List all continents.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showContinentsWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return showContinentsRequestCreation(winkVersion, accept);
    }
    /**
     * Show Geo Name Countries
     * List all countries.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;GeoNameCountryNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCountriesRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GeoNameCountryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameCountryNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/geo-ip/country/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Geo Name Countries
     * List all countries.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;GeoNameCountryNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<GeoNameCountryNonAuthenticatedEntity> showCountries(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameCountryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameCountryNonAuthenticatedEntity>() {};
        return showCountriesRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Geo Name Countries
     * List all countries.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;GeoNameCountryNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<GeoNameCountryNonAuthenticatedEntity>>> showCountriesWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameCountryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameCountryNonAuthenticatedEntity>() {};
        return showCountriesRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Geo Name Countries
     * List all countries.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCountriesWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return showCountriesRequestCreation(winkVersion, accept);
    }
    /**
     * Find Geo Name by Id
     * Finds geo-name by given identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param geoNameId Geo-name identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return GeoNameNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showGeoNameByIdRequestCreation(String geoNameId, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'geoNameId' is set
        if (geoNameId == null) {
            throw new WebClientResponseException("Missing the required parameter 'geoNameId' when calling showGeoNameById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("geoNameId", geoNameId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GeoNameNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/geo/{geoNameId}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Find Geo Name by Id
     * Finds geo-name by given identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param geoNameId Geo-name identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return GeoNameNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GeoNameNonAuthenticatedEntity> showGeoNameById(String geoNameId, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameNonAuthenticatedEntity>() {};
        return showGeoNameByIdRequestCreation(geoNameId, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Find Geo Name by Id
     * Finds geo-name by given identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param geoNameId Geo-name identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;GeoNameNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<GeoNameNonAuthenticatedEntity>> showGeoNameByIdWithHttpInfo(String geoNameId, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameNonAuthenticatedEntity>() {};
        return showGeoNameByIdRequestCreation(geoNameId, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Find Geo Name by Id
     * Finds geo-name by given identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param geoNameId Geo-name identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showGeoNameByIdWithResponseSpec(String geoNameId, String winkVersion, String accept) throws WebClientResponseException {
        return showGeoNameByIdRequestCreation(geoNameId, winkVersion, accept);
    }
    /**
     * Show Time Zones
     * List all time zones.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;String&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showTimezonesRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<List<String>> localVarReturnType = new ParameterizedTypeReference<List<String>>() {};
        return apiClient.invokeAPI("/reference-data/geo-ip/timezone/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Time Zones
     * List all time zones.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;String&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<List<String>> showTimezones(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<List<String>> localVarReturnType = new ParameterizedTypeReference<List<String>>() {};
        return showTimezonesRequestCreation(winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Time Zones
     * List all time zones.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;String&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<String>>> showTimezonesWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<List<String>> localVarReturnType = new ParameterizedTypeReference<List<String>>() {};
        return showTimezonesRequestCreation(winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Time Zones
     * List all time zones.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showTimezonesWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return showTimezonesRequestCreation(winkVersion, accept);
    }
}
