/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Reference API  The Reference API exposes endpoints related to supported taxonomies of reactive data that this platform supports.  
 *
 * The version of the OpenAPI document: 30.13.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.reference.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * LanguageNonAuthenticatedEntity
 */
@JsonPropertyOrder({
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_COUNTRY,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_DISPLAY_COUNTRY,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_DISPLAY_LANGUAGE,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_DISPLAY_NAME,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_DISPLAY_SCRIPT,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_DISPLAY_VARIANT,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_ISO3_COUNTRY,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_ISO3_LANGUAGE,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_LANGUAGE,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_SCRIPT,
  LanguageNonAuthenticatedEntity.JSON_PROPERTY_VARIANT
})
@JsonTypeName("Language_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-05T14:56:41.125117007+07:00[Asia/Bangkok]")
public class LanguageNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_COUNTRY = "country";
  private String country;

  public static final String JSON_PROPERTY_DISPLAY_COUNTRY = "displayCountry";
  private String displayCountry;

  public static final String JSON_PROPERTY_DISPLAY_LANGUAGE = "displayLanguage";
  private String displayLanguage;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_DISPLAY_SCRIPT = "displayScript";
  private String displayScript;

  public static final String JSON_PROPERTY_DISPLAY_VARIANT = "displayVariant";
  private String displayVariant;

  public static final String JSON_PROPERTY_ISO3_COUNTRY = "iso3Country";
  private String iso3Country;

  public static final String JSON_PROPERTY_ISO3_LANGUAGE = "iso3Language";
  private String iso3Language;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private String language;

  public static final String JSON_PROPERTY_SCRIPT = "script";
  private String script;

  public static final String JSON_PROPERTY_VARIANT = "variant";
  private String variant;

  public LanguageNonAuthenticatedEntity() {
  }

  public LanguageNonAuthenticatedEntity country(String country) {
    
    this.country = country;
    return this;
  }

   /**
   * Get country
   * @return country
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(String country) {
    this.country = country;
  }


  public LanguageNonAuthenticatedEntity displayCountry(String displayCountry) {
    
    this.displayCountry = displayCountry;
    return this;
  }

   /**
   * Get displayCountry
   * @return displayCountry
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISPLAY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayCountry() {
    return displayCountry;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayCountry(String displayCountry) {
    this.displayCountry = displayCountry;
  }


  public LanguageNonAuthenticatedEntity displayLanguage(String displayLanguage) {
    
    this.displayLanguage = displayLanguage;
    return this;
  }

   /**
   * Get displayLanguage
   * @return displayLanguage
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISPLAY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayLanguage() {
    return displayLanguage;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayLanguage(String displayLanguage) {
    this.displayLanguage = displayLanguage;
  }


  public LanguageNonAuthenticatedEntity displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public LanguageNonAuthenticatedEntity displayScript(String displayScript) {
    
    this.displayScript = displayScript;
    return this;
  }

   /**
   * Get displayScript
   * @return displayScript
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISPLAY_SCRIPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayScript() {
    return displayScript;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_SCRIPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayScript(String displayScript) {
    this.displayScript = displayScript;
  }


  public LanguageNonAuthenticatedEntity displayVariant(String displayVariant) {
    
    this.displayVariant = displayVariant;
    return this;
  }

   /**
   * Get displayVariant
   * @return displayVariant
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISPLAY_VARIANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayVariant() {
    return displayVariant;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_VARIANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayVariant(String displayVariant) {
    this.displayVariant = displayVariant;
  }


  public LanguageNonAuthenticatedEntity iso3Country(String iso3Country) {
    
    this.iso3Country = iso3Country;
    return this;
  }

   /**
   * Get iso3Country
   * @return iso3Country
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ISO3_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIso3Country() {
    return iso3Country;
  }


  @JsonProperty(JSON_PROPERTY_ISO3_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIso3Country(String iso3Country) {
    this.iso3Country = iso3Country;
  }


  public LanguageNonAuthenticatedEntity iso3Language(String iso3Language) {
    
    this.iso3Language = iso3Language;
    return this;
  }

   /**
   * Get iso3Language
   * @return iso3Language
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ISO3_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIso3Language() {
    return iso3Language;
  }


  @JsonProperty(JSON_PROPERTY_ISO3_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIso3Language(String iso3Language) {
    this.iso3Language = iso3Language;
  }


  public LanguageNonAuthenticatedEntity language(String language) {
    
    this.language = language;
    return this;
  }

   /**
   * Get language
   * @return language
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(String language) {
    this.language = language;
  }


  public LanguageNonAuthenticatedEntity script(String script) {
    
    this.script = script;
    return this;
  }

   /**
   * Get script
   * @return script
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SCRIPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getScript() {
    return script;
  }


  @JsonProperty(JSON_PROPERTY_SCRIPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScript(String script) {
    this.script = script;
  }


  public LanguageNonAuthenticatedEntity variant(String variant) {
    
    this.variant = variant;
    return this;
  }

   /**
   * Get variant
   * @return variant
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VARIANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVariant() {
    return variant;
  }


  @JsonProperty(JSON_PROPERTY_VARIANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariant(String variant) {
    this.variant = variant;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LanguageNonAuthenticatedEntity languageNonAuthenticatedEntity = (LanguageNonAuthenticatedEntity) o;
    return Objects.equals(this.country, languageNonAuthenticatedEntity.country) &&
        Objects.equals(this.displayCountry, languageNonAuthenticatedEntity.displayCountry) &&
        Objects.equals(this.displayLanguage, languageNonAuthenticatedEntity.displayLanguage) &&
        Objects.equals(this.displayName, languageNonAuthenticatedEntity.displayName) &&
        Objects.equals(this.displayScript, languageNonAuthenticatedEntity.displayScript) &&
        Objects.equals(this.displayVariant, languageNonAuthenticatedEntity.displayVariant) &&
        Objects.equals(this.iso3Country, languageNonAuthenticatedEntity.iso3Country) &&
        Objects.equals(this.iso3Language, languageNonAuthenticatedEntity.iso3Language) &&
        Objects.equals(this.language, languageNonAuthenticatedEntity.language) &&
        Objects.equals(this.script, languageNonAuthenticatedEntity.script) &&
        Objects.equals(this.variant, languageNonAuthenticatedEntity.variant);
  }

  @Override
  public int hashCode() {
    return Objects.hash(country, displayCountry, displayLanguage, displayName, displayScript, displayVariant, iso3Country, iso3Language, language, script, variant);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LanguageNonAuthenticatedEntity {\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    displayCountry: ").append(toIndentedString(displayCountry)).append("\n");
    sb.append("    displayLanguage: ").append(toIndentedString(displayLanguage)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    displayScript: ").append(toIndentedString(displayScript)).append("\n");
    sb.append("    displayVariant: ").append(toIndentedString(displayVariant)).append("\n");
    sb.append("    iso3Country: ").append(toIndentedString(iso3Country)).append("\n");
    sb.append("    iso3Language: ").append(toIndentedString(iso3Language)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    script: ").append(toIndentedString(script)).append("\n");
    sb.append("    variant: ").append(toIndentedString(variant)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

