/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.reference.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.reference.invoker.ApiClient;
import travel.wink.sdk.reference.model.GeoIPNonAuthenticatedEntity;
import travel.wink.sdk.reference.model.GeoNameCountryNonAuthenticatedEntity;
import travel.wink.sdk.reference.model.GeoNameNonAuthenticatedEntity;
import travel.wink.sdk.reference.model.KeyValuePairNonAuthenticatedEntity;

public class GeoDataApi {
    private ApiClient apiClient;

    public GeoDataApi() {
        this(new ApiClient());
    }

    @Autowired
    public GeoDataApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec searchForCitiesRequestCreation(String term, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (term == null) {
            throw new WebClientResponseException("Missing the required parameter 'term' when calling searchForCities", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("term", term);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GeoNameNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/reference-data/geo/city/search/{term}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<GeoNameNonAuthenticatedEntity> searchForCities(String term, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameNonAuthenticatedEntity>(this){};
        return this.searchForCitiesRequestCreation(term, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<GeoNameNonAuthenticatedEntity>>> searchForCitiesWithHttpInfo(String term, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameNonAuthenticatedEntity>(this){};
        return this.searchForCitiesRequestCreation(term, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec searchForCitiesWithResponseSpec(String term, String winkVersion, String accept) throws WebClientResponseException {
        return this.searchForCitiesRequestCreation(term, winkVersion, accept);
    }

    private WebClient.ResponseSpec searchForCityRequestCreation(String searchTerm, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (searchTerm == null) {
            throw new WebClientResponseException("Missing the required parameter 'searchTerm' when calling searchForCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("searchTerm", searchTerm);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GeoIPNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoIPNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/reference-data/geo-ip/city/{searchTerm}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<GeoIPNonAuthenticatedEntity> searchForCity(String searchTerm, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoIPNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoIPNonAuthenticatedEntity>(this){};
        return this.searchForCityRequestCreation(searchTerm, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<GeoIPNonAuthenticatedEntity>>> searchForCityWithHttpInfo(String searchTerm, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoIPNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoIPNonAuthenticatedEntity>(this){};
        return this.searchForCityRequestCreation(searchTerm, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec searchForCityWithResponseSpec(String searchTerm, String winkVersion, String accept) throws WebClientResponseException {
        return this.searchForCityRequestCreation(searchTerm, winkVersion, accept);
    }

    private WebClient.ResponseSpec showContinentsRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/reference-data/geo-ip/continent/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairNonAuthenticatedEntity> showContinents(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>(this){};
        return this.showContinentsRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairNonAuthenticatedEntity>>> showContinentsWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>(this){};
        return this.showContinentsRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showContinentsWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showContinentsRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showCountriesRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GeoNameCountryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameCountryNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/reference-data/geo-ip/country/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<GeoNameCountryNonAuthenticatedEntity> showCountries(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameCountryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameCountryNonAuthenticatedEntity>(this){};
        return this.showCountriesRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<GeoNameCountryNonAuthenticatedEntity>>> showCountriesWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameCountryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameCountryNonAuthenticatedEntity>(this){};
        return this.showCountriesRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCountriesWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showCountriesRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showGeoNameByIdRequestCreation(String geoNameId, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (geoNameId == null) {
            throw new WebClientResponseException("Missing the required parameter 'geoNameId' when calling showGeoNameById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("geoNameId", geoNameId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GeoNameNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/reference-data/geo/{geoNameId}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GeoNameNonAuthenticatedEntity> showGeoNameById(String geoNameId, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameNonAuthenticatedEntity>(this){};
        return this.showGeoNameByIdRequestCreation(geoNameId, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GeoNameNonAuthenticatedEntity>> showGeoNameByIdWithHttpInfo(String geoNameId, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameNonAuthenticatedEntity>(this){};
        return this.showGeoNameByIdRequestCreation(geoNameId, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showGeoNameByIdWithResponseSpec(String geoNameId, String winkVersion, String accept) throws WebClientResponseException {
        return this.showGeoNameByIdRequestCreation(geoNameId, winkVersion, accept);
    }

    private WebClient.ResponseSpec showTimezonesRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<List<String>> localVarReturnType = new ParameterizedTypeReference<List<String>>(this){};
        return this.apiClient.invokeAPI("/reference-data/geo-ip/timezone/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<List<String>> showTimezones(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<List<String>> localVarReturnType = new ParameterizedTypeReference<List<String>>(this){};
        return this.showTimezonesRequestCreation(winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<String>>> showTimezonesWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<List<String>> localVarReturnType = new ParameterizedTypeReference<List<String>>(this){};
        return this.showTimezonesRequestCreation(winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showTimezonesWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showTimezonesRequestCreation(winkVersion, accept);
    }
}

