package travel.wink.sdk.reference.api;

import travel.wink.sdk.reference.invoker.ApiClient;

import travel.wink.sdk.reference.model.GenericErrorMessage;
import travel.wink.sdk.reference.model.KeyValuePairAdministrator;
import travel.wink.sdk.reference.model.ShowSocialNetworks400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-03-04T20:50:47.852815046+07:00[Asia/Bangkok]")
public class RateProviderApi {
    private ApiClient apiClient;

    public RateProviderApi() {
        this(new ApiClient());
    }

    @Autowired
    public RateProviderApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Channel Managers
     * Returns all available channel managers.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairAdministrator&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showChannelManagersRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairAdministrator> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAdministrator>() {};
        return apiClient.invokeAPI("/reference-data/channel-manager/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Channel Managers
     * Returns all available channel managers.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairAdministrator&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairAdministrator> showChannelManagers(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAdministrator> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAdministrator>() {};
        return showChannelManagersRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Channel Managers
     * Returns all available channel managers.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairAdministrator&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairAdministrator>>> showChannelManagersWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAdministrator> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAdministrator>() {};
        return showChannelManagersRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Channel Managers
     * Returns all available channel managers.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showChannelManagersWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return showChannelManagersRequestCreation(winkVersion, accept);
    }
}
