package travel.wink.sdk.reference.api;

import travel.wink.sdk.reference.invoker.ApiClient;

import travel.wink.sdk.reference.model.GenericErrorMessage;
import travel.wink.sdk.reference.model.GeoIpLightweightNonAuthenticatedEntity;
import travel.wink.sdk.reference.model.GeoNameCountryNonAuthenticatedEntity;
import travel.wink.sdk.reference.model.GeoNameLightweightNonAuthenticatedEntity;
import travel.wink.sdk.reference.model.KeyValuePairNonAuthenticatedEntity;
import travel.wink.sdk.reference.model.ShowSocialNetworks400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Arrays;
import java.util.stream.Collectors;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:21:42.795961304+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class GeoDataApi {
    private ApiClient apiClient;

    public GeoDataApi() {
        this(new ApiClient());
    }

    @Autowired
    public GeoDataApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    
    /**
     * Find Geo Name by Term
     * Finds a list of geo-name entities for a term that &#x60;sounds like&#x60;.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param term Geo-name term to be searched
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;GeoNameLightweightNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec searchForCitiesRequestCreation(@jakarta.annotation.Nonnull String term, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'term' is set
        if (term == null) {
            throw new WebClientResponseException("Missing the required parameter 'term' when calling searchForCities", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "term", term));
        

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GeoNameLightweightNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameLightweightNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/geo/city/search", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Find Geo Name by Term
     * Finds a list of geo-name entities for a term that &#x60;sounds like&#x60;.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param term Geo-name term to be searched
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;GeoNameLightweightNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<GeoNameLightweightNonAuthenticatedEntity> searchForCities(@jakarta.annotation.Nonnull String term, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameLightweightNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameLightweightNonAuthenticatedEntity>() {};
        return searchForCitiesRequestCreation(term, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Find Geo Name by Term
     * Finds a list of geo-name entities for a term that &#x60;sounds like&#x60;.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param term Geo-name term to be searched
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;GeoNameLightweightNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<GeoNameLightweightNonAuthenticatedEntity>>> searchForCitiesWithHttpInfo(@jakarta.annotation.Nonnull String term, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameLightweightNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameLightweightNonAuthenticatedEntity>() {};
        return searchForCitiesRequestCreation(term, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Find Geo Name by Term
     * Finds a list of geo-name entities for a term that &#x60;sounds like&#x60;.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param term Geo-name term to be searched
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec searchForCitiesWithResponseSpec(@jakarta.annotation.Nonnull String term, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return searchForCitiesRequestCreation(term, winkVersion, accept);
    }

    /**
     * City Search
     * Searches for city matching search term.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param searchTerm Search for city by search term
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;GeoIpLightweightNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec searchForCityRequestCreation(@jakarta.annotation.Nonnull String searchTerm, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'searchTerm' is set
        if (searchTerm == null) {
            throw new WebClientResponseException("Missing the required parameter 'searchTerm' when calling searchForCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("searchTerm", searchTerm);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GeoIpLightweightNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoIpLightweightNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/geo-ip/city/{searchTerm}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * City Search
     * Searches for city matching search term.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param searchTerm Search for city by search term
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;GeoIpLightweightNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<GeoIpLightweightNonAuthenticatedEntity> searchForCity(@jakarta.annotation.Nonnull String searchTerm, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoIpLightweightNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoIpLightweightNonAuthenticatedEntity>() {};
        return searchForCityRequestCreation(searchTerm, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * City Search
     * Searches for city matching search term.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param searchTerm Search for city by search term
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;GeoIpLightweightNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<GeoIpLightweightNonAuthenticatedEntity>>> searchForCityWithHttpInfo(@jakarta.annotation.Nonnull String searchTerm, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoIpLightweightNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoIpLightweightNonAuthenticatedEntity>() {};
        return searchForCityRequestCreation(searchTerm, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * City Search
     * Searches for city matching search term.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param searchTerm Search for city by search term
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec searchForCityWithResponseSpec(@jakarta.annotation.Nonnull String searchTerm, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return searchForCityRequestCreation(searchTerm, winkVersion, accept);
    }

    /**
     * Show All Continents
     * List all continents.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContinentsRequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/geo-ip/continent/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show All Continents
     * List all continents.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairNonAuthenticatedEntity> showContinents(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return showContinentsRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show All Continents
     * List all continents.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairNonAuthenticatedEntity>>> showContinentsWithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>() {};
        return showContinentsRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show All Continents
     * List all continents.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showContinentsWithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showContinentsRequestCreation(winkVersion, accept);
    }

    /**
     * Show Geo Name Countries
     * List all countries.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;GeoNameCountryNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCountriesRequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GeoNameCountryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameCountryNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/geo-ip/country/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Geo Name Countries
     * List all countries.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;GeoNameCountryNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<GeoNameCountryNonAuthenticatedEntity> showCountries(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameCountryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameCountryNonAuthenticatedEntity>() {};
        return showCountriesRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Geo Name Countries
     * List all countries.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;GeoNameCountryNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<GeoNameCountryNonAuthenticatedEntity>>> showCountriesWithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameCountryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameCountryNonAuthenticatedEntity>() {};
        return showCountriesRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Geo Name Countries
     * List all countries.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCountriesWithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showCountriesRequestCreation(winkVersion, accept);
    }

    /**
     * Find Geo Name by Id
     * Finds geo-name by given identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param geoNameId Geo-name identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return GeoNameLightweightNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showGeoNameByIdRequestCreation(@jakarta.annotation.Nonnull String geoNameId, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'geoNameId' is set
        if (geoNameId == null) {
            throw new WebClientResponseException("Missing the required parameter 'geoNameId' when calling showGeoNameById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("geoNameId", geoNameId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GeoNameLightweightNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameLightweightNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/reference-data/geo/{geoNameId}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Find Geo Name by Id
     * Finds geo-name by given identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param geoNameId Geo-name identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return GeoNameLightweightNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GeoNameLightweightNonAuthenticatedEntity> showGeoNameById(@jakarta.annotation.Nonnull String geoNameId, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameLightweightNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameLightweightNonAuthenticatedEntity>() {};
        return showGeoNameByIdRequestCreation(geoNameId, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Find Geo Name by Id
     * Finds geo-name by given identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param geoNameId Geo-name identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;GeoNameLightweightNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<GeoNameLightweightNonAuthenticatedEntity>> showGeoNameByIdWithHttpInfo(@jakarta.annotation.Nonnull String geoNameId, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameLightweightNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<GeoNameLightweightNonAuthenticatedEntity>() {};
        return showGeoNameByIdRequestCreation(geoNameId, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Find Geo Name by Id
     * Finds geo-name by given identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param geoNameId Geo-name identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showGeoNameByIdWithResponseSpec(@jakarta.annotation.Nonnull String geoNameId, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showGeoNameByIdRequestCreation(geoNameId, winkVersion, accept);
    }

    /**
     * Show Time Zones
     * List all time zones.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;String&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showTimezonesRequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<List<String>> localVarReturnType = new ParameterizedTypeReference<List<String>>() {};
        return apiClient.invokeAPI("/reference-data/geo-ip/timezone/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Time Zones
     * List all time zones.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;String&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<List<String>> showTimezones(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<List<String>> localVarReturnType = new ParameterizedTypeReference<List<String>>() {};
        return showTimezonesRequestCreation(winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Time Zones
     * List all time zones.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;String&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<String>>> showTimezonesWithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<List<String>> localVarReturnType = new ParameterizedTypeReference<List<String>>() {};
        return showTimezonesRequestCreation(winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Time Zones
     * List all time zones.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showTimezonesWithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showTimezonesRequestCreation(winkVersion, accept);
    }
}
