/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant payment widget for all other entities.   - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Travel Agent API The Travel Agent API exposes endpoints to manage agent-facilitated bookings. This API lets you:  1. Travel Agent: Manage agent entity. 2. Booking: Create / Manage bookings  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.5.10
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.travel.agent.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.travel.agent.model.CustomMonetaryAmount;
import travel.wink.sdk.travel.agent.model.PayoutFeeAgent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Payout keeps track of all outgoing funds for a certain account.
 */
@JsonPropertyOrder({
  PayoutAgent.JSON_PROPERTY_VENDOR,
  PayoutAgent.JSON_PROPERTY_VENDOR_IDENTIFIER,
  PayoutAgent.JSON_PROPERTY_VENDOR_NAME,
  PayoutAgent.JSON_PROPERTY_VENDOR_TOKEN_KEY,
  PayoutAgent.JSON_PROPERTY_IDENTIFIER,
  PayoutAgent.JSON_PROPERTY_BENEFICIARY_IDENTIFIER,
  PayoutAgent.JSON_PROPERTY_EXTERNAL_PAYEE_IDENTIFIER,
  PayoutAgent.JSON_PROPERTY_TYPE,
  PayoutAgent.JSON_PROPERTY_ENTRY,
  PayoutAgent.JSON_PROPERTY_FEES,
  PayoutAgent.JSON_PROPERTY_CREATED,
  PayoutAgent.JSON_PROPERTY_DESCRIPTION,
  PayoutAgent.JSON_PROPERTY_PAYOUT_ID,
  PayoutAgent.JSON_PROPERTY_REFERENCE_CODE,
  PayoutAgent.JSON_PROPERTY_REFERENCE_CODE_DATE,
  PayoutAgent.JSON_PROPERTY_STATUS
})
@JsonTypeName("Payout_Agent")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-28T11:55:37.128463507+07:00[Asia/Bangkok]")
public class PayoutAgent {
  /**
   * Name of integration vendor
   */
  public enum VendorEnum {
    STRIPE("STRIPE"),
    
    AGENT("AGENT"),
    
    NMI("NMI"),
    
    WISE("WISE");

    private String value;

    VendorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static VendorEnum fromValue(String value) {
      for (VendorEnum b : VendorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_VENDOR = "vendor";
  private VendorEnum vendor;

  public static final String JSON_PROPERTY_VENDOR_IDENTIFIER = "vendorIdentifier";
  private String vendorIdentifier;

  public static final String JSON_PROPERTY_VENDOR_NAME = "vendorName";
  private String vendorName;

  public static final String JSON_PROPERTY_VENDOR_TOKEN_KEY = "vendorTokenKey";
  private String vendorTokenKey;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_BENEFICIARY_IDENTIFIER = "beneficiaryIdentifier";
  private UUID beneficiaryIdentifier;

  public static final String JSON_PROPERTY_EXTERNAL_PAYEE_IDENTIFIER = "externalPayeeIdentifier";
  private String externalPayeeIdentifier;

  /**
   * Type of withdrawal.
   */
  public enum TypeEnum {
    BANK_TRANSFER("BANK_TRANSFER"),
    
    VCC("VCC");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_ENTRY = "entry";
  private CustomMonetaryAmount entry;

  public static final String JSON_PROPERTY_FEES = "fees";
  private List<PayoutFeeAgent> fees;

  public static final String JSON_PROPERTY_CREATED = "created";
  private java.time.LocalDateTime created;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_PAYOUT_ID = "payoutId";
  private String payoutId;

  public static final String JSON_PROPERTY_REFERENCE_CODE = "referenceCode";
  private String referenceCode;

  public static final String JSON_PROPERTY_REFERENCE_CODE_DATE = "referenceCodeDate";
  private java.time.LocalDateTime referenceCodeDate;

  /**
   * Status of withdrawal.
   */
  public enum StatusEnum {
    INITIATED("INITIATED"),
    
    ACTIVE("ACTIVE"),
    
    INACTIVE("INACTIVE"),
    
    FAILED("FAILED"),
    
    CANCELLED("CANCELLED"),
    
    COMPLETE("COMPLETE");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public PayoutAgent() {
  }

  public PayoutAgent vendor(VendorEnum vendor) {
    
    this.vendor = vendor;
    return this;
  }

   /**
   * Name of integration vendor
   * @return vendor
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public VendorEnum getVendor() {
    return vendor;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendor(VendorEnum vendor) {
    this.vendor = vendor;
  }


  public PayoutAgent vendorIdentifier(String vendorIdentifier) {
    
    this.vendorIdentifier = vendorIdentifier;
    return this;
  }

   /**
   * Which acquirer account we return fund from.
   * @return vendorIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_VENDOR_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getVendorIdentifier() {
    return vendorIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendorIdentifier(String vendorIdentifier) {
    this.vendorIdentifier = vendorIdentifier;
  }


  public PayoutAgent vendorName(String vendorName) {
    
    this.vendorName = vendorName;
    return this;
  }

   /**
   * Name of regional acquirer account.
   * @return vendorName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_VENDOR_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getVendorName() {
    return vendorName;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendorName(String vendorName) {
    this.vendorName = vendorName;
  }


  public PayoutAgent vendorTokenKey(String vendorTokenKey) {
    
    this.vendorTokenKey = vendorTokenKey;
    return this;
  }

   /**
   * Key to help load Stripe for the correct region. Could be helpful for other vendors as well.
   * @return vendorTokenKey
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_VENDOR_TOKEN_KEY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getVendorTokenKey() {
    return vendorTokenKey;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR_TOKEN_KEY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendorTokenKey(String vendorTokenKey) {
    this.vendorTokenKey = vendorTokenKey;
  }


  public PayoutAgent identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique system ID.
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public PayoutAgent beneficiaryIdentifier(UUID beneficiaryIdentifier) {
    
    this.beneficiaryIdentifier = beneficiaryIdentifier;
    return this;
  }

   /**
   * Beneficiary ID.
   * @return beneficiaryIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_BENEFICIARY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getBeneficiaryIdentifier() {
    return beneficiaryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BENEFICIARY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBeneficiaryIdentifier(UUID beneficiaryIdentifier) {
    this.beneficiaryIdentifier = beneficiaryIdentifier;
  }


  public PayoutAgent externalPayeeIdentifier(String externalPayeeIdentifier) {
    
    this.externalPayeeIdentifier = externalPayeeIdentifier;
    return this;
  }

   /**
   * This would be the cardholder ID for VCCs.
   * @return externalPayeeIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_EXTERNAL_PAYEE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getExternalPayeeIdentifier() {
    return externalPayeeIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_PAYEE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExternalPayeeIdentifier(String externalPayeeIdentifier) {
    this.externalPayeeIdentifier = externalPayeeIdentifier;
  }


  public PayoutAgent type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of withdrawal.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public PayoutAgent entry(CustomMonetaryAmount entry) {
    
    this.entry = entry;
    return this;
  }

   /**
   * Get entry
   * @return entry
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ENTRY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getEntry() {
    return entry;
  }


  @JsonProperty(JSON_PROPERTY_ENTRY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEntry(CustomMonetaryAmount entry) {
    this.entry = entry;
  }


  public PayoutAgent fees(List<PayoutFeeAgent> fees) {
    
    this.fees = fees;
    return this;
  }

  public PayoutAgent addFeesItem(PayoutFeeAgent feesItem) {
    if (this.fees == null) {
      this.fees = new ArrayList<>();
    }
    this.fees.add(feesItem);
    return this;
  }

   /**
   * Fees incurred when making the withdrawal.
   * @return fees
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PayoutFeeAgent> getFees() {
    return fees;
  }


  @JsonProperty(JSON_PROPERTY_FEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFees(List<PayoutFeeAgent> fees) {
    this.fees = fees;
  }


  public PayoutAgent created(java.time.LocalDateTime created) {
    
    this.created = created;
    return this;
  }

   /**
   * When the payout record was created.
   * @return created
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getCreated() {
    return created;
  }


  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreated(java.time.LocalDateTime created) {
    this.created = created;
  }


  public PayoutAgent description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Textual response from provider
   * @return description
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public PayoutAgent payoutId(String payoutId) {
    
    this.payoutId = payoutId;
    return this;
  }

   /**
   * The identifier that was generated when scheduling the payout. This will come from the payout provider such as Stripe.
   * @return payoutId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PAYOUT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPayoutId() {
    return payoutId;
  }


  @JsonProperty(JSON_PROPERTY_PAYOUT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutId(String payoutId) {
    this.payoutId = payoutId;
  }


  public PayoutAgent referenceCode(String referenceCode) {
    
    this.referenceCode = referenceCode;
    return this;
  }

   /**
   * The transaction code that was generated when the funds move out of TripPay&#39;s account. This will come from the payout provider such as Stripe. E.g. For VCCs, it will occur when an authorization takes place.
   * @return referenceCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REFERENCE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReferenceCode() {
    return referenceCode;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReferenceCode(String referenceCode) {
    this.referenceCode = referenceCode;
  }


  public PayoutAgent referenceCodeDate(java.time.LocalDateTime referenceCodeDate) {
    
    this.referenceCodeDate = referenceCodeDate;
    return this;
  }

   /**
   * The time the funds were withdrawn
   * @return referenceCodeDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REFERENCE_CODE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getReferenceCodeDate() {
    return referenceCodeDate;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCE_CODE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReferenceCodeDate(java.time.LocalDateTime referenceCodeDate) {
    this.referenceCodeDate = referenceCodeDate;
  }


  public PayoutAgent status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Status of withdrawal.
   * @return status
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayoutAgent payoutAgent = (PayoutAgent) o;
    return Objects.equals(this.vendor, payoutAgent.vendor) &&
        Objects.equals(this.vendorIdentifier, payoutAgent.vendorIdentifier) &&
        Objects.equals(this.vendorName, payoutAgent.vendorName) &&
        Objects.equals(this.vendorTokenKey, payoutAgent.vendorTokenKey) &&
        Objects.equals(this.identifier, payoutAgent.identifier) &&
        Objects.equals(this.beneficiaryIdentifier, payoutAgent.beneficiaryIdentifier) &&
        Objects.equals(this.externalPayeeIdentifier, payoutAgent.externalPayeeIdentifier) &&
        Objects.equals(this.type, payoutAgent.type) &&
        Objects.equals(this.entry, payoutAgent.entry) &&
        Objects.equals(this.fees, payoutAgent.fees) &&
        Objects.equals(this.created, payoutAgent.created) &&
        Objects.equals(this.description, payoutAgent.description) &&
        Objects.equals(this.payoutId, payoutAgent.payoutId) &&
        Objects.equals(this.referenceCode, payoutAgent.referenceCode) &&
        Objects.equals(this.referenceCodeDate, payoutAgent.referenceCodeDate) &&
        Objects.equals(this.status, payoutAgent.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(vendor, vendorIdentifier, vendorName, vendorTokenKey, identifier, beneficiaryIdentifier, externalPayeeIdentifier, type, entry, fees, created, description, payoutId, referenceCode, referenceCodeDate, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayoutAgent {\n");
    sb.append("    vendor: ").append(toIndentedString(vendor)).append("\n");
    sb.append("    vendorIdentifier: ").append(toIndentedString(vendorIdentifier)).append("\n");
    sb.append("    vendorName: ").append(toIndentedString(vendorName)).append("\n");
    sb.append("    vendorTokenKey: ").append(toIndentedString(vendorTokenKey)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    beneficiaryIdentifier: ").append(toIndentedString(beneficiaryIdentifier)).append("\n");
    sb.append("    externalPayeeIdentifier: ").append(toIndentedString(externalPayeeIdentifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    entry: ").append(toIndentedString(entry)).append("\n");
    sb.append("    fees: ").append(toIndentedString(fees)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    payoutId: ").append(toIndentedString(payoutId)).append("\n");
    sb.append("    referenceCode: ").append(toIndentedString(referenceCode)).append("\n");
    sb.append("    referenceCodeDate: ").append(toIndentedString(referenceCodeDate)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

