/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant payment widget for all other entities.   - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Travel Agent API The Travel Agent API exposes endpoints to manage agent-facilitated bookings. This API lets you:  1. Travel Agent: Manage agent entity. 2. Booking: Create / Manage bookings  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.5.10
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.travel.agent.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import travel.wink.sdk.travel.agent.model.CustomMonetaryAmount;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Refund objects allow you to refund a charge that has previously been created but not yet refunded. Funds will be refunded to the credit or debit card that was originally charged.
 */
@JsonPropertyOrder({
  RefundAgent.JSON_PROPERTY_IDENTIFIER,
  RefundAgent.JSON_PROPERTY_ACQUIRER_REFUND_IDENTIFIER,
  RefundAgent.JSON_PROPERTY_REQUESTED_BY_IDENTIFIER,
  RefundAgent.JSON_PROPERTY_REFUND,
  RefundAgent.JSON_PROPERTY_CREATED,
  RefundAgent.JSON_PROPERTY_DESCRIPTION,
  RefundAgent.JSON_PROPERTY_REASON_TYPE,
  RefundAgent.JSON_PROPERTY_CANCEL_ON_REFUND,
  RefundAgent.JSON_PROPERTY_STATUS_TYPE,
  RefundAgent.JSON_PROPERTY_REQUEST_TYPE,
  RefundAgent.JSON_PROPERTY_REQUEST_STATUS,
  RefundAgent.JSON_PROPERTY_REQUEST_RESPONSE,
  RefundAgent.JSON_PROPERTY_RECEIPT_URL,
  RefundAgent.JSON_PROPERTY_RETRIES,
  RefundAgent.JSON_PROPERTY_ALLOCATION
})
@JsonTypeName("Refund_Agent")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-28T11:55:37.128463507+07:00[Asia/Bangkok]")
public class RefundAgent {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_ACQUIRER_REFUND_IDENTIFIER = "acquirerRefundIdentifier";
  private String acquirerRefundIdentifier;

  public static final String JSON_PROPERTY_REQUESTED_BY_IDENTIFIER = "requestedByIdentifier";
  private String requestedByIdentifier;

  public static final String JSON_PROPERTY_REFUND = "refund";
  private CustomMonetaryAmount refund;

  public static final String JSON_PROPERTY_CREATED = "created";
  private java.time.LocalDateTime created;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  /**
   * A description of the refund that can be displayed to booker
   */
  public enum ReasonTypeEnum {
    DUPLICATE("DUPLICATE"),
    
    FRAUDULENT("FRAUDULENT"),
    
    REQUESTED_BY_CUSTOMER("REQUESTED_BY_CUSTOMER"),
    
    GUEST_COMPLAINT("GUEST_COMPLAINT"),
    
    GUEST_BOOKED_INCORRECT_DATE("GUEST_BOOKED_INCORRECT_DATE"),
    
    GUEST_SICK("GUEST_SICK"),
    
    OVERBOOKING("OVERBOOKING"),
    
    EMERGENCY("EMERGENCY"),
    
    FLIGHT_CANCELLED("FLIGHT_CANCELLED"),
    
    DEATH_IN_FAMILY("DEATH_IN_FAMILY"),
    
    OTHER("OTHER"),
    
    EXPIRED_UNCAPTURED_CHARGE("EXPIRED_UNCAPTURED_CHARGE");

    private String value;

    ReasonTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ReasonTypeEnum fromValue(String value) {
      for (ReasonTypeEnum b : ReasonTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REASON_TYPE = "reasonType";
  private ReasonTypeEnum reasonType;

  /**
   * Whether to cancel the booking alongside requesting a refund.
   */
  public enum CancelOnRefundEnum {
    NONE("NONE"),
    
    CANCEL_ON_SUCCESSFUL_REFUND("CANCEL_ON_SUCCESSFUL_REFUND"),
    
    CANCEL_REGARDLESS("CANCEL_REGARDLESS");

    private String value;

    CancelOnRefundEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancelOnRefundEnum fromValue(String value) {
      for (CancelOnRefundEnum b : CancelOnRefundEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCEL_ON_REFUND = "cancelOnRefund";
  private CancelOnRefundEnum cancelOnRefund;

  /**
   * Status of the refund
   */
  public enum StatusTypeEnum {
    PENDING("PENDING"),
    
    SUCCEEDED("SUCCEEDED"),
    
    CANCELED("CANCELED"),
    
    REQUIRES_ACTION("REQUIRES_ACTION"),
    
    FAILED("FAILED");

    private String value;

    StatusTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusTypeEnum fromValue(String value) {
      for (StatusTypeEnum b : StatusTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS_TYPE = "statusType";
  private StatusTypeEnum statusType;

  /**
   * The entity making the refund request
   */
  public enum RequestTypeEnum {
    SUPPLIER("BY_SUPPLIER"),
    
    ADMIN("BY_ADMIN"),
    
    STRIPE("BY_STRIPE"),
    
    SYSTEM("BY_SYSTEM"),
    
    AGENT("BY_AGENT");

    private String value;

    RequestTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RequestTypeEnum fromValue(String value) {
      for (RequestTypeEnum b : RequestTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REQUEST_TYPE = "requestType";
  private RequestTypeEnum requestType;

  /**
   * Status of the refund request
   */
  public enum RequestStatusEnum {
    PENDING("PENDING"),
    
    APPROVED("APPROVED"),
    
    REJECTED("REJECTED");

    private String value;

    RequestStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RequestStatusEnum fromValue(String value) {
      for (RequestStatusEnum b : RequestStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REQUEST_STATUS = "requestStatus";
  private RequestStatusEnum requestStatus;

  public static final String JSON_PROPERTY_REQUEST_RESPONSE = "requestResponse";
  private String requestResponse;

  public static final String JSON_PROPERTY_RECEIPT_URL = "receiptUrl";
  private String receiptUrl;

  public static final String JSON_PROPERTY_RETRIES = "retries";
  private Integer retries = 0;

  /**
   * The type of refund determines how the funds are deducted each beneficiary.
   */
  public enum AllocationEnum {
    FROM_SALE_ONLY("FROM_SALE_ONLY"),
    
    EQUAL_DISTRIBUTION("EQUAL_DISTRIBUTION"),
    
    CUSTOMERS_ONLY("CUSTOMERS_ONLY");

    private String value;

    AllocationEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AllocationEnum fromValue(String value) {
      for (AllocationEnum b : AllocationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ALLOCATION = "allocation";
  private AllocationEnum allocation = AllocationEnum.EQUAL_DISTRIBUTION;

  public RefundAgent() {
  }

  public RefundAgent identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * A unique identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public RefundAgent acquirerRefundIdentifier(String acquirerRefundIdentifier) {
    
    this.acquirerRefundIdentifier = acquirerRefundIdentifier;
    return this;
  }

   /**
   * The acquirer refund identifier. Will get attached once it comes in on the webhook.
   * @return acquirerRefundIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACQUIRER_REFUND_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAcquirerRefundIdentifier() {
    return acquirerRefundIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACQUIRER_REFUND_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcquirerRefundIdentifier(String acquirerRefundIdentifier) {
    this.acquirerRefundIdentifier = acquirerRefundIdentifier;
  }


  public RefundAgent requestedByIdentifier(String requestedByIdentifier) {
    
    this.requestedByIdentifier = requestedByIdentifier;
    return this;
  }

   /**
   * The SSO person / entity that requested the refund.
   * @return requestedByIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REQUESTED_BY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRequestedByIdentifier() {
    return requestedByIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_REQUESTED_BY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequestedByIdentifier(String requestedByIdentifier) {
    this.requestedByIdentifier = requestedByIdentifier;
  }


  public RefundAgent refund(CustomMonetaryAmount refund) {
    
    this.refund = refund;
    return this;
  }

   /**
   * Get refund
   * @return refund
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_REFUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getRefund() {
    return refund;
  }


  @JsonProperty(JSON_PROPERTY_REFUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRefund(CustomMonetaryAmount refund) {
    this.refund = refund;
  }


  public RefundAgent created(java.time.LocalDateTime created) {
    
    this.created = created;
    return this;
  }

   /**
   * When the amount was refunded
   * @return created
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getCreated() {
    return created;
  }


  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreated(java.time.LocalDateTime created) {
    this.created = created;
  }


  public RefundAgent description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * A description of the refund that can be displayed to booker
   * @return description
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescription(String description) {
    this.description = description;
  }


  public RefundAgent reasonType(ReasonTypeEnum reasonType) {
    
    this.reasonType = reasonType;
    return this;
  }

   /**
   * A description of the refund that can be displayed to booker
   * @return reasonType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_REASON_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ReasonTypeEnum getReasonType() {
    return reasonType;
  }


  @JsonProperty(JSON_PROPERTY_REASON_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setReasonType(ReasonTypeEnum reasonType) {
    this.reasonType = reasonType;
  }


  public RefundAgent cancelOnRefund(CancelOnRefundEnum cancelOnRefund) {
    
    this.cancelOnRefund = cancelOnRefund;
    return this;
  }

   /**
   * Whether to cancel the booking alongside requesting a refund.
   * @return cancelOnRefund
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CANCEL_ON_REFUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CancelOnRefundEnum getCancelOnRefund() {
    return cancelOnRefund;
  }


  @JsonProperty(JSON_PROPERTY_CANCEL_ON_REFUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCancelOnRefund(CancelOnRefundEnum cancelOnRefund) {
    this.cancelOnRefund = cancelOnRefund;
  }


  public RefundAgent statusType(StatusTypeEnum statusType) {
    
    this.statusType = statusType;
    return this;
  }

   /**
   * Status of the refund
   * @return statusType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_STATUS_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusTypeEnum getStatusType() {
    return statusType;
  }


  @JsonProperty(JSON_PROPERTY_STATUS_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatusType(StatusTypeEnum statusType) {
    this.statusType = statusType;
  }


  public RefundAgent requestType(RequestTypeEnum requestType) {
    
    this.requestType = requestType;
    return this;
  }

   /**
   * The entity making the refund request
   * @return requestType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_REQUEST_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RequestTypeEnum getRequestType() {
    return requestType;
  }


  @JsonProperty(JSON_PROPERTY_REQUEST_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRequestType(RequestTypeEnum requestType) {
    this.requestType = requestType;
  }


  public RefundAgent requestStatus(RequestStatusEnum requestStatus) {
    
    this.requestStatus = requestStatus;
    return this;
  }

   /**
   * Status of the refund request
   * @return requestStatus
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_REQUEST_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RequestStatusEnum getRequestStatus() {
    return requestStatus;
  }


  @JsonProperty(JSON_PROPERTY_REQUEST_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRequestStatus(RequestStatusEnum requestStatus) {
    this.requestStatus = requestStatus;
  }


  public RefundAgent requestResponse(String requestResponse) {
    
    this.requestResponse = requestResponse;
    return this;
  }

   /**
   * Admin may choose to respond to the refund request made by the hotel
   * @return requestResponse
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_REQUEST_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRequestResponse() {
    return requestResponse;
  }


  @JsonProperty(JSON_PROPERTY_REQUEST_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRequestResponse(String requestResponse) {
    this.requestResponse = requestResponse;
  }


  public RefundAgent receiptUrl(String receiptUrl) {
    
    this.receiptUrl = receiptUrl;
    return this;
  }

   /**
   * This is the receipt url that contains a friendly web confirmation page. Comes in on the webhook.
   * @return receiptUrl
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RECEIPT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReceiptUrl() {
    return receiptUrl;
  }


  @JsonProperty(JSON_PROPERTY_RECEIPT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReceiptUrl(String receiptUrl) {
    this.receiptUrl = receiptUrl;
  }


  public RefundAgent retries(Integer retries) {
    
    this.retries = retries;
    return this;
  }

   /**
   * In case a TripPay admin has to go in and re-send the refund request to Stripe, we want to not to the same calculations again when a retry is executed so we keep track of retries here.
   * @return retries
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RETRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRetries() {
    return retries;
  }


  @JsonProperty(JSON_PROPERTY_RETRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRetries(Integer retries) {
    this.retries = retries;
  }


  public RefundAgent allocation(AllocationEnum allocation) {
    
    this.allocation = allocation;
    return this;
  }

   /**
   * The type of refund determines how the funds are deducted each beneficiary.
   * @return allocation
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ALLOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AllocationEnum getAllocation() {
    return allocation;
  }


  @JsonProperty(JSON_PROPERTY_ALLOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllocation(AllocationEnum allocation) {
    this.allocation = allocation;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RefundAgent refundAgent = (RefundAgent) o;
    return Objects.equals(this.identifier, refundAgent.identifier) &&
        Objects.equals(this.acquirerRefundIdentifier, refundAgent.acquirerRefundIdentifier) &&
        Objects.equals(this.requestedByIdentifier, refundAgent.requestedByIdentifier) &&
        Objects.equals(this.refund, refundAgent.refund) &&
        Objects.equals(this.created, refundAgent.created) &&
        Objects.equals(this.description, refundAgent.description) &&
        Objects.equals(this.reasonType, refundAgent.reasonType) &&
        Objects.equals(this.cancelOnRefund, refundAgent.cancelOnRefund) &&
        Objects.equals(this.statusType, refundAgent.statusType) &&
        Objects.equals(this.requestType, refundAgent.requestType) &&
        Objects.equals(this.requestStatus, refundAgent.requestStatus) &&
        Objects.equals(this.requestResponse, refundAgent.requestResponse) &&
        Objects.equals(this.receiptUrl, refundAgent.receiptUrl) &&
        Objects.equals(this.retries, refundAgent.retries) &&
        Objects.equals(this.allocation, refundAgent.allocation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, acquirerRefundIdentifier, requestedByIdentifier, refund, created, description, reasonType, cancelOnRefund, statusType, requestType, requestStatus, requestResponse, receiptUrl, retries, allocation);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RefundAgent {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    acquirerRefundIdentifier: ").append(toIndentedString(acquirerRefundIdentifier)).append("\n");
    sb.append("    requestedByIdentifier: ").append(toIndentedString(requestedByIdentifier)).append("\n");
    sb.append("    refund: ").append(toIndentedString(refund)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    reasonType: ").append(toIndentedString(reasonType)).append("\n");
    sb.append("    cancelOnRefund: ").append(toIndentedString(cancelOnRefund)).append("\n");
    sb.append("    statusType: ").append(toIndentedString(statusType)).append("\n");
    sb.append("    requestType: ").append(toIndentedString(requestType)).append("\n");
    sb.append("    requestStatus: ").append(toIndentedString(requestStatus)).append("\n");
    sb.append("    requestResponse: ").append(toIndentedString(requestResponse)).append("\n");
    sb.append("    receiptUrl: ").append(toIndentedString(receiptUrl)).append("\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("    allocation: ").append(toIndentedString(allocation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

