/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.travel.agent.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.travel.agent.model.AncillaryRequestAgent;
import travel.wink.sdk.travel.agent.model.BookingUserRequestAgent;
import travel.wink.sdk.travel.agent.model.FeeAgent;
import travel.wink.sdk.travel.agent.model.RoomConfigurationAgent;

@JsonPropertyOrder(value={"hotelIdentifier", "startDate", "endDate", "roomConfiguration", "promotionalCodes", "roomRateIdentifier", "bedroomConfigurationIdentifier", "ancillaries", "specialRequests", "user", "externalSupplierBookingCode", "externalTransactionIdentifier", "externalCustomerIdentifier", "externalFees", "vendorSpecific", "validUser"})
@JsonTypeName(value="AgentBookingRequest_Agent")
public class AgentBookingRequestAgent {
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;
    public static final String JSON_PROPERTY_ROOM_CONFIGURATION = "roomConfiguration";
    private RoomConfigurationAgent roomConfiguration;
    public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
    private List<String> promotionalCodes;
    public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
    private UUID roomRateIdentifier;
    public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION_IDENTIFIER = "bedroomConfigurationIdentifier";
    private String bedroomConfigurationIdentifier;
    public static final String JSON_PROPERTY_ANCILLARIES = "ancillaries";
    private List<AncillaryRequestAgent> ancillaries;
    public static final String JSON_PROPERTY_SPECIAL_REQUESTS = "specialRequests";
    private String specialRequests;
    public static final String JSON_PROPERTY_USER = "user";
    private BookingUserRequestAgent user;
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
    private String externalSupplierBookingCode;
    public static final String JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER = "externalTransactionIdentifier";
    private String externalTransactionIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_CUSTOMER_IDENTIFIER = "externalCustomerIdentifier";
    private String externalCustomerIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_FEES = "externalFees";
    private List<FeeAgent> externalFees;
    public static final String JSON_PROPERTY_VENDOR_SPECIFIC = "vendorSpecific";
    private Map<String, String> vendorSpecific = new HashMap<String, String>();
    public static final String JSON_PROPERTY_VALID_USER = "validUser";
    private Boolean validUser;

    public AgentBookingRequestAgent hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public AgentBookingRequestAgent startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public AgentBookingRequestAgent endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public AgentBookingRequestAgent roomConfiguration(RoomConfigurationAgent roomConfiguration) {
        this.roomConfiguration = roomConfiguration;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="roomConfiguration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RoomConfigurationAgent getRoomConfiguration() {
        return this.roomConfiguration;
    }

    @JsonProperty(value="roomConfiguration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomConfiguration(RoomConfigurationAgent roomConfiguration) {
        this.roomConfiguration = roomConfiguration;
    }

    public AgentBookingRequestAgent promotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
        return this;
    }

    public AgentBookingRequestAgent addPromotionalCodesItem(String promotionalCodesItem) {
        if (this.promotionalCodes == null) {
            this.promotionalCodes = new ArrayList<String>();
        }
        this.promotionalCodes.add(promotionalCodesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPromotionalCodes() {
        return this.promotionalCodes;
    }

    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
    }

    public AgentBookingRequestAgent roomRateIdentifier(UUID roomRateIdentifier) {
        this.roomRateIdentifier = roomRateIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="roomRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getRoomRateIdentifier() {
        return this.roomRateIdentifier;
    }

    @JsonProperty(value="roomRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomRateIdentifier(UUID roomRateIdentifier) {
        this.roomRateIdentifier = roomRateIdentifier;
    }

    public AgentBookingRequestAgent bedroomConfigurationIdentifier(String bedroomConfigurationIdentifier) {
        this.bedroomConfigurationIdentifier = bedroomConfigurationIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="bedroomConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBedroomConfigurationIdentifier() {
        return this.bedroomConfigurationIdentifier;
    }

    @JsonProperty(value="bedroomConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBedroomConfigurationIdentifier(String bedroomConfigurationIdentifier) {
        this.bedroomConfigurationIdentifier = bedroomConfigurationIdentifier;
    }

    public AgentBookingRequestAgent ancillaries(List<AncillaryRequestAgent> ancillaries) {
        this.ancillaries = ancillaries;
        return this;
    }

    public AgentBookingRequestAgent addAncillariesItem(AncillaryRequestAgent ancillariesItem) {
        if (this.ancillaries == null) {
            this.ancillaries = new ArrayList<AncillaryRequestAgent>();
        }
        this.ancillaries.add(ancillariesItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="ancillaries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AncillaryRequestAgent> getAncillaries() {
        return this.ancillaries;
    }

    @JsonProperty(value="ancillaries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAncillaries(List<AncillaryRequestAgent> ancillaries) {
        this.ancillaries = ancillaries;
    }

    public AgentBookingRequestAgent specialRequests(String specialRequests) {
        this.specialRequests = specialRequests;
        return this;
    }

    @Nullable
    @JsonProperty(value="specialRequests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSpecialRequests() {
        return this.specialRequests;
    }

    @JsonProperty(value="specialRequests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSpecialRequests(String specialRequests) {
        this.specialRequests = specialRequests;
    }

    public AgentBookingRequestAgent user(BookingUserRequestAgent user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BookingUserRequestAgent getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(BookingUserRequestAgent user) {
        this.user = user;
    }

    public AgentBookingRequestAgent externalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalSupplierBookingCode() {
        return this.externalSupplierBookingCode;
    }

    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
    }

    public AgentBookingRequestAgent externalTransactionIdentifier(String externalTransactionIdentifier) {
        this.externalTransactionIdentifier = externalTransactionIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalTransactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalTransactionIdentifier() {
        return this.externalTransactionIdentifier;
    }

    @JsonProperty(value="externalTransactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalTransactionIdentifier(String externalTransactionIdentifier) {
        this.externalTransactionIdentifier = externalTransactionIdentifier;
    }

    public AgentBookingRequestAgent externalCustomerIdentifier(String externalCustomerIdentifier) {
        this.externalCustomerIdentifier = externalCustomerIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalCustomerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalCustomerIdentifier() {
        return this.externalCustomerIdentifier;
    }

    @JsonProperty(value="externalCustomerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalCustomerIdentifier(String externalCustomerIdentifier) {
        this.externalCustomerIdentifier = externalCustomerIdentifier;
    }

    public AgentBookingRequestAgent externalFees(List<FeeAgent> externalFees) {
        this.externalFees = externalFees;
        return this;
    }

    public AgentBookingRequestAgent addExternalFeesItem(FeeAgent externalFeesItem) {
        if (this.externalFees == null) {
            this.externalFees = new ArrayList<FeeAgent>();
        }
        this.externalFees.add(externalFeesItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="externalFees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FeeAgent> getExternalFees() {
        return this.externalFees;
    }

    @JsonProperty(value="externalFees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalFees(List<FeeAgent> externalFees) {
        this.externalFees = externalFees;
    }

    public AgentBookingRequestAgent vendorSpecific(Map<String, String> vendorSpecific) {
        this.vendorSpecific = vendorSpecific;
        return this;
    }

    public AgentBookingRequestAgent putVendorSpecificItem(String key, String vendorSpecificItem) {
        if (this.vendorSpecific == null) {
            this.vendorSpecific = new HashMap<String, String>();
        }
        this.vendorSpecific.put(key, vendorSpecificItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="vendorSpecific")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getVendorSpecific() {
        return this.vendorSpecific;
    }

    @JsonProperty(value="vendorSpecific")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVendorSpecific(Map<String, String> vendorSpecific) {
        this.vendorSpecific = vendorSpecific;
    }

    public AgentBookingRequestAgent validUser(Boolean validUser) {
        this.validUser = validUser;
        return this;
    }

    @Nullable
    @JsonProperty(value="validUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getValidUser() {
        return this.validUser;
    }

    @JsonProperty(value="validUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValidUser(Boolean validUser) {
        this.validUser = validUser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentBookingRequestAgent agentBookingRequestAgent = (AgentBookingRequestAgent)o;
        return Objects.equals(this.hotelIdentifier, agentBookingRequestAgent.hotelIdentifier) && Objects.equals(this.startDate, agentBookingRequestAgent.startDate) && Objects.equals(this.endDate, agentBookingRequestAgent.endDate) && Objects.equals(this.roomConfiguration, agentBookingRequestAgent.roomConfiguration) && Objects.equals(this.promotionalCodes, agentBookingRequestAgent.promotionalCodes) && Objects.equals(this.roomRateIdentifier, agentBookingRequestAgent.roomRateIdentifier) && Objects.equals(this.bedroomConfigurationIdentifier, agentBookingRequestAgent.bedroomConfigurationIdentifier) && Objects.equals(this.ancillaries, agentBookingRequestAgent.ancillaries) && Objects.equals(this.specialRequests, agentBookingRequestAgent.specialRequests) && Objects.equals(this.user, agentBookingRequestAgent.user) && Objects.equals(this.externalSupplierBookingCode, agentBookingRequestAgent.externalSupplierBookingCode) && Objects.equals(this.externalTransactionIdentifier, agentBookingRequestAgent.externalTransactionIdentifier) && Objects.equals(this.externalCustomerIdentifier, agentBookingRequestAgent.externalCustomerIdentifier) && Objects.equals(this.externalFees, agentBookingRequestAgent.externalFees) && Objects.equals(this.vendorSpecific, agentBookingRequestAgent.vendorSpecific) && Objects.equals(this.validUser, agentBookingRequestAgent.validUser);
    }

    public int hashCode() {
        return Objects.hash(this.hotelIdentifier, this.startDate, this.endDate, this.roomConfiguration, this.promotionalCodes, this.roomRateIdentifier, this.bedroomConfigurationIdentifier, this.ancillaries, this.specialRequests, this.user, this.externalSupplierBookingCode, this.externalTransactionIdentifier, this.externalCustomerIdentifier, this.externalFees, this.vendorSpecific, this.validUser);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgentBookingRequestAgent {\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    roomConfiguration: ").append(this.toIndentedString(this.roomConfiguration)).append("\n");
        sb.append("    promotionalCodes: ").append(this.toIndentedString(this.promotionalCodes)).append("\n");
        sb.append("    roomRateIdentifier: ").append(this.toIndentedString(this.roomRateIdentifier)).append("\n");
        sb.append("    bedroomConfigurationIdentifier: ").append(this.toIndentedString(this.bedroomConfigurationIdentifier)).append("\n");
        sb.append("    ancillaries: ").append(this.toIndentedString(this.ancillaries)).append("\n");
        sb.append("    specialRequests: ").append(this.toIndentedString(this.specialRequests)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    externalSupplierBookingCode: ").append(this.toIndentedString(this.externalSupplierBookingCode)).append("\n");
        sb.append("    externalTransactionIdentifier: ").append(this.toIndentedString(this.externalTransactionIdentifier)).append("\n");
        sb.append("    externalCustomerIdentifier: ").append(this.toIndentedString(this.externalCustomerIdentifier)).append("\n");
        sb.append("    externalFees: ").append(this.toIndentedString(this.externalFees)).append("\n");
        sb.append("    vendorSpecific: ").append(this.toIndentedString(this.vendorSpecific)).append("\n");
        sb.append("    validUser: ").append(this.toIndentedString(this.validUser)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

