package travel.wink.sdk.travel.agent.api;

import travel.wink.sdk.travel.agent.invoker.ApiClient;

import travel.wink.sdk.travel.agent.model.BookingConfirmationsAgent;
import travel.wink.sdk.travel.agent.model.BookingViewAgent;
import travel.wink.sdk.travel.agent.model.BooleanResponseAgent;
import travel.wink.sdk.travel.agent.model.CancellationDetailAgent;
import travel.wink.sdk.travel.agent.model.CompanyViewAgent;
import travel.wink.sdk.travel.agent.model.CreateAgentBooking400Response;
import travel.wink.sdk.travel.agent.model.CreateAgentBookingRequestAgent;
import travel.wink.sdk.travel.agent.model.GenericErrorMessage;
import travel.wink.sdk.travel.agent.model.PageBookingViewAgent;
import travel.wink.sdk.travel.agent.model.StateAgent;
import travel.wink.sdk.travel.agent.model.UpsertTravelAgentRequestAgent;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-12-27T09:39:31.477717564+07:00[Asia/Bangkok]")
public class TravelAgentApi {
    private ApiClient apiClient;

    public TravelAgentApi() {
        this(new ApiClient());
    }

    @Autowired
    public TravelAgentApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Cancel Booking
     * Cancel a booking by its booking identifier
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Cancel booking owned by company identifier
     * @param bookingIdentifier Cancel booking by identifier
     * @param cancellationDetailAgent The cancellationDetailAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingViewAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec cancelBookingAsTravelAgentRequestCreation(String companyIdentifier, String bookingIdentifier, CancellationDetailAgent cancellationDetailAgent, String winkVersion) throws WebClientResponseException {
        Object postBody = cancellationDetailAgent;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling cancelBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling cancelBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationDetailAgent' is set
        if (cancellationDetailAgent == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationDetailAgent' when calling cancelBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingViewAgent> localVarReturnType = new ParameterizedTypeReference<BookingViewAgent>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/booking/{bookingIdentifier}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Cancel Booking
     * Cancel a booking by its booking identifier
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Cancel booking owned by company identifier
     * @param bookingIdentifier Cancel booking by identifier
     * @param cancellationDetailAgent The cancellationDetailAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingViewAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingViewAgent> cancelBookingAsTravelAgent(String companyIdentifier, String bookingIdentifier, CancellationDetailAgent cancellationDetailAgent, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewAgent> localVarReturnType = new ParameterizedTypeReference<BookingViewAgent>() {};
        return cancelBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, cancellationDetailAgent, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Cancel Booking
     * Cancel a booking by its booking identifier
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Cancel booking owned by company identifier
     * @param bookingIdentifier Cancel booking by identifier
     * @param cancellationDetailAgent The cancellationDetailAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingViewAgent&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingViewAgent>> cancelBookingAsTravelAgentWithHttpInfo(String companyIdentifier, String bookingIdentifier, CancellationDetailAgent cancellationDetailAgent, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewAgent> localVarReturnType = new ParameterizedTypeReference<BookingViewAgent>() {};
        return cancelBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, cancellationDetailAgent, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Cancel Booking
     * Cancel a booking by its booking identifier
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Cancel booking owned by company identifier
     * @param bookingIdentifier Cancel booking by identifier
     * @param cancellationDetailAgent The cancellationDetailAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec cancelBookingAsTravelAgentWithResponseSpec(String companyIdentifier, String bookingIdentifier, CancellationDetailAgent cancellationDetailAgent, String winkVersion) throws WebClientResponseException {
        return cancelBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, cancellationDetailAgent, winkVersion);
    }
    /**
     * Create Agent Booking
     * Create agent booking. Expects the agent to be a registered agent with TripPay and have available funds to cover the booking amount.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param createAgentBookingRequestAgent The createAgentBookingRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingConfirmationsAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAgentBookingRequestCreation(CreateAgentBookingRequestAgent createAgentBookingRequestAgent, String winkVersion) throws WebClientResponseException {
        Object postBody = createAgentBookingRequestAgent;
        // verify the required parameter 'createAgentBookingRequestAgent' is set
        if (createAgentBookingRequestAgent == null) {
            throw new WebClientResponseException("Missing the required parameter 'createAgentBookingRequestAgent' when calling createAgentBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingConfirmationsAgent> localVarReturnType = new ParameterizedTypeReference<BookingConfirmationsAgent>() {};
        return apiClient.invokeAPI("/api/booking/agent", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Agent Booking
     * Create agent booking. Expects the agent to be a registered agent with TripPay and have available funds to cover the booking amount.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param createAgentBookingRequestAgent The createAgentBookingRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingConfirmationsAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingConfirmationsAgent> createAgentBooking(CreateAgentBookingRequestAgent createAgentBookingRequestAgent, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingConfirmationsAgent> localVarReturnType = new ParameterizedTypeReference<BookingConfirmationsAgent>() {};
        return createAgentBookingRequestCreation(createAgentBookingRequestAgent, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Agent Booking
     * Create agent booking. Expects the agent to be a registered agent with TripPay and have available funds to cover the booking amount.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param createAgentBookingRequestAgent The createAgentBookingRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingConfirmationsAgent&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingConfirmationsAgent>> createAgentBookingWithHttpInfo(CreateAgentBookingRequestAgent createAgentBookingRequestAgent, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingConfirmationsAgent> localVarReturnType = new ParameterizedTypeReference<BookingConfirmationsAgent>() {};
        return createAgentBookingRequestCreation(createAgentBookingRequestAgent, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Agent Booking
     * Create agent booking. Expects the agent to be a registered agent with TripPay and have available funds to cover the booking amount.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param createAgentBookingRequestAgent The createAgentBookingRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createAgentBookingWithResponseSpec(CreateAgentBookingRequestAgent createAgentBookingRequestAgent, String winkVersion) throws WebClientResponseException {
        return createAgentBookingRequestCreation(createAgentBookingRequestAgent, winkVersion);
    }
    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Resend booking owned by company identifier
     * @param bookingIdentifier Resend booking by identifier
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponseAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec resendBookingConfirmationEmailAsTravelAgentRequestCreation(String companyIdentifier, String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        Object postBody = body;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling resendBookingConfirmationEmailAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling resendBookingConfirmationEmailAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new WebClientResponseException("Missing the required parameter 'body' when calling resendBookingConfirmationEmailAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BooleanResponseAgent> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAgent>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/booking/{bookingIdentifier}/resend", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Resend booking owned by company identifier
     * @param bookingIdentifier Resend booking by identifier
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponseAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BooleanResponseAgent> resendBookingConfirmationEmailAsTravelAgent(String companyIdentifier, String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAgent> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAgent>() {};
        return resendBookingConfirmationEmailAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, body, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Resend booking owned by company identifier
     * @param bookingIdentifier Resend booking by identifier
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BooleanResponseAgent&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BooleanResponseAgent>> resendBookingConfirmationEmailAsTravelAgentWithHttpInfo(String companyIdentifier, String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAgent> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAgent>() {};
        return resendBookingConfirmationEmailAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, body, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Resend booking owned by company identifier
     * @param bookingIdentifier Resend booking by identifier
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec resendBookingConfirmationEmailAsTravelAgentWithResponseSpec(String companyIdentifier, String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        return resendBookingConfirmationEmailAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, body, winkVersion);
    }
    /**
     * Show Booking
     * Show a booking record by its identifier.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking for company identifier
     * @param bookingIdentifier Show booking with booking identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BookingViewAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingAsTravelAgentRequestCreation(String companyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling showBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingViewAgent> localVarReturnType = new ParameterizedTypeReference<BookingViewAgent>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/booking/{bookingIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Booking
     * Show a booking record by its identifier.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking for company identifier
     * @param bookingIdentifier Show booking with booking identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BookingViewAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingViewAgent> showBookingAsTravelAgent(String companyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewAgent> localVarReturnType = new ParameterizedTypeReference<BookingViewAgent>() {};
        return showBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Booking
     * Show a booking record by its identifier.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking for company identifier
     * @param bookingIdentifier Show booking with booking identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;BookingViewAgent&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingViewAgent>> showBookingAsTravelAgentWithHttpInfo(String companyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewAgent> localVarReturnType = new ParameterizedTypeReference<BookingViewAgent>() {};
        return showBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Booking
     * Show a booking record by its identifier.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking for company identifier
     * @param bookingIdentifier Show booking with booking identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBookingAsTravelAgentWithResponseSpec(String companyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, winkVersion, accept);
    }
    /**
     * Show Bookings
     * Show bookings for the company that helped create those booking.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Show bookings for company identifier
     * @param stateAgent The stateAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return PageBookingViewAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingGridAsTravelAgentRequestCreation(String companyIdentifier, StateAgent stateAgent, String winkVersion) throws WebClientResponseException {
        Object postBody = stateAgent;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBookingGridAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'stateAgent' is set
        if (stateAgent == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateAgent' when calling showBookingGridAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageBookingViewAgent> localVarReturnType = new ParameterizedTypeReference<PageBookingViewAgent>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/booking/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Bookings
     * Show bookings for the company that helped create those booking.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Show bookings for company identifier
     * @param stateAgent The stateAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return PageBookingViewAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageBookingViewAgent> showBookingGridAsTravelAgent(String companyIdentifier, StateAgent stateAgent, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewAgent> localVarReturnType = new ParameterizedTypeReference<PageBookingViewAgent>() {};
        return showBookingGridAsTravelAgentRequestCreation(companyIdentifier, stateAgent, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Bookings
     * Show bookings for the company that helped create those booking.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Show bookings for company identifier
     * @param stateAgent The stateAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageBookingViewAgent&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageBookingViewAgent>> showBookingGridAsTravelAgentWithHttpInfo(String companyIdentifier, StateAgent stateAgent, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewAgent> localVarReturnType = new ParameterizedTypeReference<PageBookingViewAgent>() {};
        return showBookingGridAsTravelAgentRequestCreation(companyIdentifier, stateAgent, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Bookings
     * Show bookings for the company that helped create those booking.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Show bookings for company identifier
     * @param stateAgent The stateAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBookingGridAsTravelAgentWithResponseSpec(String companyIdentifier, StateAgent stateAgent, String winkVersion) throws WebClientResponseException {
        return showBookingGridAsTravelAgentRequestCreation(companyIdentifier, stateAgent, winkVersion);
    }
    /**
     * Update Agent
     * Update an existing agent
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Update agent by company id
     * @param upsertTravelAgentRequestAgent The upsertTravelAgentRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAgentRequestCreation(String companyIdentifier, UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertTravelAgentRequestAgent;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertTravelAgentRequestAgent' is set
        if (upsertTravelAgentRequestAgent == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertTravelAgentRequestAgent' when calling updateAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyViewAgent> localVarReturnType = new ParameterizedTypeReference<CompanyViewAgent>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/agent", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Agent
     * Update an existing agent
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Update agent by company id
     * @param upsertTravelAgentRequestAgent The upsertTravelAgentRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompanyViewAgent> updateAgent(String companyIdentifier, UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAgent> localVarReturnType = new ParameterizedTypeReference<CompanyViewAgent>() {};
        return updateAgentRequestCreation(companyIdentifier, upsertTravelAgentRequestAgent, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Agent
     * Update an existing agent
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Update agent by company id
     * @param upsertTravelAgentRequestAgent The upsertTravelAgentRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CompanyViewAgent&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CompanyViewAgent>> updateAgentWithHttpInfo(String companyIdentifier, UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAgent> localVarReturnType = new ParameterizedTypeReference<CompanyViewAgent>() {};
        return updateAgentRequestCreation(companyIdentifier, upsertTravelAgentRequestAgent, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Agent
     * Update an existing agent
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Update agent by company id
     * @param upsertTravelAgentRequestAgent The upsertTravelAgentRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateAgentWithResponseSpec(String companyIdentifier, UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, String winkVersion) throws WebClientResponseException {
        return updateAgentRequestCreation(companyIdentifier, upsertTravelAgentRequestAgent, winkVersion);
    }
}
