/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Travel Agent API The Travel Agent API exposes endpoints to manage agent-facilitated bookings. This API lets you:  1. Travel Agent: Manage agent entity. 2. Booking: Create / Manage bookings  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.14.5
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.travel.agent.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import travel.wink.sdk.travel.agent.model.AncillaryRequestAgent;
import travel.wink.sdk.travel.agent.model.BookingUserRequestAgent;
import travel.wink.sdk.travel.agent.model.FeeAgent;
import travel.wink.sdk.travel.agent.model.RoomConfigurationAgent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * List of room configuration booking requests. Each entry is a separately booked room.
 */
@JsonPropertyOrder({
  AgentBookingRequestAgent.JSON_PROPERTY_HOTEL_IDENTIFIER,
  AgentBookingRequestAgent.JSON_PROPERTY_START_DATE,
  AgentBookingRequestAgent.JSON_PROPERTY_END_DATE,
  AgentBookingRequestAgent.JSON_PROPERTY_NIGHTS,
  AgentBookingRequestAgent.JSON_PROPERTY_ROOM_CONFIGURATION,
  AgentBookingRequestAgent.JSON_PROPERTY_PROMOTIONAL_CODES,
  AgentBookingRequestAgent.JSON_PROPERTY_ROOM_RATE_IDENTIFIER,
  AgentBookingRequestAgent.JSON_PROPERTY_BEDROOM_CONFIGURATION_IDENTIFIER,
  AgentBookingRequestAgent.JSON_PROPERTY_ANCILLARIES,
  AgentBookingRequestAgent.JSON_PROPERTY_SPECIAL_REQUESTS,
  AgentBookingRequestAgent.JSON_PROPERTY_USER,
  AgentBookingRequestAgent.JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE,
  AgentBookingRequestAgent.JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER,
  AgentBookingRequestAgent.JSON_PROPERTY_EXTERNAL_CUSTOMER_IDENTIFIER,
  AgentBookingRequestAgent.JSON_PROPERTY_EXTERNAL_FEES,
  AgentBookingRequestAgent.JSON_PROPERTY_VENDOR_SPECIFIC,
  AgentBookingRequestAgent.JSON_PROPERTY_VALID_USER
})
@JsonTypeName("AgentBookingRequest_Agent")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-03-04T20:50:59.267991942+07:00[Asia/Bangkok]")
public class AgentBookingRequestAgent {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_NIGHTS = "nights";
  private Integer nights;

  public static final String JSON_PROPERTY_ROOM_CONFIGURATION = "roomConfiguration";
  private RoomConfigurationAgent roomConfiguration;

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  private List<String> promotionalCodes;

  public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
  private UUID roomRateIdentifier;

  public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION_IDENTIFIER = "bedroomConfigurationIdentifier";
  private String bedroomConfigurationIdentifier;

  public static final String JSON_PROPERTY_ANCILLARIES = "ancillaries";
  private List<AncillaryRequestAgent> ancillaries;

  public static final String JSON_PROPERTY_SPECIAL_REQUESTS = "specialRequests";
  private String specialRequests;

  public static final String JSON_PROPERTY_USER = "user";
  private BookingUserRequestAgent user;

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
  private String externalSupplierBookingCode;

  public static final String JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER = "externalTransactionIdentifier";
  private String externalTransactionIdentifier;

  public static final String JSON_PROPERTY_EXTERNAL_CUSTOMER_IDENTIFIER = "externalCustomerIdentifier";
  private String externalCustomerIdentifier;

  public static final String JSON_PROPERTY_EXTERNAL_FEES = "externalFees";
  private List<FeeAgent> externalFees;

  public static final String JSON_PROPERTY_VENDOR_SPECIFIC = "vendorSpecific";
  private Map<String, String> vendorSpecific = new HashMap<>();

  public static final String JSON_PROPERTY_VALID_USER = "validUser";
  private Boolean validUser;

  public AgentBookingRequestAgent() {
  }

  public AgentBookingRequestAgent hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Unique hotel record identifier.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public AgentBookingRequestAgent startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Date when guest arrives on the premises.
   * @return startDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public AgentBookingRequestAgent endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Date when guest departs the premises. Optional if nights is specified.
   * @return endDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public AgentBookingRequestAgent nights(Integer nights) {
    
    this.nights = nights;
    return this;
  }

   /**
   * Date when guest departs the premises. Optional if endDate is specified.
   * @return nights
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNights() {
    return nights;
  }


  @JsonProperty(JSON_PROPERTY_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNights(Integer nights) {
    this.nights = nights;
  }


  public AgentBookingRequestAgent roomConfiguration(RoomConfigurationAgent roomConfiguration) {
    
    this.roomConfiguration = roomConfiguration;
    return this;
  }

   /**
   * Get roomConfiguration
   * @return roomConfiguration
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RoomConfigurationAgent getRoomConfiguration() {
    return roomConfiguration;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomConfiguration(RoomConfigurationAgent roomConfiguration) {
    this.roomConfiguration = roomConfiguration;
  }


  public AgentBookingRequestAgent promotionalCodes(List<String> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public AgentBookingRequestAgent addPromotionalCodesItem(String promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

   /**
   * Get promotionalCodes
   * @return promotionalCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(List<String> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }


  public AgentBookingRequestAgent roomRateIdentifier(UUID roomRateIdentifier) {
    
    this.roomRateIdentifier = roomRateIdentifier;
    return this;
  }

   /**
   * The unique master rate that made the guest room / rate plan available for sale.
   * @return roomRateIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getRoomRateIdentifier() {
    return roomRateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateIdentifier(UUID roomRateIdentifier) {
    this.roomRateIdentifier = roomRateIdentifier;
  }


  public AgentBookingRequestAgent bedroomConfigurationIdentifier(String bedroomConfigurationIdentifier) {
    
    this.bedroomConfigurationIdentifier = bedroomConfigurationIdentifier;
    return this;
  }

   /**
   * Guest can optionally request a specific bedroom layout if the room type is set up with multiple layout choices.
   * @return bedroomConfigurationIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBedroomConfigurationIdentifier() {
    return bedroomConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBedroomConfigurationIdentifier(String bedroomConfigurationIdentifier) {
    this.bedroomConfigurationIdentifier = bedroomConfigurationIdentifier;
  }


  public AgentBookingRequestAgent ancillaries(List<AncillaryRequestAgent> ancillaries) {
    
    this.ancillaries = ancillaries;
    return this;
  }

  public AgentBookingRequestAgent addAncillariesItem(AncillaryRequestAgent ancillariesItem) {
    if (this.ancillaries == null) {
      this.ancillaries = new ArrayList<>();
    }
    this.ancillaries.add(ancillariesItem);
    return this;
  }

   /**
   * Get ancillaries
   * @return ancillaries
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AncillaryRequestAgent> getAncillaries() {
    return ancillaries;
  }


  @JsonProperty(JSON_PROPERTY_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAncillaries(List<AncillaryRequestAgent> ancillaries) {
    this.ancillaries = ancillaries;
  }


  public AgentBookingRequestAgent specialRequests(String specialRequests) {
    
    this.specialRequests = specialRequests;
    return this;
  }

   /**
   * A guest can send a special request to the hotel in free-text here.
   * @return specialRequests
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SPECIAL_REQUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSpecialRequests() {
    return specialRequests;
  }


  @JsonProperty(JSON_PROPERTY_SPECIAL_REQUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpecialRequests(String specialRequests) {
    this.specialRequests = specialRequests;
  }


  public AgentBookingRequestAgent user(BookingUserRequestAgent user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUserRequestAgent getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(BookingUserRequestAgent user) {
    this.user = user;
  }


  public AgentBookingRequestAgent externalSupplierBookingCode(String externalSupplierBookingCode) {
    
    this.externalSupplierBookingCode = externalSupplierBookingCode;
    return this;
  }

   /**
   * External booking code generated by the affiliate
   * @return externalSupplierBookingCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierBookingCode() {
    return externalSupplierBookingCode;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
    this.externalSupplierBookingCode = externalSupplierBookingCode;
  }


  public AgentBookingRequestAgent externalTransactionIdentifier(String externalTransactionIdentifier) {
    
    this.externalTransactionIdentifier = externalTransactionIdentifier;
    return this;
  }

   /**
   * External transaction identifier
   * @return externalTransactionIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalTransactionIdentifier() {
    return externalTransactionIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalTransactionIdentifier(String externalTransactionIdentifier) {
    this.externalTransactionIdentifier = externalTransactionIdentifier;
  }


  public AgentBookingRequestAgent externalCustomerIdentifier(String externalCustomerIdentifier) {
    
    this.externalCustomerIdentifier = externalCustomerIdentifier;
    return this;
  }

   /**
   * External customer identifier
   * @return externalCustomerIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_CUSTOMER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalCustomerIdentifier() {
    return externalCustomerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_CUSTOMER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalCustomerIdentifier(String externalCustomerIdentifier) {
    this.externalCustomerIdentifier = externalCustomerIdentifier;
  }


  public AgentBookingRequestAgent externalFees(List<FeeAgent> externalFees) {
    
    this.externalFees = externalFees;
    return this;
  }

  public AgentBookingRequestAgent addExternalFeesItem(FeeAgent externalFeesItem) {
    if (this.externalFees == null) {
      this.externalFees = new ArrayList<>();
    }
    this.externalFees.add(externalFeesItem);
    return this;
  }

   /**
   * Get externalFees
   * @return externalFees
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_EXTERNAL_FEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<FeeAgent> getExternalFees() {
    return externalFees;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_FEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalFees(List<FeeAgent> externalFees) {
    this.externalFees = externalFees;
  }


  public AgentBookingRequestAgent vendorSpecific(Map<String, String> vendorSpecific) {
    
    this.vendorSpecific = vendorSpecific;
    return this;
  }

  public AgentBookingRequestAgent putVendorSpecificItem(String key, String vendorSpecificItem) {
    if (this.vendorSpecific == null) {
      this.vendorSpecific = new HashMap<>();
    }
    this.vendorSpecific.put(key, vendorSpecificItem);
    return this;
  }

   /**
   * External metadata
   * @return vendorSpecific
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VENDOR_SPECIFIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getVendorSpecific() {
    return vendorSpecific;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR_SPECIFIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVendorSpecific(Map<String, String> vendorSpecific) {
    this.vendorSpecific = vendorSpecific;
  }


  public AgentBookingRequestAgent validUser(Boolean validUser) {
    
    this.validUser = validUser;
    return this;
  }

   /**
   * Get validUser
   * @return validUser
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VALID_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getValidUser() {
    return validUser;
  }


  @JsonProperty(JSON_PROPERTY_VALID_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValidUser(Boolean validUser) {
    this.validUser = validUser;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AgentBookingRequestAgent agentBookingRequestAgent = (AgentBookingRequestAgent) o;
    return Objects.equals(this.hotelIdentifier, agentBookingRequestAgent.hotelIdentifier) &&
        Objects.equals(this.startDate, agentBookingRequestAgent.startDate) &&
        Objects.equals(this.endDate, agentBookingRequestAgent.endDate) &&
        Objects.equals(this.nights, agentBookingRequestAgent.nights) &&
        Objects.equals(this.roomConfiguration, agentBookingRequestAgent.roomConfiguration) &&
        Objects.equals(this.promotionalCodes, agentBookingRequestAgent.promotionalCodes) &&
        Objects.equals(this.roomRateIdentifier, agentBookingRequestAgent.roomRateIdentifier) &&
        Objects.equals(this.bedroomConfigurationIdentifier, agentBookingRequestAgent.bedroomConfigurationIdentifier) &&
        Objects.equals(this.ancillaries, agentBookingRequestAgent.ancillaries) &&
        Objects.equals(this.specialRequests, agentBookingRequestAgent.specialRequests) &&
        Objects.equals(this.user, agentBookingRequestAgent.user) &&
        Objects.equals(this.externalSupplierBookingCode, agentBookingRequestAgent.externalSupplierBookingCode) &&
        Objects.equals(this.externalTransactionIdentifier, agentBookingRequestAgent.externalTransactionIdentifier) &&
        Objects.equals(this.externalCustomerIdentifier, agentBookingRequestAgent.externalCustomerIdentifier) &&
        Objects.equals(this.externalFees, agentBookingRequestAgent.externalFees) &&
        Objects.equals(this.vendorSpecific, agentBookingRequestAgent.vendorSpecific) &&
        Objects.equals(this.validUser, agentBookingRequestAgent.validUser);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, startDate, endDate, nights, roomConfiguration, promotionalCodes, roomRateIdentifier, bedroomConfigurationIdentifier, ancillaries, specialRequests, user, externalSupplierBookingCode, externalTransactionIdentifier, externalCustomerIdentifier, externalFees, vendorSpecific, validUser);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AgentBookingRequestAgent {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    nights: ").append(toIndentedString(nights)).append("\n");
    sb.append("    roomConfiguration: ").append(toIndentedString(roomConfiguration)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    roomRateIdentifier: ").append(toIndentedString(roomRateIdentifier)).append("\n");
    sb.append("    bedroomConfigurationIdentifier: ").append(toIndentedString(bedroomConfigurationIdentifier)).append("\n");
    sb.append("    ancillaries: ").append(toIndentedString(ancillaries)).append("\n");
    sb.append("    specialRequests: ").append(toIndentedString(specialRequests)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    externalSupplierBookingCode: ").append(toIndentedString(externalSupplierBookingCode)).append("\n");
    sb.append("    externalTransactionIdentifier: ").append(toIndentedString(externalTransactionIdentifier)).append("\n");
    sb.append("    externalCustomerIdentifier: ").append(toIndentedString(externalCustomerIdentifier)).append("\n");
    sb.append("    externalFees: ").append(toIndentedString(externalFees)).append("\n");
    sb.append("    vendorSpecific: ").append(toIndentedString(vendorSpecific)).append("\n");
    sb.append("    validUser: ").append(toIndentedString(validUser)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

