/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Travel Agent API The Travel Agent API exposes endpoints to manage agent-facilitated bookings. This API lets you:  1. Travel Agent: Manage agent entity. 2. Booking: Create / Manage bookings  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.14.5
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.travel.agent.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.travel.agent.model.CustomMonetaryAmount;
import travel.wink.sdk.travel.agent.model.LocalizedDescriptionAgent;
import travel.wink.sdk.travel.agent.model.QuoteAgent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Price details
 */
@JsonPropertyOrder({
  StayRateAgent.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL,
  StayRateAgent.JSON_PROPERTY_SOURCE_BASE_TOTAL,
  StayRateAgent.JSON_PROPERTY_INTERNAL_BASE_TOTAL,
  StayRateAgent.JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER,
  StayRateAgent.JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER,
  StayRateAgent.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER,
  StayRateAgent.JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER,
  StayRateAgent.JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER,
  StayRateAgent.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER,
  StayRateAgent.JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER,
  StayRateAgent.JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER,
  StayRateAgent.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER,
  StayRateAgent.JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER,
  StayRateAgent.JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER,
  StayRateAgent.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER,
  StayRateAgent.JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER,
  StayRateAgent.JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER,
  StayRateAgent.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER,
  StayRateAgent.JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER,
  StayRateAgent.JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER,
  StayRateAgent.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER,
  StayRateAgent.JSON_PROPERTY_QUANTITY,
  StayRateAgent.JSON_PROPERTY_MIN_OCCUPANCY,
  StayRateAgent.JSON_PROPERTY_MAX_OCCUPANCY,
  StayRateAgent.JSON_PROPERTY_RATE_SOURCE,
  StayRateAgent.JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT,
  StayRateAgent.JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT,
  StayRateAgent.JSON_PROPERTY_PREMIUM_PERCENT,
  StayRateAgent.JSON_PROPERTY_AVAILABLE,
  StayRateAgent.JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE,
  StayRateAgent.JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE,
  StayRateAgent.JSON_PROPERTY_OFFER_DETAILS,
  StayRateAgent.JSON_PROPERTY_PROMOTIONAL_CODES,
  StayRateAgent.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL,
  StayRateAgent.JSON_PROPERTY_SOURCE_TOTAL,
  StayRateAgent.JSON_PROPERTY_INTERNAL_TOTAL,
  StayRateAgent.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_AVERAGE_PRICE_PER_NIGHT,
  StayRateAgent.JSON_PROPERTY_INTERNAL_AVERAGE_PRICE_PER_NIGHT,
  StayRateAgent.JSON_PROPERTY_SOURCE_AVERAGE_PRICE_PER_NIGHT,
  StayRateAgent.JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT
})
@JsonTypeName("StayRate_Agent")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-03-04T20:50:59.267991942+07:00[Asia/Bangkok]")
public class StayRateAgent {
  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL = "userSpecifiedCurrencyBaseTotal";
  private CustomMonetaryAmount userSpecifiedCurrencyBaseTotal;

  public static final String JSON_PROPERTY_SOURCE_BASE_TOTAL = "sourceBaseTotal";
  private CustomMonetaryAmount sourceBaseTotal;

  public static final String JSON_PROPERTY_INTERNAL_BASE_TOTAL = "internalBaseTotal";
  private CustomMonetaryAmount internalBaseTotal;

  public static final String JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER = "sourceExtraPaxModifier";
  private BigDecimal sourceExtraPaxModifier;

  public static final String JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER = "internalExtraPaxModifier";
  private BigDecimal internalExtraPaxModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER = "userSpecifiedCurrencyExtraPaxModifier";
  private BigDecimal userSpecifiedCurrencyExtraPaxModifier;

  public static final String JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER = "sourceExtraChildModifier";
  private BigDecimal sourceExtraChildModifier;

  public static final String JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER = "internalExtraChildModifier";
  private BigDecimal internalExtraChildModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER = "userSpecifiedCurrencyExtraChildModifier";
  private BigDecimal userSpecifiedCurrencyExtraChildModifier;

  public static final String JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER = "sourceSingleOccupantModifier";
  private BigDecimal sourceSingleOccupantModifier;

  public static final String JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER = "internalSingleOccupantModifier";
  private BigDecimal internalSingleOccupantModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER = "userSpecifiedCurrencySingleOccupantModifier";
  private BigDecimal userSpecifiedCurrencySingleOccupantModifier;

  public static final String JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER = "sourcePromotionalModifier";
  private BigDecimal sourcePromotionalModifier;

  public static final String JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER = "internalPromotionalModifier";
  private BigDecimal internalPromotionalModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER = "userSpecifiedCurrencyPromotionalModifier";
  private BigDecimal userSpecifiedCurrencyPromotionalModifier;

  public static final String JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER = "sourcePremiumModifier";
  private BigDecimal sourcePremiumModifier;

  public static final String JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER = "internalPremiumModifier";
  private BigDecimal internalPremiumModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER = "userSpecifiedCurrencyPremiumModifier";
  private BigDecimal userSpecifiedCurrencyPremiumModifier;

  public static final String JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER = "sourceChannelModifier";
  private BigDecimal sourceChannelModifier;

  public static final String JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER = "internalChannelModifier";
  private BigDecimal internalChannelModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER = "userSpecifiedCurrencyChannelModifier";
  private BigDecimal userSpecifiedCurrencyChannelModifier;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Integer quantity;

  public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
  private Integer minOccupancy;

  public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
  private Integer maxOccupancy;

  public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
  private String rateSource;

  public static final String JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT = "promotionalDiscountPercent";
  private Float promotionalDiscountPercent;

  public static final String JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT = "channelDiscountPercent";
  private Float channelDiscountPercent;

  public static final String JSON_PROPERTY_PREMIUM_PERCENT = "premiumPercent";
  private Float premiumPercent;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public static final String JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE = "sourceToUserCurrencyQuote";
  private QuoteAgent sourceToUserCurrencyQuote;

  public static final String JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE = "sourceToInternalCurrencyQuote";
  private QuoteAgent sourceToInternalCurrencyQuote;

  public static final String JSON_PROPERTY_OFFER_DETAILS = "offerDetails";
  private List<LocalizedDescriptionAgent> offerDetails;

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  private List<String> promotionalCodes;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
  private CustomMonetaryAmount userSpecifiedCurrencyTotal;

  public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
  private CustomMonetaryAmount sourceTotal;

  public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
  private CustomMonetaryAmount internalTotal;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_AVERAGE_PRICE_PER_NIGHT = "userSpecifiedCurrencyAveragePricePerNight";
  private CustomMonetaryAmount userSpecifiedCurrencyAveragePricePerNight;

  public static final String JSON_PROPERTY_INTERNAL_AVERAGE_PRICE_PER_NIGHT = "internalAveragePricePerNight";
  private CustomMonetaryAmount internalAveragePricePerNight;

  public static final String JSON_PROPERTY_SOURCE_AVERAGE_PRICE_PER_NIGHT = "sourceAveragePricePerNight";
  private CustomMonetaryAmount sourceAveragePricePerNight;

  public static final String JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT = "totalDiscountPercent";
  private Float totalDiscountPercent;

  public StayRateAgent() {
  }

  public StayRateAgent userSpecifiedCurrencyBaseTotal(CustomMonetaryAmount userSpecifiedCurrencyBaseTotal) {
    
    this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyBaseTotal
   * @return userSpecifiedCurrencyBaseTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getUserSpecifiedCurrencyBaseTotal() {
    return userSpecifiedCurrencyBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyBaseTotal(CustomMonetaryAmount userSpecifiedCurrencyBaseTotal) {
    this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
  }


  public StayRateAgent sourceBaseTotal(CustomMonetaryAmount sourceBaseTotal) {
    
    this.sourceBaseTotal = sourceBaseTotal;
    return this;
  }

   /**
   * Get sourceBaseTotal
   * @return sourceBaseTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getSourceBaseTotal() {
    return sourceBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceBaseTotal(CustomMonetaryAmount sourceBaseTotal) {
    this.sourceBaseTotal = sourceBaseTotal;
  }


  public StayRateAgent internalBaseTotal(CustomMonetaryAmount internalBaseTotal) {
    
    this.internalBaseTotal = internalBaseTotal;
    return this;
  }

   /**
   * Get internalBaseTotal
   * @return internalBaseTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getInternalBaseTotal() {
    return internalBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalBaseTotal(CustomMonetaryAmount internalBaseTotal) {
    this.internalBaseTotal = internalBaseTotal;
  }


  public StayRateAgent sourceExtraPaxModifier(BigDecimal sourceExtraPaxModifier) {
    
    this.sourceExtraPaxModifier = sourceExtraPaxModifier;
    return this;
  }

   /**
   * Extra person modifier in hotel currency.
   * @return sourceExtraPaxModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceExtraPaxModifier() {
    return sourceExtraPaxModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceExtraPaxModifier(BigDecimal sourceExtraPaxModifier) {
    this.sourceExtraPaxModifier = sourceExtraPaxModifier;
  }


  public StayRateAgent internalExtraPaxModifier(BigDecimal internalExtraPaxModifier) {
    
    this.internalExtraPaxModifier = internalExtraPaxModifier;
    return this;
  }

   /**
   * Extra person modifier in wink currency
   * @return internalExtraPaxModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalExtraPaxModifier() {
    return internalExtraPaxModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalExtraPaxModifier(BigDecimal internalExtraPaxModifier) {
    this.internalExtraPaxModifier = internalExtraPaxModifier;
  }


  public StayRateAgent userSpecifiedCurrencyExtraPaxModifier(BigDecimal userSpecifiedCurrencyExtraPaxModifier) {
    
    this.userSpecifiedCurrencyExtraPaxModifier = userSpecifiedCurrencyExtraPaxModifier;
    return this;
  }

   /**
   * Extra person modifier in user specified currency
   * @return userSpecifiedCurrencyExtraPaxModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyExtraPaxModifier() {
    return userSpecifiedCurrencyExtraPaxModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyExtraPaxModifier(BigDecimal userSpecifiedCurrencyExtraPaxModifier) {
    this.userSpecifiedCurrencyExtraPaxModifier = userSpecifiedCurrencyExtraPaxModifier;
  }


  public StayRateAgent sourceExtraChildModifier(BigDecimal sourceExtraChildModifier) {
    
    this.sourceExtraChildModifier = sourceExtraChildModifier;
    return this;
  }

   /**
   * Extra child modifier in hotel currency
   * @return sourceExtraChildModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceExtraChildModifier() {
    return sourceExtraChildModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceExtraChildModifier(BigDecimal sourceExtraChildModifier) {
    this.sourceExtraChildModifier = sourceExtraChildModifier;
  }


  public StayRateAgent internalExtraChildModifier(BigDecimal internalExtraChildModifier) {
    
    this.internalExtraChildModifier = internalExtraChildModifier;
    return this;
  }

   /**
   * Extra child modifier in wink currency
   * @return internalExtraChildModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalExtraChildModifier() {
    return internalExtraChildModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalExtraChildModifier(BigDecimal internalExtraChildModifier) {
    this.internalExtraChildModifier = internalExtraChildModifier;
  }


  public StayRateAgent userSpecifiedCurrencyExtraChildModifier(BigDecimal userSpecifiedCurrencyExtraChildModifier) {
    
    this.userSpecifiedCurrencyExtraChildModifier = userSpecifiedCurrencyExtraChildModifier;
    return this;
  }

   /**
   * Extra child modifier in user specified currcency
   * @return userSpecifiedCurrencyExtraChildModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyExtraChildModifier() {
    return userSpecifiedCurrencyExtraChildModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyExtraChildModifier(BigDecimal userSpecifiedCurrencyExtraChildModifier) {
    this.userSpecifiedCurrencyExtraChildModifier = userSpecifiedCurrencyExtraChildModifier;
  }


  public StayRateAgent sourceSingleOccupantModifier(BigDecimal sourceSingleOccupantModifier) {
    
    this.sourceSingleOccupantModifier = sourceSingleOccupantModifier;
    return this;
  }

   /**
   * Single occupant modifier in hotel currency
   * @return sourceSingleOccupantModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceSingleOccupantModifier() {
    return sourceSingleOccupantModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceSingleOccupantModifier(BigDecimal sourceSingleOccupantModifier) {
    this.sourceSingleOccupantModifier = sourceSingleOccupantModifier;
  }


  public StayRateAgent internalSingleOccupantModifier(BigDecimal internalSingleOccupantModifier) {
    
    this.internalSingleOccupantModifier = internalSingleOccupantModifier;
    return this;
  }

   /**
   * Singe occupant modifier in wink currency
   * @return internalSingleOccupantModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalSingleOccupantModifier() {
    return internalSingleOccupantModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalSingleOccupantModifier(BigDecimal internalSingleOccupantModifier) {
    this.internalSingleOccupantModifier = internalSingleOccupantModifier;
  }


  public StayRateAgent userSpecifiedCurrencySingleOccupantModifier(BigDecimal userSpecifiedCurrencySingleOccupantModifier) {
    
    this.userSpecifiedCurrencySingleOccupantModifier = userSpecifiedCurrencySingleOccupantModifier;
    return this;
  }

   /**
   * Single occupant modifier in user specified currency
   * @return userSpecifiedCurrencySingleOccupantModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencySingleOccupantModifier() {
    return userSpecifiedCurrencySingleOccupantModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencySingleOccupantModifier(BigDecimal userSpecifiedCurrencySingleOccupantModifier) {
    this.userSpecifiedCurrencySingleOccupantModifier = userSpecifiedCurrencySingleOccupantModifier;
  }


  public StayRateAgent sourcePromotionalModifier(BigDecimal sourcePromotionalModifier) {
    
    this.sourcePromotionalModifier = sourcePromotionalModifier;
    return this;
  }

   /**
   * Rate discount modifiers in hotel currency
   * @return sourcePromotionalModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourcePromotionalModifier() {
    return sourcePromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePromotionalModifier(BigDecimal sourcePromotionalModifier) {
    this.sourcePromotionalModifier = sourcePromotionalModifier;
  }


  public StayRateAgent internalPromotionalModifier(BigDecimal internalPromotionalModifier) {
    
    this.internalPromotionalModifier = internalPromotionalModifier;
    return this;
  }

   /**
   * Rate discount modifiers in wink currency
   * @return internalPromotionalModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalPromotionalModifier() {
    return internalPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPromotionalModifier(BigDecimal internalPromotionalModifier) {
    this.internalPromotionalModifier = internalPromotionalModifier;
  }


  public StayRateAgent userSpecifiedCurrencyPromotionalModifier(BigDecimal userSpecifiedCurrencyPromotionalModifier) {
    
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
    return this;
  }

   /**
   * Rate discount modifiers in user specified currency
   * @return userSpecifiedCurrencyPromotionalModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyPromotionalModifier() {
    return userSpecifiedCurrencyPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPromotionalModifier(BigDecimal userSpecifiedCurrencyPromotionalModifier) {
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
  }


  public StayRateAgent sourcePremiumModifier(BigDecimal sourcePremiumModifier) {
    
    this.sourcePremiumModifier = sourcePremiumModifier;
    return this;
  }

   /**
   * Rate premiums modifiers in hotel currency
   * @return sourcePremiumModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourcePremiumModifier() {
    return sourcePremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePremiumModifier(BigDecimal sourcePremiumModifier) {
    this.sourcePremiumModifier = sourcePremiumModifier;
  }


  public StayRateAgent internalPremiumModifier(BigDecimal internalPremiumModifier) {
    
    this.internalPremiumModifier = internalPremiumModifier;
    return this;
  }

   /**
   * Rate premiums modifiers in wink currency
   * @return internalPremiumModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalPremiumModifier() {
    return internalPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPremiumModifier(BigDecimal internalPremiumModifier) {
    this.internalPremiumModifier = internalPremiumModifier;
  }


  public StayRateAgent userSpecifiedCurrencyPremiumModifier(BigDecimal userSpecifiedCurrencyPremiumModifier) {
    
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
    return this;
  }

   /**
   * Rate premiums modifiers in user specified currency
   * @return userSpecifiedCurrencyPremiumModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyPremiumModifier() {
    return userSpecifiedCurrencyPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPremiumModifier(BigDecimal userSpecifiedCurrencyPremiumModifier) {
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
  }


  public StayRateAgent sourceChannelModifier(BigDecimal sourceChannelModifier) {
    
    this.sourceChannelModifier = sourceChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in hotel currency
   * @return sourceChannelModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceChannelModifier() {
    return sourceChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceChannelModifier(BigDecimal sourceChannelModifier) {
    this.sourceChannelModifier = sourceChannelModifier;
  }


  public StayRateAgent internalChannelModifier(BigDecimal internalChannelModifier) {
    
    this.internalChannelModifier = internalChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in wink currency
   * @return internalChannelModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalChannelModifier() {
    return internalChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalChannelModifier(BigDecimal internalChannelModifier) {
    this.internalChannelModifier = internalChannelModifier;
  }


  public StayRateAgent userSpecifiedCurrencyChannelModifier(BigDecimal userSpecifiedCurrencyChannelModifier) {
    
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in user specified currency
   * @return userSpecifiedCurrencyChannelModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyChannelModifier() {
    return userSpecifiedCurrencyChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyChannelModifier(BigDecimal userSpecifiedCurrencyChannelModifier) {
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
  }


  public StayRateAgent quantity(Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * Quantity
   * @return quantity
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }


  public StayRateAgent minOccupancy(Integer minOccupancy) {
    
    this.minOccupancy = minOccupancy;
    return this;
  }

   /**
   * Minimum occupancy
   * @return minOccupancy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinOccupancy() {
    return minOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinOccupancy(Integer minOccupancy) {
    this.minOccupancy = minOccupancy;
  }


  public StayRateAgent maxOccupancy(Integer maxOccupancy) {
    
    this.maxOccupancy = maxOccupancy;
    return this;
  }

   /**
   * Maximum occupancy
   * @return maxOccupancy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxOccupancy() {
    return maxOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxOccupancy(Integer maxOccupancy) {
    this.maxOccupancy = maxOccupancy;
  }


  public StayRateAgent rateSource(String rateSource) {
    
    this.rateSource = rateSource;
    return this;
  }

   /**
   * Source
   * @return rateSource
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateSource() {
    return rateSource;
  }


  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateSource(String rateSource) {
    this.rateSource = rateSource;
  }


  public StayRateAgent promotionalDiscountPercent(Float promotionalDiscountPercent) {
    
    this.promotionalDiscountPercent = promotionalDiscountPercent;
    return this;
  }

   /**
   * Promotional discount percent
   * @return promotionalDiscountPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPromotionalDiscountPercent() {
    return promotionalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalDiscountPercent(Float promotionalDiscountPercent) {
    this.promotionalDiscountPercent = promotionalDiscountPercent;
  }


  public StayRateAgent channelDiscountPercent(Float channelDiscountPercent) {
    
    this.channelDiscountPercent = channelDiscountPercent;
    return this;
  }

   /**
   * Chanel discount percent
   * @return channelDiscountPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getChannelDiscountPercent() {
    return channelDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelDiscountPercent(Float channelDiscountPercent) {
    this.channelDiscountPercent = channelDiscountPercent;
  }


  public StayRateAgent premiumPercent(Float premiumPercent) {
    
    this.premiumPercent = premiumPercent;
    return this;
  }

   /**
   * Premium percent
   * @return premiumPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPremiumPercent() {
    return premiumPercent;
  }


  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPremiumPercent(Float premiumPercent) {
    this.premiumPercent = premiumPercent;
  }


  public StayRateAgent available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Available
   * @return available
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  public StayRateAgent sourceToUserCurrencyQuote(QuoteAgent sourceToUserCurrencyQuote) {
    
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToUserCurrencyQuote
   * @return sourceToUserCurrencyQuote
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public QuoteAgent getSourceToUserCurrencyQuote() {
    return sourceToUserCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceToUserCurrencyQuote(QuoteAgent sourceToUserCurrencyQuote) {
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
  }


  public StayRateAgent sourceToInternalCurrencyQuote(QuoteAgent sourceToInternalCurrencyQuote) {
    
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToInternalCurrencyQuote
   * @return sourceToInternalCurrencyQuote
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public QuoteAgent getSourceToInternalCurrencyQuote() {
    return sourceToInternalCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceToInternalCurrencyQuote(QuoteAgent sourceToInternalCurrencyQuote) {
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
  }


  public StayRateAgent offerDetails(List<LocalizedDescriptionAgent> offerDetails) {
    
    this.offerDetails = offerDetails;
    return this;
  }

  public StayRateAgent addOfferDetailsItem(LocalizedDescriptionAgent offerDetailsItem) {
    if (this.offerDetails == null) {
      this.offerDetails = new ArrayList<>();
    }
    this.offerDetails.add(offerDetailsItem);
    return this;
  }

   /**
   * Localized text of the discount
   * @return offerDetails
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedDescriptionAgent> getOfferDetails() {
    return offerDetails;
  }


  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOfferDetails(List<LocalizedDescriptionAgent> offerDetails) {
    this.offerDetails = offerDetails;
  }


  public StayRateAgent promotionalCodes(List<String> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public StayRateAgent addPromotionalCodesItem(String promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

   /**
   * Promotional codes
   * @return promotionalCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(List<String> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }


  public StayRateAgent userSpecifiedCurrencyTotal(CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyTotal
   * @return userSpecifiedCurrencyTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getUserSpecifiedCurrencyTotal() {
    return userSpecifiedCurrencyTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyTotal(CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
  }


  public StayRateAgent sourceTotal(CustomMonetaryAmount sourceTotal) {
    
    this.sourceTotal = sourceTotal;
    return this;
  }

   /**
   * Get sourceTotal
   * @return sourceTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getSourceTotal() {
    return sourceTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceTotal(CustomMonetaryAmount sourceTotal) {
    this.sourceTotal = sourceTotal;
  }


  public StayRateAgent internalTotal(CustomMonetaryAmount internalTotal) {
    
    this.internalTotal = internalTotal;
    return this;
  }

   /**
   * Get internalTotal
   * @return internalTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getInternalTotal() {
    return internalTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalTotal(CustomMonetaryAmount internalTotal) {
    this.internalTotal = internalTotal;
  }


  public StayRateAgent userSpecifiedCurrencyAveragePricePerNight(CustomMonetaryAmount userSpecifiedCurrencyAveragePricePerNight) {
    
    this.userSpecifiedCurrencyAveragePricePerNight = userSpecifiedCurrencyAveragePricePerNight;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyAveragePricePerNight
   * @return userSpecifiedCurrencyAveragePricePerNight
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getUserSpecifiedCurrencyAveragePricePerNight() {
    return userSpecifiedCurrencyAveragePricePerNight;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyAveragePricePerNight(CustomMonetaryAmount userSpecifiedCurrencyAveragePricePerNight) {
    this.userSpecifiedCurrencyAveragePricePerNight = userSpecifiedCurrencyAveragePricePerNight;
  }


  public StayRateAgent internalAveragePricePerNight(CustomMonetaryAmount internalAveragePricePerNight) {
    
    this.internalAveragePricePerNight = internalAveragePricePerNight;
    return this;
  }

   /**
   * Get internalAveragePricePerNight
   * @return internalAveragePricePerNight
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getInternalAveragePricePerNight() {
    return internalAveragePricePerNight;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAveragePricePerNight(CustomMonetaryAmount internalAveragePricePerNight) {
    this.internalAveragePricePerNight = internalAveragePricePerNight;
  }


  public StayRateAgent sourceAveragePricePerNight(CustomMonetaryAmount sourceAveragePricePerNight) {
    
    this.sourceAveragePricePerNight = sourceAveragePricePerNight;
    return this;
  }

   /**
   * Get sourceAveragePricePerNight
   * @return sourceAveragePricePerNight
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getSourceAveragePricePerNight() {
    return sourceAveragePricePerNight;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAveragePricePerNight(CustomMonetaryAmount sourceAveragePricePerNight) {
    this.sourceAveragePricePerNight = sourceAveragePricePerNight;
  }


  public StayRateAgent totalDiscountPercent(Float totalDiscountPercent) {
    
    this.totalDiscountPercent = totalDiscountPercent;
    return this;
  }

   /**
   * Get totalDiscountPercent
   * @return totalDiscountPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalDiscountPercent() {
    return totalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalDiscountPercent(Float totalDiscountPercent) {
    this.totalDiscountPercent = totalDiscountPercent;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StayRateAgent stayRateAgent = (StayRateAgent) o;
    return Objects.equals(this.userSpecifiedCurrencyBaseTotal, stayRateAgent.userSpecifiedCurrencyBaseTotal) &&
        Objects.equals(this.sourceBaseTotal, stayRateAgent.sourceBaseTotal) &&
        Objects.equals(this.internalBaseTotal, stayRateAgent.internalBaseTotal) &&
        Objects.equals(this.sourceExtraPaxModifier, stayRateAgent.sourceExtraPaxModifier) &&
        Objects.equals(this.internalExtraPaxModifier, stayRateAgent.internalExtraPaxModifier) &&
        Objects.equals(this.userSpecifiedCurrencyExtraPaxModifier, stayRateAgent.userSpecifiedCurrencyExtraPaxModifier) &&
        Objects.equals(this.sourceExtraChildModifier, stayRateAgent.sourceExtraChildModifier) &&
        Objects.equals(this.internalExtraChildModifier, stayRateAgent.internalExtraChildModifier) &&
        Objects.equals(this.userSpecifiedCurrencyExtraChildModifier, stayRateAgent.userSpecifiedCurrencyExtraChildModifier) &&
        Objects.equals(this.sourceSingleOccupantModifier, stayRateAgent.sourceSingleOccupantModifier) &&
        Objects.equals(this.internalSingleOccupantModifier, stayRateAgent.internalSingleOccupantModifier) &&
        Objects.equals(this.userSpecifiedCurrencySingleOccupantModifier, stayRateAgent.userSpecifiedCurrencySingleOccupantModifier) &&
        Objects.equals(this.sourcePromotionalModifier, stayRateAgent.sourcePromotionalModifier) &&
        Objects.equals(this.internalPromotionalModifier, stayRateAgent.internalPromotionalModifier) &&
        Objects.equals(this.userSpecifiedCurrencyPromotionalModifier, stayRateAgent.userSpecifiedCurrencyPromotionalModifier) &&
        Objects.equals(this.sourcePremiumModifier, stayRateAgent.sourcePremiumModifier) &&
        Objects.equals(this.internalPremiumModifier, stayRateAgent.internalPremiumModifier) &&
        Objects.equals(this.userSpecifiedCurrencyPremiumModifier, stayRateAgent.userSpecifiedCurrencyPremiumModifier) &&
        Objects.equals(this.sourceChannelModifier, stayRateAgent.sourceChannelModifier) &&
        Objects.equals(this.internalChannelModifier, stayRateAgent.internalChannelModifier) &&
        Objects.equals(this.userSpecifiedCurrencyChannelModifier, stayRateAgent.userSpecifiedCurrencyChannelModifier) &&
        Objects.equals(this.quantity, stayRateAgent.quantity) &&
        Objects.equals(this.minOccupancy, stayRateAgent.minOccupancy) &&
        Objects.equals(this.maxOccupancy, stayRateAgent.maxOccupancy) &&
        Objects.equals(this.rateSource, stayRateAgent.rateSource) &&
        Objects.equals(this.promotionalDiscountPercent, stayRateAgent.promotionalDiscountPercent) &&
        Objects.equals(this.channelDiscountPercent, stayRateAgent.channelDiscountPercent) &&
        Objects.equals(this.premiumPercent, stayRateAgent.premiumPercent) &&
        Objects.equals(this.available, stayRateAgent.available) &&
        Objects.equals(this.sourceToUserCurrencyQuote, stayRateAgent.sourceToUserCurrencyQuote) &&
        Objects.equals(this.sourceToInternalCurrencyQuote, stayRateAgent.sourceToInternalCurrencyQuote) &&
        Objects.equals(this.offerDetails, stayRateAgent.offerDetails) &&
        Objects.equals(this.promotionalCodes, stayRateAgent.promotionalCodes) &&
        Objects.equals(this.userSpecifiedCurrencyTotal, stayRateAgent.userSpecifiedCurrencyTotal) &&
        Objects.equals(this.sourceTotal, stayRateAgent.sourceTotal) &&
        Objects.equals(this.internalTotal, stayRateAgent.internalTotal) &&
        Objects.equals(this.userSpecifiedCurrencyAveragePricePerNight, stayRateAgent.userSpecifiedCurrencyAveragePricePerNight) &&
        Objects.equals(this.internalAveragePricePerNight, stayRateAgent.internalAveragePricePerNight) &&
        Objects.equals(this.sourceAveragePricePerNight, stayRateAgent.sourceAveragePricePerNight) &&
        Objects.equals(this.totalDiscountPercent, stayRateAgent.totalDiscountPercent);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userSpecifiedCurrencyBaseTotal, sourceBaseTotal, internalBaseTotal, sourceExtraPaxModifier, internalExtraPaxModifier, userSpecifiedCurrencyExtraPaxModifier, sourceExtraChildModifier, internalExtraChildModifier, userSpecifiedCurrencyExtraChildModifier, sourceSingleOccupantModifier, internalSingleOccupantModifier, userSpecifiedCurrencySingleOccupantModifier, sourcePromotionalModifier, internalPromotionalModifier, userSpecifiedCurrencyPromotionalModifier, sourcePremiumModifier, internalPremiumModifier, userSpecifiedCurrencyPremiumModifier, sourceChannelModifier, internalChannelModifier, userSpecifiedCurrencyChannelModifier, quantity, minOccupancy, maxOccupancy, rateSource, promotionalDiscountPercent, channelDiscountPercent, premiumPercent, available, sourceToUserCurrencyQuote, sourceToInternalCurrencyQuote, offerDetails, promotionalCodes, userSpecifiedCurrencyTotal, sourceTotal, internalTotal, userSpecifiedCurrencyAveragePricePerNight, internalAveragePricePerNight, sourceAveragePricePerNight, totalDiscountPercent);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StayRateAgent {\n");
    sb.append("    userSpecifiedCurrencyBaseTotal: ").append(toIndentedString(userSpecifiedCurrencyBaseTotal)).append("\n");
    sb.append("    sourceBaseTotal: ").append(toIndentedString(sourceBaseTotal)).append("\n");
    sb.append("    internalBaseTotal: ").append(toIndentedString(internalBaseTotal)).append("\n");
    sb.append("    sourceExtraPaxModifier: ").append(toIndentedString(sourceExtraPaxModifier)).append("\n");
    sb.append("    internalExtraPaxModifier: ").append(toIndentedString(internalExtraPaxModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyExtraPaxModifier: ").append(toIndentedString(userSpecifiedCurrencyExtraPaxModifier)).append("\n");
    sb.append("    sourceExtraChildModifier: ").append(toIndentedString(sourceExtraChildModifier)).append("\n");
    sb.append("    internalExtraChildModifier: ").append(toIndentedString(internalExtraChildModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyExtraChildModifier: ").append(toIndentedString(userSpecifiedCurrencyExtraChildModifier)).append("\n");
    sb.append("    sourceSingleOccupantModifier: ").append(toIndentedString(sourceSingleOccupantModifier)).append("\n");
    sb.append("    internalSingleOccupantModifier: ").append(toIndentedString(internalSingleOccupantModifier)).append("\n");
    sb.append("    userSpecifiedCurrencySingleOccupantModifier: ").append(toIndentedString(userSpecifiedCurrencySingleOccupantModifier)).append("\n");
    sb.append("    sourcePromotionalModifier: ").append(toIndentedString(sourcePromotionalModifier)).append("\n");
    sb.append("    internalPromotionalModifier: ").append(toIndentedString(internalPromotionalModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyPromotionalModifier: ").append(toIndentedString(userSpecifiedCurrencyPromotionalModifier)).append("\n");
    sb.append("    sourcePremiumModifier: ").append(toIndentedString(sourcePremiumModifier)).append("\n");
    sb.append("    internalPremiumModifier: ").append(toIndentedString(internalPremiumModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyPremiumModifier: ").append(toIndentedString(userSpecifiedCurrencyPremiumModifier)).append("\n");
    sb.append("    sourceChannelModifier: ").append(toIndentedString(sourceChannelModifier)).append("\n");
    sb.append("    internalChannelModifier: ").append(toIndentedString(internalChannelModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyChannelModifier: ").append(toIndentedString(userSpecifiedCurrencyChannelModifier)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    minOccupancy: ").append(toIndentedString(minOccupancy)).append("\n");
    sb.append("    maxOccupancy: ").append(toIndentedString(maxOccupancy)).append("\n");
    sb.append("    rateSource: ").append(toIndentedString(rateSource)).append("\n");
    sb.append("    promotionalDiscountPercent: ").append(toIndentedString(promotionalDiscountPercent)).append("\n");
    sb.append("    channelDiscountPercent: ").append(toIndentedString(channelDiscountPercent)).append("\n");
    sb.append("    premiumPercent: ").append(toIndentedString(premiumPercent)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    sourceToUserCurrencyQuote: ").append(toIndentedString(sourceToUserCurrencyQuote)).append("\n");
    sb.append("    sourceToInternalCurrencyQuote: ").append(toIndentedString(sourceToInternalCurrencyQuote)).append("\n");
    sb.append("    offerDetails: ").append(toIndentedString(offerDetails)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    userSpecifiedCurrencyTotal: ").append(toIndentedString(userSpecifiedCurrencyTotal)).append("\n");
    sb.append("    sourceTotal: ").append(toIndentedString(sourceTotal)).append("\n");
    sb.append("    internalTotal: ").append(toIndentedString(internalTotal)).append("\n");
    sb.append("    userSpecifiedCurrencyAveragePricePerNight: ").append(toIndentedString(userSpecifiedCurrencyAveragePricePerNight)).append("\n");
    sb.append("    internalAveragePricePerNight: ").append(toIndentedString(internalAveragePricePerNight)).append("\n");
    sb.append("    sourceAveragePricePerNight: ").append(toIndentedString(sourceAveragePricePerNight)).append("\n");
    sb.append("    totalDiscountPercent: ").append(toIndentedString(totalDiscountPercent)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

