/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.travel.agent.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"type", "identifier", "audiences", "audienceSize"})
@JsonTypeName(value="OnlinePresence_Agent")
public class OnlinePresenceAgent {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_AUDIENCES = "audiences";
    private List<AudiencesEnum> audiences;
    public static final String JSON_PROPERTY_AUDIENCE_SIZE = "audienceSize";
    private Long audienceSize;

    public OnlinePresenceAgent type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OnlinePresenceAgent identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public OnlinePresenceAgent audiences(List<AudiencesEnum> audiences) {
        this.audiences = audiences;
        return this;
    }

    public OnlinePresenceAgent addAudiencesItem(AudiencesEnum audiencesItem) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<AudiencesEnum>();
        }
        this.audiences.add(audiencesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="audiences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AudiencesEnum> getAudiences() {
        return this.audiences;
    }

    @JsonProperty(value="audiences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAudiences(List<AudiencesEnum> audiences) {
        this.audiences = audiences;
    }

    public OnlinePresenceAgent audienceSize(Long audienceSize) {
        this.audienceSize = audienceSize;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="audienceSize")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getAudienceSize() {
        return this.audienceSize;
    }

    @JsonProperty(value="audienceSize")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAudienceSize(Long audienceSize) {
        this.audienceSize = audienceSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OnlinePresenceAgent onlinePresenceAgent = (OnlinePresenceAgent)o;
        return Objects.equals((Object)this.type, (Object)onlinePresenceAgent.type) && Objects.equals(this.identifier, onlinePresenceAgent.identifier) && Objects.equals(this.audiences, onlinePresenceAgent.audiences) && Objects.equals(this.audienceSize, onlinePresenceAgent.audienceSize);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.identifier, this.audiences, this.audienceSize});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OnlinePresenceAgent {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    audiences: ").append(this.toIndentedString(this.audiences)).append("\n");
        sb.append("    audienceSize: ").append(this.toIndentedString(this.audienceSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        WINK("WINK"),
        WEB_SITE("WEB_SITE"),
        PERSONAL_WEB_SITE("PERSONAL_WEB_SITE"),
        CORPORATE_WEB_SITE("CORPORATE_WEB_SITE"),
        FACEBOOK("FACEBOOK"),
        INSTAGRAM("INSTAGRAM"),
        TWITTER_X("TWITTER_X"),
        LINKEDIN("LINKEDIN"),
        TIKTOK("TIKTOK"),
        SNAPCHAT("SNAPCHAT"),
        MASTODON("MASTODON"),
        THREADS("THREADS"),
        HIVE_SOCIAL("HIVE_SOCIAL"),
        MEWE("MEWE"),
        ELLO("ELLO"),
        WHATSAPP("WHATSAPP"),
        TELEGRAM("TELEGRAM"),
        SIGNAL("SIGNAL"),
        WECHAT("WECHAT"),
        LINE("LINE"),
        KAKAOTALK("KAKAOTALK"),
        VIBER("VIBER"),
        DISCORD("DISCORD"),
        SKYPE("SKYPE"),
        FACEBOOK_MESSENGER("FACEBOOK_MESSENGER"),
        YOUTUBE("YOUTUBE"),
        TWITCH("TWITCH"),
        BILIBILI("BILIBILI"),
        VIMEO("VIMEO"),
        DAILYMOTION("DAILYMOTION"),
        KICK("KICK"),
        UPLIVE("UPLIVE"),
        PINTEREST("PINTEREST"),
        BEREAL("BEREAL"),
        VSCO("VSCO"),
        IMGUR("IMGUR"),
        FLICKR("FLICKR"),
        FIVE_HUNDRED_PX("FIVE_HUNDRED_PX"),
        REDDIT("REDDIT"),
        QUORA("QUORA"),
        TUMBLR("TUMBLR"),
        PLURK("PLURK"),
        MEDIUM("MEDIUM"),
        BLUESKY("BLUESKY"),
        MINDS("MINDS"),
        STEEMIT("STEEMIT"),
        DIASPORA("DIASPORA"),
        WHISPER("WHISPER"),
        YIK_YAK("YIK_YAK"),
        TELLONYM("TELLONYM"),
        GOOGLE("GOOGLE"),
        GITHUB("GITHUB"),
        SPOTIFY("SPOTIFY"),
        UPWORK("UPWORK"),
        SHOPIFY("SHOPIFY"),
        AMAZON("AMAZON");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AudiencesEnum {
        EVERYONE("EVERYONE"),
        ADVENTURE("ADVENTURE"),
        BEACH("BEACH"),
        BUSINESS("BUSINESS"),
        CULTURAL_EXPERIENCE("CULTURAL_EXPERIENCE"),
        EDUCATION("EDUCATION"),
        FAMILY("FAMILY"),
        FOOD_AND_CULINARY("FOOD_AND_CULINARY"),
        HIKING("HIKING"),
        HISTORICAL_SITES("HISTORICAL_SITES"),
        HONEYMOON("HONEYMOON"),
        LUXURY("LUXURY"),
        MEDICAL_TOURISM("MEDICAL_TOURISM"),
        MUSIC_AND_FESTIVALS("MUSIC_AND_FESTIVALS"),
        NATURE_AND_WILDLIFE("NATURE_AND_WILDLIFE"),
        PHOTOGRAPHY("PHOTOGRAPHY"),
        PILGRIMAGE("PILGRIMAGE"),
        RELAXATION("RELAXATION"),
        ROAD_TRIP("ROAD_TRIP"),
        ROMANCE("ROMANCE"),
        SHOPPING("SHOPPING"),
        SKIING("SKIING"),
        SOLO_TRAVEL("SOLO_TRAVEL"),
        SPORTS_EVENTS("SPORTS_EVENTS"),
        VOLUNTEERING("VOLUNTEERING"),
        WELLNESS_AND_SPA("WELLNESS_AND_SPA"),
        CITY("CITY"),
        WILDLIFE("WILDLIFE");

        private String value;

        private AudiencesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AudiencesEnum fromValue(String value) {
            for (AudiencesEnum b : AudiencesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

