/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Travel Agent API The Travel Agent API exposes endpoints to manage agent-facilitated bookings. This API lets you:  1. Travel Agent: Manage agent entity. 2. Booking: Create / Manage bookings  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.16.4
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.travel.agent.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.travel.agent.model.AddressAgent;
import travel.wink.sdk.travel.agent.model.CompanyUserAgent;
import travel.wink.sdk.travel.agent.model.CustomMonetaryAmount;
import travel.wink.sdk.travel.agent.model.ManagedByEntityAgent;
import travel.wink.sdk.travel.agent.model.OnlinePresenceAgent;
import travel.wink.sdk.travel.agent.model.SimpleMultimediaAgent;
import travel.wink.sdk.travel.agent.model.TravelAgentAgent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * A Company is our definition of a sales channel / affiliate. A property also has a company record.
 */
@JsonPropertyOrder({
  CompanyAgent.JSON_PROPERTY_IDENTIFIER,
  CompanyAgent.JSON_PROPERTY_USER_IDENTIFIER,
  CompanyAgent.JSON_PROPERTY_OWNER,
  CompanyAgent.JSON_PROPERTY_NAME,
  CompanyAgent.JSON_PROPERTY_URL_NAME,
  CompanyAgent.JSON_PROPERTY_LEGAL_NAME,
  CompanyAgent.JSON_PROPERTY_ENABLED,
  CompanyAgent.JSON_PROPERTY_APPROVED,
  CompanyAgent.JSON_PROPERTY_COMPANY_TYPE,
  CompanyAgent.JSON_PROPERTY_TYPE,
  CompanyAgent.JSON_PROPERTY_DESCRIPTION,
  CompanyAgent.JSON_PROPERTY_ADDRESS,
  CompanyAgent.JSON_PROPERTY_MANAGERS,
  CompanyAgent.JSON_PROPERTY_LOGO,
  CompanyAgent.JSON_PROPERTY_TRAVEL_AGENT,
  CompanyAgent.JSON_PROPERTY_MANAGED_BY,
  CompanyAgent.JSON_PROPERTY_ONLINE_PRESENCE,
  CompanyAgent.JSON_PROPERTY_ANNUAL_TRAVEL_SPEND_IN_DOLLARS
})
@JsonTypeName("Company_Agent")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-03T15:01:40.522173851+07:00[Asia/Bangkok]")
public class CompanyAgent {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
  private UUID userIdentifier;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private CompanyUserAgent owner;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
  private String legalName;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled;

  public static final String JSON_PROPERTY_APPROVED = "approved";
  private Boolean approved = false;

  /**
   * Type of company
   */
  public enum CompanyTypeEnum {
    COMPANY("COMPANY"),
    
    INDIVIDUAL("INDIVIDUAL");

    private String value;

    CompanyTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CompanyTypeEnum fromValue(String value) {
      for (CompanyTypeEnum b : CompanyTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_COMPANY_TYPE = "companyType";
  private CompanyTypeEnum companyType;

  /**
   * Type of sales channel
   */
  public enum TypeEnum {
    DIRECT("DIRECT"),
    
    APPLICATION("APPLICATION"),
    
    HOTEL("HOTEL"),
    
    TRAVELIKO("TRAVELIKO"),
    
    CORPORATE("CORPORATE"),
    
    TRAVEL_AGENT("TRAVEL_AGENT"),
    
    INFLUENCER("INFLUENCER"),
    
    BLOGGER("BLOGGER"),
    
    DESTINATION("DESTINATION"),
    
    CHANNEL_MANAGER("CHANNEL_MANAGER"),
    
    PROPERTY_MANAGEMENT_SYSTEM("PROPERTY_MANAGEMENT_SYSTEM"),
    
    CENTRAL_RESERVATION_SYSTEM("CENTRAL_RESERVATION_SYSTEM"),
    
    GOOGLE_HOTEL_API("GOOGLE_HOTEL_API"),
    
    MANAGEMENT_COMPANY("MANAGEMENT_COMPANY"),
    
    CHAIN("CHAIN"),
    
    BRAND("BRAND"),
    
    EVENT_ORGANIZER("EVENT_ORGANIZER");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressAgent address;

  public static final String JSON_PROPERTY_MANAGERS = "managers";
  private List<CompanyUserAgent> managers;

  public static final String JSON_PROPERTY_LOGO = "logo";
  private SimpleMultimediaAgent logo;

  public static final String JSON_PROPERTY_TRAVEL_AGENT = "travelAgent";
  private TravelAgentAgent travelAgent;

  public static final String JSON_PROPERTY_MANAGED_BY = "managedBy";
  private ManagedByEntityAgent managedBy;

  public static final String JSON_PROPERTY_ONLINE_PRESENCE = "onlinePresence";
  private List<OnlinePresenceAgent> onlinePresence;

  public static final String JSON_PROPERTY_ANNUAL_TRAVEL_SPEND_IN_DOLLARS = "annualTravelSpendInDollars";
  private CustomMonetaryAmount annualTravelSpendInDollars;

  public CompanyAgent() {
  }

  public CompanyAgent identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public CompanyAgent userIdentifier(UUID userIdentifier) {
    
    this.userIdentifier = userIdentifier;
    return this;
  }

   /**
   * User or Registered client owner identifier that created this record
   * @return userIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getUserIdentifier() {
    return userIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserIdentifier(UUID userIdentifier) {
    this.userIdentifier = userIdentifier;
  }


  public CompanyAgent owner(CompanyUserAgent owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CompanyUserAgent getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwner(CompanyUserAgent owner) {
    this.owner = owner;
  }


  public CompanyAgent name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of company
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public CompanyAgent urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Url slug of company name
   * @return urlName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public CompanyAgent legalName(String legalName) {
    
    this.legalName = legalName;
    return this;
  }

   /**
   * Legal name of entity if other than name
   * @return legalName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLegalName() {
    return legalName;
  }


  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalName(String legalName) {
    this.legalName = legalName;
  }


  public CompanyAgent enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether this company is enabled by reactive.
   * @return enabled
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public CompanyAgent approved(Boolean approved) {
    
    this.approved = approved;
    return this;
  }

   /**
   * Whether this company has been approved by KYC.
   * @return approved
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_APPROVED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getApproved() {
    return approved;
  }


  @JsonProperty(JSON_PROPERTY_APPROVED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setApproved(Boolean approved) {
    this.approved = approved;
  }


  public CompanyAgent companyType(CompanyTypeEnum companyType) {
    
    this.companyType = companyType;
    return this;
  }

   /**
   * Type of company
   * @return companyType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMPANY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CompanyTypeEnum getCompanyType() {
    return companyType;
  }


  @JsonProperty(JSON_PROPERTY_COMPANY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCompanyType(CompanyTypeEnum companyType) {
    this.companyType = companyType;
  }


  public CompanyAgent type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of sales channel
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public CompanyAgent description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * A personal message from the company.
   * @return description
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public CompanyAgent address(AddressAgent address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AddressAgent getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(AddressAgent address) {
    this.address = address;
  }


  public CompanyAgent managers(List<CompanyUserAgent> managers) {
    
    this.managers = managers;
    return this;
  }

  public CompanyAgent addManagersItem(CompanyUserAgent managersItem) {
    if (this.managers == null) {
      this.managers = new ArrayList<>();
    }
    this.managers.add(managersItem);
    return this;
  }

   /**
   * Get managers
   * @return managers
  **/
  @jakarta.annotation.Nullable
  @Valid
 @Size(min=0,max=30)
  @JsonProperty(JSON_PROPERTY_MANAGERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CompanyUserAgent> getManagers() {
    return managers;
  }


  @JsonProperty(JSON_PROPERTY_MANAGERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setManagers(List<CompanyUserAgent> managers) {
    this.managers = managers;
  }


  public CompanyAgent logo(SimpleMultimediaAgent logo) {
    
    this.logo = logo;
    return this;
  }

   /**
   * Get logo
   * @return logo
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOGO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SimpleMultimediaAgent getLogo() {
    return logo;
  }


  @JsonProperty(JSON_PROPERTY_LOGO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogo(SimpleMultimediaAgent logo) {
    this.logo = logo;
  }


  public CompanyAgent travelAgent(TravelAgentAgent travelAgent) {
    
    this.travelAgent = travelAgent;
    return this;
  }

   /**
   * Get travelAgent
   * @return travelAgent
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TRAVEL_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TravelAgentAgent getTravelAgent() {
    return travelAgent;
  }


  @JsonProperty(JSON_PROPERTY_TRAVEL_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTravelAgent(TravelAgentAgent travelAgent) {
    this.travelAgent = travelAgent;
  }


  public CompanyAgent managedBy(ManagedByEntityAgent managedBy) {
    
    this.managedBy = managedBy;
    return this;
  }

   /**
   * Get managedBy
   * @return managedBy
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MANAGED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ManagedByEntityAgent getManagedBy() {
    return managedBy;
  }


  @JsonProperty(JSON_PROPERTY_MANAGED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setManagedBy(ManagedByEntityAgent managedBy) {
    this.managedBy = managedBy;
  }


  public CompanyAgent onlinePresence(List<OnlinePresenceAgent> onlinePresence) {
    
    this.onlinePresence = onlinePresence;
    return this;
  }

  public CompanyAgent addOnlinePresenceItem(OnlinePresenceAgent onlinePresenceItem) {
    if (this.onlinePresence == null) {
      this.onlinePresence = new ArrayList<>();
    }
    this.onlinePresence.add(onlinePresenceItem);
    return this;
  }

   /**
   * Get onlinePresence
   * @return onlinePresence
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ONLINE_PRESENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OnlinePresenceAgent> getOnlinePresence() {
    return onlinePresence;
  }


  @JsonProperty(JSON_PROPERTY_ONLINE_PRESENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOnlinePresence(List<OnlinePresenceAgent> onlinePresence) {
    this.onlinePresence = onlinePresence;
  }


  public CompanyAgent annualTravelSpendInDollars(CustomMonetaryAmount annualTravelSpendInDollars) {
    
    this.annualTravelSpendInDollars = annualTravelSpendInDollars;
    return this;
  }

   /**
   * Get annualTravelSpendInDollars
   * @return annualTravelSpendInDollars
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ANNUAL_TRAVEL_SPEND_IN_DOLLARS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getAnnualTravelSpendInDollars() {
    return annualTravelSpendInDollars;
  }


  @JsonProperty(JSON_PROPERTY_ANNUAL_TRAVEL_SPEND_IN_DOLLARS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnnualTravelSpendInDollars(CustomMonetaryAmount annualTravelSpendInDollars) {
    this.annualTravelSpendInDollars = annualTravelSpendInDollars;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompanyAgent companyAgent = (CompanyAgent) o;
    return Objects.equals(this.identifier, companyAgent.identifier) &&
        Objects.equals(this.userIdentifier, companyAgent.userIdentifier) &&
        Objects.equals(this.owner, companyAgent.owner) &&
        Objects.equals(this.name, companyAgent.name) &&
        Objects.equals(this.urlName, companyAgent.urlName) &&
        Objects.equals(this.legalName, companyAgent.legalName) &&
        Objects.equals(this.enabled, companyAgent.enabled) &&
        Objects.equals(this.approved, companyAgent.approved) &&
        Objects.equals(this.companyType, companyAgent.companyType) &&
        Objects.equals(this.type, companyAgent.type) &&
        Objects.equals(this.description, companyAgent.description) &&
        Objects.equals(this.address, companyAgent.address) &&
        Objects.equals(this.managers, companyAgent.managers) &&
        Objects.equals(this.logo, companyAgent.logo) &&
        Objects.equals(this.travelAgent, companyAgent.travelAgent) &&
        Objects.equals(this.managedBy, companyAgent.managedBy) &&
        Objects.equals(this.onlinePresence, companyAgent.onlinePresence) &&
        Objects.equals(this.annualTravelSpendInDollars, companyAgent.annualTravelSpendInDollars);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, userIdentifier, owner, name, urlName, legalName, enabled, approved, companyType, type, description, address, managers, logo, travelAgent, managedBy, onlinePresence, annualTravelSpendInDollars);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompanyAgent {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    userIdentifier: ").append(toIndentedString(userIdentifier)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    legalName: ").append(toIndentedString(legalName)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    approved: ").append(toIndentedString(approved)).append("\n");
    sb.append("    companyType: ").append(toIndentedString(companyType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    managers: ").append(toIndentedString(managers)).append("\n");
    sb.append("    logo: ").append(toIndentedString(logo)).append("\n");
    sb.append("    travelAgent: ").append(toIndentedString(travelAgent)).append("\n");
    sb.append("    managedBy: ").append(toIndentedString(managedBy)).append("\n");
    sb.append("    onlinePresence: ").append(toIndentedString(onlinePresence)).append("\n");
    sb.append("    annualTravelSpendInDollars: ").append(toIndentedString(annualTravelSpendInDollars)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

