/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Travel Agent API The Travel Agent API exposes endpoints to manage agent-facilitated bookings. This API lets you:  1. Travel Agent: Manage agent entity. 2. Booking: Create / Manage bookings  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.16.4
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.travel.agent.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import travel.wink.sdk.travel.agent.model.CancellationPolicyAgent;
import travel.wink.sdk.travel.agent.model.CancellationPolicyExceptionsAgent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Rate plan used for this stay
 */
@JsonPropertyOrder({
  RoomConfigurationPriceRatePlanAgent.JSON_PROPERTY_IDENTIFIER,
  RoomConfigurationPriceRatePlanAgent.JSON_PROPERTY_NAME,
  RoomConfigurationPriceRatePlanAgent.JSON_PROPERTY_BREAKFAST,
  RoomConfigurationPriceRatePlanAgent.JSON_PROPERTY_BRUNCH,
  RoomConfigurationPriceRatePlanAgent.JSON_PROPERTY_LUNCH,
  RoomConfigurationPriceRatePlanAgent.JSON_PROPERTY_DINNER,
  RoomConfigurationPriceRatePlanAgent.JSON_PROPERTY_ALL_INCLUSIVE,
  RoomConfigurationPriceRatePlanAgent.JSON_PROPERTY_ALL_INCLUSIVE_PLUS_ALCOHOL,
  RoomConfigurationPriceRatePlanAgent.JSON_PROPERTY_EARLY_CHECK_IN_CHARGE,
  RoomConfigurationPriceRatePlanAgent.JSON_PROPERTY_LATE_CHECK_OUT_CHARGE,
  RoomConfigurationPriceRatePlanAgent.JSON_PROPERTY_CANCELLATION_POLICY,
  RoomConfigurationPriceRatePlanAgent.JSON_PROPERTY_CANCELLATION_POLICY_EXCEPTIONS
})
@JsonTypeName("RoomConfigurationPriceRatePlan_Agent")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-03T15:01:40.522173851+07:00[Asia/Bangkok]")
public class RoomConfigurationPriceRatePlanAgent {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_BREAKFAST = "breakfast";
  private Boolean breakfast = false;

  public static final String JSON_PROPERTY_BRUNCH = "brunch";
  private Boolean brunch = false;

  public static final String JSON_PROPERTY_LUNCH = "lunch";
  private Boolean lunch = false;

  public static final String JSON_PROPERTY_DINNER = "dinner";
  private Boolean dinner = false;

  public static final String JSON_PROPERTY_ALL_INCLUSIVE = "allInclusive";
  private Boolean allInclusive = false;

  public static final String JSON_PROPERTY_ALL_INCLUSIVE_PLUS_ALCOHOL = "allInclusivePlusAlcohol";
  private Boolean allInclusivePlusAlcohol = false;

  public static final String JSON_PROPERTY_EARLY_CHECK_IN_CHARGE = "earlyCheckInCharge";
  private Object earlyCheckInCharge;

  public static final String JSON_PROPERTY_LATE_CHECK_OUT_CHARGE = "lateCheckOutCharge";
  private Object lateCheckOutCharge;

  public static final String JSON_PROPERTY_CANCELLATION_POLICY = "cancellationPolicy";
  private CancellationPolicyAgent cancellationPolicy;

  public static final String JSON_PROPERTY_CANCELLATION_POLICY_EXCEPTIONS = "cancellationPolicyExceptions";
  private CancellationPolicyExceptionsAgent cancellationPolicyExceptions;

  public RoomConfigurationPriceRatePlanAgent() {
  }

  public RoomConfigurationPriceRatePlanAgent identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Rate plan identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public RoomConfigurationPriceRatePlanAgent name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Provides the name of the rate plan.
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public RoomConfigurationPriceRatePlanAgent breakfast(Boolean breakfast) {
    
    this.breakfast = breakfast;
    return this;
  }

   /**
   * When true, indicates breakfast is included.
   * @return breakfast
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BREAKFAST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBreakfast() {
    return breakfast;
  }


  @JsonProperty(JSON_PROPERTY_BREAKFAST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBreakfast(Boolean breakfast) {
    this.breakfast = breakfast;
  }


  public RoomConfigurationPriceRatePlanAgent brunch(Boolean brunch) {
    
    this.brunch = brunch;
    return this;
  }

   /**
   * When true, indicates brunch is included.
   * @return brunch
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BRUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBrunch() {
    return brunch;
  }


  @JsonProperty(JSON_PROPERTY_BRUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBrunch(Boolean brunch) {
    this.brunch = brunch;
  }


  public RoomConfigurationPriceRatePlanAgent lunch(Boolean lunch) {
    
    this.lunch = lunch;
    return this;
  }

   /**
   * When true, indicates lunch is included.
   * @return lunch
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getLunch() {
    return lunch;
  }


  @JsonProperty(JSON_PROPERTY_LUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLunch(Boolean lunch) {
    this.lunch = lunch;
  }


  public RoomConfigurationPriceRatePlanAgent dinner(Boolean dinner) {
    
    this.dinner = dinner;
    return this;
  }

   /**
   * When true, indicates dinner is included.
   * @return dinner
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DINNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getDinner() {
    return dinner;
  }


  @JsonProperty(JSON_PROPERTY_DINNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDinner(Boolean dinner) {
    this.dinner = dinner;
  }


  public RoomConfigurationPriceRatePlanAgent allInclusive(Boolean allInclusive) {
    
    this.allInclusive = allInclusive;
    return this;
  }

   /**
   * Everything included except alcohol
   * @return allInclusive
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ALL_INCLUSIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getAllInclusive() {
    return allInclusive;
  }


  @JsonProperty(JSON_PROPERTY_ALL_INCLUSIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAllInclusive(Boolean allInclusive) {
    this.allInclusive = allInclusive;
  }


  public RoomConfigurationPriceRatePlanAgent allInclusivePlusAlcohol(Boolean allInclusivePlusAlcohol) {
    
    this.allInclusivePlusAlcohol = allInclusivePlusAlcohol;
    return this;
  }

   /**
   * Everything included with alcohol
   * @return allInclusivePlusAlcohol
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ALL_INCLUSIVE_PLUS_ALCOHOL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getAllInclusivePlusAlcohol() {
    return allInclusivePlusAlcohol;
  }


  @JsonProperty(JSON_PROPERTY_ALL_INCLUSIVE_PLUS_ALCOHOL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAllInclusivePlusAlcohol(Boolean allInclusivePlusAlcohol) {
    this.allInclusivePlusAlcohol = allInclusivePlusAlcohol;
  }


  public RoomConfigurationPriceRatePlanAgent earlyCheckInCharge(Object earlyCheckInCharge) {
    
    this.earlyCheckInCharge = earlyCheckInCharge;
    return this;
  }

   /**
   * Get earlyCheckInCharge
   * @return earlyCheckInCharge
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getEarlyCheckInCharge() {
    return earlyCheckInCharge;
  }


  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEarlyCheckInCharge(Object earlyCheckInCharge) {
    this.earlyCheckInCharge = earlyCheckInCharge;
  }


  public RoomConfigurationPriceRatePlanAgent lateCheckOutCharge(Object lateCheckOutCharge) {
    
    this.lateCheckOutCharge = lateCheckOutCharge;
    return this;
  }

   /**
   * Get lateCheckOutCharge
   * @return lateCheckOutCharge
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getLateCheckOutCharge() {
    return lateCheckOutCharge;
  }


  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLateCheckOutCharge(Object lateCheckOutCharge) {
    this.lateCheckOutCharge = lateCheckOutCharge;
  }


  public RoomConfigurationPriceRatePlanAgent cancellationPolicy(CancellationPolicyAgent cancellationPolicy) {
    
    this.cancellationPolicy = cancellationPolicy;
    return this;
  }

   /**
   * Get cancellationPolicy
   * @return cancellationPolicy
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellationPolicyAgent getCancellationPolicy() {
    return cancellationPolicy;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationPolicy(CancellationPolicyAgent cancellationPolicy) {
    this.cancellationPolicy = cancellationPolicy;
  }


  public RoomConfigurationPriceRatePlanAgent cancellationPolicyExceptions(CancellationPolicyExceptionsAgent cancellationPolicyExceptions) {
    
    this.cancellationPolicyExceptions = cancellationPolicyExceptions;
    return this;
  }

   /**
   * Get cancellationPolicyExceptions
   * @return cancellationPolicyExceptions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_EXCEPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellationPolicyExceptionsAgent getCancellationPolicyExceptions() {
    return cancellationPolicyExceptions;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_EXCEPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationPolicyExceptions(CancellationPolicyExceptionsAgent cancellationPolicyExceptions) {
    this.cancellationPolicyExceptions = cancellationPolicyExceptions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomConfigurationPriceRatePlanAgent roomConfigurationPriceRatePlanAgent = (RoomConfigurationPriceRatePlanAgent) o;
    return Objects.equals(this.identifier, roomConfigurationPriceRatePlanAgent.identifier) &&
        Objects.equals(this.name, roomConfigurationPriceRatePlanAgent.name) &&
        Objects.equals(this.breakfast, roomConfigurationPriceRatePlanAgent.breakfast) &&
        Objects.equals(this.brunch, roomConfigurationPriceRatePlanAgent.brunch) &&
        Objects.equals(this.lunch, roomConfigurationPriceRatePlanAgent.lunch) &&
        Objects.equals(this.dinner, roomConfigurationPriceRatePlanAgent.dinner) &&
        Objects.equals(this.allInclusive, roomConfigurationPriceRatePlanAgent.allInclusive) &&
        Objects.equals(this.allInclusivePlusAlcohol, roomConfigurationPriceRatePlanAgent.allInclusivePlusAlcohol) &&
        Objects.equals(this.earlyCheckInCharge, roomConfigurationPriceRatePlanAgent.earlyCheckInCharge) &&
        Objects.equals(this.lateCheckOutCharge, roomConfigurationPriceRatePlanAgent.lateCheckOutCharge) &&
        Objects.equals(this.cancellationPolicy, roomConfigurationPriceRatePlanAgent.cancellationPolicy) &&
        Objects.equals(this.cancellationPolicyExceptions, roomConfigurationPriceRatePlanAgent.cancellationPolicyExceptions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, name, breakfast, brunch, lunch, dinner, allInclusive, allInclusivePlusAlcohol, earlyCheckInCharge, lateCheckOutCharge, cancellationPolicy, cancellationPolicyExceptions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomConfigurationPriceRatePlanAgent {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    breakfast: ").append(toIndentedString(breakfast)).append("\n");
    sb.append("    brunch: ").append(toIndentedString(brunch)).append("\n");
    sb.append("    lunch: ").append(toIndentedString(lunch)).append("\n");
    sb.append("    dinner: ").append(toIndentedString(dinner)).append("\n");
    sb.append("    allInclusive: ").append(toIndentedString(allInclusive)).append("\n");
    sb.append("    allInclusivePlusAlcohol: ").append(toIndentedString(allInclusivePlusAlcohol)).append("\n");
    sb.append("    earlyCheckInCharge: ").append(toIndentedString(earlyCheckInCharge)).append("\n");
    sb.append("    lateCheckOutCharge: ").append(toIndentedString(lateCheckOutCharge)).append("\n");
    sb.append("    cancellationPolicy: ").append(toIndentedString(cancellationPolicy)).append("\n");
    sb.append("    cancellationPolicyExceptions: ").append(toIndentedString(cancellationPolicyExceptions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

